/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.response;

import android.content.Context;
import android.content.SharedPreferences;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.network.NetworkManager;
import com.clevertap.android.sdk.product_config.CTProductConfigController;
import com.clevertap.android.sdk.response.CleverTapResponse;
import com.clevertap.android.sdk.response.CleverTapResponseDecorator;
import com.clevertap.android.sdk.validation.Validator;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ARPResponse
extends CleverTapResponseDecorator {
    private final CTProductConfigController ctProductConfigController;
    private final CleverTapResponse cleverTapResponse;
    private final CleverTapInstanceConfig config;
    private final Logger logger;
    private final NetworkManager networkManager;
    private final Validator validator;

    public ARPResponse(CleverTapResponse cleverTapResponse, CleverTapInstanceConfig config, NetworkManager networkManager, Validator validator, ControllerManager controllerManager) {
        this.cleverTapResponse = cleverTapResponse;
        this.config = config;
        this.ctProductConfigController = controllerManager.getCTProductConfigController();
        this.logger = this.config.getLogger();
        this.networkManager = networkManager;
        this.validator = validator;
    }

    @Override
    public void processResponse(JSONObject response, String stringBody, Context context) {
        block5: {
            try {
                JSONObject arp;
                if (!response.has("arp") || (arp = (JSONObject)response.get("arp")).length() <= 0) break block5;
                if (this.ctProductConfigController != null) {
                    this.ctProductConfigController.setArpValue(arp);
                }
                try {
                    this.processDiscardedEventsList(arp);
                }
                catch (Throwable t) {
                    this.logger.verbose("Error handling discarded events response: " + t.getLocalizedMessage());
                }
                this.handleARPUpdate(context, arp);
            }
            catch (Throwable t) {
                this.logger.verbose(this.config.getAccountId(), "Failed to process ARP", t);
            }
        }
        this.cleverTapResponse.processResponse(response, stringBody, context);
    }

    private void handleARPUpdate(Context context, JSONObject arp) {
        if (arp == null || arp.length() == 0) {
            return;
        }
        String nameSpaceKey = this.networkManager.getNewNamespaceARPKey();
        if (nameSpaceKey == null) {
            return;
        }
        SharedPreferences prefs = StorageHelper.getPreferences(context, nameSpaceKey);
        SharedPreferences.Editor editor = prefs.edit();
        Iterator keys = arp.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                Object o = arp.get(key);
                if (o instanceof Number) {
                    int update = ((Number)o).intValue();
                    editor.putInt(key, update);
                    continue;
                }
                if (o instanceof String) {
                    if (((String)o).length() < 100) {
                        editor.putString(key, (String)o);
                        continue;
                    }
                    this.logger.verbose(this.config.getAccountId(), "ARP update for key " + key + " rejected (string value too long)");
                    continue;
                }
                if (o instanceof Boolean) {
                    editor.putBoolean(key, ((Boolean)o).booleanValue());
                    continue;
                }
                this.logger.verbose(this.config.getAccountId(), "ARP update for key " + key + " rejected (invalid data type)");
            }
            catch (JSONException jSONException) {}
        }
        this.logger.verbose(this.config.getAccountId(), "Stored ARP for namespace key: " + nameSpaceKey + " values: " + arp.toString());
        StorageHelper.persist(editor);
    }

    private void processDiscardedEventsList(JSONObject response) {
        if (!response.has("d_e")) {
            this.logger.verbose(this.config.getAccountId(), "ARP doesn't contain the Discarded Events key");
            return;
        }
        try {
            ArrayList<String> discardedEventsList = new ArrayList<String>();
            JSONArray discardedEventsArray = response.getJSONArray("d_e");
            if (discardedEventsArray != null) {
                for (int i = 0; i < discardedEventsArray.length(); ++i) {
                    discardedEventsList.add(discardedEventsArray.getString(i));
                }
            }
            if (this.validator != null) {
                this.validator.setDiscardedEvents(discardedEventsList);
            } else {
                this.logger.verbose(this.config.getAccountId(), "Validator object is NULL");
            }
        }
        catch (JSONException e) {
            this.logger.verbose(this.config.getAccountId(), "Error parsing discarded events list" + e.getLocalizedMessage());
        }
    }
}

