/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.pushnotification;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.app.NotificationCompat;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.pushnotification.INotificationRenderer;
import com.clevertap.android.sdk.pushnotification.LaunchPendingIntentFactory;
import org.json.JSONArray;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class CoreNotificationRenderer
implements INotificationRenderer {
    private String notifMessage;
    private String notifTitle;
    private int smallIcon;

    @Override
    @Nullable
    public Object getCollapseKey(Bundle extras) {
        Object collapse_key = extras.get("wzrk_ck");
        return collapse_key;
    }

    @Override
    public String getMessage(Bundle extras) {
        this.notifMessage = extras.getString("nm");
        return this.notifMessage;
    }

    @Override
    public String getTitle(Bundle extras, Context context) {
        String title = extras.getString("nt", "");
        this.notifTitle = title.isEmpty() ? context.getApplicationInfo().name : title;
        return this.notifTitle;
    }

    @Override
    public NotificationCompat.Builder renderNotification(Bundle extras, Context context, NotificationCompat.Builder nb, CleverTapInstanceConfig config, int notificationId) {
        boolean requiresChannelId;
        NotificationCompat.BigTextStyle style2;
        String icoPath;
        block11: {
            icoPath = extras.getString("ico");
            String bigPictureUrl = extras.getString("wzrk_bp");
            if (bigPictureUrl != null && bigPictureUrl.startsWith("http")) {
                try {
                    Bitmap bpMap = Utils.getNotificationBitmap(bigPictureUrl, false, context);
                    if (bpMap == null) {
                        throw new Exception("Failed to fetch big picture!");
                    }
                    if (extras.containsKey("wzrk_nms")) {
                        String summaryText = extras.getString("wzrk_nms");
                        style2 = new NotificationCompat.BigPictureStyle().setSummaryText((CharSequence)summaryText).bigPicture(bpMap);
                        break block11;
                    }
                    style2 = new NotificationCompat.BigPictureStyle().setSummaryText((CharSequence)this.notifMessage).bigPicture(bpMap);
                }
                catch (Throwable t) {
                    style2 = new NotificationCompat.BigTextStyle().bigText((CharSequence)this.notifMessage);
                    config.getLogger().verbose(config.getAccountId(), "Falling back to big text notification, couldn't fetch big picture", t);
                }
            } else {
                style2 = new NotificationCompat.BigTextStyle().bigText((CharSequence)this.notifMessage);
            }
        }
        boolean bl = requiresChannelId = Build.VERSION.SDK_INT >= 26;
        if (requiresChannelId && extras.containsKey("wzrk_st")) {
            nb.setSubText((CharSequence)extras.getString("wzrk_st"));
        }
        if (extras.containsKey("wzrk_clr")) {
            int color = Color.parseColor((String)extras.getString("wzrk_clr"));
            nb.setColor(color);
            nb.setColorized(true);
        }
        nb.setContentTitle((CharSequence)this.notifTitle).setContentText((CharSequence)this.notifMessage).setContentIntent(LaunchPendingIntentFactory.getLaunchPendingIntent(extras, context)).setAutoCancel(true).setStyle((NotificationCompat.Style)style2).setSmallIcon(this.smallIcon);
        nb.setLargeIcon(Utils.getNotificationBitmap(icoPath, true, context));
        JSONArray actions = null;
        String actionsString = extras.getString("wzrk_acts");
        if (actionsString != null) {
            try {
                actions = new JSONArray(actionsString);
            }
            catch (Throwable t) {
                config.getLogger().debug(config.getAccountId(), "error parsing notification actions: " + t.getLocalizedMessage());
            }
        }
        this.setActionButtons(context, extras, notificationId, nb, actions);
        return nb;
    }

    @Override
    public void setSmallIcon(int smallIcon, Context context) {
        this.smallIcon = smallIcon;
    }

    @Override
    public String getActionButtonIconKey() {
        return "ico";
    }
}

