/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.network;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CTLockManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.db.BaseDatabaseManager;
import com.clevertap.android.sdk.db.QueueCursor;
import com.clevertap.android.sdk.events.EventGroup;
import com.clevertap.android.sdk.login.IdentityRepoFactory;
import com.clevertap.android.sdk.network.BaseNetworkManager;
import com.clevertap.android.sdk.network.SSLContextBuilder;
import com.clevertap.android.sdk.response.ARPResponse;
import com.clevertap.android.sdk.response.BaseResponse;
import com.clevertap.android.sdk.response.CleverTapResponse;
import com.clevertap.android.sdk.response.CleverTapResponseHelper;
import com.clevertap.android.sdk.response.ConsoleResponse;
import com.clevertap.android.sdk.response.DisplayUnitResponse;
import com.clevertap.android.sdk.response.FeatureFlagResponse;
import com.clevertap.android.sdk.response.GeofenceResponse;
import com.clevertap.android.sdk.response.InAppResponse;
import com.clevertap.android.sdk.response.InboxResponse;
import com.clevertap.android.sdk.response.MetadataResponse;
import com.clevertap.android.sdk.response.ProductConfigResponse;
import com.clevertap.android.sdk.response.PushAmpResponse;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.Task;
import com.clevertap.android.sdk.utils.CTJsonConverter;
import com.clevertap.android.sdk.validation.ValidationResultStack;
import com.clevertap.android.sdk.validation.Validator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class NetworkManager
extends BaseNetworkManager {
    private static SSLSocketFactory sslSocketFactory;
    private static SSLContext sslContext;
    private final BaseCallbackManager callbackManager;
    private CleverTapResponse cleverTapResponse;
    private final CleverTapInstanceConfig config;
    private final Context context;
    private final ControllerManager controllerManager;
    private final CoreMetaData coreMetaData;
    private int currentRequestTimestamp = 0;
    private final BaseDatabaseManager databaseManager;
    private final DeviceInfo deviceInfo;
    private final Logger logger;
    private int networkRetryCount = 0;
    private final ValidationResultStack validationResultStack;
    private int responseFailureCount = 0;

    public static boolean isNetworkOnline(Context context) {
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            if (cm == null) {
                return true;
            }
            NetworkInfo netInfo = cm.getActiveNetworkInfo();
            return netInfo != null && netInfo.isConnected();
        }
        catch (Throwable ignore) {
            return true;
        }
    }

    public NetworkManager(Context context, CleverTapInstanceConfig config, DeviceInfo deviceInfo, CoreMetaData coreMetaData, ValidationResultStack validationResultStack, ControllerManager controllerManager, BaseDatabaseManager baseDatabaseManager, BaseCallbackManager callbackManager, CTLockManager ctLockManager, Validator validator, LocalDataStore localDataStore) {
        this.context = context;
        this.config = config;
        this.deviceInfo = deviceInfo;
        this.callbackManager = callbackManager;
        this.logger = this.config.getLogger();
        this.coreMetaData = coreMetaData;
        this.validationResultStack = validationResultStack;
        this.controllerManager = controllerManager;
        this.databaseManager = baseDatabaseManager;
        CleverTapResponse cleverTapResponse = new CleverTapResponseHelper();
        cleverTapResponse = new GeofenceResponse(cleverTapResponse, config, callbackManager);
        cleverTapResponse = new ProductConfigResponse(cleverTapResponse, config, coreMetaData, controllerManager);
        cleverTapResponse = new FeatureFlagResponse(cleverTapResponse, config, controllerManager);
        cleverTapResponse = new DisplayUnitResponse(cleverTapResponse, config, callbackManager, controllerManager);
        cleverTapResponse = new PushAmpResponse(cleverTapResponse, context, config, baseDatabaseManager, callbackManager, controllerManager);
        cleverTapResponse = new InboxResponse(cleverTapResponse, config, ctLockManager, callbackManager, controllerManager);
        cleverTapResponse = new ConsoleResponse(cleverTapResponse, config);
        cleverTapResponse = new ARPResponse(cleverTapResponse, config, this, validator, controllerManager);
        cleverTapResponse = new MetadataResponse(cleverTapResponse, config, deviceInfo, this);
        cleverTapResponse = new InAppResponse(cleverTapResponse, config, controllerManager, false);
        cleverTapResponse = new BaseResponse(context, config, deviceInfo, this, localDataStore, cleverTapResponse);
        this.setCleverTapResponse(cleverTapResponse);
    }

    @Override
    public void flushDBQueue(Context context, EventGroup eventGroup) {
        this.config.getLogger().verbose(this.config.getAccountId(), "Somebody has invoked me to send the queue to CleverTap servers");
        QueueCursor previousCursor = null;
        boolean loadMore = true;
        while (loadMore) {
            QueueCursor cursor = this.databaseManager.getQueuedEvents(context, 50, previousCursor, eventGroup);
            if (cursor == null || cursor.isEmpty().booleanValue()) {
                this.config.getLogger().verbose(this.config.getAccountId(), "No events in the queue, failing");
                break;
            }
            previousCursor = cursor;
            JSONArray queue = cursor.getData();
            if (queue == null || queue.length() <= 0) {
                this.config.getLogger().verbose(this.config.getAccountId(), "No events in the queue, failing");
                break;
            }
            loadMore = this.sendQueue(context, eventGroup, queue);
        }
    }

    @Override
    public int getDelayFrequency() {
        int minDelayFrequency = 0;
        this.logger.debug(this.config.getAccountId(), "Network retry #" + this.networkRetryCount);
        if (this.networkRetryCount < 10) {
            this.logger.debug(this.config.getAccountId(), "Failure count is " + this.networkRetryCount + ". Setting delay frequency to 1s");
            minDelayFrequency = 1000;
            return minDelayFrequency;
        }
        if (this.config.getAccountRegion() == null) {
            this.logger.debug(this.config.getAccountId(), "Setting delay frequency to 1s");
            return 1000;
        }
        SecureRandom randomGen = new SecureRandom();
        int randomDelay = (randomGen.nextInt(10) + 1) * 1000;
        if ((minDelayFrequency += randomDelay) < 600000) {
            this.logger.debug(this.config.getAccountId(), "Setting delay frequency to " + minDelayFrequency);
            return minDelayFrequency;
        }
        minDelayFrequency = 1000;
        this.logger.debug(this.config.getAccountId(), "Setting delay frequency to " + minDelayFrequency);
        return minDelayFrequency;
    }

    public String getNewNamespaceARPKey() {
        String accountId = this.config.getAccountId();
        if (accountId == null) {
            return null;
        }
        this.logger.verbose(this.config.getAccountId(), "New ARP Key = ARP:" + accountId + ":" + this.deviceInfo.getDeviceID());
        return "ARP:" + accountId + ":" + this.deviceInfo.getDeviceID();
    }

    public void incrementResponseFailureCount() {
        ++this.responseFailureCount;
    }

    @Override
    public void initHandshake(EventGroup eventGroup, Runnable handshakeSuccessCallback) {
        this.responseFailureCount = 0;
        this.setDomain(this.context, null);
        this.performHandshakeForDomain(this.context, eventGroup, handshakeSuccessCallback);
    }

    @Override
    public boolean needsHandshakeForDomain(EventGroup eventGroup) {
        String domain = this.getDomainFromPrefsOrMetadata(eventGroup);
        return domain == null || this.responseFailureCount > 5;
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public void setI(Context context, long i) {
        SharedPreferences prefs = StorageHelper.getPreferences(context, "IJ");
        SharedPreferences.Editor editor = prefs.edit();
        editor.putLong(StorageHelper.storageKeyWithSuffix(this.config, "comms_i"), i);
        StorageHelper.persist(editor);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public void setJ(Context context, long j) {
        SharedPreferences prefs = StorageHelper.getPreferences(context, "IJ");
        SharedPreferences.Editor editor = prefs.edit();
        editor.putLong(StorageHelper.storageKeyWithSuffix(this.config, "comms_j"), j);
        StorageHelper.persist(editor);
    }

    HttpsURLConnection buildHttpsURLConnection(String endpoint) throws IOException {
        SSLContext _sslContext;
        URL url = new URL(endpoint);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        conn.setRequestProperty("X-CleverTap-Account-ID", this.config.getAccountId());
        conn.setRequestProperty("X-CleverTap-Token", this.config.getAccountToken());
        conn.setInstanceFollowRedirects(false);
        if (this.config.isSslPinningEnabled() && (_sslContext = NetworkManager.getSSLContext()) != null) {
            conn.setSSLSocketFactory(NetworkManager.getPinnedCertsSslSocketfactory(_sslContext));
        }
        return conn;
    }

    CleverTapResponse getCleverTapResponse() {
        return this.cleverTapResponse;
    }

    void setCleverTapResponse(CleverTapResponse cleverTapResponse) {
        this.cleverTapResponse = cleverTapResponse;
    }

    int getCurrentRequestTimestamp() {
        return this.currentRequestTimestamp;
    }

    void setCurrentRequestTimestamp(int currentRequestTimestamp) {
        this.currentRequestTimestamp = currentRequestTimestamp;
    }

    String getDomain(boolean defaultToHandshakeURL, EventGroup eventGroup) {
        boolean emptyDomain;
        String domain = this.getDomainFromPrefsOrMetadata(eventGroup);
        boolean bl = emptyDomain = domain == null || domain.trim().length() == 0;
        if (emptyDomain && !defaultToHandshakeURL) {
            return null;
        }
        domain = emptyDomain ? "wzrkt.com/hello" : domain + "/a1";
        return domain;
    }

    String getDomainFromPrefsOrMetadata(EventGroup eventGroup) {
        try {
            String region = this.config.getAccountRegion();
            if (region != null && region.trim().length() > 0) {
                this.setResponseFailureCount(0);
                if (eventGroup.equals((Object)EventGroup.PUSH_NOTIFICATION_VIEWED)) {
                    return region.trim().toLowerCase() + eventGroup.httpResource + "." + "wzrkt.com";
                }
                return region.trim().toLowerCase() + "." + "wzrkt.com";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (eventGroup.equals((Object)EventGroup.PUSH_NOTIFICATION_VIEWED)) {
            return StorageHelper.getStringFromPrefs(this.context, this.config, "comms_dmn_spiky", null);
        }
        return StorageHelper.getStringFromPrefs(this.context, this.config, "comms_dmn", null);
    }

    String getEndpoint(boolean defaultToHandshakeURL, EventGroup eventGroup) {
        String domain = this.getDomain(defaultToHandshakeURL, eventGroup);
        if (domain == null) {
            this.logger.verbose(this.config.getAccountId(), "Unable to configure endpoint, domain is null");
            return null;
        }
        String accountId = this.config.getAccountId();
        if (accountId == null) {
            this.logger.verbose(this.config.getAccountId(), "Unable to configure endpoint, accountID is null");
            return null;
        }
        String endpoint = "https://" + domain + "?os=Android&t=" + this.deviceInfo.getSdkVersion();
        endpoint = endpoint + "&z=" + accountId;
        boolean needsHandshake = this.needsHandshakeForDomain(eventGroup);
        if (needsHandshake) {
            return endpoint;
        }
        this.currentRequestTimestamp = (int)(System.currentTimeMillis() / 1000L);
        endpoint = endpoint + "&ts=" + this.getCurrentRequestTimestamp();
        return endpoint;
    }

    int getFirstRequestTimestamp() {
        return StorageHelper.getIntFromPrefs(this.context, this.config, "comms_first_ts", 0);
    }

    int getLastRequestTimestamp() {
        return StorageHelper.getIntFromPrefs(this.context, this.config, "comms_last_ts", 0);
    }

    void setLastRequestTimestamp(int ts) {
        StorageHelper.putInt(this.context, StorageHelper.storageKeyWithSuffix(this.config, "comms_last_ts"), ts);
    }

    int getResponseFailureCount() {
        return this.responseFailureCount;
    }

    void setResponseFailureCount(int responseFailureCount) {
        this.responseFailureCount = responseFailureCount;
    }

    boolean hasDomainChanged(String newDomain) {
        String oldDomain = StorageHelper.getStringFromPrefs(this.context, this.config, "comms_dmn", null);
        return !newDomain.equals(oldDomain);
    }

    String insertHeader(Context context, JSONArray arr) {
        try {
            long j;
            JSONObject header = new JSONObject();
            String deviceId = this.deviceInfo.getDeviceID();
            if (deviceId != null && !deviceId.equals("")) {
                header.put("g", (Object)deviceId);
            } else {
                this.logger.verbose(this.config.getAccountId(), "CRITICAL: Couldn't finalise on a device ID! Using error device ID instead!");
            }
            header.put("type", (Object)"meta");
            JSONObject appFields = this.deviceInfo.getAppLaunchedFields();
            header.put("af", (Object)appFields);
            long i = this.getI();
            if (i > 0L) {
                header.put("_i", i);
            }
            if ((j = this.getJ()) > 0L) {
                header.put("_j", j);
            }
            String accountId = this.config.getAccountId();
            String token = this.config.getAccountToken();
            if (accountId == null || token == null) {
                this.logger.debug(this.config.getAccountId(), "Account ID/token not found, unable to configure queue request");
                return null;
            }
            header.put("id", (Object)accountId);
            header.put("tk", (Object)token);
            header.put("l_ts", this.getLastRequestTimestamp());
            header.put("f_ts", this.getFirstRequestTimestamp());
            header.put("ct_pi", (Object)IdentityRepoFactory.getRepo(this.context, this.config, this.deviceInfo, this.validationResultStack).getIdentitySet().toString());
            header.put("ddnd", !this.deviceInfo.getNotificationsEnabledForUser() || !this.controllerManager.getPushProviders().isNotificationSupported());
            if (this.coreMetaData.isBgPing()) {
                header.put("bk", 1);
                this.coreMetaData.setBgPing(false);
            }
            header.put("rtl", (Object)CTJsonConverter.getRenderedTargetList(this.databaseManager.loadDBAdapter(this.context)));
            if (!this.coreMetaData.isInstallReferrerDataSent()) {
                header.put("rct", this.coreMetaData.getReferrerClickTime());
                header.put("ait", this.coreMetaData.getAppInstallTime());
            }
            header.put("frs", this.coreMetaData.isFirstRequestInSession());
            this.coreMetaData.setFirstRequestInSession(false);
            try {
                JSONObject arp = this.getARP();
                if (arp != null && arp.length() > 0) {
                    header.put("arp", (Object)arp);
                }
            }
            catch (Throwable t) {
                this.logger.verbose(this.config.getAccountId(), "Failed to attach ARP", t);
            }
            JSONObject ref = new JSONObject();
            try {
                String utmCampaign;
                String utmMedium;
                String utmSource = this.coreMetaData.getSource();
                if (utmSource != null) {
                    ref.put("us", (Object)utmSource);
                }
                if ((utmMedium = this.coreMetaData.getMedium()) != null) {
                    ref.put("um", (Object)utmMedium);
                }
                if ((utmCampaign = this.coreMetaData.getCampaign()) != null) {
                    ref.put("uc", (Object)utmCampaign);
                }
                if (ref.length() > 0) {
                    header.put("ref", (Object)ref);
                }
            }
            catch (Throwable t) {
                this.logger.verbose(this.config.getAccountId(), "Failed to attach ref", t);
            }
            JSONObject wzrkParams = this.coreMetaData.getWzrkParams();
            if (wzrkParams != null && wzrkParams.length() > 0) {
                header.put("wzrk_ref", (Object)wzrkParams);
            }
            if (this.controllerManager.getInAppFCManager() != null) {
                Logger.v("Attaching InAppFC to Header");
                this.controllerManager.getInAppFCManager().attachToHeader(context, header);
            } else {
                this.logger.verbose(this.config.getAccountId(), "controllerManager.getInAppFCManager() is NULL, not Attaching InAppFC to Header");
            }
            return "[" + header.toString() + ", " + arr.toString().substring(1);
        }
        catch (Throwable t) {
            this.logger.verbose(this.config.getAccountId(), "CommsManager: Failed to attach header", t);
            return arr.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performHandshakeForDomain(Context context, EventGroup eventGroup, Runnable handshakeSuccessCallback) {
        String endpoint = this.getEndpoint(true, eventGroup);
        if (endpoint == null) {
            this.logger.verbose(this.config.getAccountId(), "Unable to perform handshake, endpoint is null");
        }
        this.logger.verbose(this.config.getAccountId(), "Performing handshake with " + endpoint);
        HttpsURLConnection conn = null;
        try {
            conn = this.buildHttpsURLConnection(endpoint);
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                this.logger.verbose(this.config.getAccountId(), "Invalid HTTP status code received for handshake - " + responseCode);
                return;
            }
            this.logger.verbose(this.config.getAccountId(), "Received success from handshake :)");
            if (this.processIncomingHeaders(context, conn)) {
                this.logger.verbose(this.config.getAccountId(), "We are not muted");
                handshakeSuccessCallback.run();
            }
        }
        catch (Throwable t) {
            this.logger.verbose(this.config.getAccountId(), "Failed to perform handshake!", t);
        }
        finally {
            if (conn != null) {
                try {
                    conn.getInputStream().close();
                    conn.disconnect();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    boolean processIncomingHeaders(Context context, HttpsURLConnection conn) {
        String muteCommand = conn.getHeaderField("X-WZRK-MUTE");
        if (muteCommand != null && muteCommand.trim().length() > 0) {
            if (muteCommand.equals("true")) {
                this.setMuted(context, true);
                return false;
            }
            this.setMuted(context, false);
        }
        String domainName = conn.getHeaderField("X-WZRK-RD");
        Logger.v("Getting domain from header - " + domainName);
        if (domainName == null || domainName.trim().length() == 0) {
            return true;
        }
        String spikyDomainName = conn.getHeaderField("X-WZRK-SPIKY-RD");
        Logger.v("Getting spiky domain from header - " + spikyDomainName);
        this.setMuted(context, false);
        this.setDomain(context, domainName);
        Logger.v("Setting spiky domain from header as -" + spikyDomainName);
        if (spikyDomainName == null) {
            this.setSpikyDomain(context, domainName);
        } else {
            this.setSpikyDomain(context, spikyDomainName);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    boolean sendQueue(Context context, EventGroup eventGroup, JSONArray queue) {
        boolean bl;
        URLConnection conn;
        block32: {
            block30: {
                boolean bl2;
                block31: {
                    String req;
                    String endpoint;
                    block28: {
                        boolean bl3;
                        block29: {
                            block26: {
                                boolean bl4;
                                block27: {
                                    if (queue == null || queue.length() <= 0) {
                                        return false;
                                    }
                                    if (this.deviceInfo.getDeviceID() == null) {
                                        this.logger.debug(this.config.getAccountId(), "CleverTap Id not finalized, unable to send queue");
                                        return false;
                                    }
                                    conn = null;
                                    endpoint = this.getEndpoint(false, eventGroup);
                                    if (endpoint != null) break block26;
                                    this.logger.debug(this.config.getAccountId(), "Problem configuring queue endpoint, unable to send queue");
                                    bl4 = false;
                                    if (conn == null) break block27;
                                    try {
                                        conn.getInputStream().close();
                                        ((HttpURLConnection)conn).disconnect();
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                                return bl4;
                            }
                            conn = this.buildHttpsURLConnection(endpoint);
                            req = this.insertHeader(context, queue);
                            if (req != null) break block28;
                            this.logger.debug(this.config.getAccountId(), "Problem configuring queue request, unable to send queue");
                            bl3 = false;
                            if (conn == null) break block29;
                            try {
                                conn.getInputStream().close();
                                ((HttpURLConnection)conn).disconnect();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        return bl3;
                    }
                    this.logger.debug(this.config.getAccountId(), "Send queue contains " + queue.length() + " items: " + req);
                    this.logger.debug(this.config.getAccountId(), "Sending queue to: " + endpoint);
                    conn.setDoOutput(true);
                    conn.getOutputStream().write(req.getBytes("UTF-8"));
                    int responseCode = ((HttpURLConnection)conn).getResponseCode();
                    if (responseCode != 200) {
                        throw new IOException("Response code is not 200. It is " + responseCode);
                    }
                    String newDomain = conn.getHeaderField("X-WZRK-RD");
                    if (newDomain == null || newDomain.trim().length() <= 0 || !this.hasDomainChanged(newDomain)) break block30;
                    this.setDomain(context, newDomain);
                    this.logger.debug(this.config.getAccountId(), "The domain has changed to " + newDomain + ". The request will be retried shortly.");
                    bl2 = false;
                    if (conn == null) break block31;
                    try {
                        conn.getInputStream().close();
                        ((HttpURLConnection)conn).disconnect();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            if (this.processIncomingHeaders(context, (HttpsURLConnection)conn)) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                String body = sb.toString();
                this.getCleverTapResponse().processResponse(null, body, this.context);
            }
            this.setLastRequestTimestamp(this.getCurrentRequestTimestamp());
            this.setFirstRequestTimestampIfNeeded(this.getCurrentRequestTimestamp());
            this.logger.debug(this.config.getAccountId(), "Queue sent successfully");
            this.responseFailureCount = 0;
            this.networkRetryCount = 0;
            bl = true;
            if (conn == null) break block32;
            try {
                conn.getInputStream().close();
                ((HttpURLConnection)conn).disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return bl;
        catch (Throwable e) {
            try {
                this.logger.debug(this.config.getAccountId(), "An exception occurred while sending the queue, will retry: ", e);
                ++this.responseFailureCount;
                ++this.networkRetryCount;
                this.callbackManager.getFailureFlushListener().failureFlush(context);
                boolean bl5 = false;
                return bl5;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.getInputStream().close();
                        ((HttpURLConnection)conn).disconnect();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    void setDomain(Context context, String domainName) {
        this.logger.verbose(this.config.getAccountId(), "Setting domain to " + domainName);
        StorageHelper.putString(context, StorageHelper.storageKeyWithSuffix(this.config, "comms_dmn"), domainName);
    }

    void setFirstRequestTimestampIfNeeded(int ts) {
        if (this.getFirstRequestTimestamp() > 0) {
            return;
        }
        StorageHelper.putInt(this.context, StorageHelper.storageKeyWithSuffix(this.config, "comms_first_ts"), ts);
    }

    void setSpikyDomain(Context context, String spikyDomainName) {
        this.logger.verbose(this.config.getAccountId(), "Setting spiky domain to " + spikyDomainName);
        StorageHelper.putString(context, StorageHelper.storageKeyWithSuffix(this.config, "comms_dmn_spiky"), spikyDomainName);
    }

    private JSONObject getARP() {
        try {
            String nameSpaceKey = this.getNewNamespaceARPKey();
            if (nameSpaceKey == null) {
                return null;
            }
            SharedPreferences prefs = !StorageHelper.getPreferences(this.context, nameSpaceKey).getAll().isEmpty() ? StorageHelper.getPreferences(this.context, nameSpaceKey) : this.migrateARPToNewNameSpace(nameSpaceKey, this.getNamespaceARPKey());
            Map all = prefs.getAll();
            Iterator iter = all.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry kv = iter.next();
                Object o = kv.getValue();
                if (!(o instanceof Number) || ((Number)o).intValue() != -1) continue;
                iter.remove();
            }
            JSONObject ret = new JSONObject(all);
            this.logger.verbose(this.config.getAccountId(), "Fetched ARP for namespace key: " + nameSpaceKey + " values: " + all.toString());
            return ret;
        }
        catch (Throwable t) {
            this.logger.verbose(this.config.getAccountId(), "Failed to construct ARP object", t);
            return null;
        }
    }

    private long getI() {
        return StorageHelper.getLongFromPrefs(this.context, this.config, "comms_i", 0, "IJ");
    }

    private long getJ() {
        return StorageHelper.getLongFromPrefs(this.context, this.config, "comms_j", 0, "IJ");
    }

    private String getNamespaceARPKey() {
        String accountId = this.config.getAccountId();
        if (accountId == null) {
            return null;
        }
        this.logger.verbose(this.config.getAccountId(), "Old ARP Key = ARP:" + accountId);
        return "ARP:" + accountId;
    }

    private SharedPreferences migrateARPToNewNameSpace(String newKey, String oldKey) {
        SharedPreferences oldPrefs = StorageHelper.getPreferences(this.context, oldKey);
        SharedPreferences newPrefs = StorageHelper.getPreferences(this.context, newKey);
        SharedPreferences.Editor editor = newPrefs.edit();
        Map all = oldPrefs.getAll();
        for (Map.Entry kv : all.entrySet()) {
            Object o = kv.getValue();
            if (o instanceof Number) {
                int update = ((Number)o).intValue();
                editor.putInt((String)kv.getKey(), update);
                continue;
            }
            if (o instanceof String) {
                if (((String)o).length() < 100) {
                    editor.putString((String)kv.getKey(), (String)o);
                    continue;
                }
                this.logger.verbose(this.config.getAccountId(), "ARP update for key " + (String)kv.getKey() + " rejected (string value too long)");
                continue;
            }
            if (o instanceof Boolean) {
                editor.putBoolean((String)kv.getKey(), ((Boolean)o).booleanValue());
                continue;
            }
            this.logger.verbose(this.config.getAccountId(), "ARP update for key " + (String)kv.getKey() + " rejected (invalid data type)");
        }
        this.logger.verbose(this.config.getAccountId(), "Completed ARP update for namespace key: " + newKey + "");
        StorageHelper.persist(editor);
        oldPrefs.edit().clear().apply();
        return newPrefs;
    }

    private void setMuted(final Context context, boolean mute) {
        if (mute) {
            int now = (int)(System.currentTimeMillis() / 1000L);
            StorageHelper.putInt(context, StorageHelper.storageKeyWithSuffix(this.config, "comms_mtd"), now);
            this.setDomain(context, null);
            Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask();
            task.execute("CommsManager#setMuted", new Callable<Void>(){

                @Override
                public Void call() {
                    NetworkManager.this.databaseManager.clearQueues(context);
                    return null;
                }
            });
        } else {
            StorageHelper.putInt(context, StorageHelper.storageKeyWithSuffix(this.config, "comms_mtd"), 0);
        }
    }

    private static SSLSocketFactory getPinnedCertsSslSocketfactory(SSLContext sslContext) {
        if (sslContext == null) {
            return null;
        }
        if (sslSocketFactory == null) {
            try {
                sslSocketFactory = sslContext.getSocketFactory();
                Logger.d("Pinning SSL session to DigiCertGlobalRoot CA certificate");
            }
            catch (Throwable e) {
                Logger.d("Issue in pinning SSL,", e);
            }
        }
        return sslSocketFactory;
    }

    private static synchronized SSLContext getSSLContext() {
        if (sslContext == null) {
            sslContext = new SSLContextBuilder().build();
        }
        return sslContext;
    }
}

