/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import com.clevertap.android.sdk.inapp.CTInAppBaseFragment;
import com.clevertap.android.sdk.inapp.CTInAppBaseFullFragment;
import com.clevertap.android.sdk.inapp.CTInAppNotificationButton;

public abstract class CTInAppBaseFullNativeFragment
extends CTInAppBaseFullFragment {
    int getDPI() {
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        if (wm == null) {
            return 0;
        }
        DisplayMetrics dm = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(dm);
        return dm.densityDpi;
    }

    void setupInAppButton(Button inAppButton, CTInAppNotificationButton inAppNotificationButton, int buttonIndex) {
        if (inAppNotificationButton != null) {
            inAppButton.setVisibility(0);
            inAppButton.setTag((Object)buttonIndex);
            inAppButton.setText((CharSequence)inAppNotificationButton.getText());
            inAppButton.setTextColor(Color.parseColor((String)inAppNotificationButton.getTextColor()));
            inAppButton.setOnClickListener((View.OnClickListener)new CTInAppBaseFragment.CTInAppNativeButtonClickListener(this));
            ShapeDrawable borderDrawable = null;
            ShapeDrawable shapeDrawable = null;
            if (!inAppNotificationButton.getBorderRadius().isEmpty()) {
                float value = Float.parseFloat(inAppNotificationButton.getBorderRadius()) * (480.0f / (float)this.getDPI()) * 2.0f;
                shapeDrawable = new ShapeDrawable((Shape)new RoundRectShape(new float[]{value, value, value, value, value, value, value, value}, null, new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}));
                shapeDrawable.getPaint().setColor(Color.parseColor((String)inAppNotificationButton.getBackgroundColor()));
                shapeDrawable.getPaint().setStyle(Paint.Style.FILL);
                shapeDrawable.getPaint().setAntiAlias(true);
                borderDrawable = new ShapeDrawable((Shape)new RoundRectShape(new float[]{value, value, value, value, value, value, value, value}, null, new float[]{value, value, value, value, value, value, value, value}));
            }
            if (!inAppNotificationButton.getBorderColor().isEmpty() && borderDrawable != null) {
                borderDrawable.getPaint().setColor(Color.parseColor((String)inAppNotificationButton.getBorderColor()));
                borderDrawable.setPadding(1, 1, 1, 1);
                borderDrawable.getPaint().setStyle(Paint.Style.FILL);
            }
            if (shapeDrawable != null) {
                Drawable[] drawables = new Drawable[]{borderDrawable, shapeDrawable};
                LayerDrawable layerDrawable = new LayerDrawable(drawables);
                inAppButton.setBackground((Drawable)layerDrawable);
            }
        } else {
            inAppButton.setVisibility(8);
        }
    }
}

