/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.inapp;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Looper;
import android.os.Parcelable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentTransaction;
import com.clevertap.android.sdk.AnalyticsManager;
import com.clevertap.android.sdk.BaseCallbackManager;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ControllerManager;
import com.clevertap.android.sdk.CoreMetaData;
import com.clevertap.android.sdk.InAppNotificationActivity;
import com.clevertap.android.sdk.InAppNotificationListener;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.inapp.CTInAppBasePartialFragment;
import com.clevertap.android.sdk.inapp.CTInAppHtmlFooterFragment;
import com.clevertap.android.sdk.inapp.CTInAppHtmlHeaderFragment;
import com.clevertap.android.sdk.inapp.CTInAppNativeFooterFragment;
import com.clevertap.android.sdk.inapp.CTInAppNativeHeaderFragment;
import com.clevertap.android.sdk.inapp.CTInAppNotification;
import com.clevertap.android.sdk.inapp.CTInAppType;
import com.clevertap.android.sdk.inapp.InAppListener;
import com.clevertap.android.sdk.task.CTExecutorFactory;
import com.clevertap.android.sdk.task.MainLooperHandler;
import com.clevertap.android.sdk.task.Task;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.json.JSONArray;
import org.json.JSONObject;

public class InAppController
implements CTInAppNotification.CTInAppNotificationListener,
InAppListener {
    private static CTInAppNotification currentlyDisplayingInApp = null;
    private static final List<CTInAppNotification> pendingNotifications = Collections.synchronizedList(new ArrayList());
    private HashSet<String> inappActivityExclude = null;
    private final AnalyticsManager analyticsManager;
    private final BaseCallbackManager callbackManager;
    private final CleverTapInstanceConfig config;
    private final Context context;
    private final ControllerManager controllerManager;
    private final CoreMetaData coreMetaData;
    private final Logger logger;
    private final MainLooperHandler mainLooperHandler;

    public InAppController(Context context, CleverTapInstanceConfig config, MainLooperHandler mainLooperHandler, ControllerManager controllerManager, BaseCallbackManager callbackManager, AnalyticsManager analyticsManager, CoreMetaData coreMetaData) {
        this.context = context;
        this.config = config;
        this.logger = this.config.getLogger();
        this.mainLooperHandler = mainLooperHandler;
        this.controllerManager = controllerManager;
        this.callbackManager = callbackManager;
        this.analyticsManager = analyticsManager;
        this.coreMetaData = coreMetaData;
    }

    public void checkExistingInAppNotifications(Activity activity) {
        boolean canShow = this.canShowInAppOnActivity();
        if (canShow && currentlyDisplayingInApp != null && System.currentTimeMillis() / 1000L < currentlyDisplayingInApp.getTimeToLive()) {
            Fragment inAppFragment = ((FragmentActivity)activity).getSupportFragmentManager().getFragment(new Bundle(), currentlyDisplayingInApp.getType());
            if (CoreMetaData.getCurrentActivity() != null && inAppFragment != null) {
                FragmentTransaction fragmentTransaction = ((FragmentActivity)activity).getSupportFragmentManager().beginTransaction();
                Bundle bundle = new Bundle();
                bundle.putParcelable("inApp", (Parcelable)currentlyDisplayingInApp);
                bundle.putParcelable("config", (Parcelable)this.config);
                inAppFragment.setArguments(bundle);
                fragmentTransaction.setCustomAnimations(0x10B0000, 0x10B0001);
                fragmentTransaction.add(0x1020002, inAppFragment, currentlyDisplayingInApp.getType());
                Logger.v(this.config.getAccountId(), "calling InAppFragment " + currentlyDisplayingInApp.getCampaignId());
                fragmentTransaction.commit();
            }
        }
    }

    public void checkPendingInAppNotifications(Activity activity) {
        boolean canShow = this.canShowInAppOnActivity();
        if (canShow) {
            if (this.mainLooperHandler.getPendingRunnable() != null) {
                this.logger.verbose(this.config.getAccountId(), "Found a pending inapp runnable. Scheduling it");
                this.mainLooperHandler.postDelayed(this.mainLooperHandler.getPendingRunnable(), 200L);
                this.mainLooperHandler.setPendingRunnable(null);
            } else {
                this.showNotificationIfAvailable(this.context);
            }
        } else {
            Logger.d("In-app notifications will not be shown for this activity (" + (activity != null ? activity.getLocalClassName() : "") + ")");
        }
    }

    @Override
    public void inAppNotificationDidClick(CTInAppNotification inAppNotification, Bundle formData, HashMap<String, String> keyValueMap) {
        this.analyticsManager.pushInAppNotificationStateEvent(true, inAppNotification, formData);
        if (keyValueMap != null && !keyValueMap.isEmpty() && this.callbackManager.getInAppNotificationButtonListener() != null) {
            this.callbackManager.getInAppNotificationButtonListener().onInAppButtonClick(keyValueMap);
        }
    }

    @Override
    public void inAppNotificationDidDismiss(final Context context, final CTInAppNotification inAppNotification, Bundle formData) {
        inAppNotification.didDismiss();
        if (this.controllerManager.getInAppFCManager() != null) {
            this.controllerManager.getInAppFCManager().didDismiss(inAppNotification);
            this.logger.verbose(this.config.getAccountId(), "InApp Dismissed: " + inAppNotification.getCampaignId());
        }
        try {
            InAppNotificationListener listener = this.callbackManager.getInAppNotificationListener();
            if (listener != null) {
                HashMap<String, Object> notifKVS = inAppNotification.getCustomExtras() != null ? Utils.convertJSONObjectToHashMap(inAppNotification.getCustomExtras()) : new HashMap();
                Logger.v("Calling the in-app listener on behalf of " + this.coreMetaData.getSource());
                if (formData != null) {
                    listener.onDismissed(notifKVS, Utils.convertBundleObjectToHashMap(formData));
                } else {
                    listener.onDismissed(notifKVS, null);
                }
            }
        }
        catch (Throwable t) {
            this.logger.verbose(this.config.getAccountId(), "Failed to call the in-app notification listener", t);
        }
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask("TAG_FEATURE_IN_APPS");
        task.execute("InappController#inAppNotificationDidDismiss", new Callable<Void>(){

            @Override
            public Void call() {
                InAppController.inAppDidDismiss(context, InAppController.this.config, inAppNotification, InAppController.this);
                InAppController.this._showNotificationIfAvailable(context);
                return null;
            }
        });
    }

    @Override
    public void inAppNotificationDidShow(CTInAppNotification inAppNotification, Bundle formData) {
        this.analyticsManager.pushInAppNotificationStateEvent(false, inAppNotification, formData);
    }

    @Override
    public void notificationReady(final CTInAppNotification inAppNotification) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            this.mainLooperHandler.post(new Runnable(){

                @Override
                public void run() {
                    InAppController.this.notificationReady(inAppNotification);
                }
            });
            return;
        }
        if (inAppNotification.getError() != null) {
            this.logger.debug(this.config.getAccountId(), "Unable to process inapp notification " + inAppNotification.getError());
            return;
        }
        this.logger.debug(this.config.getAccountId(), "Notification ready: " + inAppNotification.getJsonDescription());
        this.displayNotification(inAppNotification);
    }

    public void showNotificationIfAvailable(final Context context) {
        if (!this.config.isAnalyticsOnly()) {
            Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask("TAG_FEATURE_IN_APPS");
            task.execute("InappController#showNotificationIfAvailable", new Callable<Void>(){

                @Override
                public Void call() {
                    InAppController.this._showNotificationIfAvailable(context);
                    return null;
                }
            });
        }
    }

    private void _showNotificationIfAvailable(Context context) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        try {
            if (!this.canShowInAppOnActivity()) {
                Logger.v("Not showing notification on blacklisted activity");
                return;
            }
            InAppController.checkPendingNotifications(context, this.config, this);
            JSONArray inapps = new JSONArray(StorageHelper.getStringFromPrefs(context, this.config, "inApp", "[]"));
            if (inapps.length() < 1) {
                return;
            }
            JSONObject inapp = inapps.getJSONObject(0);
            this.prepareNotificationForDisplay(inapp);
            JSONArray inappsUpdated = new JSONArray();
            for (int i = 0; i < inapps.length(); ++i) {
                if (i == 0) continue;
                inappsUpdated.put(inapps.get(i));
            }
            SharedPreferences.Editor editor = prefs.edit().putString(StorageHelper.storageKeyWithSuffix(this.config, "inApp"), inappsUpdated.toString());
            StorageHelper.persist(editor);
        }
        catch (Throwable t) {
            this.logger.verbose(this.config.getAccountId(), "InApp: Couldn't parse JSON array string from prefs", t);
        }
    }

    private boolean canShowInAppOnActivity() {
        this.updateBlacklistedActivitySet();
        for (String blacklistedActivity : this.inappActivityExclude) {
            String currentActivityName = CoreMetaData.getCurrentActivityName();
            if (currentActivityName == null || !currentActivityName.contains(blacklistedActivity)) continue;
            return false;
        }
        return true;
    }

    private void displayNotification(final CTInAppNotification inAppNotification) {
        boolean goFromListener;
        if (Looper.myLooper() != Looper.getMainLooper()) {
            this.mainLooperHandler.post(new Runnable(){

                @Override
                public void run() {
                    InAppController.this.displayNotification(inAppNotification);
                }
            });
            return;
        }
        if (this.controllerManager.getInAppFCManager() != null) {
            if (!this.controllerManager.getInAppFCManager().canShow(inAppNotification)) {
                this.logger.verbose(this.config.getAccountId(), "InApp has been rejected by FC, not showing " + inAppNotification.getCampaignId());
                this.showInAppNotificationIfAny();
                return;
            }
        } else {
            this.logger.verbose(this.config.getAccountId(), "getCoreState().getInAppFCManager() is NULL, not showing " + inAppNotification.getCampaignId());
            return;
        }
        this.controllerManager.getInAppFCManager().didShow(this.context, inAppNotification);
        InAppNotificationListener listener = this.callbackManager.getInAppNotificationListener();
        if (listener != null) {
            HashMap<String, Object> kvs = inAppNotification.getCustomExtras() != null ? Utils.convertJSONObjectToHashMap(inAppNotification.getCustomExtras()) : new HashMap();
            goFromListener = listener.beforeShow(kvs);
        } else {
            goFromListener = true;
        }
        if (!goFromListener) {
            this.logger.verbose(this.config.getAccountId(), "Application has decided to not show this in-app notification: " + inAppNotification.getCampaignId());
            this.showInAppNotificationIfAny();
            return;
        }
        InAppController.showInApp(this.context, inAppNotification, this.config, this);
    }

    private void prepareNotificationForDisplay(final JSONObject jsonObject) {
        this.logger.debug(this.config.getAccountId(), "Preparing In-App for display: " + jsonObject.toString());
        Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask("TAG_FEATURE_IN_APPS");
        task.execute("InappController#prepareNotificationForDisplay", new Callable<Void>(){

            @Override
            public Void call() {
                new NotificationPrepareRunnable(InAppController.this, jsonObject).run();
                return null;
            }
        });
    }

    private void showInAppNotificationIfAny() {
        if (!this.config.isAnalyticsOnly()) {
            Task<Void> task = CTExecutorFactory.executors(this.config).postAsyncSafelyTask("TAG_FEATURE_IN_APPS");
            task.execute("InAppController#showInAppNotificationIfAny", new Callable<Void>(){

                @Override
                public Void call() {
                    InAppController.this._showNotificationIfAvailable(InAppController.this.context);
                    return null;
                }
            });
        }
    }

    private void updateBlacklistedActivitySet() {
        if (this.inappActivityExclude == null) {
            this.inappActivityExclude = new HashSet();
            try {
                String activities = ManifestInfo.getInstance(this.context).getExcludedActivities();
                if (activities != null) {
                    String[] split;
                    for (String a : split = activities.split(",")) {
                        this.inappActivityExclude.add(a.trim());
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.logger.debug(this.config.getAccountId(), "In-app notifications will not be shown on " + Arrays.toString(this.inappActivityExclude.toArray()));
        }
    }

    private static void checkPendingNotifications(final Context context, final CleverTapInstanceConfig config, final InAppController inAppController) {
        Logger.v(config.getAccountId(), "checking Pending Notifications");
        if (pendingNotifications != null && !pendingNotifications.isEmpty()) {
            try {
                final CTInAppNotification notification = pendingNotifications.get(0);
                pendingNotifications.remove(0);
                MainLooperHandler mainHandler = new MainLooperHandler();
                mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        InAppController.showInApp(context, notification, config, inAppController);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void inAppDidDismiss(Context context, CleverTapInstanceConfig config, CTInAppNotification inAppNotification, InAppController inAppController) {
        Logger.v(config.getAccountId(), "Running inAppDidDismiss");
        if (currentlyDisplayingInApp != null && currentlyDisplayingInApp.getCampaignId().equals(inAppNotification.getCampaignId())) {
            currentlyDisplayingInApp = null;
            InAppController.checkPendingNotifications(context, config, inAppController);
        }
    }

    private static void showInApp(Context context, CTInAppNotification inAppNotification, CleverTapInstanceConfig config, InAppController inAppController) {
        Logger.v(config.getAccountId(), "Attempting to show next In-App");
        if (!CoreMetaData.isAppForeground()) {
            pendingNotifications.add(inAppNotification);
            Logger.v(config.getAccountId(), "Not in foreground, queueing this In App");
            return;
        }
        if (currentlyDisplayingInApp != null) {
            pendingNotifications.add(inAppNotification);
            Logger.v(config.getAccountId(), "In App already displaying, queueing this In App");
            return;
        }
        if (System.currentTimeMillis() / 1000L > inAppNotification.getTimeToLive()) {
            Logger.d("InApp has elapsed its time to live, not showing the InApp");
            return;
        }
        currentlyDisplayingInApp = inAppNotification;
        CTInAppBasePartialFragment inAppFragment = null;
        CTInAppType type = inAppNotification.getInAppType();
        switch (type) {
            case CTInAppTypeCoverHTML: 
            case CTInAppTypeInterstitialHTML: 
            case CTInAppTypeHalfInterstitialHTML: 
            case CTInAppTypeCover: 
            case CTInAppTypeHalfInterstitial: 
            case CTInAppTypeInterstitial: 
            case CTInAppTypeAlert: 
            case CTInAppTypeInterstitialImageOnly: 
            case CTInAppTypeHalfInterstitialImageOnly: 
            case CTInAppTypeCoverImageOnly: {
                Intent intent = new Intent(context, InAppNotificationActivity.class);
                intent.putExtra("inApp", (Parcelable)inAppNotification);
                Bundle configBundle = new Bundle();
                configBundle.putParcelable("config", (Parcelable)config);
                intent.putExtra("configBundle", configBundle);
                try {
                    Activity currentActivity = CoreMetaData.getCurrentActivity();
                    if (currentActivity == null) {
                        throw new IllegalStateException("Current activity reference not found");
                    }
                    config.getLogger().verbose(config.getAccountId(), "calling InAppActivity for notification: " + inAppNotification.getJsonDescription());
                    currentActivity.startActivity(intent);
                    Logger.d("Displaying In-App: " + inAppNotification.getJsonDescription());
                }
                catch (Throwable t) {
                    Logger.v("Please verify the integration of your app. It is not setup to support in-app notifications yet.", t);
                }
                break;
            }
            case CTInAppTypeFooterHTML: {
                inAppFragment = new CTInAppHtmlFooterFragment();
                break;
            }
            case CTInAppTypeHeaderHTML: {
                inAppFragment = new CTInAppHtmlHeaderFragment();
                break;
            }
            case CTInAppTypeFooter: {
                inAppFragment = new CTInAppNativeFooterFragment();
                break;
            }
            case CTInAppTypeHeader: {
                inAppFragment = new CTInAppNativeHeaderFragment();
                break;
            }
            default: {
                Logger.d(config.getAccountId(), "Unknown InApp Type found: " + (Object)((Object)type));
                currentlyDisplayingInApp = null;
                return;
            }
        }
        if (inAppFragment != null) {
            Logger.d("Displaying In-App: " + inAppNotification.getJsonDescription());
            try {
                FragmentTransaction fragmentTransaction = ((FragmentActivity)CoreMetaData.getCurrentActivity()).getSupportFragmentManager().beginTransaction();
                Bundle bundle = new Bundle();
                bundle.putParcelable("inApp", (Parcelable)inAppNotification);
                bundle.putParcelable("config", (Parcelable)config);
                inAppFragment.setArguments(bundle);
                fragmentTransaction.setCustomAnimations(0x10B0000, 0x10B0001);
                fragmentTransaction.add(0x1020002, (Fragment)inAppFragment, inAppNotification.getType());
                Logger.v(config.getAccountId(), "calling InAppFragment " + inAppNotification.getCampaignId());
                fragmentTransaction.commit();
            }
            catch (ClassCastException e) {
                Logger.v(config.getAccountId(), "Fragment not able to render, please ensure your Activity is an instance of AppCompatActivity" + e.getMessage());
            }
            catch (Throwable t) {
                Logger.v(config.getAccountId(), "Fragment not able to render", t);
            }
        }
    }

    private final class NotificationPrepareRunnable
    implements Runnable {
        private final WeakReference<InAppController> inAppControllerWeakReference;
        private final JSONObject jsonObject;
        private final boolean videoSupport = Utils.haveVideoPlayerSupport;

        NotificationPrepareRunnable(InAppController inAppController2, JSONObject jsonObject) {
            this.inAppControllerWeakReference = new WeakReference<InAppController>(inAppController2);
            this.jsonObject = jsonObject;
        }

        @Override
        public void run() {
            CTInAppNotification inAppNotification = new CTInAppNotification().initWithJSON(this.jsonObject, this.videoSupport);
            if (inAppNotification.getError() != null) {
                InAppController.this.logger.debug(InAppController.this.config.getAccountId(), "Unable to parse inapp notification " + inAppNotification.getError());
                return;
            }
            inAppNotification.listener = (CTInAppNotification.CTInAppNotificationListener)this.inAppControllerWeakReference.get();
            inAppNotification.prepareForDisplay();
        }
    }
}

