/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.pushnotification;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.clevertap.android.sdk.CTExecutors;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.ValidationResultStack;
import com.clevertap.android.sdk.pushnotification.CTApiPushListener;
import com.clevertap.android.sdk.pushnotification.CTPushProvider;
import com.clevertap.android.sdk.pushnotification.CTPushProviderListener;
import com.clevertap.android.sdk.pushnotification.PushConstants;
import com.clevertap.android.sdk.pushnotification.PushNotificationUtil;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class PushProviders
implements CTPushProviderListener {
    private final ArrayList<PushConstants.PushType> allEnabledPushTypes = new ArrayList();
    private final ArrayList<CTPushProvider> availableCTPushProviders = new ArrayList();
    private final CTApiPushListener ctApiPushListener;
    private final ArrayList<PushConstants.PushType> customEnabledPushTypes = new ArrayList();

    @NonNull
    public static PushProviders load(CTApiPushListener ctApiPushListener) {
        PushProviders providers = new PushProviders(ctApiPushListener);
        providers.init();
        return providers;
    }

    private PushProviders(CTApiPushListener ctApiPushListener) {
        this.ctApiPushListener = ctApiPushListener;
    }

    public void cacheToken(final String token, final PushConstants.PushType pushType) {
        if (TextUtils.isEmpty((CharSequence)token) || pushType == null) {
            return;
        }
        try {
            CTExecutors.getInstance().diskIO().execute(new Runnable(){

                @Override
                public void run() {
                    if (PushProviders.this.alreadyHaveToken(token, pushType)) {
                        return;
                    }
                    String key = pushType.getTokenPrefKey();
                    if (TextUtils.isEmpty((CharSequence)key)) {
                        return;
                    }
                    StorageHelper.putStringImmediate(PushProviders.this.context(), StorageHelper.storageKeyWithSuffix(PushProviders.this.config(), key), token);
                    PushProviders.this.config().log("PushProvider", (Object)((Object)pushType) + "Cached New Token successfully " + token);
                }
            });
        }
        catch (Throwable t) {
            this.config().log("PushProvider", (Object)((Object)pushType) + "Unable to cache token " + token, t);
        }
    }

    @Override
    public CleverTapInstanceConfig config() {
        return this.ctApiPushListener.config();
    }

    @Override
    public Context context() {
        return this.ctApiPushListener.context();
    }

    @Override
    public DeviceInfo deviceInfo() {
        return this.ctApiPushListener.deviceInfo();
    }

    @NonNull
    public ArrayList<PushConstants.PushType> getAvailablePushTypes() {
        ArrayList<PushConstants.PushType> pushTypes = new ArrayList<PushConstants.PushType>();
        for (CTPushProvider pushProvider : this.availableCTPushProviders) {
            pushTypes.add(pushProvider.getPushType());
        }
        return pushTypes;
    }

    public String getCachedToken(PushConstants.PushType pushType) {
        String key;
        if (pushType != null && !TextUtils.isEmpty((CharSequence)(key = pushType.getTokenPrefKey()))) {
            String cachedToken = StorageHelper.getStringFromPrefs(this.context(), this.config(), key, null);
            this.config().log("PushProvider", (Object)((Object)pushType) + "getting Cached Token - " + cachedToken);
            return cachedToken;
        }
        if (pushType != null) {
            this.config().log("PushProvider", (Object)((Object)pushType) + " Unable to find cached Token for type ");
        }
        return null;
    }

    public void handleToken(String token, PushConstants.PushType pushType, boolean register) {
        if (register) {
            this.registerToken(token, pushType);
        } else {
            this.unregisterToken(token, pushType);
        }
    }

    public boolean isNotificationSupported() {
        for (PushConstants.PushType pushType : this.getAvailablePushTypes()) {
            if (this.getCachedToken(pushType) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onNewToken(String token, PushConstants.PushType pushType) {
        this.ctApiPushListener.onNewToken(token, pushType);
    }

    public void refreshAllTokens() {
        CTExecutors.getInstance().diskIO().execute(new Runnable(){

            @Override
            public void run() {
                PushProviders.this.refreshCTProviderTokens();
                PushProviders.this.refreshCustomProviderTokens();
            }
        });
    }

    @Override
    public ValidationResultStack remoteErrorLogger() {
        return this.ctApiPushListener.remoteErrorLogger();
    }

    public void unregisterToken(String token, PushConstants.PushType pushType) {
        this.ctApiPushListener.pushDeviceTokenEvent(token, false, pushType);
    }

    private boolean alreadyHaveToken(String newToken, PushConstants.PushType pushType) {
        boolean alreadyAvailable;
        boolean bl = alreadyAvailable = !TextUtils.isEmpty((CharSequence)newToken) && pushType != null && newToken.equalsIgnoreCase(this.getCachedToken(pushType));
        if (pushType != null) {
            this.config().log("PushProvider", (Object)((Object)pushType) + "Token Already available value: " + alreadyAvailable);
        }
        return alreadyAvailable;
    }

    @NonNull
    private List<CTPushProvider> createProviders() {
        ArrayList<CTPushProvider> providers = new ArrayList<CTPushProvider>();
        for (PushConstants.PushType pushType : this.allEnabledPushTypes) {
            String className = pushType.getCtProviderClassName();
            CTPushProvider pushProvider = null;
            try {
                Class<?> providerClass = Class.forName(className);
                Constructor<?> constructor = providerClass.getConstructor(CTPushProviderListener.class);
                pushProvider = (CTPushProvider)constructor.newInstance(this);
                this.config().log("PushProvider", "Found provider:" + className);
            }
            catch (InstantiationException e) {
                this.config().log("PushProvider", "Unable to create provider InstantiationException" + className);
            }
            catch (IllegalAccessException e) {
                this.config().log("PushProvider", "Unable to create provider IllegalAccessException" + className);
            }
            catch (ClassNotFoundException e) {
                this.config().log("PushProvider", "Unable to create provider ClassNotFoundException" + className);
            }
            catch (Exception e) {
                this.config().log("PushProvider", "Unable to create provider " + className + " Exception:" + e.getClass().getName());
            }
            if (pushProvider == null) continue;
            providers.add(pushProvider);
        }
        return providers;
    }

    private void findCTPushProviders(List<CTPushProvider> providers) {
        if (providers.isEmpty()) {
            this.config().log("PushProvider", "No push providers found!. Make sure to install at least one push provider");
            return;
        }
        for (CTPushProvider provider : providers) {
            if (!this.isValid(provider)) {
                this.config().log("PushProvider", "Invalid Provider: " + provider.getClass());
                continue;
            }
            if (!provider.isSupported()) {
                this.config().log("PushProvider", "Unsupported Provider: " + provider.getClass());
                continue;
            }
            if (provider.isAvailable()) {
                this.config().log("PushProvider", "Available Provider: " + provider.getClass());
                this.availableCTPushProviders.add(provider);
                continue;
            }
            this.config().log("PushProvider", "Unavailable Provider: " + provider.getClass());
        }
    }

    private void findCustomEnabledPushTypes() {
        this.customEnabledPushTypes.addAll(this.allEnabledPushTypes);
        for (CTPushProvider pushProvider : this.availableCTPushProviders) {
            this.customEnabledPushTypes.remove((Object)pushProvider.getPushType());
        }
    }

    private void findEnabledPushTypes() {
        for (PushConstants.PushType pushType : PushNotificationUtil.getPushTypes(this.config().getAllowedPushTypes())) {
            String className = pushType.getMessagingSDKClassName();
            try {
                Class.forName(className);
                this.allEnabledPushTypes.add(pushType);
                this.config().log("PushProvider", "SDK Class Available :" + className);
            }
            catch (Exception e) {
                this.config().log("PushProvider", "SDK class Not available " + className + " Exception:" + e.getClass().getName());
            }
        }
    }

    private void init() {
        this.findEnabledPushTypes();
        List<CTPushProvider> providers = this.createProviders();
        this.findCTPushProviders(providers);
        this.findCustomEnabledPushTypes();
    }

    private boolean isValid(CTPushProvider provider) {
        if (40004 < provider.minSDKSupportVersionCode()) {
            this.config().log("PushProvider", "Provider: %s version %s does not match the SDK version %s. Make sure all Airship dependencies are the same version.");
            return false;
        }
        switch (provider.getPushType()) {
            case FCM: 
            case HPS: 
            case XPS: 
            case BPS: {
                if (provider.getPlatform() == 1) break;
                this.config().log("PushProvider", "Invalid Provider: " + provider.getClass() + " delivery is only available for Android platforms." + (Object)((Object)provider.getPushType()));
                return false;
            }
            case ADM: {
                if (provider.getPlatform() == 2) break;
                this.config().log("PushProvider", "Invalid Provider: " + provider.getClass() + " ADM delivery is only available for Amazon platforms." + (Object)((Object)provider.getPushType()));
                return false;
            }
        }
        return true;
    }

    private void refreshCTProviderTokens() {
        for (CTPushProvider pushProvider : this.availableCTPushProviders) {
            try {
                pushProvider.requestToken();
            }
            catch (Throwable t) {
                this.config().log("PushProvider", "Token Refresh error " + pushProvider, t);
            }
        }
    }

    private void refreshCustomProviderTokens() {
        for (PushConstants.PushType pushType : this.customEnabledPushTypes) {
            try {
                this.ctApiPushListener.pushDeviceTokenEvent(this.getCachedToken(pushType), true, pushType);
            }
            catch (Throwable t) {
                this.config().log("PushProvider", "Token Refresh error " + (Object)((Object)pushType), t);
            }
        }
    }

    private void registerToken(String token, PushConstants.PushType pushType) {
        this.ctApiPushListener.pushDeviceTokenEvent(token, true, pushType);
        this.cacheToken(token, pushType);
    }
}

