/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.location.Location;
import android.location.LocationManager;
import android.media.AudioAttributes;
import android.media.RingtoneManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.app.NotificationCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentTransaction;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;
import com.clevertap.android.sdk.CTExperimentsListener;
import com.clevertap.android.sdk.CTFeatureFlagsListener;
import com.clevertap.android.sdk.CTInAppBasePartialFragment;
import com.clevertap.android.sdk.CTInAppHtmlFooterFragment;
import com.clevertap.android.sdk.CTInAppHtmlHeaderFragment;
import com.clevertap.android.sdk.CTInAppNativeFooterFragment;
import com.clevertap.android.sdk.CTInAppNativeHeaderFragment;
import com.clevertap.android.sdk.CTInAppNotification;
import com.clevertap.android.sdk.CTInAppType;
import com.clevertap.android.sdk.CTInboxActivity;
import com.clevertap.android.sdk.CTInboxController;
import com.clevertap.android.sdk.CTInboxListener;
import com.clevertap.android.sdk.CTInboxMessage;
import com.clevertap.android.sdk.CTInboxStyleConfig;
import com.clevertap.android.sdk.CTJsonConverter;
import com.clevertap.android.sdk.CTMessageDAO;
import com.clevertap.android.sdk.CleverTapAPIListener;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Constants;
import com.clevertap.android.sdk.DBAdapter;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.EventDetail;
import com.clevertap.android.sdk.GeofenceCallback;
import com.clevertap.android.sdk.InAppFCManager;
import com.clevertap.android.sdk.InAppNotificationActivity;
import com.clevertap.android.sdk.InAppNotificationButtonListener;
import com.clevertap.android.sdk.InAppNotificationListener;
import com.clevertap.android.sdk.InboxMessageButtonListener;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.ManifestValidator;
import com.clevertap.android.sdk.QueueCursor;
import com.clevertap.android.sdk.SSLContextBuilder;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.SyncListener;
import com.clevertap.android.sdk.UTMDetail;
import com.clevertap.android.sdk.UriHelper;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.ValidationResult;
import com.clevertap.android.sdk.ValidationResultFactory;
import com.clevertap.android.sdk.ValidationResultStack;
import com.clevertap.android.sdk.Validator;
import com.clevertap.android.sdk.ab_testing.CTABTestController;
import com.clevertap.android.sdk.displayunits.CTDisplayUnitController;
import com.clevertap.android.sdk.displayunits.DisplayUnitListener;
import com.clevertap.android.sdk.displayunits.model.CleverTapDisplayUnit;
import com.clevertap.android.sdk.featureFlags.CTFeatureFlagsController;
import com.clevertap.android.sdk.login.IdentityRepo;
import com.clevertap.android.sdk.login.IdentityRepoFactory;
import com.clevertap.android.sdk.login.LoginInfoProvider;
import com.clevertap.android.sdk.product_config.CTProductConfigController;
import com.clevertap.android.sdk.product_config.CTProductConfigListener;
import com.clevertap.android.sdk.pushnotification.CTPushNotificationListener;
import com.clevertap.android.sdk.pushnotification.CTPushNotificationReceiver;
import com.clevertap.android.sdk.pushnotification.NotificationInfo;
import com.clevertap.android.sdk.pushnotification.PushConstants;
import com.clevertap.android.sdk.pushnotification.PushProviders;
import com.clevertap.android.sdk.pushnotification.amp.CTBackgroundJobService;
import com.clevertap.android.sdk.pushnotification.amp.CTPushAmpListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CleverTapAPI
implements CleverTapAPIListener {
    public static final String NOTIFICATION_TAG = "wzrk_pn";
    static boolean haveVideoPlayerSupport;
    private static int debugLevel;
    private static CleverTapInstanceConfig defaultConfig;
    private static HashMap<String, CleverTapAPI> instances;
    private static boolean appForeground;
    private static int activityCount;
    private static final List<CTInAppNotification> pendingNotifications;
    private static CTInAppNotification currentlyDisplayingInApp;
    private static WeakReference<Activity> currentActivity;
    private static int initialAppEnteredForegroundTime;
    private static SSLContext sslContext;
    private static SSLSocketFactory sslSocketFactory;
    private static String sdkVersion;
    private static boolean isUIEditorEnabled;
    private long EXECUTOR_THREAD_ID = 0L;
    private long NOTIFICATION_THREAD_ID = 0L;
    private long appInstallTime = 0L;
    private long appLastSeen = 0L;
    private boolean appLaunchPushed = false;
    private final Object appLaunchPushedLock = new Object();
    private String cachedGUID = null;
    private Runnable commsRunnable = null;
    private final CleverTapInstanceConfig config;
    private final Context context;
    private CTABTestController ctABTestController;
    private CTFeatureFlagsController ctFeatureFlagsController;
    private CTInboxController ctInboxController;
    private CTProductConfigController ctProductConfigController;
    private int currentRequestTimestamp = 0;
    private String currentScreenName = "";
    private int currentSessionId = 0;
    private boolean currentUserOptedOut = false;
    private DBAdapter dbAdapter;
    private final DeviceInfo deviceInfo;
    private final Object displayUnitControllerLock = new Object();
    private WeakReference<DisplayUnitListener> displayUnitListenerWeakReference;
    private boolean enableNetworkInfoReporting = false;
    private final ExecutorService es;
    private final Boolean eventLock = true;
    private CTExperimentsListener experimentsListener = null;
    private WeakReference<CTFeatureFlagsListener> featureFlagsListener;
    private boolean firstRequestInSession = false;
    private boolean firstSession = false;
    private GeofenceCallback geofenceCallback;
    private int geofenceSDKVersion = 0;
    private final Handler handlerUsingMainLooper;
    private InAppFCManager inAppFCManager;
    private WeakReference<InAppNotificationButtonListener> inAppNotificationButtonListener;
    private InAppNotificationListener inAppNotificationListener;
    private HashSet<String> inappActivityExclude = null;
    private final Object inboxControllerLock = new Object();
    private CTInboxListener inboxListener;
    private WeakReference<InboxMessageButtonListener> inboxMessageButtonListener;
    private boolean installReferrerDataSent = false;
    private final HashMap<String, Integer> installReferrerMap = new HashMap(8);
    private boolean isBgPing = false;
    private boolean isLocationForGeofence = false;
    private boolean isProductConfigRequested;
    private int lastLocationPingTime = 0;
    private int lastLocationPingTimeForGeofence = 0;
    private int lastSessionLength = 0;
    private int lastVisitTime;
    private final LocalDataStore localDataStore;
    private Location locationFromUser = null;
    private CTDisplayUnitController mCTDisplayUnitController;
    private int mResponseFailureCount = 0;
    private final int maxDelayFrequency = 600000;
    private int minDelayFrequency = 0;
    private int networkRetryCount = 0;
    private final HashMap<String, Object> notificationIdTagMap = new HashMap();
    private final Object notificationMapLock = new Object();
    private final HashMap<String, Object> notificationViewedIdTagMap = new HashMap();
    private final ExecutorService ns;
    private boolean offline = false;
    private final Object optOutFlagLock = new Object();
    private Runnable pendingInappRunnable = null;
    private String processingUserLoginIdentifier = null;
    private final Boolean processingUserLoginLock = true;
    private WeakReference<CTProductConfigListener> productConfigListener;
    private CTPushAmpListener pushAmpListener = null;
    private CTPushNotificationListener pushNotificationListener = null;
    private Runnable pushNotificationViewedRunnable = null;
    private final PushProviders pushProviders;
    private long referrerClickTime = 0L;
    private String source = null;
    private String medium = null;
    private String campaign = null;
    private SyncListener syncListener = null;
    private final Object tokenLock = new Object();
    private DevicePushTokenRefreshListener tokenRefreshListener;
    private final ValidationResultStack validationResultStack;
    private final Validator validator;
    private JSONObject wzrkParams = null;

    public static void changeCredentials(String accountID, String token) {
        CleverTapAPI.changeCredentials(accountID, token, null);
    }

    public static void changeCredentials(String accountID, String token, String region) {
        if (defaultConfig != null) {
            Logger.i("CleverTap SDK already initialized with accountID:" + defaultConfig.getAccountId() + " and token:" + defaultConfig.getAccountToken() + ". Cannot change credentials to " + accountID + " and " + token);
            return;
        }
        ManifestInfo.changeCredentials(accountID, token, region);
    }

    public static void createNotification(Context context, Bundle extras, int notificationId) {
        String _accountId = extras.getString("wzrk_acct_id");
        if (instances == null) {
            CleverTapAPI instance = CleverTapAPI.createInstanceIfAvailable(context, _accountId);
            if (instance != null) {
                instance._createNotification(context, extras, notificationId);
            }
            return;
        }
        for (String accountId : instances.keySet()) {
            CleverTapAPI instance = instances.get(accountId);
            boolean shouldProcess = false;
            if (instance != null) {
                boolean bl = shouldProcess = _accountId == null && instance.config.isDefaultInstance() || instance.getAccountId().equals(_accountId);
            }
            if (!shouldProcess) continue;
            try {
                instance._createNotification(context, extras, notificationId);
            }
            catch (Throwable throwable) {}
            break;
        }
    }

    public static void createNotification(Context context, Bundle extras) {
        CleverTapAPI.createNotification(context, extras, -1000);
    }

    public static void createNotificationChannel(final Context context, final String channelId, final CharSequence channelName, final String channelDescription, final int importance, final boolean showBadge) {
        final CleverTapAPI instance = CleverTapAPI.getDefaultInstanceOrFirstOther(context);
        if (instance == null) {
            Logger.v("No CleverTap Instance found in CleverTapAPI#createNotificatonChannel");
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                instance.postAsyncSafely("createNotificationChannel", new Runnable(){

                    @Override
                    @RequiresApi(api=26)
                    public void run() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        if (notificationManager == null) {
                            return;
                        }
                        NotificationChannel notificationChannel = new NotificationChannel(channelId, channelName, importance);
                        notificationChannel.setDescription(channelDescription);
                        notificationChannel.setShowBadge(showBadge);
                        notificationManager.createNotificationChannel(notificationChannel);
                        instance.getConfigLogger().info(instance.getAccountId(), "Notification channel " + channelName.toString() + " has been created");
                    }
                });
            }
        }
        catch (Throwable t) {
            instance.getConfigLogger().verbose(instance.getAccountId(), "Failure creating Notification Channel", t);
        }
    }

    public static void createNotificationChannel(final Context context, final String channelId, final CharSequence channelName, final String channelDescription, final int importance, final String groupId, final boolean showBadge) {
        final CleverTapAPI instance = CleverTapAPI.getDefaultInstanceOrFirstOther(context);
        if (instance == null) {
            Logger.v("No CleverTap Instance found in CleverTapAPI#createNotificatonChannel");
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                instance.postAsyncSafely("creatingNotificationChannel", new Runnable(){

                    @Override
                    @RequiresApi(api=26)
                    public void run() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        if (notificationManager == null) {
                            return;
                        }
                        NotificationChannel notificationChannel = new NotificationChannel(channelId, channelName, importance);
                        notificationChannel.setDescription(channelDescription);
                        notificationChannel.setGroup(groupId);
                        notificationChannel.setShowBadge(showBadge);
                        notificationManager.createNotificationChannel(notificationChannel);
                        instance.getConfigLogger().info(instance.getAccountId(), "Notification channel " + channelName.toString() + " has been created");
                    }
                });
            }
        }
        catch (Throwable t) {
            instance.getConfigLogger().verbose(instance.getAccountId(), "Failure creating Notification Channel", t);
        }
    }

    public static void createNotificationChannel(final Context context, final String channelId, final CharSequence channelName, final String channelDescription, final int importance, final boolean showBadge, final String sound) {
        final CleverTapAPI instance = CleverTapAPI.getDefaultInstanceOrFirstOther(context);
        if (instance == null) {
            Logger.v("No CleverTap Instance found in CleverTapAPI#createNotificatonChannel");
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                instance.postAsyncSafely("createNotificationChannel", new Runnable(){

                    @Override
                    @RequiresApi(api=26)
                    public void run() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        if (notificationManager == null) {
                            return;
                        }
                        String soundfile = "";
                        Uri soundUri = null;
                        if (!sound.isEmpty()) {
                            if (sound.contains(".mp3") || sound.contains(".ogg") || sound.contains(".wav")) {
                                soundfile = sound.substring(0, sound.length() - 4);
                            } else {
                                instance.getConfigLogger().debug(instance.getAccountId(), "Sound file name not supported");
                            }
                            if (!soundfile.isEmpty()) {
                                soundUri = Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + soundfile));
                            }
                        }
                        NotificationChannel notificationChannel = new NotificationChannel(channelId, channelName, importance);
                        notificationChannel.setDescription(channelDescription);
                        notificationChannel.setShowBadge(showBadge);
                        if (soundUri != null) {
                            notificationChannel.setSound(soundUri, new AudioAttributes.Builder().setUsage(5).build());
                        } else {
                            instance.getConfigLogger().debug(instance.getAccountId(), "Sound file not found, notification channel will be created without custom sound");
                        }
                        notificationManager.createNotificationChannel(notificationChannel);
                        instance.getConfigLogger().info(instance.getAccountId(), "Notification channel " + channelName.toString() + " has been created");
                    }
                });
            }
        }
        catch (Throwable t) {
            instance.getConfigLogger().verbose(instance.getAccountId(), "Failure creating Notification Channel", t);
        }
    }

    public static void createNotificationChannel(final Context context, final String channelId, final CharSequence channelName, final String channelDescription, final int importance, final String groupId, final boolean showBadge, final String sound) {
        final CleverTapAPI instance = CleverTapAPI.getDefaultInstanceOrFirstOther(context);
        if (instance == null) {
            Logger.v("No CleverTap Instance found in CleverTapAPI#createNotificatonChannel");
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                instance.postAsyncSafely("creatingNotificationChannel", new Runnable(){

                    @Override
                    @RequiresApi(api=26)
                    public void run() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        if (notificationManager == null) {
                            return;
                        }
                        String soundfile = "";
                        Uri soundUri = null;
                        if (!sound.isEmpty()) {
                            if (sound.contains(".mp3") || sound.contains(".ogg") || sound.contains(".wav")) {
                                soundfile = sound.substring(0, sound.length() - 4);
                            } else {
                                instance.getConfigLogger().debug(instance.getAccountId(), "Sound file name not supported");
                            }
                            if (!soundfile.isEmpty()) {
                                soundUri = Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + soundfile));
                            }
                        }
                        NotificationChannel notificationChannel = new NotificationChannel(channelId, channelName, importance);
                        notificationChannel.setDescription(channelDescription);
                        notificationChannel.setGroup(groupId);
                        notificationChannel.setShowBadge(showBadge);
                        if (soundUri != null) {
                            notificationChannel.setSound(soundUri, new AudioAttributes.Builder().setUsage(5).build());
                        } else {
                            instance.getConfigLogger().debug(instance.getAccountId(), "Sound file not found, notification channel will be created without custom sound");
                        }
                        notificationManager.createNotificationChannel(notificationChannel);
                        instance.getConfigLogger().info(instance.getAccountId(), "Notification channel " + channelName.toString() + " has been created");
                    }
                });
            }
        }
        catch (Throwable t) {
            instance.getConfigLogger().verbose(instance.getAccountId(), "Failure creating Notification Channel", t);
        }
    }

    public static void createNotificationChannelGroup(final Context context, final String groupId, final CharSequence groupName) {
        final CleverTapAPI instance = CleverTapAPI.getDefaultInstanceOrFirstOther(context);
        if (instance == null) {
            Logger.v("No CleverTap Instance found in CleverTapAPI#createNotificationChannelGroup");
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                instance.postAsyncSafely("creatingNotificationChannelGroup", new Runnable(){

                    @Override
                    @RequiresApi(api=26)
                    public void run() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        if (notificationManager == null) {
                            return;
                        }
                        notificationManager.createNotificationChannelGroup(new NotificationChannelGroup(groupId, groupName));
                        instance.getConfigLogger().info(instance.getAccountId(), "Notification channel group " + groupName.toString() + " has been created");
                    }
                });
            }
        }
        catch (Throwable t) {
            instance.getConfigLogger().verbose(instance.getAccountId(), "Failure creating Notification Channel Group", t);
        }
    }

    public static void deleteNotificationChannel(final Context context, final String channelId) {
        final CleverTapAPI instance = CleverTapAPI.getDefaultInstanceOrFirstOther(context);
        if (instance == null) {
            Logger.v("No CleverTap Instance found in CleverTapAPI#deleteNotificationChannel");
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                instance.postAsyncSafely("deletingNotificationChannel", new Runnable(){

                    @Override
                    @RequiresApi(api=26)
                    public void run() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        if (notificationManager == null) {
                            return;
                        }
                        notificationManager.deleteNotificationChannel(channelId);
                        instance.getConfigLogger().info(instance.getAccountId(), "Notification channel " + channelId + " has been deleted");
                    }
                });
            }
        }
        catch (Throwable t) {
            instance.getConfigLogger().verbose(instance.getAccountId(), "Failure deleting Notification Channel", t);
        }
    }

    public static void deleteNotificationChannelGroup(final Context context, final String groupId) {
        final CleverTapAPI instance = CleverTapAPI.getDefaultInstanceOrFirstOther(context);
        if (instance == null) {
            Logger.v("No CleverTap Instance found in CleverTapAPI#deleteNotificationChannelGroup");
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                instance.postAsyncSafely("deletingNotificationChannelGroup", new Runnable(){

                    @Override
                    @RequiresApi(api=26)
                    public void run() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        if (notificationManager == null) {
                            return;
                        }
                        notificationManager.deleteNotificationChannelGroup(groupId);
                        instance.getConfigLogger().info(instance.getAccountId(), "Notification channel group " + groupId + " has been deleted");
                    }
                });
            }
        }
        catch (Throwable t) {
            instance.getConfigLogger().verbose(instance.getAccountId(), "Failure deleting Notification Channel Group", t);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void fcmTokenRefresh(Context context, String token) {
        for (CleverTapAPI instance : CleverTapAPI.getAvailableInstances(context)) {
            if (instance == null || instance.getConfig().isAnalyticsOnly()) {
                Logger.d(instance.getAccountId(), "Instance is Analytics Only not processing device token");
                continue;
            }
            String tokenUsingManifestMetaEntry = Utils.getFcmTokenUsingManifestMetaEntry(context, instance.config);
            if (!TextUtils.isEmpty((CharSequence)tokenUsingManifestMetaEntry)) {
                token = tokenUsingManifestMetaEntry;
            }
            instance.doTokenRefresh(token, PushConstants.PushType.FCM);
        }
    }

    public static int getDebugLevel() {
        return debugLevel;
    }

    public static void setDebugLevel(int level) {
        debugLevel = level;
    }

    public static void setDebugLevel(LogLevel level) {
        debugLevel = level.intValue();
    }

    public static CleverTapAPI getDefaultInstance(Context context, String cleverTapID) {
        sdkVersion = "!SDK-VERSION-STRING!:com.clevertap.android:clevertap-android-sdk:4.0.4.0";
        if (defaultConfig != null) {
            return CleverTapAPI.instanceWithConfig(context, defaultConfig, cleverTapID);
        }
        defaultConfig = CleverTapAPI.getDefaultConfig(context);
        if (defaultConfig != null) {
            return CleverTapAPI.instanceWithConfig(context, defaultConfig, cleverTapID);
        }
        return null;
    }

    @Nullable
    public static CleverTapAPI getDefaultInstance(Context context) {
        return CleverTapAPI.getDefaultInstance(context, null);
    }

    @Nullable
    public static CleverTapAPI getGlobalInstance(Context context, String _accountId) {
        if (instances == null) {
            return CleverTapAPI.createInstanceIfAvailable(context, _accountId);
        }
        CleverTapAPI instance = null;
        for (String accountId : instances.keySet()) {
            instance = instances.get(accountId);
        }
        return instance;
    }

    public static NotificationInfo getNotificationInfo(Bundle extras) {
        if (extras == null) {
            return new NotificationInfo(false, false);
        }
        boolean fromCleverTap = extras.containsKey(NOTIFICATION_TAG);
        boolean shouldRender = fromCleverTap && extras.containsKey("nm");
        return new NotificationInfo(fromCleverTap, shouldRender);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void handleNotificationClicked(Context context, Bundle notification) {
        if (notification == null) {
            return;
        }
        String _accountId = null;
        try {
            _accountId = notification.getString("wzrk_acct_id");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (instances == null) {
            CleverTapAPI instance = CleverTapAPI.createInstanceIfAvailable(context, _accountId);
            if (instance != null) {
                instance.pushNotificationClickedEvent(notification);
            }
            return;
        }
        for (String accountId : instances.keySet()) {
            CleverTapAPI instance = instances.get(accountId);
            boolean shouldProcess = false;
            if (instance != null) {
                boolean bl = shouldProcess = _accountId == null && instance.config.isDefaultInstance() || instance.getAccountId().equals(_accountId);
            }
            if (!shouldProcess) continue;
            instance.pushNotificationClickedEvent(notification);
            break;
        }
    }

    public static CleverTapAPI instanceWithConfig(Context context, CleverTapInstanceConfig config) {
        return CleverTapAPI.instanceWithConfig(context, config, null);
    }

    public static CleverTapAPI instanceWithConfig(Context context, @NonNull CleverTapInstanceConfig config, String cleverTapID) {
        CleverTapAPI instance;
        if (config == null) {
            Logger.v("CleverTapInstanceConfig cannot be null");
            return null;
        }
        if (instances == null) {
            instances = new HashMap();
        }
        if ((instance = instances.get(config.getAccountId())) == null) {
            instance = new CleverTapAPI(context, config, cleverTapID);
            instances.put(config.getAccountId(), instance);
            final CleverTapAPI finalInstance = instance;
            instance.postAsyncSafely("notifyProfileInitialized", new Runnable(){

                @Override
                public void run() {
                    if (finalInstance.getCleverTapID() != null) {
                        finalInstance.notifyUserProfileInitialized();
                        finalInstance.recordDeviceIDErrors();
                    }
                }
            });
        } else if (instance.isErrorDeviceId() && instance.getConfig().getEnableCustomCleverTapId() && Utils.validateCTID(cleverTapID)) {
            instance.asyncProfileSwitchUser(null, null, cleverTapID);
        }
        return instance;
    }

    public static void onActivityPaused() {
        if (instances == null) {
            return;
        }
        for (String accountId : instances.keySet()) {
            CleverTapAPI instance = instances.get(accountId);
            try {
                if (instance == null) continue;
                instance.activityPaused();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void onActivityResumed(Activity activity) {
        CleverTapAPI.onActivityResumed(activity, null);
    }

    public static void onActivityResumed(Activity activity, String cleverTapID) {
        if (instances == null) {
            CleverTapAPI.createInstanceIfAvailable(activity.getApplicationContext(), null, cleverTapID);
        }
        CleverTapAPI.setAppForeground(true);
        if (instances == null) {
            Logger.v("Instances is null in onActivityResumed!");
            return;
        }
        String currentActivityName = CleverTapAPI.getCurrentActivityName();
        CleverTapAPI.setCurrentActivity(activity);
        if (currentActivityName == null || !currentActivityName.equals(activity.getLocalClassName())) {
            ++activityCount;
        }
        if (initialAppEnteredForegroundTime <= 0) {
            initialAppEnteredForegroundTime = (int)System.currentTimeMillis() / 1000;
        }
        for (String accountId : instances.keySet()) {
            CleverTapAPI instance = instances.get(accountId);
            try {
                if (instance == null) continue;
                instance.activityResumed(activity);
            }
            catch (Throwable t) {
                Logger.v("Throwable - " + t.getLocalizedMessage());
            }
        }
    }

    public static void processPushNotification(Context context, Bundle extras) {
        String _accountId = extras.getString("wzrk_acct_id");
        if (instances == null) {
            CleverTapAPI instance = CleverTapAPI.createInstanceIfAvailable(context, _accountId);
            if (instance != null) {
                instance.processCustomPushNotification(extras);
            }
            return;
        }
        for (String accountId : instances.keySet()) {
            CleverTapAPI instance = instances.get(accountId);
            if (instance == null) continue;
            instance.processCustomPushNotification(extras);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void runBackgroundIntentService(Context context) {
        if (instances == null) {
            CleverTapAPI instance = CleverTapAPI.getDefaultInstance(context);
            if (instance != null) {
                if (instance.getConfig().isBackgroundSync()) {
                    instance.runInstanceJobWork(context, null);
                } else {
                    Logger.d("Instance doesn't allow Background sync, not running the Job");
                }
            }
            return;
        }
        for (String accountId : instances.keySet()) {
            CleverTapAPI instance = instances.get(accountId);
            if (instance == null) continue;
            if (instance.getConfig().isAnalyticsOnly()) {
                Logger.d(accountId, "Instance is Analytics Only not processing device token");
                continue;
            }
            if (!instance.getConfig().isBackgroundSync()) {
                Logger.d(accountId, "Instance doesn't allow Background sync, not running the Job");
                continue;
            }
            instance.runInstanceJobWork(context, null);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void runJobWork(Context context, JobParameters parameters) {
        if (instances == null) {
            CleverTapAPI instance = CleverTapAPI.getDefaultInstance(context);
            if (instance != null) {
                if (instance.getConfig().isBackgroundSync()) {
                    instance.runInstanceJobWork(context, parameters);
                } else {
                    Logger.d("Instance doesn't allow Background sync, not running the Job");
                }
            }
            return;
        }
        for (String accountId : instances.keySet()) {
            CleverTapAPI instance = instances.get(accountId);
            if (instance != null && instance.getConfig().isAnalyticsOnly()) {
                Logger.d(accountId, "Instance is Analytics Only not running the Job");
                continue;
            }
            if (instance == null || !instance.getConfig().isBackgroundSync()) {
                Logger.d(accountId, "Instance doesn't allow Background sync, not running the Job");
                continue;
            }
            instance.runInstanceJobWork(context, parameters);
        }
    }

    @Deprecated
    public static void setUIEditorConnectionEnabled(boolean enabled) {
        isUIEditorEnabled = enabled;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void tokenRefresh(Context context, String token, PushConstants.PushType pushType) {
        for (CleverTapAPI instance : CleverTapAPI.getAvailableInstances(context)) {
            if (instance == null || instance.getConfig().isAnalyticsOnly()) {
                Logger.d(instance.getAccountId(), "Instance is Analytics Only not processing device token");
                continue;
            }
            instance.doTokenRefresh(token, pushType);
        }
    }

    private CleverTapAPI(final Context context, final CleverTapInstanceConfig config, String cleverTapID) {
        this.config = new CleverTapInstanceConfig(config);
        this.context = context;
        this.handlerUsingMainLooper = new Handler(Looper.getMainLooper());
        this.es = Executors.newFixedThreadPool(1);
        this.ns = Executors.newFixedThreadPool(1);
        this.localDataStore = new LocalDataStore(context, config);
        this.validationResultStack = new ValidationResultStack();
        this.deviceInfo = new DeviceInfo(context, config, cleverTapID);
        if (this.deviceInfo.getDeviceID() != null) {
            Logger.v("Initializing InAppFC with device Id = " + this.deviceInfo.getDeviceID());
            this.inAppFCManager = new InAppFCManager(context, config, this.deviceInfo.getDeviceID());
        }
        this.initFeatureFlags(false);
        this.validator = new Validator();
        this.pushProviders = PushProviders.load(this);
        this.postAsyncSafely("CleverTapAPI#initializeDeviceInfo", new Runnable(){

            @Override
            public void run() {
                if (config.isDefaultInstance()) {
                    CleverTapAPI.this.manifestAsyncValidation();
                }
            }
        });
        int now = (int)System.currentTimeMillis() / 1000;
        if (now - initialAppEnteredForegroundTime > 5) {
            this.config.setCreatedPostAppLaunch();
        }
        this.setLastVisitTime();
        if (!(config.isDefaultInstance() || instances != null && instances.size() > 0)) {
            config.setEnableABTesting(true);
        }
        this.initABTesting();
        this.postAsyncSafely("setStatesAsync", new Runnable(){

            @Override
            public void run() {
                CleverTapAPI.this.setDeviceNetworkInfoReportingFromStorage();
                CleverTapAPI.this.setCurrentUserOptOutStateFromStorage();
            }
        });
        this.postAsyncSafely("saveConfigtoSharedPrefs", new Runnable(){

            @Override
            public void run() {
                String configJson = config.toJSONString();
                if (configJson == null) {
                    Logger.v("Unable to save config to SharedPrefs, config Json is null");
                    return;
                }
                StorageHelper.putString(context, StorageHelper.storageKeyWithSuffix(config, "instance"), configJson);
            }
        });
        if (this.config.isBackgroundSync() && !this.config.isAnalyticsOnly()) {
            this.postAsyncSafely("createOrResetJobScheduler", new Runnable(){

                @Override
                public void run() {
                    if (Build.VERSION.SDK_INT >= 21) {
                        CleverTapAPI.this.createOrResetJobScheduler(context);
                    } else {
                        CleverTapAPI.this.createAlarmScheduler(context);
                    }
                }
            });
        }
        Logger.i("CleverTap SDK initialized with accountId: " + config.getAccountId() + " accountToken: " + config.getAccountToken() + " accountRegion: " + config.getAccountRegion());
    }

    @Override
    public void ABExperimentsUpdated() {
        try {
            CTExperimentsListener sl = this.getCTExperimentsListener();
            if (sl != null) {
                sl.CTExperimentsUpdated();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void addMultiValueForKey(String key, String value) {
        if (value == null || value.isEmpty()) {
            this._generateEmptyMultiValueError(key);
            return;
        }
        this.addMultiValuesForKey(key, new ArrayList<String>(Collections.singletonList(value)));
    }

    public void addMultiValuesForKey(final String key, final ArrayList<String> values) {
        this.postAsyncSafely("addMultiValuesForKey", new Runnable(){

            @Override
            public void run() {
                String command = CleverTapAPI.this.getLocalDataStore().getProfileValueForKey(key) != null ? "$add" : "$set";
                CleverTapAPI.this._handleMultiValues(values, key, command);
            }
        });
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public CleverTapInstanceConfig config() {
        return this.config;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Context context() {
        return this.context;
    }

    public void deleteInboxMessage(final CTInboxMessage message) {
        this.postAsyncSafely("deleteInboxMessage", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = CleverTapAPI.this.inboxControllerLock;
                synchronized (object) {
                    if (CleverTapAPI.this.ctInboxController != null) {
                        boolean update = CleverTapAPI.this.ctInboxController.deleteMessageWithId(message.getMessageId());
                        if (update) {
                            CleverTapAPI.this._notifyInboxMessagesDidUpdate();
                        }
                    } else {
                        CleverTapAPI.this.getConfigLogger().debug(CleverTapAPI.this.getAccountId(), "Notification Inbox not initialized");
                    }
                }
            }
        });
    }

    public void deleteInboxMessage(String messageId) {
        CTInboxMessage message = this.getInboxMessageForId(messageId);
        this.deleteInboxMessage(message);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public DeviceInfo deviceInfo() {
        return this.deviceInfo;
    }

    public void disablePersonalization() {
        this.config.enablePersonalization(false);
    }

    public void enableDeviceNetworkInfoReporting(boolean value) {
        this.enableNetworkInfoReporting = value;
        StorageHelper.putBoolean(this.context, StorageHelper.storageKeyWithSuffix(this.config, "NetworkInfo"), this.enableNetworkInfoReporting);
        this.getConfigLogger().verbose(this.getAccountId(), "Device Network Information reporting set to " + this.enableNetworkInfoReporting);
    }

    public void enablePersonalization() {
        this.config.enablePersonalization(true);
    }

    public CTFeatureFlagsController featureFlag() {
        return this.ctFeatureFlagsController;
    }

    @Override
    public void featureFlagsDidUpdate() {
        try {
            if (this.featureFlagsListener != null && this.featureFlagsListener.get() != null) {
                ((CTFeatureFlagsListener)this.featureFlagsListener.get()).featureFlagsUpdated();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void fetchFeatureFlags() {
        if (this.config.isAnalyticsOnly()) {
            return;
        }
        JSONObject event = new JSONObject();
        JSONObject notif = new JSONObject();
        try {
            notif.put("t", 1);
            event.put("evtName", (Object)"wzrk_fetch");
            event.put("evtData", (Object)notif);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.queueEvent(this.context, event, 7);
    }

    @Override
    public void fetchProductConfig() {
        JSONObject event = new JSONObject();
        JSONObject notif = new JSONObject();
        try {
            notif.put("t", 0);
            event.put("evtName", (Object)"wzrk_fetch");
            event.put("evtData", (Object)notif);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.queueEvent(this.context, event, 7);
        this.isProductConfigRequested = true;
        this.getConfigLogger().verbose(this.getAccountId(), "Product Config : Fetching product config");
    }

    public void flush() {
        this.flushQueueAsync(this.context, EventGroup.REGULAR);
    }

    public String getAccountId() {
        return this.config.getAccountId();
    }

    @Nullable
    public ArrayList<CleverTapDisplayUnit> getAllDisplayUnits() {
        if (this.mCTDisplayUnitController != null) {
            return this.mCTDisplayUnitController.getAllDisplayUnits();
        }
        this.getConfigLogger().verbose(this.getAccountId(), "DisplayUnit : Failed to get all Display Units");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<CTInboxMessage> getAllInboxMessages() {
        ArrayList<CTInboxMessage> inboxMessageArrayList = new ArrayList<CTInboxMessage>();
        Object object = this.inboxControllerLock;
        synchronized (object) {
            if (this.ctInboxController != null) {
                ArrayList<CTMessageDAO> messageDAOArrayList = this.ctInboxController.getMessages();
                for (CTMessageDAO messageDAO : messageDAOArrayList) {
                    Logger.v("CTMessage Dao - " + messageDAO.toJSON().toString());
                    inboxMessageArrayList.add(new CTInboxMessage(messageDAO.toJSON()));
                }
                return inboxMessageArrayList;
            }
            this.getConfigLogger().debug(this.getAccountId(), "Notification Inbox not initialized");
            return inboxMessageArrayList;
        }
    }

    @Deprecated
    @RequiresApi(api=19)
    public Boolean getBooleanVariable(String name, Boolean defaultValue) {
        if (this.ctABTestController == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "ABTesting is not enabled for this instance");
            return defaultValue;
        }
        return this.ctABTestController.getBooleanVariable(name, defaultValue);
    }

    public CTExperimentsListener getCTExperimentsListener() {
        return this.experimentsListener;
    }

    public void setCTExperimentsListener(CTExperimentsListener experimentsListener) {
        this.experimentsListener = experimentsListener;
    }

    public CTInboxListener getCTNotificationInboxListener() {
        return this.inboxListener;
    }

    public void setCTNotificationInboxListener(CTInboxListener notificationInboxListener) {
        this.inboxListener = notificationInboxListener;
    }

    public CTPushAmpListener getCTPushAmpListener() {
        return this.pushAmpListener;
    }

    public void setCTPushAmpListener(CTPushAmpListener pushAmpListener) {
        this.pushAmpListener = pushAmpListener;
    }

    public CTPushNotificationListener getCTPushNotificationListener() {
        return this.pushNotificationListener;
    }

    public void setCTPushNotificationListener(CTPushNotificationListener pushNotificationListener) {
        this.pushNotificationListener = pushNotificationListener;
    }

    public String getCleverTapAttributionIdentifier() {
        return this.deviceInfo.getAttributionID();
    }

    public String getCleverTapID() {
        return this.deviceInfo.getDeviceID();
    }

    public int getCount(String event) {
        EventDetail eventDetail = this.getLocalDataStore().getEventDetail(event);
        if (eventDetail != null) {
            return eventDetail.getCount();
        }
        return -1;
    }

    public EventDetail getDetails(String event) {
        return this.getLocalDataStore().getEventDetail(event);
    }

    public Map<String, String> getDeviceInfo() {
        HashMap<String, String> deviceInfo = new HashMap<String, String>();
        deviceInfo.put("build", String.valueOf(this.deviceInfo.getBuild()));
        deviceInfo.put("versionName", this.deviceInfo.getVersionName());
        deviceInfo.put("osName", this.deviceInfo.getOsName());
        deviceInfo.put("osVersion", this.deviceInfo.getOsVersion());
        deviceInfo.put("manufacturer", this.deviceInfo.getManufacturer());
        deviceInfo.put("model", this.deviceInfo.getModel());
        deviceInfo.put("sdkVersion", String.valueOf(this.deviceInfo.getSdkVersion()));
        deviceInfo.put("dpi", String.valueOf(this.deviceInfo.getDPI()));
        deviceInfo.put("device_width", String.valueOf(this.deviceInfo.getWidthPixels()));
        deviceInfo.put("device_height", String.valueOf(this.deviceInfo.getHeightPixels()));
        if (this.deviceInfo.getLibrary() != null) {
            deviceInfo.put("library", this.deviceInfo.getLibrary());
        }
        return deviceInfo;
    }

    public String getDevicePushToken(PushConstants.PushType type) {
        return this.pushProviders.getCachedToken(type);
    }

    public DevicePushTokenRefreshListener getDevicePushTokenRefreshListener() {
        return this.tokenRefreshListener;
    }

    public void setDevicePushTokenRefreshListener(DevicePushTokenRefreshListener tokenRefreshListener) {
        this.tokenRefreshListener = tokenRefreshListener;
    }

    @Nullable
    public CleverTapDisplayUnit getDisplayUnitForId(String unitID) {
        if (this.mCTDisplayUnitController != null) {
            return this.mCTDisplayUnitController.getDisplayUnitForID(unitID);
        }
        this.getConfigLogger().verbose(this.getAccountId(), "DisplayUnit : Failed to get Display Unit for id: " + unitID);
        return null;
    }

    @Deprecated
    @RequiresApi(api=19)
    public Double getDoubleVariable(String name, Double defaultValue) {
        if (this.ctABTestController == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "ABTesting is not enabled for this instance");
            return defaultValue;
        }
        return this.ctABTestController.getDoubleVariable(name, defaultValue);
    }

    public int getFirstTime(String event) {
        EventDetail eventDetail = this.getLocalDataStore().getEventDetail(event);
        if (eventDetail != null) {
            return eventDetail.getFirstTime();
        }
        return -1;
    }

    public GeofenceCallback getGeofenceCallback() {
        return this.geofenceCallback;
    }

    public void setGeofenceCallback(GeofenceCallback geofenceCallback) {
        this.geofenceCallback = geofenceCallback;
    }

    public Map<String, EventDetail> getHistory() {
        return this.getLocalDataStore().getEventHistory(this.context);
    }

    public InAppNotificationListener getInAppNotificationListener() {
        return this.inAppNotificationListener;
    }

    public void setInAppNotificationListener(InAppNotificationListener inAppNotificationListener) {
        this.inAppNotificationListener = inAppNotificationListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInboxMessageCount() {
        Object object = this.inboxControllerLock;
        synchronized (object) {
            if (this.ctInboxController != null) {
                return this.ctInboxController.count();
            }
            this.getConfigLogger().debug(this.getAccountId(), "Notification Inbox not initialized");
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CTInboxMessage getInboxMessageForId(String messageId) {
        Object object = this.inboxControllerLock;
        synchronized (object) {
            if (this.ctInboxController != null) {
                CTMessageDAO message = this.ctInboxController.getMessageForId(messageId);
                CTInboxMessage cTInboxMessage = message != null ? new CTInboxMessage(message.toJSON()) : null;
                return cTInboxMessage;
            }
            this.getConfigLogger().debug(this.getAccountId(), "Notification Inbox not initialized");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInboxMessageUnreadCount() {
        Object object = this.inboxControllerLock;
        synchronized (object) {
            if (this.ctInboxController != null) {
                return this.ctInboxController.unreadCount();
            }
            this.getConfigLogger().debug(this.getAccountId(), "Notification Inbox not initialized");
            return -1;
        }
    }

    @RequiresApi(api=19)
    public Integer getIntegerVariable(String name, Integer defaultValue) {
        if (this.ctABTestController == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "ABTesting is not enabled for this instance");
            return defaultValue;
        }
        return this.ctABTestController.getIntegerVariable(name, defaultValue);
    }

    public int getLastTime(String event) {
        EventDetail eventDetail = this.getLocalDataStore().getEventDetail(event);
        if (eventDetail != null) {
            return eventDetail.getLastTime();
        }
        return -1;
    }

    @Deprecated
    @RequiresApi(api=19)
    public List<Boolean> getListOfBooleanVariable(String name, List<Boolean> defaultValue) {
        if (this.ctABTestController == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "ABTesting is not enabled for this instance");
            return defaultValue;
        }
        return this.ctABTestController.getListOfBooleanVariable(name, defaultValue);
    }

    @Deprecated
    @RequiresApi(api=19)
    public List<Double> getListOfDoubleVariable(String name, List<Double> defaultValue) {
        if (this.ctABTestController == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "ABTesting is not enabled for this instance");
            return defaultValue;
        }
        return this.ctABTestController.getListOfDoubleVariable(name, defaultValue);
    }

    @Deprecated
    @RequiresApi(api=19)
    public List<Integer> getListOfIntegerVariable(String name, List<Integer> defaultValue) {
        if (this.ctABTestController == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "ABTesting is not enabled for this instance");
            return defaultValue;
        }
        return this.ctABTestController.getListOfIntegerVariable(name, defaultValue);
    }

    @Deprecated
    @RequiresApi(api=19)
    public List<String> getListOfStringVariable(String name, List<String> defaultValue) {
        if (this.ctABTestController == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "ABTesting is not enabled for this instance");
            return defaultValue;
        }
        return this.ctABTestController.getListOfStringVariable(name, defaultValue);
    }

    public Location getLocation() {
        return this._getLocation();
    }

    public void setLocation(Location location) {
        this._setLocation(location);
    }

    @Deprecated
    @RequiresApi(api=19)
    public Map<String, Boolean> getMapOfBooleanVariable(String name, Map<String, Boolean> defaultValue) {
        if (this.ctABTestController == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "ABTesting is not enabled for this instance");
            return defaultValue;
        }
        return this.ctABTestController.getMapOfBooleanVariable(name, defaultValue);
    }

    @Deprecated
    @RequiresApi(api=19)
    public Map<String, Double> getMapOfDoubleVariable(String name, Map<String, Double> defaultValue) {
        if (this.ctABTestController == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "ABTesting is not enabled for this instance");
            return defaultValue;
        }
        return this.ctABTestController.getMapOfDoubleVariable(name, defaultValue);
    }

    @Deprecated
    @RequiresApi(api=19)
    public Map<String, Integer> getMapOfIntegerVariable(String name, Map<String, Integer> defaultValue) {
        if (this.ctABTestController == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "ABTesting is not enabled for this instance");
            return defaultValue;
        }
        return this.ctABTestController.getMapOfIntegerVariable(name, defaultValue);
    }

    @Deprecated
    @RequiresApi(api=19)
    public Map<String, String> getMapOfStringVariable(String name, Map<String, String> defaultValue) {
        if (this.ctABTestController == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "ABTesting is not enabled for this instance");
            return defaultValue;
        }
        return this.ctABTestController.getMapOfStringVariable(name, defaultValue);
    }

    public int getPreviousVisitTime() {
        return this.lastVisitTime;
    }

    public Object getProperty(String name) {
        if (!this.config.isPersonalizationEnabled()) {
            return null;
        }
        return this.getLocalDataStore().getProfileProperty(name);
    }

    public String getPushToken(@NonNull PushConstants.PushType pushType) {
        return this.pushProviders.getCachedToken(pushType);
    }

    public int getScreenCount() {
        return activityCount;
    }

    @Deprecated
    @RequiresApi(api=19)
    public String getStringVariable(String name, String defaultValue) {
        if (this.ctABTestController == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "ABTesting is not enabled for this instance");
            return defaultValue;
        }
        return this.ctABTestController.getStringVariable(name, defaultValue);
    }

    public SyncListener getSyncListener() {
        return this.syncListener;
    }

    public void setSyncListener(SyncListener syncListener) {
        this.syncListener = syncListener;
    }

    public int getTimeElapsed() {
        int currentSession = this.getCurrentSession();
        if (currentSession == 0) {
            return -1;
        }
        int now = (int)(System.currentTimeMillis() / 1000L);
        return now - currentSession;
    }

    public int getTotalVisits() {
        EventDetail ed = this.getLocalDataStore().getEventDetail("App Launched");
        if (ed != null) {
            return ed.getCount();
        }
        return 0;
    }

    public UTMDetail getUTMDetails() {
        UTMDetail ud = new UTMDetail();
        ud.setSource(this.source);
        ud.setMedium(this.medium);
        ud.setCampaign(this.campaign);
        return ud;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<CTInboxMessage> getUnreadInboxMessages() {
        ArrayList<CTInboxMessage> inboxMessageArrayList = new ArrayList<CTInboxMessage>();
        Object object = this.inboxControllerLock;
        synchronized (object) {
            if (this.ctInboxController != null) {
                ArrayList<CTMessageDAO> messageDAOArrayList = this.ctInboxController.getUnreadMessages();
                for (CTMessageDAO messageDAO : messageDAOArrayList) {
                    inboxMessageArrayList.add(new CTInboxMessage(messageDAO.toJSON()));
                }
                return inboxMessageArrayList;
            }
            this.getConfigLogger().debug(this.getAccountId(), "Notification Inbox not initialized");
            return inboxMessageArrayList;
        }
    }

    @Override
    public void inAppNotificationDidClick(CTInAppNotification inAppNotification, Bundle formData, HashMap<String, String> keyValueMap) {
        this.pushInAppNotificationStateEvent(true, inAppNotification, formData);
        if (keyValueMap != null && !keyValueMap.isEmpty() && this.inAppNotificationButtonListener != null && this.inAppNotificationButtonListener.get() != null) {
            ((InAppNotificationButtonListener)this.inAppNotificationButtonListener.get()).onInAppButtonClick(keyValueMap);
        }
    }

    @Override
    public void inAppNotificationDidDismiss(final Context context, final CTInAppNotification inAppNotification, Bundle formData) {
        inAppNotification.didDismiss();
        if (this.inAppFCManager != null) {
            this.inAppFCManager.didDismiss(inAppNotification);
            this.getConfigLogger().verbose(this.getAccountId(), "InApp Dismissed: " + inAppNotification.getCampaignId());
        }
        try {
            InAppNotificationListener listener = this.getInAppNotificationListener();
            if (listener != null) {
                HashMap<String, Object> notifKVS = inAppNotification.getCustomExtras() != null ? Utils.convertJSONObjectToHashMap(inAppNotification.getCustomExtras()) : new HashMap();
                Logger.v("Calling the in-app listener on behalf of " + this.source);
                if (formData != null) {
                    listener.onDismissed(notifKVS, Utils.convertBundleObjectToHashMap(formData));
                } else {
                    listener.onDismissed(notifKVS, null);
                }
            }
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Failed to call the in-app notification listener", t);
        }
        this.runOnNotificationQueue(new Runnable(){

            @Override
            public void run() {
                CleverTapAPI.inAppDidDismiss(context, CleverTapAPI.this.getConfig(), inAppNotification);
                CleverTapAPI.this._showNotificationIfAvailable(context);
            }
        });
    }

    @Override
    public void inAppNotificationDidShow(CTInAppNotification inAppNotification, Bundle formData) {
        this.pushInAppNotificationStateEvent(false, inAppNotification, formData);
    }

    public void initializeInbox() {
        if (this.getConfig().isAnalyticsOnly()) {
            this.getConfigLogger().debug(this.getAccountId(), "Instance is analytics only, not initializing Notification Inbox");
            return;
        }
        this.postAsyncSafely("initializeInbox", new Runnable(){

            @Override
            public void run() {
                CleverTapAPI.this._initializeInbox();
            }
        });
    }

    public void markReadInboxMessage(final CTInboxMessage message) {
        this.postAsyncSafely("markReadInboxMessage", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = CleverTapAPI.this.inboxControllerLock;
                synchronized (object) {
                    if (CleverTapAPI.this.ctInboxController != null) {
                        boolean read = CleverTapAPI.this.ctInboxController.markReadForMessageWithId(message.getMessageId());
                        if (read) {
                            CleverTapAPI.this._notifyInboxMessagesDidUpdate();
                        }
                    } else {
                        CleverTapAPI.this.getConfigLogger().debug(CleverTapAPI.this.getAccountId(), "Notification Inbox not initialized");
                    }
                }
            }
        });
    }

    public void markReadInboxMessage(String messageId) {
        CTInboxMessage message = this.getInboxMessageForId(messageId);
        this.markReadInboxMessage(message);
    }

    @Override
    public void messageDidClick(CTInboxActivity ctInboxActivity, CTInboxMessage inboxMessage, Bundle data, HashMap<String, String> keyValue) {
        this.pushInboxMessageStateEvent(true, inboxMessage, data);
        if (keyValue != null && !keyValue.isEmpty() && this.inboxMessageButtonListener != null && this.inboxMessageButtonListener.get() != null) {
            ((InboxMessageButtonListener)this.inboxMessageButtonListener.get()).onInboxButtonClick(keyValue);
        }
    }

    @Override
    public void messageDidShow(CTInboxActivity ctInboxActivity, final CTInboxMessage inboxMessage, final Bundle data) {
        this.postAsyncSafely("handleMessageDidShow", new Runnable(){

            @Override
            public void run() {
                CTInboxMessage message = CleverTapAPI.this.getInboxMessageForId(inboxMessage.getMessageId());
                if (!message.isRead()) {
                    CleverTapAPI.this.markReadInboxMessage(inboxMessage);
                    CleverTapAPI.this.pushInboxMessageStateEvent(false, inboxMessage, data);
                }
            }
        });
    }

    @Override
    public void notificationReady(final CTInAppNotification inAppNotification) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            this.getHandlerUsingMainLooper().post(new Runnable(){

                @Override
                public void run() {
                    CleverTapAPI.this.notificationReady(inAppNotification);
                }
            });
            return;
        }
        if (inAppNotification.getError() != null) {
            this.getConfigLogger().debug(this.getAccountId(), "Unable to process inapp notification " + inAppNotification.getError());
            return;
        }
        this.getConfigLogger().debug(this.getAccountId(), "Notification ready: " + inAppNotification.getJsonDescription());
        this.displayNotification(inAppNotification);
    }

    @Override
    public void onActivated() {
        if (this.productConfigListener != null && this.productConfigListener.get() != null) {
            ((CTProductConfigListener)this.productConfigListener.get()).onActivated();
        }
    }

    @Override
    public void onFetched() {
        if (this.productConfigListener != null && this.productConfigListener.get() != null) {
            ((CTProductConfigListener)this.productConfigListener.get()).onFetched();
        }
    }

    @Override
    public void onInit() {
        if (this.productConfigListener != null && this.productConfigListener.get() != null) {
            this.getConfigLogger().verbose(this.config.getAccountId(), "Product Config initialized");
            ((CTProductConfigListener)this.productConfigListener.get()).onInit();
        }
    }

    @Override
    public void onNewToken(String freshToken, PushConstants.PushType pushType) {
        if (!TextUtils.isEmpty((CharSequence)freshToken)) {
            this.doTokenRefresh(freshToken, pushType);
            this.deviceTokenDidRefresh(freshToken, pushType);
        }
    }

    public void onUserLogin(Map<String, Object> profile, String cleverTapID) {
        if (this.getConfig().getEnableCustomCleverTapId()) {
            if (cleverTapID == null) {
                Logger.i("CLEVERTAP_USE_CUSTOM_ID has been specified in the AndroidManifest.xml Please call onUserlogin() and pass a custom CleverTap ID");
            }
        } else if (cleverTapID != null) {
            Logger.i("CLEVERTAP_USE_CUSTOM_ID has not been specified in the AndroidManifest.xml Please call CleverTapAPI.defaultInstance() without a custom CleverTap ID");
        }
        this._onUserLogin(profile, cleverTapID);
    }

    public void onUserLogin(Map<String, Object> profile) {
        this.onUserLogin(profile, null);
    }

    public CTProductConfigController productConfig() {
        if (this.ctProductConfigController == null) {
            this.initProductConfig(false);
        }
        return this.ctProductConfigController;
    }

    public void pushBaiduRegistrationId(String regId, boolean register) {
        this.pushProviders.handleToken(regId, PushConstants.PushType.BPS, register);
    }

    public void pushChargedEvent(HashMap<String, Object> chargeDetails, ArrayList<HashMap<String, Object>> items) {
        if (chargeDetails == null || items == null) {
            this.getConfigLogger().debug(this.getAccountId(), "Invalid Charged event: details and or items is null");
            return;
        }
        if (items.size() > 50) {
            ValidationResult error = ValidationResultFactory.create(522);
            this.getConfigLogger().debug(this.getAccountId(), error.getErrorDesc());
            this.validationResultStack.pushValidationResult(error);
        }
        JSONObject evtData = new JSONObject();
        JSONObject chargedEvent = new JSONObject();
        try {
            ValidationResult vr;
            for (String key : chargeDetails.keySet()) {
                Object value = chargeDetails.get(key);
                vr = this.validator.cleanObjectKey(key);
                key = vr.getObject().toString();
                if (vr.getErrorCode() != 0) {
                    chargedEvent.put("wzrk_error", (Object)CTJsonConverter.getErrorObject(vr));
                }
                try {
                    vr = this.validator.cleanObjectValue(value, Validator.ValidationContext.Event);
                }
                catch (IllegalArgumentException e) {
                    ValidationResult error = ValidationResultFactory.create(511, 7, "Charged", key, value != null ? value.toString() : "");
                    this.validationResultStack.pushValidationResult(error);
                    this.getConfigLogger().debug(this.getAccountId(), error.getErrorDesc());
                    continue;
                }
                value = vr.getObject();
                if (vr.getErrorCode() != 0) {
                    chargedEvent.put("wzrk_error", (Object)CTJsonConverter.getErrorObject(vr));
                }
                evtData.put(key, value);
            }
            JSONArray jsonItemsArray = new JSONArray();
            for (HashMap<String, Object> map : items) {
                JSONObject itemDetails = new JSONObject();
                for (String key : map.keySet()) {
                    Object value = map.get(key);
                    vr = this.validator.cleanObjectKey(key);
                    key = vr.getObject().toString();
                    if (vr.getErrorCode() != 0) {
                        chargedEvent.put("wzrk_error", (Object)CTJsonConverter.getErrorObject(vr));
                    }
                    try {
                        vr = this.validator.cleanObjectValue(value, Validator.ValidationContext.Event);
                    }
                    catch (IllegalArgumentException e) {
                        ValidationResult error = ValidationResultFactory.create(511, 15, key, value != null ? value.toString() : "");
                        this.getConfigLogger().debug(this.getAccountId(), error.getErrorDesc());
                        this.validationResultStack.pushValidationResult(error);
                        continue;
                    }
                    value = vr.getObject();
                    if (vr.getErrorCode() != 0) {
                        chargedEvent.put("wzrk_error", (Object)CTJsonConverter.getErrorObject(vr));
                    }
                    itemDetails.put(key, value);
                }
                jsonItemsArray.put((Object)itemDetails);
            }
            evtData.put("Items", (Object)jsonItemsArray);
            chargedEvent.put("evtName", (Object)"Charged");
            chargedEvent.put("evtData", (Object)evtData);
            this.queueEvent(this.context, chargedEvent, 4);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void pushDeepLink(Uri uri) {
        this.pushDeepLink(uri, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void pushDeviceTokenEvent(String token, boolean register, PushConstants.PushType pushType) {
        if (pushType == null) {
            return;
        }
        String string = token = !TextUtils.isEmpty((CharSequence)token) ? token : this.pushProviders.getCachedToken(pushType);
        if (TextUtils.isEmpty((CharSequence)token)) {
            return;
        }
        Object object = this.tokenLock;
        synchronized (object) {
            JSONObject event = new JSONObject();
            JSONObject data = new JSONObject();
            String action = register ? "register" : "unregister";
            try {
                data.put("action", (Object)action);
                data.put("id", (Object)token);
                data.put("type", (Object)pushType.getType());
                event.put("data", (Object)data);
                this.getConfigLogger().verbose(this.getAccountId(), (Object)((Object)pushType) + action + " device token " + token);
                this.queueEvent(this.context, event, 5);
            }
            catch (Throwable t) {
                this.getConfigLogger().verbose(this.getAccountId(), (Object)((Object)pushType) + action + " device token failed", t);
            }
        }
    }

    public void pushDisplayUnitClickedEventForID(String unitID) {
        JSONObject event = new JSONObject();
        try {
            JSONObject eventExtraData;
            CleverTapDisplayUnit displayUnit;
            event.put("evtName", (Object)"Notification Clicked");
            if (this.mCTDisplayUnitController != null && (displayUnit = this.mCTDisplayUnitController.getDisplayUnitForID(unitID)) != null && (eventExtraData = displayUnit.getWZRKFields()) != null) {
                event.put("evtData", (Object)eventExtraData);
                try {
                    this.setWzrkParams(eventExtraData);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.queueEvent(this.context, event, 4);
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "DisplayUnit : Failed to push Display Unit clicked event" + t);
        }
    }

    public void pushDisplayUnitViewedEventForID(String unitID) {
        JSONObject event = new JSONObject();
        try {
            JSONObject eventExtras;
            CleverTapDisplayUnit displayUnit;
            event.put("evtName", (Object)"Notification Viewed");
            if (this.mCTDisplayUnitController != null && (displayUnit = this.mCTDisplayUnitController.getDisplayUnitForID(unitID)) != null && (eventExtras = displayUnit.getWZRKFields()) != null) {
                event.put("evtData", (Object)eventExtras);
            }
            this.queueEvent(this.context, event, 4);
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "DisplayUnit : Failed to push Display Unit viewed event" + t);
        }
    }

    public void pushError(String errorMessage, int errorCode) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("Error Message", errorMessage);
        props.put("Error Code", errorCode);
        try {
            String activityName = CleverTapAPI.getCurrentActivityName();
            if (activityName != null) {
                props.put("Location", activityName);
            } else {
                props.put("Location", "Unknown");
            }
        }
        catch (Throwable t) {
            props.put("Location", "Unknown");
        }
        this.pushEvent("Error Occurred", props);
    }

    public void pushEvent(String eventName) {
        if (eventName == null || eventName.trim().equals("")) {
            return;
        }
        this.pushEvent(eventName, null);
    }

    public void pushEvent(String eventName, Map<String, Object> eventActions) {
        if (eventName == null || eventName.equals("")) {
            return;
        }
        ValidationResult validationResult = this.validator.isRestrictedEventName(eventName);
        if (validationResult.getErrorCode() > 0) {
            this.validationResultStack.pushValidationResult(validationResult);
            return;
        }
        ValidationResult discardedResult = this.validator.isEventDiscarded(eventName);
        if (discardedResult.getErrorCode() > 0) {
            this.validationResultStack.pushValidationResult(discardedResult);
            return;
        }
        if (eventActions == null) {
            eventActions = new HashMap<String, Object>();
        }
        JSONObject event = new JSONObject();
        try {
            ValidationResult vr = this.validator.cleanEventName(eventName);
            if (vr.getErrorCode() != 0) {
                event.put("wzrk_error", (Object)CTJsonConverter.getErrorObject(vr));
            }
            eventName = vr.getObject().toString();
            JSONObject actions = new JSONObject();
            for (String key : eventActions.keySet()) {
                Object value = eventActions.get(key);
                vr = this.validator.cleanObjectKey(key);
                key = vr.getObject().toString();
                if (vr.getErrorCode() != 0) {
                    event.put("wzrk_error", (Object)CTJsonConverter.getErrorObject(vr));
                }
                try {
                    vr = this.validator.cleanObjectValue(value, Validator.ValidationContext.Event);
                }
                catch (IllegalArgumentException e) {
                    ValidationResult error = ValidationResultFactory.create(512, 7, eventName, key, value != null ? value.toString() : "");
                    this.getConfigLogger().debug(this.getAccountId(), error.getErrorDesc());
                    this.validationResultStack.pushValidationResult(error);
                    continue;
                }
                value = vr.getObject();
                if (vr.getErrorCode() != 0) {
                    event.put("wzrk_error", (Object)CTJsonConverter.getErrorObject(vr));
                }
                actions.put(key, value);
            }
            event.put("evtName", (Object)eventName);
            event.put("evtData", (Object)actions);
            this.queueEvent(this.context, event, 4);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Deprecated
    public void pushFacebookUser(final JSONObject graphUser) {
        this.postAsyncSafely("pushFacebookUser", new Runnable(){

            @Override
            public void run() {
                CleverTapAPI.this._pushFacebookUser(graphUser);
            }
        });
    }

    public void pushFcmRegistrationId(String fcmId, boolean register) {
        this.pushProviders.handleToken(fcmId, PushConstants.PushType.FCM, register);
    }

    public void pushGeoFenceError(int errorCode, String errorMessage) {
        ValidationResult validationResult = new ValidationResult(errorCode, errorMessage);
        this.validationResultStack.pushValidationResult(validationResult);
    }

    public Future<?> pushGeoFenceExitedEvent(JSONObject geoFenceProperties) {
        return this.raiseEventForGeofences("Geocluster Exited", geoFenceProperties);
    }

    public Future<?> pushGeofenceEnteredEvent(JSONObject geofenceProperties) {
        return this.raiseEventForGeofences("Geocluster Entered", geofenceProperties);
    }

    public void pushHuaweiRegistrationId(String regId, boolean register) {
        this.pushProviders.handleToken(regId, PushConstants.PushType.HPS, register);
    }

    public void pushInboxNotificationClickedEvent(String messageId) {
        CTInboxMessage message = this.getInboxMessageForId(messageId);
        this.pushInboxMessageStateEvent(true, message, null);
    }

    public void pushInboxNotificationViewedEvent(String messageId) {
        CTInboxMessage message = this.getInboxMessageForId(messageId);
        this.pushInboxMessageStateEvent(false, message, null);
    }

    @Deprecated
    public void pushInstallReferrer(Intent intent) {
        try {
            String url;
            Bundle extras = intent.getExtras();
            if (extras == null || !extras.containsKey("referrer")) {
                return;
            }
            try {
                url = URLDecoder.decode(extras.getString("referrer"), "UTF-8");
                this.getConfigLogger().verbose(this.getAccountId(), "Referrer received: " + url);
            }
            catch (Throwable e) {
                return;
            }
            if (url == null) {
                return;
            }
            int now = (int)(System.currentTimeMillis() / 1000L);
            if (this.installReferrerMap.containsKey(url) && now - this.installReferrerMap.get(url) < 10) {
                this.getConfigLogger().verbose(this.getAccountId(), "Skipping install referrer due to duplicate within 10 seconds");
                return;
            }
            this.installReferrerMap.put(url, now);
            Uri uri = Uri.parse((String)("wzrk://track?install=true&" + url));
            this.pushDeepLink(uri, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void pushInstallReferrer(String url) {
        try {
            this.getConfigLogger().verbose(this.getAccountId(), "Referrer received: " + url);
            if (url == null) {
                return;
            }
            int now = (int)(System.currentTimeMillis() / 1000L);
            if (this.installReferrerMap.containsKey(url) && now - this.installReferrerMap.get(url) < 10) {
                this.getConfigLogger().verbose(this.getAccountId(), "Skipping install referrer due to duplicate within 10 seconds");
                return;
            }
            this.installReferrerMap.put(url, now);
            Uri uri = Uri.parse((String)("wzrk://track?install=true&" + url));
            this.pushDeepLink(uri, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized void pushInstallReferrer(String source, String medium, String campaign) {
        if (source == null && medium == null && campaign == null) {
            return;
        }
        try {
            int status = StorageHelper.getInt(this.context, "app_install_status", 0);
            if (status != 0) {
                Logger.d("Install referrer has already been set. Will not override it");
                return;
            }
            StorageHelper.putInt(this.context, "app_install_status", 1);
            if (source != null) {
                source = Uri.encode((String)source);
            }
            if (medium != null) {
                medium = Uri.encode((String)medium);
            }
            if (campaign != null) {
                campaign = Uri.encode((String)campaign);
            }
            String uriStr = "wzrk://track?install=true";
            if (source != null) {
                uriStr = uriStr + "&utm_source=" + source;
            }
            if (medium != null) {
                uriStr = uriStr + "&utm_medium=" + medium;
            }
            if (campaign != null) {
                uriStr = uriStr + "&utm_campaign=" + campaign;
            }
            Uri uri = Uri.parse((String)uriStr);
            this.pushDeepLink(uri, true);
        }
        catch (Throwable t) {
            Logger.v("Failed to push install referrer", t);
        }
    }

    public void pushNotificationClickedEvent(final Bundle extras) {
        boolean shouldProcess;
        if (this.config.isAnalyticsOnly()) {
            this.getConfigLogger().debug(this.getAccountId(), "is Analytics Only - will not process Notification Clicked event.");
            return;
        }
        if (extras == null || extras.isEmpty() || extras.get(NOTIFICATION_TAG) == null) {
            this.getConfigLogger().debug(this.getAccountId(), "Push notification: " + (extras == null ? "NULL" : extras.toString()) + " not from CleverTap - will not process Notification Clicked event.");
            return;
        }
        String accountId = null;
        try {
            accountId = extras.getString("wzrk_acct_id");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean bl = shouldProcess = accountId == null && this.config.isDefaultInstance() || this.getAccountId().equals(accountId);
        if (!shouldProcess) {
            this.getConfigLogger().debug(this.getAccountId(), "Push notification not targeted at this instance, not processing Notification Clicked Event");
            return;
        }
        if (extras.containsKey("wzrk_inapp")) {
            this.pendingInappRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        Logger.v("Received in-app via push payload: " + extras.getString("wzrk_inapp"));
                        JSONObject r = new JSONObject();
                        JSONArray inappNotifs = new JSONArray();
                        r.put("inapp_notifs", (Object)inappNotifs);
                        inappNotifs.put((Object)new JSONObject(extras.getString("wzrk_inapp")));
                        CleverTapAPI.this.processInAppResponse(r, CleverTapAPI.this.context);
                    }
                    catch (Throwable t) {
                        Logger.v("Failed to display inapp notification from push notification payload", t);
                    }
                }
            };
            return;
        }
        if (extras.containsKey("wzrk_inbox")) {
            this.pendingInappRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        Logger.v("Received inbox via push payload: " + extras.getString("wzrk_inbox"));
                        JSONObject r = new JSONObject();
                        JSONArray inappNotifs = new JSONArray();
                        r.put("inbox_notifs", (Object)inappNotifs);
                        JSONObject testPushObject = new JSONObject(extras.getString("wzrk_inbox"));
                        testPushObject.put("_id", (Object)String.valueOf(System.currentTimeMillis() / 1000L));
                        inappNotifs.put((Object)testPushObject);
                        CleverTapAPI.this.processInboxResponse(r);
                    }
                    catch (Throwable t) {
                        Logger.v("Failed to process inbox message from push notification payload", t);
                    }
                }
            };
            return;
        }
        if (extras.containsKey("wzrk_adunit")) {
            this.handleSendTestForDisplayUnits(extras);
            return;
        }
        if (!extras.containsKey("wzrk_id") || extras.getString("wzrk_id") == null) {
            this.getConfigLogger().debug(this.getAccountId(), "Push notification ID Tag is null, not processing Notification Clicked event for:  " + extras.toString());
            return;
        }
        boolean isDuplicate = this.checkDuplicateNotificationIds(extras, this.notificationIdTagMap, 5000);
        if (isDuplicate) {
            this.getConfigLogger().debug(this.getAccountId(), "Already processed Notification Clicked event for " + extras.toString() + ", dropping duplicate.");
            return;
        }
        JSONObject event = new JSONObject();
        JSONObject notif = new JSONObject();
        try {
            for (String x : extras.keySet()) {
                if (!x.startsWith("wzrk_")) continue;
                Object value = extras.get(x);
                notif.put(x, value);
            }
            event.put("evtName", (Object)"Notification Clicked");
            event.put("evtData", (Object)notif);
            this.queueEvent(this.context, event, 4);
            try {
                this.setWzrkParams(CTJsonConverter.getWzrkFields(extras));
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.getCTPushNotificationListener() != null) {
            this.getCTPushNotificationListener().onNotificationClickedPayloadReceived(Utils.convertBundleObjectToHashMap(extras));
        } else {
            Logger.d("CTPushNotificationListener is not set");
        }
    }

    public void pushNotificationViewedEvent(Bundle extras) {
        if (extras == null || extras.isEmpty() || extras.get(NOTIFICATION_TAG) == null) {
            this.getConfigLogger().debug(this.getAccountId(), "Push notification: " + (extras == null ? "NULL" : extras.toString()) + " not from CleverTap - will not process Notification Viewed event.");
            return;
        }
        if (!extras.containsKey("wzrk_id") || extras.getString("wzrk_id") == null) {
            this.getConfigLogger().debug(this.getAccountId(), "Push notification ID Tag is null, not processing Notification Viewed event for:  " + extras.toString());
            return;
        }
        boolean isDuplicate = this.checkDuplicateNotificationIds(extras, this.notificationViewedIdTagMap, 2000);
        if (isDuplicate) {
            this.getConfigLogger().debug(this.getAccountId(), "Already processed Notification Viewed event for " + extras.toString() + ", dropping duplicate.");
            return;
        }
        this.getConfigLogger().debug("Recording Notification Viewed event for notification:  " + extras.toString());
        JSONObject event = new JSONObject();
        try {
            JSONObject notif = CTJsonConverter.getWzrkFields(extras);
            event.put("evtName", (Object)"Notification Viewed");
            event.put("evtData", (Object)notif);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.queueEvent(this.context, event, 6);
    }

    public void pushProfile(final Map<String, Object> profile) {
        if (profile == null || profile.isEmpty()) {
            return;
        }
        this.postAsyncSafely("profilePush", new Runnable(){

            @Override
            public void run() {
                CleverTapAPI.this._push(profile);
            }
        });
    }

    public void pushXiaomiRegistrationId(String regId, boolean register) {
        this.pushProviders.handleToken(regId, PushConstants.PushType.XPS, register);
    }

    public void recordScreen(String screenName) {
        if (screenName == null || !this.currentScreenName.isEmpty() && this.currentScreenName.equals(screenName)) {
            return;
        }
        this.getConfigLogger().debug(this.getAccountId(), "Screen changed to " + screenName);
        this.currentScreenName = screenName;
        this.recordPageEventWithExtras(null);
    }

    @Deprecated
    @RequiresApi(api=19)
    public void registerBooleanVariable(String name) {
        if (this.ctABTestController == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "ABTesting is not enabled for this instance");
            return;
        }
        this.ctABTestController.registerBooleanVariable(name);
    }

    @Deprecated
    @RequiresApi(api=19)
    public void registerDoubleVariable(String name) {
        if (this.ctABTestController == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "ABTesting is not enabled for this instance");
            return;
        }
        this.ctABTestController.registerDoubleVariable(name);
    }

    @Deprecated
    @RequiresApi(api=19)
    public void registerIntegerVariable(String name) {
        if (this.ctABTestController == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "ABTesting is not enabled for this instance");
            return;
        }
        this.ctABTestController.registerIntegerVariable(name);
    }

    @Deprecated
    @RequiresApi(api=19)
    public void registerListOfBooleanVariable(String name) {
        if (this.ctABTestController == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "ABTesting is not enabled for this instance");
            return;
        }
        this.ctABTestController.registerListOfBooleanVariable(name);
    }

    @Deprecated
    @RequiresApi(api=19)
    public void registerListOfDoubleVariable(String name) {
        if (this.ctABTestController == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "ABTesting is not enabled for this instance");
            return;
        }
        this.ctABTestController.registerListOfDoubleVariable(name);
    }

    @Deprecated
    @RequiresApi(api=19)
    public void registerListOfIntegerVariable(String name) {
        if (this.ctABTestController == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "ABTesting is not enabled for this instance");
            return;
        }
        this.ctABTestController.registerListOfIntegerVariable(name);
    }

    @Deprecated
    @RequiresApi(api=19)
    public void registerListOfStringVariable(String name) {
        if (this.ctABTestController == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "ABTesting is not enabled for this instance");
            return;
        }
        this.ctABTestController.registerListOfStringVariable(name);
    }

    @Deprecated
    @RequiresApi(api=19)
    public void registerMapOfBooleanVariable(String name) {
        if (this.ctABTestController == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "ABTesting is not enabled for this instance");
            return;
        }
        this.ctABTestController.registerMapOfBooleanVariable(name);
    }

    @Deprecated
    @RequiresApi(api=19)
    public void registerMapOfDoubleVariable(String name) {
        if (this.ctABTestController == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "ABTesting is not enabled for this instance");
            return;
        }
        this.ctABTestController.registerMapOfDoubleVariable(name);
    }

    @Deprecated
    @RequiresApi(api=19)
    public void registerMapOfIntegerVariable(String name) {
        if (this.ctABTestController == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "ABTesting is not enabled for this instance");
            return;
        }
        this.ctABTestController.registerMapOfIntegerVariable(name);
    }

    @Deprecated
    @RequiresApi(api=19)
    public void registerMapOfStringVariable(String name) {
        if (this.ctABTestController == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "ABTesting is not enabled for this instance");
            return;
        }
        this.ctABTestController.registerMapOfStringVariable(name);
    }

    @Deprecated
    @RequiresApi(api=19)
    public void registerStringVariable(String name) {
        if (this.ctABTestController == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "ABTesting is not enabled for this instance");
            return;
        }
        this.ctABTestController.registerStringVariable(name);
    }

    @Override
    public ValidationResultStack remoteErrorLogger() {
        return this.validationResultStack;
    }

    public void removeMultiValueForKey(String key, String value) {
        if (value == null || value.isEmpty()) {
            this._generateEmptyMultiValueError(key);
            return;
        }
        this.removeMultiValuesForKey(key, new ArrayList<String>(Collections.singletonList(value)));
    }

    public void removeMultiValuesForKey(final String key, final ArrayList<String> values) {
        this.postAsyncSafely("removeMultiValuesForKey", new Runnable(){

            @Override
            public void run() {
                CleverTapAPI.this._handleMultiValues(values, key, "$remove");
            }
        });
    }

    public void removeValueForKey(final String key) {
        this.postAsyncSafely("removeValueForKey", new Runnable(){

            @Override
            public void run() {
                CleverTapAPI.this._removeValueForKey(key);
            }
        });
    }

    public void setCTFeatureFlagsListener(CTFeatureFlagsListener featureFlagsListener) {
        this.featureFlagsListener = new WeakReference<CTFeatureFlagsListener>(featureFlagsListener);
    }

    public void setCTProductConfigListener(CTProductConfigListener listener) {
        if (listener != null) {
            this.productConfigListener = new WeakReference<CTProductConfigListener>(listener);
        }
    }

    public void setDisplayUnitListener(DisplayUnitListener listener) {
        if (listener != null) {
            this.displayUnitListenerWeakReference = new WeakReference<DisplayUnitListener>(listener);
        } else {
            this.getConfigLogger().verbose(this.getAccountId(), "DisplayUnit : Failed to set - DisplayUnitListener can't be null");
        }
    }

    public void setInAppNotificationButtonListener(InAppNotificationButtonListener listener) {
        this.inAppNotificationButtonListener = new WeakReference<InAppNotificationButtonListener>(listener);
    }

    public void setInboxMessageButtonListener(InboxMessageButtonListener listener) {
        this.inboxMessageButtonListener = new WeakReference<InboxMessageButtonListener>(listener);
    }

    public void setLibrary(String library) {
        if (this.deviceInfo != null) {
            this.deviceInfo.setLibrary(library);
        }
    }

    public Future<?> setLocationForGeofences(Location location, int sdkVersion) {
        this.setLocationForGeofence(true);
        this.setGeofenceSDKVersion(sdkVersion);
        return this._setLocation(location);
    }

    public void setMultiValuesForKey(final String key, final ArrayList<String> values) {
        this.postAsyncSafely("setMultiValuesForKey", new Runnable(){

            @Override
            public void run() {
                CleverTapAPI.this._handleMultiValues(values, key, "$set");
            }
        });
    }

    public void setOptOut(boolean userOptOut) {
        final boolean enable = userOptOut;
        this.postAsyncSafely("setOptOut", new Runnable(){

            @Override
            public void run() {
                HashMap<String, Object> optOutMap = new HashMap<String, Object>();
                optOutMap.put("ct_optout", enable);
                if (enable) {
                    CleverTapAPI.this.pushProfile(optOutMap);
                    CleverTapAPI.this.setCurrentUserOptedOut(true);
                } else {
                    CleverTapAPI.this.setCurrentUserOptedOut(false);
                    CleverTapAPI.this.pushProfile(optOutMap);
                }
                String key = CleverTapAPI.this.optOutKey();
                if (key == null) {
                    CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "Unable to persist user OptOut state, storage key is null");
                    return;
                }
                StorageHelper.putBoolean(CleverTapAPI.this.context, StorageHelper.storageKeyWithSuffix(CleverTapAPI.this.config, key), enable);
                CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "Set current user OptOut state to: " + enable);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showAppInbox(CTInboxStyleConfig styleConfig) {
        Object object = this.inboxControllerLock;
        synchronized (object) {
            if (this.ctInboxController == null) {
                this.getConfigLogger().debug(this.getAccountId(), "Notification Inbox not initialized");
                return;
            }
        }
        CTInboxStyleConfig _styleConfig = new CTInboxStyleConfig(styleConfig);
        Intent intent = new Intent(this.context, CTInboxActivity.class);
        intent.putExtra("styleConfig", (Parcelable)_styleConfig);
        Bundle configBundle = new Bundle();
        configBundle.putParcelable("config", (Parcelable)this.config);
        intent.putExtra("configBundle", configBundle);
        try {
            Activity currentActivity = CleverTapAPI.getCurrentActivity();
            if (currentActivity == null) {
                throw new IllegalStateException("Current activity reference not found");
            }
            currentActivity.startActivity(intent);
            Logger.d("Displaying Notification Inbox");
        }
        catch (Throwable t) {
            Logger.v("Please verify the integration of your app. It is not setup to support Notification Inbox yet.", t);
        }
    }

    public void showAppInbox() {
        CTInboxStyleConfig styleConfig = new CTInboxStyleConfig();
        this.showAppInbox(styleConfig);
    }

    void deviceIDCreated(String deviceId) {
        Logger.v("Initializing InAppFC after Device ID Created = " + deviceId);
        this.inAppFCManager = new InAppFCManager(this.context, this.config, deviceId);
        Logger.v("Initializing ABTesting after Device ID Created = " + deviceId);
        this.initABTesting();
        this.initFeatureFlags(true);
        this.initProductConfig(true);
        this.getConfigLogger().verbose("Got device id from DeviceInfo, notifying user profile initialized to SyncListener");
        this.notifyUserProfileInitialized(deviceId);
    }

    void pushInAppNotificationStateEvent(boolean clicked, CTInAppNotification data, Bundle customData) {
        JSONObject event = new JSONObject();
        try {
            JSONObject notif = CTJsonConverter.getWzrkFields(data);
            if (customData != null) {
                for (String x : customData.keySet()) {
                    Object value = customData.get(x);
                    if (value == null) continue;
                    notif.put(x, value);
                }
            }
            if (clicked) {
                try {
                    this.setWzrkParams(notif);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                event.put("evtName", (Object)"Notification Clicked");
            } else {
                event.put("evtName", (Object)"Notification Viewed");
            }
            event.put("evtData", (Object)notif);
            this.queueEvent(this.context, event, 4);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void pushInboxMessageStateEvent(boolean clicked, CTInboxMessage data, Bundle customData) {
        JSONObject event = new JSONObject();
        try {
            JSONObject notif = CTJsonConverter.getWzrkFields(data);
            if (customData != null) {
                for (String x : customData.keySet()) {
                    Object value = customData.get(x);
                    if (value == null) continue;
                    notif.put(x, value);
                }
            }
            if (clicked) {
                try {
                    this.setWzrkParams(notif);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                event.put("evtName", (Object)"Notification Clicked");
            } else {
                event.put("evtName", (Object)"Notification Viewed");
            }
            event.put("evtData", (Object)notif);
            this.queueEvent(this.context, event, 4);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private JSONArray _cleanMultiValues(ArrayList<String> values, String key) {
        try {
            if (values == null || key == null) {
                return null;
            }
            JSONArray cleanedValues = new JSONArray();
            for (String value : values) {
                Object _value;
                value = value == null ? "" : value;
                ValidationResult vr = this.validator.cleanMultiValuePropertyValue(value);
                if (vr.getErrorCode() != 0) {
                    this.validationResultStack.pushValidationResult(vr);
                }
                String string = value = (_value = vr.getObject()) != null ? vr.getObject().toString() : null;
                if (value == null || value.isEmpty()) {
                    this._generateEmptyMultiValueError(key);
                    return null;
                }
                cleanedValues.put((Object)value);
            }
            return cleanedValues;
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Error cleaning multi values for key " + key, t);
            this._generateEmptyMultiValueError(key);
            return null;
        }
    }

    private JSONArray _constructExistingMultiValue(String key, String command) {
        boolean remove = command.equals("$remove");
        boolean add = command.equals("$add");
        if (!remove && !add) {
            return new JSONArray();
        }
        Object existing = this._getProfilePropertyIgnorePersonalizationFlag(key);
        if (existing == null) {
            if (remove) {
                return null;
            }
            return new JSONArray();
        }
        if (existing instanceof JSONArray) {
            return (JSONArray)existing;
        }
        JSONArray _default = add ? new JSONArray() : null;
        String stringified = this._stringifyAndCleanScalarProfilePropValue(existing);
        return stringified != null ? new JSONArray().put((Object)stringified) : _default;
    }

    private void _createNotification(final Context context, final Bundle extras, final int notificationId) {
        if (extras == null || extras.get(NOTIFICATION_TAG) == null) {
            return;
        }
        if (this.config.isAnalyticsOnly()) {
            this.getConfigLogger().debug(this.getAccountId(), "Instance is set for Analytics only, cannot create notification");
            return;
        }
        try {
            this.postAsyncSafely("CleverTapAPI#_createNotification", new Runnable(){

                @Override
                public void run() {
                    try {
                        CleverTapAPI.this.getConfigLogger().debug(CleverTapAPI.this.getAccountId(), "Handling notification: " + extras.toString());
                        CleverTapAPI.this.dbAdapter = CleverTapAPI.this.loadDBAdapter(context);
                        if (extras.getString("wzrk_pid") != null && CleverTapAPI.this.dbAdapter.doesPushNotificationIdExist(extras.getString("wzrk_pid"))) {
                            CleverTapAPI.this.getConfigLogger().debug(CleverTapAPI.this.getAccountId(), "Push Notification already rendered, not showing again");
                            return;
                        }
                        String notifMessage = extras.getString("nm");
                        String string = notifMessage = notifMessage != null ? notifMessage : "";
                        if (notifMessage.isEmpty()) {
                            CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "Push notification message is empty, not rendering");
                            CleverTapAPI.this.loadDBAdapter(context).storeUninstallTimestamp();
                            String pingFreq = extras.getString("pf", "");
                            if (!TextUtils.isEmpty((CharSequence)pingFreq)) {
                                CleverTapAPI.this.updatePingFrequencyIfNeeded(context, Integer.parseInt(pingFreq));
                            }
                            return;
                        }
                        String notifTitle = extras.getString("nt", "");
                        notifTitle = notifTitle.isEmpty() ? context.getApplicationInfo().name : notifTitle;
                        CleverTapAPI.this.triggerNotification(context, extras, notifMessage, notifTitle, notificationId);
                    }
                    catch (Throwable t) {
                        CleverTapAPI.this.getConfigLogger().debug(CleverTapAPI.this.getAccountId(), "Couldn't render notification: ", t);
                    }
                }
            });
        }
        catch (Throwable t) {
            this.getConfigLogger().debug(this.getAccountId(), "Failed to process push notification", t);
        }
    }

    private void _generateEmptyMultiValueError(String key) {
        ValidationResult error = ValidationResultFactory.create(512, 1, key);
        this.validationResultStack.pushValidationResult(error);
        this.getConfigLogger().debug(this.getAccountId(), error.getErrorDesc());
    }

    private void _generateInvalidMultiValueKeyError(String key) {
        ValidationResult error = ValidationResultFactory.create(523, 23, key);
        this.validationResultStack.pushValidationResult(error);
        this.getConfigLogger().debug(this.getAccountId(), "Invalid multi-value property key " + key + " profile multi value operation aborted");
    }

    @SuppressLint(value={"MissingPermission"})
    private Location _getLocation() {
        try {
            LocationManager lm = (LocationManager)this.context.getSystemService("location");
            if (lm == null) {
                Logger.d("Location Manager is null.");
                return null;
            }
            List providers = lm.getProviders(true);
            Location bestLocation = null;
            Location l = null;
            for (String provider : providers) {
                try {
                    l = lm.getLastKnownLocation(provider);
                }
                catch (SecurityException e) {
                    Logger.v("Location security exception", e);
                }
                if (l == null || bestLocation != null && !(l.getAccuracy() < bestLocation.getAccuracy())) continue;
                bestLocation = l;
            }
            return bestLocation;
        }
        catch (Throwable t) {
            Logger.v("Couldn't get user's location", t);
            return null;
        }
    }

    private Object _getProfilePropertyIgnorePersonalizationFlag(String key) {
        return this.getLocalDataStore().getProfileValueForKey(key);
    }

    private void _handleMultiValues(ArrayList<String> values, String key, String command) {
        Object _key;
        String cleanKey;
        if (key == null) {
            return;
        }
        if (values == null || values.isEmpty()) {
            this._generateEmptyMultiValueError(key);
            return;
        }
        ValidationResult vr = this.validator.cleanMultiValuePropertyKey(key);
        if (vr.getErrorCode() != 0) {
            this.validationResultStack.pushValidationResult(vr);
        }
        String string = cleanKey = (_key = vr.getObject()) != null ? vr.getObject().toString() : null;
        if (cleanKey == null || cleanKey.isEmpty()) {
            this._generateInvalidMultiValueKeyError(key);
            return;
        }
        key = cleanKey;
        try {
            JSONArray currentValues = this._constructExistingMultiValue(key, command);
            JSONArray newValues = this._cleanMultiValues(values, key);
            this._validateAndPushMultiValue(currentValues, newValues, values, key, command);
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Error handling multi value operation for key " + key, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initializeInbox() {
        Object object = this.inboxControllerLock;
        synchronized (object) {
            if (this.ctInboxController != null) {
                this._notifyInboxInitialized();
                return;
            }
            if (this.getCleverTapID() != null) {
                this.ctInboxController = new CTInboxController(this.getCleverTapID(), this.loadDBAdapter(this.context), haveVideoPlayerSupport);
                this._notifyInboxInitialized();
            } else {
                this.getConfigLogger().info("CRITICAL : No device ID found!");
            }
        }
    }

    private void _notifyInboxInitialized() {
        if (this.inboxListener != null) {
            this.inboxListener.inboxDidInitialize();
        }
    }

    private void _notifyInboxMessagesDidUpdate() {
        if (this.inboxListener != null) {
            Utils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (CleverTapAPI.this.inboxListener != null) {
                        CleverTapAPI.this.inboxListener.inboxMessagesDidUpdate();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _onUserLogin(Map<String, Object> profile, String cleverTapID) {
        if (profile == null) {
            return;
        }
        try {
            String currentGUID = this.getCleverTapID();
            if (currentGUID == null) {
                return;
            }
            boolean haveIdentifier = false;
            LoginInfoProvider loginInfoProvider = new LoginInfoProvider(this);
            IdentityRepo iProfileHandler = IdentityRepoFactory.getRepo(this);
            for (String key : profile.keySet()) {
                Object value = profile.get(key);
                boolean isProfileKey = iProfileHandler.hasIdentity(key);
                if (!isProfileKey) continue;
                try {
                    String identifier = null;
                    if (value != null) {
                        identifier = value.toString();
                    }
                    if (identifier == null || identifier.length() <= 0) continue;
                    haveIdentifier = true;
                    this.cachedGUID = loginInfoProvider.getGUIDForIdentifier(key, identifier);
                    if (this.cachedGUID == null) continue;
                    break;
                }
                catch (Throwable throwable) {
                }
            }
            if (!(this.isErrorDeviceId() || haveIdentifier && !loginInfoProvider.isAnonymousDevice())) {
                this.getConfigLogger().debug(this.getAccountId(), "onUserLogin: no identifier provided or device is anonymous, pushing on current user profile");
                this.pushProfile(profile);
                return;
            }
            if (this.cachedGUID != null && this.cachedGUID.equals(currentGUID)) {
                this.getConfigLogger().debug(this.getAccountId(), "onUserLogin: " + profile.toString() + " maps to current device id " + currentGUID + " pushing on current profile");
                this.pushProfile(profile);
                return;
            }
            String profileToString = profile.toString();
            if (this.isProcessUserLoginWithIdentifier(profileToString)) {
                this.getConfigLogger().debug(this.getAccountId(), "Already processing onUserLogin for " + profileToString);
                return;
            }
            Boolean bl = this.processingUserLoginLock;
            synchronized (bl) {
                this.processingUserLoginIdentifier = profileToString;
            }
            this.getConfigLogger().verbose(this.getAccountId(), "onUserLogin: queuing reset profile for " + profileToString + " with Cached GUID " + (this.cachedGUID != null ? this.cachedGUID : "NULL"));
            this.asyncProfileSwitchUser(profile, this.cachedGUID, cleverTapID);
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "onUserLogin failed", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _processInboxMessages(JSONArray messages) {
        Object object = this.inboxControllerLock;
        synchronized (object) {
            boolean update;
            if (this.ctInboxController == null) {
                this._initializeInbox();
            }
            if (this.ctInboxController != null && (update = this.ctInboxController.updateMessages(messages))) {
                this._notifyInboxMessagesDidUpdate();
            }
        }
    }

    private void _push(Map<String, Object> profile) {
        if (profile == null || profile.isEmpty()) {
            return;
        }
        try {
            JSONObject customProfile = new JSONObject();
            JSONObject fieldsToUpdateLocally = new JSONObject();
            for (String key : profile.keySet()) {
                Object value = profile.get(key);
                ValidationResult vr = this.validator.cleanObjectKey(key);
                key = vr.getObject().toString();
                if (vr.getErrorCode() != 0) {
                    this.validationResultStack.pushValidationResult(vr);
                }
                if (key.isEmpty()) {
                    ValidationResult keyError = ValidationResultFactory.create(512, 2, new String[0]);
                    this.validationResultStack.pushValidationResult(keyError);
                    this.getConfigLogger().debug(this.getAccountId(), keyError.getErrorDesc());
                    continue;
                }
                try {
                    vr = this.validator.cleanObjectValue(value, Validator.ValidationContext.Profile);
                }
                catch (Throwable e) {
                    ValidationResult error = ValidationResultFactory.create(512, 3, value != null ? value.toString() : "", key);
                    this.validationResultStack.pushValidationResult(error);
                    this.getConfigLogger().debug(this.getAccountId(), error.getErrorDesc());
                    continue;
                }
                value = vr.getObject();
                if (vr.getErrorCode() != 0) {
                    this.validationResultStack.pushValidationResult(vr);
                }
                if (key.equalsIgnoreCase("Phone")) {
                    try {
                        String _value;
                        value = value.toString();
                        String countryCode = this.deviceInfo.getCountryCode();
                        if ((countryCode == null || countryCode.isEmpty()) && !(_value = (String)value).startsWith("+")) {
                            ValidationResult error = ValidationResultFactory.create(512, 4, _value);
                            this.validationResultStack.pushValidationResult(error);
                            this.getConfigLogger().debug(this.getAccountId(), error.getErrorDesc());
                        }
                        this.getConfigLogger().verbose(this.getAccountId(), "Profile phone is: " + value + " device country code is: " + (countryCode != null ? countryCode : "null"));
                    }
                    catch (Exception e) {
                        this.validationResultStack.pushValidationResult(ValidationResultFactory.create(512, 5, new String[0]));
                        this.getConfigLogger().debug(this.getAccountId(), "Invalid phone number: " + e.getLocalizedMessage());
                        continue;
                    }
                }
                fieldsToUpdateLocally.put(key, value);
                customProfile.put(key, value);
            }
            this.getConfigLogger().verbose(this.getAccountId(), "Constructed custom profile: " + customProfile.toString());
            if (fieldsToUpdateLocally.length() > 0) {
                this.getLocalDataStore().setProfileFields(fieldsToUpdateLocally);
            }
            this.pushBasicProfile(customProfile);
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Failed to push profile", t);
        }
    }

    private void _pushFacebookUser(JSONObject graphUser) {
        try {
            String education;
            String work;
            if (graphUser == null) {
                return;
            }
            String name = this.getGraphUserPropertySafely(graphUser, "name", "");
            try {
                ValidationResult vr = this.validator.cleanObjectValue(name, Validator.ValidationContext.Profile);
                name = vr.getObject().toString();
                if (vr.getErrorCode() != 0) {
                    this.validationResultStack.pushValidationResult(vr);
                }
            }
            catch (IllegalArgumentException e) {
                name = "";
            }
            String gender = this.getGraphUserPropertySafely(graphUser, "gender", null);
            gender = gender != null ? (gender.toLowerCase().startsWith("m") ? "M" : (gender.toLowerCase().startsWith("f") ? "F" : "")) : null;
            String email = this.getGraphUserPropertySafely(graphUser, "email", "");
            String birthday = this.getGraphUserPropertySafely(graphUser, "birthday", null);
            if (birthday != null) {
                if (birthday.matches("^../..")) {
                    birthday = "";
                } else {
                    try {
                        Date date = Constants.FB_DOB_DATE_FORMAT.parse(birthday);
                        birthday = "$D_" + (int)(date.getTime() / 1000L);
                    }
                    catch (ParseException e) {
                        birthday = "";
                    }
                }
            }
            try {
                JSONArray workArray = graphUser.getJSONArray("work");
                work = workArray.length() > 0 ? "Y" : "N";
            }
            catch (Throwable t) {
                work = null;
            }
            try {
                JSONArray eduArray = graphUser.getJSONArray("education");
                String fbEdu = eduArray.getJSONObject(eduArray.length() - 1).getString("type");
                education = fbEdu.toLowerCase().contains("high school") ? "School" : (fbEdu.toLowerCase().contains("college") ? "College" : (fbEdu.toLowerCase().contains("graduate school") ? "Graduate" : ""));
            }
            catch (Throwable t) {
                education = null;
            }
            String id2 = this.getGraphUserPropertySafely(graphUser, "id", "");
            String married = this.getGraphUserPropertySafely(graphUser, "relationship_status", null);
            if (married != null) {
                married = married.equalsIgnoreCase("married") ? "Y" : "N";
            }
            JSONObject profile = new JSONObject();
            if (id2 != null && id2.length() > 3) {
                profile.put("FBID", (Object)id2);
            }
            if (name != null && name.length() > 3) {
                profile.put("Name", (Object)name);
            }
            if (email != null && email.length() > 3) {
                profile.put("Email", (Object)email);
            }
            if (gender != null && !gender.trim().equals("")) {
                profile.put("Gender", (Object)gender);
            }
            if (education != null && !education.trim().equals("")) {
                profile.put("Education", (Object)education);
            }
            if (work != null && !work.trim().equals("")) {
                profile.put("Employed", (Object)work);
            }
            if (birthday != null && birthday.length() > 3) {
                profile.put("DOB", (Object)birthday);
            }
            if (married != null && !married.trim().equals("")) {
                profile.put("Married", (Object)married);
            }
            this.pushBasicProfile(profile);
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Failed to parse graph user object successfully", t);
        }
    }

    private void _removeValueForKey(String key) {
        try {
            key = key == null ? "" : key;
            ValidationResult vr = this.validator.cleanObjectKey(key);
            key = vr.getObject().toString();
            if (key.isEmpty()) {
                ValidationResult error = ValidationResultFactory.create(512, 6, new String[0]);
                this.validationResultStack.pushValidationResult(error);
                this.getConfigLogger().debug(this.getAccountId(), error.getErrorDesc());
                return;
            }
            if (vr.getErrorCode() != 0) {
                this.validationResultStack.pushValidationResult(vr);
            }
            this.getLocalDataStore().removeProfileField(key);
            JSONObject command = new JSONObject().put("$delete", true);
            JSONObject update = new JSONObject().put(key, (Object)command);
            this.pushBasicProfile(update);
            this.getConfigLogger().verbose(this.getAccountId(), "removing value for key " + key + " from user profile");
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Failed to remove profile value for key " + key, t);
        }
    }

    private Future<?> _setLocation(Location location) {
        if (location == null) {
            return null;
        }
        this.locationFromUser = location;
        this.getConfigLogger().verbose(this.getAccountId(), "Location updated (" + location.getLatitude() + ", " + location.getLongitude() + ")");
        if (!this.isLocationForGeofence() && !CleverTapAPI.isAppForeground()) {
            return null;
        }
        int now = (int)(System.currentTimeMillis() / 1000L);
        Future<?> future = null;
        if (this.isLocationForGeofence() && now > this.lastLocationPingTimeForGeofence + 10) {
            future = this.queueEvent(this.context, new JSONObject(), 2);
            this.lastLocationPingTimeForGeofence = now;
            this.getConfigLogger().verbose(this.getAccountId(), "Queuing location ping event for geofence location (" + location.getLatitude() + ", " + location.getLongitude() + ")");
        } else if (!this.isLocationForGeofence() && now > this.lastLocationPingTime + 10) {
            future = this.queueEvent(this.context, new JSONObject(), 2);
            this.lastLocationPingTime = now;
            this.getConfigLogger().verbose(this.getAccountId(), "Queuing location ping event for location (" + location.getLatitude() + ", " + location.getLongitude() + ")");
        }
        return future;
    }

    private void _showNotificationIfAvailable(Context context) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        try {
            if (!this.canShowInAppOnActivity()) {
                Logger.v("Not showing notification on blacklisted activity");
                return;
            }
            CleverTapAPI.checkPendingNotifications(context, this.config);
            JSONArray inapps = new JSONArray(StorageHelper.getStringFromPrefs(context, this.config, "inApp", "[]"));
            if (inapps.length() < 1) {
                return;
            }
            JSONObject inapp = inapps.getJSONObject(0);
            this.prepareNotificationForDisplay(inapp);
            JSONArray inappsUpdated = new JSONArray();
            for (int i = 0; i < inapps.length(); ++i) {
                if (i == 0) continue;
                inappsUpdated.put(inapps.get(i));
            }
            SharedPreferences.Editor editor = prefs.edit().putString(StorageHelper.storageKeyWithSuffix(this.config, "inApp"), inappsUpdated.toString());
            StorageHelper.persist(editor);
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "InApp: Couldn't parse JSON array string from prefs", t);
        }
    }

    private String _stringifyAndCleanScalarProfilePropValue(Object value) {
        String val = CTJsonConverter.toJsonString(value);
        if (val != null) {
            Object _value;
            ValidationResult vr = this.validator.cleanMultiValuePropertyValue(val);
            if (vr.getErrorCode() != 0) {
                this.validationResultStack.pushValidationResult(vr);
            }
            val = (_value = vr.getObject()) != null ? vr.getObject().toString() : null;
        }
        return val;
    }

    private void _validateAndPushMultiValue(JSONArray currentValues, JSONArray newValues, ArrayList<String> originalValues, String key, String command) {
        try {
            JSONArray localValues;
            if (currentValues == null || newValues == null || originalValues == null || key == null || command == null) {
                return;
            }
            String mergeOperation = command.equals("$remove") ? "multiValuePropertyRemoveValues" : "multiValuePropertyAddValues";
            ValidationResult vr = this.validator.mergeMultiValuePropertyForKey(currentValues, newValues, mergeOperation, key);
            if (vr.getErrorCode() != 0) {
                this.validationResultStack.pushValidationResult(vr);
            }
            if ((localValues = (JSONArray)vr.getObject()) == null || localValues.length() <= 0) {
                this.getLocalDataStore().removeProfileField(key);
            } else {
                this.getLocalDataStore().setProfileField(key, localValues);
            }
            JSONObject commandObj = new JSONObject();
            commandObj.put(command, (Object)new JSONArray(originalValues));
            JSONObject fields = new JSONObject();
            fields.put(key, (Object)commandObj);
            this.pushBasicProfile(fields);
            this.getConfigLogger().verbose(this.getAccountId(), "Constructed multi-value profile push: " + fields.toString());
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Error pushing multiValue for key " + key, t);
        }
    }

    private void activityPaused() {
        CleverTapAPI.setAppForeground(false);
        this.appLastSeen = System.currentTimeMillis();
        this.getConfigLogger().verbose(this.getAccountId(), "App in background");
        int now = (int)(System.currentTimeMillis() / 1000L);
        if (this.inCurrentSession()) {
            try {
                StorageHelper.putInt(this.context, StorageHelper.storageKeyWithSuffix(this.config, "sexe"), now);
                this.getConfigLogger().verbose(this.getAccountId(), "Updated session time: " + now);
            }
            catch (Throwable t) {
                this.getConfigLogger().verbose(this.getAccountId(), "Failed to update session time time: " + t.getMessage());
            }
        }
    }

    private void activityResumed(Activity activity) {
        this.getConfigLogger().verbose(this.getAccountId(), "App in foreground");
        this.checkTimeoutSession();
        if (!this.isAppLaunchPushed()) {
            this.pushAppLaunchedEvent();
            this.fetchFeatureFlags();
            this.onTokenRefresh();
            this.postAsyncSafely("HandlingInstallReferrer", new Runnable(){

                @Override
                public void run() {
                    if (!CleverTapAPI.this.installReferrerDataSent && CleverTapAPI.this.isFirstSession()) {
                        CleverTapAPI.this.handleInstallReferrerOnFirstInstall();
                    }
                }
            });
            try {
                if (this.geofenceCallback != null) {
                    this.geofenceCallback.triggerLocation();
                }
            }
            catch (IllegalStateException e) {
                this.getConfigLogger().verbose(this.getAccountId(), e.getLocalizedMessage());
            }
            catch (Exception e) {
                this.getConfigLogger().verbose(this.getAccountId(), "Failed to trigger location");
            }
        }
        if (!this.inCurrentSession()) {
            this.pushInitialEventsAsync();
        }
        this.checkExistingInAppNotifications(activity);
        this.checkPendingInAppNotifications(activity);
    }

    private void addToQueue(Context context, JSONObject event, int eventType) {
        if (eventType == 6) {
            this.getConfigLogger().verbose(this.getAccountId(), "Pushing Notification Viewed event onto separate queue");
            this.processPushNotificationViewedEvent(context, event);
        } else {
            this.processEvent(context, event, eventType);
        }
    }

    private void asyncProfileSwitchUser(final Map<String, Object> profile, final String cacheGuid, final String cleverTapID) {
        this.postAsyncSafely("resetProfile", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "asyncProfileSwitchUser:[profile " + profile + " with Cached GUID " + (cacheGuid != null ? CleverTapAPI.this.cachedGUID : "NULL and cleverTapID " + cleverTapID));
                    CleverTapAPI.this.setCurrentUserOptedOut(false);
                    CleverTapAPI.this.forcePushDeviceToken(false);
                    CleverTapAPI.this.flushQueueSync(CleverTapAPI.this.context, EventGroup.REGULAR);
                    CleverTapAPI.this.flushQueueSync(CleverTapAPI.this.context, EventGroup.PUSH_NOTIFICATION_VIEWED);
                    CleverTapAPI.this.clearQueues(CleverTapAPI.this.context);
                    CleverTapAPI.this.getLocalDataStore().changeUser();
                    activityCount = 1;
                    CleverTapAPI.this.destroySession();
                    if (cacheGuid != null) {
                        CleverTapAPI.this.deviceInfo.forceUpdateDeviceId(cacheGuid);
                        CleverTapAPI.this.notifyUserProfileInitialized(cacheGuid);
                    } else if (CleverTapAPI.this.getConfig().getEnableCustomCleverTapId()) {
                        CleverTapAPI.this.deviceInfo.forceUpdateCustomCleverTapID(cleverTapID);
                    } else {
                        CleverTapAPI.this.deviceInfo.forceNewDeviceID();
                    }
                    CleverTapAPI.this.notifyUserProfileInitialized(CleverTapAPI.this.getCleverTapID());
                    CleverTapAPI.this.setCurrentUserOptOutStateFromStorage();
                    CleverTapAPI.this.forcePushAppLaunchedEvent();
                    if (profile != null) {
                        CleverTapAPI.this.pushProfile(profile);
                    }
                    CleverTapAPI.this.forcePushDeviceToken(true);
                    Boolean bl = CleverTapAPI.this.processingUserLoginLock;
                    synchronized (bl) {
                        CleverTapAPI.this.processingUserLoginIdentifier = null;
                    }
                    CleverTapAPI.this.resetInbox();
                    CleverTapAPI.this.resetABTesting();
                    CleverTapAPI.this.resetFeatureFlags();
                    CleverTapAPI.this.resetProductConfigs();
                    CleverTapAPI.this.recordDeviceIDErrors();
                    CleverTapAPI.this.resetDisplayUnits();
                    CleverTapAPI.this.inAppFCManager.changeUser(CleverTapAPI.this.getCleverTapID());
                }
                catch (Throwable t) {
                    CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "Reset Profile error", t);
                }
            }
        });
    }

    private void attachMeta(JSONObject o, Context context) {
        try {
            o.put("mc", Utils.getMemoryConsumption());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            o.put("nt", (Object)Utils.getCurrentNetworkType(context));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void attachPackageNameIfRequired(Context context, JSONObject event) {
        try {
            String type = event.getString("type");
            if ("event".equals(type) && "App Launched".equals(event.getString("evtName"))) {
                event.put("pai", (Object)context.getPackageName());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private HttpsURLConnection buildHttpsURLConnection(String endpoint) throws IOException {
        SSLContext _sslContext;
        URL url = new URL(endpoint);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        conn.setRequestProperty("X-CleverTap-Account-ID", this.getAccountId());
        conn.setRequestProperty("X-CleverTap-Token", this.config.getAccountToken());
        conn.setInstanceFollowRedirects(false);
        if (this.config.isSslPinningEnabled() && (_sslContext = CleverTapAPI.getSSLContext()) != null) {
            conn.setSSLSocketFactory(CleverTapAPI.getPinnedCertsSslSocketfactory(_sslContext));
        }
        return conn;
    }

    private boolean canShowInAppOnActivity() {
        this.updateBlacklistedActivitySet();
        for (String blacklistedActivity : this.inappActivityExclude) {
            String currentActivityName = CleverTapAPI.getCurrentActivityName();
            if (currentActivityName == null || !currentActivityName.contains(blacklistedActivity)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDuplicateNotificationIds(Bundle extras, HashMap<String, Object> notificationTagMap, int interval) {
        Object object = this.notificationMapLock;
        synchronized (object) {
            boolean isDupe = false;
            try {
                long timestamp;
                String notificationIdTag = extras.getString("wzrk_id");
                long now = System.currentTimeMillis();
                if (notificationTagMap.containsKey(notificationIdTag) && now - (timestamp = ((Long)notificationTagMap.get(notificationIdTag)).longValue()) < (long)interval) {
                    isDupe = true;
                }
                notificationTagMap.put(notificationIdTag, now);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return isDupe;
        }
    }

    private void checkExistingInAppNotifications(Activity activity) {
        boolean canShow = this.canShowInAppOnActivity();
        if (canShow && currentlyDisplayingInApp != null && System.currentTimeMillis() / 1000L < currentlyDisplayingInApp.getTimeToLive()) {
            Fragment inAppFragment = ((FragmentActivity)activity).getSupportFragmentManager().getFragment(new Bundle(), currentlyDisplayingInApp.getType());
            if (CleverTapAPI.getCurrentActivity() != null && inAppFragment != null) {
                FragmentTransaction fragmentTransaction = ((FragmentActivity)activity).getSupportFragmentManager().beginTransaction();
                Bundle bundle = new Bundle();
                bundle.putParcelable("inApp", (Parcelable)currentlyDisplayingInApp);
                bundle.putParcelable("config", (Parcelable)this.config);
                inAppFragment.setArguments(bundle);
                fragmentTransaction.setCustomAnimations(0x10B0000, 0x10B0001);
                fragmentTransaction.add(0x1020002, inAppFragment, currentlyDisplayingInApp.getType());
                Logger.v(this.config.getAccountId(), "calling InAppFragment " + currentlyDisplayingInApp.getCampaignId());
                fragmentTransaction.commit();
            }
        }
    }

    private void checkPendingInAppNotifications(Activity activity) {
        boolean canShow = this.canShowInAppOnActivity();
        if (canShow) {
            if (this.pendingInappRunnable != null) {
                this.getConfigLogger().verbose(this.getAccountId(), "Found a pending inapp runnable. Scheduling it");
                this.getHandlerUsingMainLooper().postDelayed(this.pendingInappRunnable, 200L);
                this.pendingInappRunnable = null;
            } else {
                this.showNotificationIfAvailable(this.context);
            }
        } else {
            Logger.d("In-app notifications will not be shown for this activity (" + (activity != null ? activity.getLocalClassName() : "") + ")");
        }
    }

    private void checkTimeoutSession() {
        if (this.appLastSeen <= 0L) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.appLastSeen > 1200000L) {
            this.getConfigLogger().verbose(this.getAccountId(), "Session Timed Out");
            this.destroySession();
            CleverTapAPI.setCurrentActivity(null);
        }
    }

    private synchronized void clearCampaign() {
        this.campaign = null;
    }

    private void clearFirstRequestTimestampIfNeeded(Context context) {
        StorageHelper.putInt(context, StorageHelper.storageKeyWithSuffix(this.config, "comms_first_ts"), 0);
    }

    private void clearIJ(Context context) {
        SharedPreferences prefs = StorageHelper.getPreferences(context, "IJ");
        SharedPreferences.Editor editor = prefs.edit();
        editor.clear();
        StorageHelper.persist(editor);
    }

    private void clearLastRequestTimestamp(Context context) {
        StorageHelper.putInt(context, StorageHelper.storageKeyWithSuffix(this.config, "comms_last_ts"), 0);
    }

    private synchronized void clearMedium() {
        this.medium = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearQueues(Context context) {
        Boolean bl = this.eventLock;
        synchronized (bl) {
            DBAdapter adapter = this.loadDBAdapter(context);
            DBAdapter.Table tableName = DBAdapter.Table.EVENTS;
            adapter.removeEvents(tableName);
            tableName = DBAdapter.Table.PROFILE_EVENTS;
            adapter.removeEvents(tableName);
            this.clearUserContext(context);
        }
    }

    private synchronized void clearSource() {
        this.source = null;
    }

    private void clearUserContext(Context context) {
        this.clearIJ(context);
        this.clearFirstRequestTimestampIfNeeded(context);
        this.clearLastRequestTimestamp(context);
    }

    private synchronized void clearWzrkParams() {
        this.wzrkParams = null;
    }

    private void createAlarmScheduler(Context context) {
        int pingFrequency = this.getPingFrequency(context);
        if (pingFrequency > 0) {
            AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
            Intent intent = new Intent("com.clevertap.BG_EVENT");
            intent.setPackage(context.getPackageName());
            PendingIntent alarmPendingIntent = PendingIntent.getService((Context)context, (int)this.getAccountId().hashCode(), (Intent)intent, (int)0x8000000);
            if (alarmManager != null) {
                alarmManager.setInexactRepeating(2, SystemClock.elapsedRealtime(), 60000L * (long)pingFrequency, alarmPendingIntent);
            }
        }
    }

    @SuppressLint(value={"MissingPermission"})
    @RequiresApi(api=21)
    private void createOrResetJobScheduler(Context context) {
        int existingJobId = StorageHelper.getInt(context, "pfjobid", -1);
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (Build.VERSION.SDK_INT < 26) {
            if (existingJobId >= 0) {
                jobScheduler.cancel(existingJobId);
                StorageHelper.putInt(context, "pfjobid", -1);
            }
            this.getConfigLogger().debug(this.getAccountId(), "Push Amplification feature is not supported below Oreo");
            return;
        }
        if (jobScheduler == null) {
            return;
        }
        int pingFrequency = this.getPingFrequency(context);
        if (existingJobId < 0 && pingFrequency < 0) {
            return;
        }
        if (pingFrequency < 0) {
            jobScheduler.cancel(existingJobId);
            StorageHelper.putInt(context, "pfjobid", -1);
            return;
        }
        ComponentName componentName = new ComponentName(context, CTBackgroundJobService.class);
        boolean needsCreate = existingJobId < 0 && pingFrequency > 0;
        JobInfo existingJobInfo = CleverTapAPI.getJobInfo(existingJobId, jobScheduler);
        if (existingJobInfo != null && existingJobInfo.getIntervalMillis() != (long)pingFrequency * 60000L) {
            jobScheduler.cancel(existingJobId);
            StorageHelper.putInt(context, "pfjobid", -1);
            needsCreate = true;
        }
        if (needsCreate) {
            JobInfo jobInfo;
            int resultCode;
            int jobid = this.getAccountId().hashCode();
            JobInfo.Builder builder = new JobInfo.Builder(jobid, componentName);
            builder.setRequiredNetworkType(1);
            builder.setRequiresCharging(false);
            builder.setPeriodic((long)pingFrequency * 60000L, 300000L);
            builder.setRequiresBatteryNotLow(true);
            if (Utils.hasPermission(context, "android.permission.RECEIVE_BOOT_COMPLETED")) {
                builder.setPersisted(true);
            }
            if ((resultCode = jobScheduler.schedule(jobInfo = builder.build())) == 1) {
                Logger.d(this.getAccountId(), "Job scheduled - " + jobid);
                StorageHelper.putInt(context, "pfjobid", jobid);
            } else {
                Logger.d(this.getAccountId(), "Job not scheduled - " + jobid);
            }
        }
    }

    private void createSession(Context context) {
        this.currentSessionId = (int)(System.currentTimeMillis() / 1000L);
        this.getConfigLogger().verbose(this.getAccountId(), "Session created with ID: " + this.currentSessionId);
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        int lastSessionID = StorageHelper.getIntFromPrefs(context, this.config, "lastSessionId", 0);
        int lastSessionTime = StorageHelper.getIntFromPrefs(context, this.config, "sexe", 0);
        if (lastSessionTime > 0) {
            this.lastSessionLength = lastSessionTime - lastSessionID;
        }
        this.getConfigLogger().verbose(this.getAccountId(), "Last session length: " + this.lastSessionLength + " seconds");
        if (lastSessionID == 0) {
            this.firstSession = true;
        }
        SharedPreferences.Editor editor = prefs.edit().putInt(StorageHelper.storageKeyWithSuffix(this.config, "lastSessionId"), this.currentSessionId);
        StorageHelper.persist(editor);
    }

    private void destroySession() {
        this.currentSessionId = 0;
        this.setAppLaunchPushed(false);
        if (this.isFirstSession()) {
            this.firstSession = false;
        }
        this.getConfigLogger().verbose(this.getAccountId(), "Session destroyed; Session ID is now 0");
        this.clearSource();
        this.clearMedium();
        this.clearCampaign();
        this.clearWzrkParams();
    }

    private void deviceTokenDidRefresh(String token, PushConstants.PushType type) {
        if (this.tokenRefreshListener != null) {
            this.getConfigLogger().debug(this.getAccountId(), "Notifying devicePushTokenDidRefresh: " + token);
            this.tokenRefreshListener.devicePushTokenDidRefresh(token, type);
        }
    }

    private void displayNotification(final CTInAppNotification inAppNotification) {
        boolean goFromListener;
        if (Looper.myLooper() != Looper.getMainLooper()) {
            this.getHandlerUsingMainLooper().post(new Runnable(){

                @Override
                public void run() {
                    CleverTapAPI.this.displayNotification(inAppNotification);
                }
            });
            return;
        }
        if (this.inAppFCManager != null) {
            if (!this.inAppFCManager.canShow(inAppNotification)) {
                this.getConfigLogger().verbose(this.getAccountId(), "InApp has been rejected by FC, not showing " + inAppNotification.getCampaignId());
                this.showInAppNotificationIfAny();
                return;
            }
        } else {
            this.getConfigLogger().verbose(this.getAccountId(), "InAppFCManager is NULL, not showing " + inAppNotification.getCampaignId());
            return;
        }
        this.inAppFCManager.didShow(this.context, inAppNotification);
        InAppNotificationListener listener = this.getInAppNotificationListener();
        if (listener != null) {
            HashMap<String, Object> kvs = inAppNotification.getCustomExtras() != null ? Utils.convertJSONObjectToHashMap(inAppNotification.getCustomExtras()) : new HashMap();
            goFromListener = listener.beforeShow(kvs);
        } else {
            goFromListener = true;
        }
        if (!goFromListener) {
            this.getConfigLogger().verbose(this.getAccountId(), "Application has decided to not show this in-app notification: " + inAppNotification.getCampaignId());
            this.showInAppNotificationIfAny();
            return;
        }
        CleverTapAPI.showInApp(this.context, inAppNotification, this.config);
    }

    private void doTokenRefresh(String token, PushConstants.PushType pushType) {
        if (TextUtils.isEmpty((CharSequence)token) || pushType == null) {
            return;
        }
        switch (pushType) {
            case FCM: {
                this.pushFcmRegistrationId(token, true);
                break;
            }
            case XPS: {
                this.pushXiaomiRegistrationId(token, true);
                break;
            }
            case HPS: {
                this.pushHuaweiRegistrationId(token, true);
                break;
            }
            case BPS: {
                this.pushBaiduRegistrationId(token, true);
                break;
            }
            case ADM: {
                this.pushAmazonRegistrationId(token, true);
            }
        }
    }

    private void flushDBQueue(Context context, EventGroup eventGroup) {
        this.getConfigLogger().verbose(this.getAccountId(), "Somebody has invoked me to send the queue to CleverTap servers");
        QueueCursor previousCursor = null;
        boolean loadMore = true;
        while (loadMore) {
            QueueCursor cursor = this.getQueuedEvents(context, 50, previousCursor, eventGroup);
            if (cursor == null || cursor.isEmpty().booleanValue()) {
                this.getConfigLogger().verbose(this.getAccountId(), "No events in the queue, failing");
                break;
            }
            previousCursor = cursor;
            JSONArray queue = cursor.getData();
            if (queue == null || queue.length() <= 0) {
                this.getConfigLogger().verbose(this.getAccountId(), "No events in the queue, failing");
                break;
            }
            loadMore = this.sendQueue(context, eventGroup, queue);
        }
    }

    private void flushQueueAsync(final Context context, final EventGroup eventGroup) {
        this.postAsyncSafely("CommsManager#flushQueueAsync", new Runnable(){

            @Override
            public void run() {
                if (eventGroup == EventGroup.PUSH_NOTIFICATION_VIEWED) {
                    CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "Pushing Notification Viewed event onto queue flush sync");
                } else {
                    CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "Pushing event onto queue flush sync");
                }
                CleverTapAPI.this.flushQueueSync(context, eventGroup);
            }
        });
    }

    private void flushQueueSync(final Context context, final EventGroup eventGroup) {
        if (!this.isNetworkOnline(context)) {
            this.getConfigLogger().verbose(this.getAccountId(), "Network connectivity unavailable. Will retry later");
            return;
        }
        if (this.isOffline()) {
            this.getConfigLogger().debug(this.getAccountId(), "CleverTap Instance has been set to offline, won't send events queue");
            return;
        }
        if (this.needsHandshakeForDomain(eventGroup)) {
            this.mResponseFailureCount = 0;
            this.setDomain(context, null);
            this.performHandshakeForDomain(context, eventGroup, new Runnable(){

                @Override
                public void run() {
                    CleverTapAPI.this.flushDBQueue(context, eventGroup);
                }
            });
        } else {
            this.getConfigLogger().verbose(this.getAccountId(), "Pushing Notification Viewed event onto queue DB flush");
            this.flushDBQueue(context, eventGroup);
        }
    }

    private void forcePushAppLaunchedEvent() {
        this.setAppLaunchPushed(false);
        this.pushAppLaunchedEvent();
    }

    private void forcePushDeviceToken(boolean register) {
        for (PushConstants.PushType pushType : this.pushProviders.getAvailablePushTypes()) {
            this.pushDeviceTokenEvent(null, register, pushType);
        }
    }

    private JSONObject getARP() {
        try {
            String nameSpaceKey = this.getNewNamespaceARPKey();
            if (nameSpaceKey == null) {
                return null;
            }
            SharedPreferences prefs = null;
            prefs = !StorageHelper.getPreferences(this.context, nameSpaceKey).getAll().isEmpty() ? StorageHelper.getPreferences(this.context, nameSpaceKey) : this.migrateARPToNewNameSpace(nameSpaceKey, this.getNamespaceARPKey());
            Map all = prefs.getAll();
            Iterator iter = all.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry kv = iter.next();
                Object o = kv.getValue();
                if (!(o instanceof Number) || ((Number)o).intValue() != -1) continue;
                iter.remove();
            }
            JSONObject ret = new JSONObject(all);
            this.getConfigLogger().verbose(this.getAccountId(), "Fetched ARP for namespace key: " + nameSpaceKey + " values: " + all.toString());
            return ret;
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Failed to construct ARP object", t);
            return null;
        }
    }

    private long getAppInstallTime() {
        return this.appInstallTime;
    }

    private JSONObject getAppLaunchedFields() {
        try {
            boolean deviceIsMultiUser = false;
            if (this.deviceInfo.getGoogleAdID() != null) {
                deviceIsMultiUser = new LoginInfoProvider(this).deviceIsMultiUser();
            }
            return CTJsonConverter.from(this.deviceInfo, this.locationFromUser, this.enableNetworkInfoReporting, deviceIsMultiUser);
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Failed to construct App Launched event", t);
            return new JSONObject();
        }
    }

    private synchronized String getCampaign() {
        return this.campaign;
    }

    private synchronized void setCampaign(String campaign) {
        if (this.campaign == null) {
            this.campaign = campaign;
        }
    }

    private CleverTapInstanceConfig getConfig() {
        return this.config;
    }

    private Logger getConfigLogger() {
        return this.getConfig().getLogger();
    }

    private int getCurrentSession() {
        return this.currentSessionId;
    }

    private int getDelayFrequency() {
        this.getConfigLogger().debug(this.getAccountId(), "Network retry #" + this.networkRetryCount);
        if (this.networkRetryCount < 10) {
            this.getConfigLogger().debug(this.getAccountId(), "Failure count is " + this.networkRetryCount + ". Setting delay frequency to 1s");
            this.minDelayFrequency = 1000;
            return this.minDelayFrequency;
        }
        if (this.config.getAccountRegion() == null) {
            this.getConfigLogger().debug(this.getAccountId(), "Setting delay frequency to 1s");
            return 1000;
        }
        Random randomGen = new Random();
        int randomDelay = (randomGen.nextInt(10) + 1) * 1000;
        this.minDelayFrequency += randomDelay;
        if (this.minDelayFrequency < 600000) {
            this.getConfigLogger().debug(this.getAccountId(), "Setting delay frequency to " + this.minDelayFrequency);
            return this.minDelayFrequency;
        }
        this.minDelayFrequency = 1000;
        this.getConfigLogger().debug(this.getAccountId(), "Setting delay frequency to " + this.minDelayFrequency);
        return this.minDelayFrequency;
    }

    private String getDomain(boolean defaultToHandshakeURL, EventGroup eventGroup) {
        boolean emptyDomain;
        String domain = this.getDomainFromPrefsOrMetadata(eventGroup);
        boolean bl = emptyDomain = domain == null || domain.trim().length() == 0;
        if (emptyDomain && !defaultToHandshakeURL) {
            return null;
        }
        domain = emptyDomain ? "wzrkt.com/hello" : domain + "/a1";
        return domain;
    }

    private String getDomainFromPrefsOrMetadata(EventGroup eventGroup) {
        try {
            String region = this.config.getAccountRegion();
            if (region != null && region.trim().length() > 0) {
                this.mResponseFailureCount = 0;
                if (eventGroup.equals((Object)EventGroup.PUSH_NOTIFICATION_VIEWED)) {
                    return region.trim().toLowerCase() + eventGroup.httpResource + "." + "wzrkt.com";
                }
                return region.trim().toLowerCase() + "." + "wzrkt.com";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (eventGroup.equals((Object)EventGroup.PUSH_NOTIFICATION_VIEWED)) {
            return StorageHelper.getStringFromPrefs(this.context, this.config, "comms_dmn_spiky", null);
        }
        return StorageHelper.getStringFromPrefs(this.context, this.config, "comms_dmn", null);
    }

    private String getEndpoint(boolean defaultToHandshakeURL, EventGroup eventGroup) {
        String domain = this.getDomain(defaultToHandshakeURL, eventGroup);
        if (domain == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "Unable to configure endpoint, domain is null");
            return null;
        }
        String accountId = this.getAccountId();
        if (accountId == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "Unable to configure endpoint, accountID is null");
            return null;
        }
        String endpoint = "https://" + domain + "?os=Android&t=" + this.deviceInfo.getSdkVersion();
        endpoint = endpoint + "&z=" + accountId;
        boolean needsHandshake = this.needsHandshakeForDomain(eventGroup);
        if (needsHandshake) {
            return endpoint;
        }
        this.currentRequestTimestamp = (int)(System.currentTimeMillis() / 1000L);
        endpoint = endpoint + "&ts=" + this.currentRequestTimestamp;
        return endpoint;
    }

    private int getFirstRequestTimestamp() {
        return StorageHelper.getIntFromPrefs(this.context, this.config, "comms_first_ts", 0);
    }

    private int getGeofenceSDKVersion() {
        return this.geofenceSDKVersion;
    }

    private void setGeofenceSDKVersion(int geofenceSDKVersion) {
        this.geofenceSDKVersion = geofenceSDKVersion;
    }

    private String getGraphUserPropertySafely(JSONObject graphUser, String key, String def) {
        try {
            String prop = (String)graphUser.get(key);
            if (prop != null) {
                return prop;
            }
            return def;
        }
        catch (Throwable t) {
            return def;
        }
    }

    private Handler getHandlerUsingMainLooper() {
        return this.handlerUsingMainLooper;
    }

    private long getI() {
        return StorageHelper.getLongFromPrefs(this.context, this.config, "comms_i", 0, "IJ");
    }

    private long getJ() {
        return StorageHelper.getLongFromPrefs(this.context, this.config, "comms_j", 0, "IJ");
    }

    private int getLastRequestTimestamp() {
        return StorageHelper.getIntFromPrefs(this.context, this.config, "comms_last_ts", 0);
    }

    private int getLastSessionLength() {
        return this.lastSessionLength;
    }

    private LocalDataStore getLocalDataStore() {
        return this.localDataStore;
    }

    private synchronized String getMedium() {
        return this.medium;
    }

    private synchronized void setMedium(String medium) {
        if (this.medium == null) {
            this.medium = medium;
        }
    }

    private String getNamespaceARPKey() {
        String accountId = this.getAccountId();
        if (accountId == null) {
            return null;
        }
        this.getConfigLogger().verbose(this.getAccountId(), "Old ARP Key = ARP:" + accountId);
        return "ARP:" + accountId;
    }

    private String getNewNamespaceARPKey() {
        String accountId = this.getAccountId();
        if (accountId == null) {
            return null;
        }
        this.getConfigLogger().verbose(this.getAccountId(), "New ARP Key = ARP:" + accountId + ":" + this.getCleverTapID());
        return "ARP:" + accountId + ":" + this.getCleverTapID();
    }

    private int getPingFrequency(Context context) {
        return StorageHelper.getInt(context, "pf", 240);
    }

    private QueueCursor getPushNotificationViewedQueuedEvents(Context context, int batchSize, QueueCursor previousCursor) {
        return this.getQueueCursor(context, DBAdapter.Table.PUSH_NOTIFICATION_VIEWED, batchSize, previousCursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueCursor getQueueCursor(Context context, DBAdapter.Table table, int batchSize, QueueCursor previousCursor) {
        Boolean bl = this.eventLock;
        synchronized (bl) {
            DBAdapter.Table tableName;
            DBAdapter adapter = this.loadDBAdapter(context);
            DBAdapter.Table table2 = tableName = previousCursor != null ? previousCursor.getTableName() : table;
            if (previousCursor != null) {
                adapter.cleanupEventsFromLastId(previousCursor.getLastId(), previousCursor.getTableName());
            }
            QueueCursor newCursor = new QueueCursor();
            newCursor.setTableName(tableName);
            JSONObject queuedDBEvents = adapter.fetchEvents(tableName, batchSize);
            newCursor = this.updateCursorForDBObject(queuedDBEvents, newCursor);
            return newCursor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueCursor getQueuedDBEvents(Context context, int batchSize, QueueCursor previousCursor) {
        Boolean bl = this.eventLock;
        synchronized (bl) {
            QueueCursor newCursor = this.getQueueCursor(context, DBAdapter.Table.EVENTS, batchSize, previousCursor);
            if (newCursor.isEmpty().booleanValue() && newCursor.getTableName().equals((Object)DBAdapter.Table.EVENTS)) {
                newCursor = this.getQueueCursor(context, DBAdapter.Table.PROFILE_EVENTS, batchSize, null);
            }
            return newCursor.isEmpty() != false ? null : newCursor;
        }
    }

    private QueueCursor getQueuedEvents(Context context, int batchSize, QueueCursor previousCursor, EventGroup eventGroup) {
        if (eventGroup == EventGroup.PUSH_NOTIFICATION_VIEWED) {
            this.getConfigLogger().verbose(this.getAccountId(), "Returning Queued Notification Viewed events");
            return this.getPushNotificationViewedQueuedEvents(context, batchSize, previousCursor);
        }
        this.getConfigLogger().verbose(this.getAccountId(), "Returning Queued events");
        return this.getQueuedDBEvents(context, batchSize, previousCursor);
    }

    private long getReferrerClickTime() {
        return this.referrerClickTime;
    }

    private String getScreenName() {
        return this.currentScreenName.equals("") ? null : this.currentScreenName;
    }

    private synchronized String getSource() {
        return this.source;
    }

    private synchronized void setSource(String source) {
        if (this.source == null) {
            this.source = source;
        }
    }

    private synchronized JSONObject getWzrkParams() {
        return this.wzrkParams;
    }

    private synchronized void setWzrkParams(JSONObject wzrkParams) {
        if (this.wzrkParams == null) {
            this.wzrkParams = wzrkParams;
        }
    }

    private void handleARPUpdate(Context context, JSONObject arp) {
        if (arp == null || arp.length() == 0) {
            return;
        }
        String nameSpaceKey = this.getNewNamespaceARPKey();
        if (nameSpaceKey == null) {
            return;
        }
        SharedPreferences prefs = StorageHelper.getPreferences(context, nameSpaceKey);
        SharedPreferences.Editor editor = prefs.edit();
        Iterator keys = arp.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                Object o = arp.get(key);
                if (o instanceof Number) {
                    int update = ((Number)o).intValue();
                    editor.putInt(key, update);
                    continue;
                }
                if (o instanceof String) {
                    if (((String)o).length() < 100) {
                        editor.putString(key, (String)o);
                        continue;
                    }
                    this.getConfigLogger().verbose(this.getAccountId(), "ARP update for key " + key + " rejected (string value too long)");
                    continue;
                }
                if (o instanceof Boolean) {
                    editor.putBoolean(key, ((Boolean)o).booleanValue());
                    continue;
                }
                this.getConfigLogger().verbose(this.getAccountId(), "ARP update for key " + key + " rejected (invalid data type)");
            }
            catch (JSONException jSONException) {}
        }
        this.getConfigLogger().verbose(this.getAccountId(), "Stored ARP for namespace key: " + nameSpaceKey + " values: " + arp.toString());
        StorageHelper.persist(editor);
    }

    private void handleInstallReferrerOnFirstInstall() {
        this.getConfigLogger().verbose(this.getAccountId(), "Starting to handle install referrer");
        try {
            final InstallReferrerClient referrerClient = InstallReferrerClient.newBuilder((Context)this.context).build();
            referrerClient.startConnection(new InstallReferrerStateListener(){

                public void onInstallReferrerServiceDisconnected() {
                    if (!CleverTapAPI.this.installReferrerDataSent) {
                        CleverTapAPI.this.handleInstallReferrerOnFirstInstall();
                    }
                }

                public void onInstallReferrerSetupFinished(int responseCode) {
                    switch (responseCode) {
                        case 0: {
                            ReferrerDetails response = null;
                            try {
                                response = referrerClient.getInstallReferrer();
                                String referrerUrl = response.getInstallReferrer();
                                CleverTapAPI.this.referrerClickTime = response.getReferrerClickTimestampSeconds();
                                CleverTapAPI.this.appInstallTime = response.getInstallBeginTimestampSeconds();
                                CleverTapAPI.this.pushInstallReferrer(referrerUrl);
                                CleverTapAPI.this.installReferrerDataSent = true;
                                CleverTapAPI.this.getConfigLogger().debug(CleverTapAPI.this.getAccountId(), "Install Referrer data set [Referrer URL-" + referrerUrl + "]");
                            }
                            catch (RemoteException e) {
                                CleverTapAPI.this.getConfigLogger().debug(CleverTapAPI.this.getAccountId(), "Remote exception caused by Google Play Install Referrer library - " + e.getMessage());
                                referrerClient.endConnection();
                                CleverTapAPI.this.installReferrerDataSent = false;
                            }
                            referrerClient.endConnection();
                            break;
                        }
                        case 2: {
                            CleverTapAPI.this.getConfigLogger().debug(CleverTapAPI.this.getAccountId(), "Install Referrer data not set, API not supported by Play Store on device");
                            break;
                        }
                        case 1: {
                            CleverTapAPI.this.getConfigLogger().debug(CleverTapAPI.this.getAccountId(), "Install Referrer data not set, connection to Play Store unavailable");
                        }
                    }
                }
            });
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Google Play Install Referrer's InstallReferrerClient Class not found - " + t.getLocalizedMessage() + " \n Please add implementation 'com.android.installreferrer:installreferrer:2.1' to your build.gradle");
        }
    }

    private void handlePushNotificationsInResponse(JSONArray pushNotifications) {
        try {
            for (int i = 0; i < pushNotifications.length(); ++i) {
                Bundle pushBundle = new Bundle();
                JSONObject pushObject = pushNotifications.getJSONObject(i);
                if (pushObject.has("wzrk_acct_id")) {
                    pushBundle.putString("wzrk_acct_id", pushObject.getString("wzrk_acct_id"));
                }
                if (pushObject.has("wzrk_acts")) {
                    pushBundle.putString("wzrk_acts", pushObject.getString("wzrk_acts"));
                }
                if (pushObject.has("nm")) {
                    pushBundle.putString("nm", pushObject.getString("nm"));
                }
                if (pushObject.has("nt")) {
                    pushBundle.putString("nt", pushObject.getString("nt"));
                }
                if (pushObject.has("wzrk_bp")) {
                    pushBundle.putString("wzrk_bp", pushObject.getString("wzrk_bp"));
                }
                if (pushObject.has("pr")) {
                    pushBundle.putString("pr", pushObject.getString("pr"));
                }
                if (pushObject.has("wzrk_pivot")) {
                    pushBundle.putString("wzrk_pivot", pushObject.getString("wzrk_pivot"));
                }
                if (pushObject.has("wzrk_sound")) {
                    pushBundle.putString("wzrk_sound", pushObject.getString("wzrk_sound"));
                }
                if (pushObject.has("wzrk_cid")) {
                    pushBundle.putString("wzrk_cid", pushObject.getString("wzrk_cid"));
                }
                if (pushObject.has("wzrk_bc")) {
                    pushBundle.putString("wzrk_bc", pushObject.getString("wzrk_bc"));
                }
                if (pushObject.has("wzrk_bi")) {
                    pushBundle.putString("wzrk_bi", pushObject.getString("wzrk_bi"));
                }
                if (pushObject.has("wzrk_id")) {
                    pushBundle.putString("wzrk_id", pushObject.getString("wzrk_id"));
                }
                if (pushObject.has(NOTIFICATION_TAG)) {
                    pushBundle.putString(NOTIFICATION_TAG, pushObject.getString(NOTIFICATION_TAG));
                }
                if (pushObject.has("ico")) {
                    pushBundle.putString("ico", pushObject.getString("ico"));
                }
                if (pushObject.has("wzrk_ck")) {
                    pushBundle.putString("wzrk_ck", pushObject.getString("wzrk_ck"));
                }
                if (pushObject.has("wzrk_dl")) {
                    pushBundle.putString("wzrk_dl", pushObject.getString("wzrk_dl"));
                }
                if (pushObject.has("wzrk_pid")) {
                    pushBundle.putString("wzrk_pid", pushObject.getString("wzrk_pid"));
                }
                if (pushObject.has("wzrk_ttl")) {
                    pushBundle.putLong("wzrk_ttl", pushObject.getLong("wzrk_ttl"));
                }
                if (pushObject.has("wzrk_rnv")) {
                    pushBundle.putString("wzrk_rnv", pushObject.getString("wzrk_rnv"));
                }
                Iterator iterator = pushObject.keys();
                while (iterator.hasNext()) {
                    String key = iterator.next().toString();
                    pushBundle.putString(key, pushObject.getString(key));
                }
                if (!pushBundle.isEmpty() && !this.dbAdapter.doesPushNotificationIdExist(pushObject.getString("wzrk_pid"))) {
                    this.getConfigLogger().verbose("Creating Push Notification locally");
                    if (this.pushAmpListener != null) {
                        this.pushAmpListener.onPushAmpPayloadReceived(pushBundle);
                        continue;
                    }
                    CleverTapAPI.createNotification(this.context, pushBundle);
                    continue;
                }
                this.getConfigLogger().verbose(this.getAccountId(), "Push Notification already shown, ignoring local notification :" + pushObject.getString("wzrk_pid"));
            }
        }
        catch (JSONException e) {
            this.getConfigLogger().verbose(this.getAccountId(), "Error parsing push notification JSON");
        }
    }

    private void handleSendTestForDisplayUnits(Bundle extras) {
        try {
            String pushJsonPayload = extras.getString("wzrk_adunit");
            Logger.v("Received Display Unit via push payload: " + pushJsonPayload);
            JSONObject r = new JSONObject();
            JSONArray displayUnits = new JSONArray();
            r.put("adUnit_notifs", (Object)displayUnits);
            JSONObject testPushObject = new JSONObject(pushJsonPayload);
            displayUnits.put((Object)testPushObject);
            this.processDisplayUnitsResponse(r);
        }
        catch (Throwable t) {
            Logger.v("Failed to process Display Unit from push notification payload", t);
        }
    }

    private boolean hasDomainChanged(String newDomain) {
        String oldDomain = StorageHelper.getStringFromPrefs(this.context, this.config, "comms_dmn", null);
        return !newDomain.equals(oldDomain);
    }

    private boolean inCurrentSession() {
        return this.currentSessionId > 0;
    }

    private void initABTesting() {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        if (!this.config.isAnalyticsOnly()) {
            if (!this.config.isABTestingEnabled()) {
                this.getConfigLogger().debug(this.config.getAccountId(), "AB Testing is not enabled for this instance");
                return;
            }
            if (this.getCleverTapID() == null) {
                this.getConfigLogger().verbose(this.config.getAccountId(), "GUID not set yet, deferring ABTesting initialization");
                return;
            }
            this.config.setEnableUIEditor(isUIEditorEnabled);
            if (this.ctABTestController == null) {
                this.ctABTestController = new CTABTestController(this.context, this.config, this.getCleverTapID(), this);
                this.getConfigLogger().verbose(this.config.getAccountId(), "AB Testing initialized");
            }
        }
    }

    private void initFeatureFlags(boolean fromPlayServices) {
        Logger.v("Initializing Feature Flags with device Id = " + this.getCleverTapID());
        if (this.config.isAnalyticsOnly()) {
            this.getConfigLogger().debug(this.config.getAccountId(), "Feature Flag is not enabled for this instance");
            return;
        }
        if (this.ctFeatureFlagsController == null) {
            this.ctFeatureFlagsController = new CTFeatureFlagsController(this.context, this.getCleverTapID(), this.config, this);
            this.getConfigLogger().verbose(this.config.getAccountId(), "Feature Flags initialized");
        }
        if (fromPlayServices && !this.ctFeatureFlagsController.isInitialized()) {
            this.ctFeatureFlagsController.setGuidAndInit(this.getCleverTapID());
        }
    }

    private void initProductConfig(boolean fromPlayServices) {
        Logger.v("Initializing Product Config with device Id = " + this.getCleverTapID());
        if (this.config.isAnalyticsOnly()) {
            this.getConfigLogger().debug(this.config.getAccountId(), "Product Config is not enabled for this instance");
            return;
        }
        if (this.ctProductConfigController == null) {
            this.ctProductConfigController = new CTProductConfigController(this.context, this.getCleverTapID(), this.config, this);
        }
        if (fromPlayServices && !this.ctProductConfigController.isInitialized()) {
            this.ctProductConfigController.setGuidAndInit(this.getCleverTapID());
        }
    }

    private String insertHeader(Context context, JSONArray arr) {
        try {
            long j;
            JSONObject header = new JSONObject();
            String deviceId = this.getCleverTapID();
            if (deviceId != null && !deviceId.equals("")) {
                header.put("g", (Object)deviceId);
            } else {
                this.getConfigLogger().verbose(this.getAccountId(), "CRITICAL: Couldn't finalise on a device ID! Using error device ID instead!");
            }
            header.put("type", (Object)"meta");
            JSONObject appFields = this.getAppLaunchedFields();
            header.put("af", (Object)appFields);
            long i = this.getI();
            if (i > 0L) {
                header.put("_i", i);
            }
            if ((j = this.getJ()) > 0L) {
                header.put("_j", j);
            }
            String accountId = this.getAccountId();
            String token = this.config.getAccountToken();
            if (accountId == null || token == null) {
                this.getConfigLogger().debug(this.getAccountId(), "Account ID/token not found, unable to configure queue request");
                return null;
            }
            header.put("id", (Object)accountId);
            header.put("tk", (Object)token);
            header.put("l_ts", this.getLastRequestTimestamp());
            header.put("f_ts", this.getFirstRequestTimestamp());
            header.put("ct_pi", (Object)IdentityRepoFactory.getRepo(this).getIdentitySet().toString());
            header.put("ddnd", !this.deviceInfo.getNotificationsEnabledForUser() || !this.pushProviders.isNotificationSupported());
            if (this.isBgPing) {
                header.put("bk", 1);
                this.isBgPing = false;
            }
            header.put("rtl", (Object)CTJsonConverter.getRenderedTargetList(this.dbAdapter));
            if (!this.installReferrerDataSent) {
                header.put("rct", this.getReferrerClickTime());
                header.put("ait", this.getAppInstallTime());
            }
            header.put("frs", this.isFirstRequestInSession());
            this.setFirstRequestInSession(false);
            try {
                JSONObject arp = this.getARP();
                if (arp != null && arp.length() > 0) {
                    header.put("arp", (Object)arp);
                }
            }
            catch (Throwable t) {
                this.getConfigLogger().verbose(this.getAccountId(), "Failed to attach ARP", t);
            }
            JSONObject ref = new JSONObject();
            try {
                String utmCampaign;
                String utmMedium;
                String utmSource = this.getSource();
                if (utmSource != null) {
                    ref.put("us", (Object)utmSource);
                }
                if ((utmMedium = this.getMedium()) != null) {
                    ref.put("um", (Object)utmMedium);
                }
                if ((utmCampaign = this.getCampaign()) != null) {
                    ref.put("uc", (Object)utmCampaign);
                }
                if (ref.length() > 0) {
                    header.put("ref", (Object)ref);
                }
            }
            catch (Throwable t) {
                this.getConfigLogger().verbose(this.getAccountId(), "Failed to attach ref", t);
            }
            JSONObject wzrkParams = this.getWzrkParams();
            if (wzrkParams != null && wzrkParams.length() > 0) {
                header.put("wzrk_ref", (Object)wzrkParams);
            }
            if (this.inAppFCManager != null) {
                Logger.v("Attaching InAppFC to Header");
                this.inAppFCManager.attachToHeader(context, header);
            }
            return "[" + header.toString() + ", " + arr.toString().substring(1);
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "CommsManager: Failed to attach header", t);
            return arr.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAppLaunchPushed() {
        Object object = this.appLaunchPushedLock;
        synchronized (object) {
            return this.appLaunchPushed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAppLaunchPushed(boolean pushed) {
        Object object = this.appLaunchPushedLock;
        synchronized (object) {
            this.appLaunchPushed = pushed;
        }
    }

    private boolean isAppLaunchReportingDisabled() {
        return this.config.isDisableAppLaunchedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCurrentUserOptedOut() {
        Object object = this.optOutFlagLock;
        synchronized (object) {
            return this.currentUserOptedOut;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentUserOptedOut(boolean enable) {
        Object object = this.optOutFlagLock;
        synchronized (object) {
            this.currentUserOptedOut = enable;
        }
    }

    private boolean isErrorDeviceId() {
        return this.deviceInfo.isErrorDeviceId();
    }

    private boolean isFirstRequestInSession() {
        return this.firstRequestInSession;
    }

    private void setFirstRequestInSession(boolean firstRequestInSession) {
        this.firstRequestInSession = firstRequestInSession;
    }

    private boolean isFirstSession() {
        return this.firstSession;
    }

    private boolean isLocationForGeofence() {
        return this.isLocationForGeofence;
    }

    private void setLocationForGeofence(boolean locationForGeofence) {
        this.isLocationForGeofence = locationForGeofence;
    }

    private boolean isMuted() {
        int muteTS;
        int now = (int)(System.currentTimeMillis() / 1000L);
        return now - (muteTS = StorageHelper.getIntFromPrefs(this.context, this.config, "comms_mtd", 0)) < 86400;
    }

    private boolean isNetworkOnline(Context context) {
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            if (cm == null) {
                return true;
            }
            NetworkInfo netInfo = cm.getActiveNetworkInfo();
            return netInfo != null && netInfo.isConnected();
        }
        catch (Throwable ignore) {
            return true;
        }
    }

    private boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean value) {
        this.offline = value;
        if (this.offline) {
            this.getConfigLogger().debug(this.getAccountId(), "CleverTap Instance has been set to offline, won't send events queue");
        } else {
            this.getConfigLogger().debug(this.getAccountId(), "CleverTap Instance has been set to online, sending events queue");
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isProcessUserLoginWithIdentifier(String identifier) {
        Boolean bl = this.processingUserLoginLock;
        synchronized (bl) {
            return this.processingUserLoginIdentifier != null && this.processingUserLoginIdentifier.equals(identifier);
        }
    }

    private boolean isTimeBetweenDNDTime(Date startTime, Date stopTime, Date currentTime) {
        Calendar startTimeCalendar = Calendar.getInstance();
        startTimeCalendar.setTime(startTime);
        Calendar currentTimeCalendar = Calendar.getInstance();
        currentTimeCalendar.setTime(currentTime);
        Calendar stopTimeCalendar = Calendar.getInstance();
        stopTimeCalendar.setTime(stopTime);
        if (stopTime.compareTo(startTime) < 0) {
            if (currentTimeCalendar.compareTo(stopTimeCalendar) < 0) {
                currentTimeCalendar.add(5, 1);
            }
            stopTimeCalendar.add(5, 1);
        }
        return currentTimeCalendar.compareTo(startTimeCalendar) >= 0 && currentTimeCalendar.compareTo(stopTimeCalendar) < 0;
    }

    private void lazyCreateSession(Context context) {
        if (!this.inCurrentSession()) {
            this.setFirstRequestInSession(true);
            if (this.validator != null) {
                this.validator.setDiscardedEvents(null);
            }
            this.createSession(context);
            this.pushInitialEventsAsync();
        }
    }

    private DBAdapter loadDBAdapter(Context context) {
        if (this.dbAdapter == null) {
            this.dbAdapter = new DBAdapter(context, this.config);
            this.dbAdapter.cleanupStaleEvents(DBAdapter.Table.EVENTS);
            this.dbAdapter.cleanupStaleEvents(DBAdapter.Table.PROFILE_EVENTS);
            this.dbAdapter.cleanupStaleEvents(DBAdapter.Table.PUSH_NOTIFICATION_VIEWED);
            this.dbAdapter.cleanUpPushNotifications();
        }
        return this.dbAdapter;
    }

    private void manifestAsyncValidation() {
        this.postAsyncSafely("Manifest Validation", new Runnable(){

            @Override
            public void run() {
                ManifestValidator.validate(CleverTapAPI.this.context, CleverTapAPI.this.deviceInfo, CleverTapAPI.this.pushProviders);
            }
        });
    }

    private SharedPreferences migrateARPToNewNameSpace(String newKey, String oldKey) {
        SharedPreferences oldPrefs = StorageHelper.getPreferences(this.context, oldKey);
        SharedPreferences newPrefs = StorageHelper.getPreferences(this.context, newKey);
        SharedPreferences.Editor editor = newPrefs.edit();
        Map all = oldPrefs.getAll();
        for (Map.Entry kv : all.entrySet()) {
            Object o = kv.getValue();
            if (o instanceof Number) {
                int update = ((Number)o).intValue();
                editor.putInt((String)kv.getKey(), update);
                continue;
            }
            if (o instanceof String) {
                if (((String)o).length() < 100) {
                    editor.putString((String)kv.getKey(), (String)o);
                    continue;
                }
                this.getConfigLogger().verbose(this.getAccountId(), "ARP update for key " + (String)kv.getKey() + " rejected (string value too long)");
                continue;
            }
            if (o instanceof Boolean) {
                editor.putBoolean((String)kv.getKey(), ((Boolean)o).booleanValue());
                continue;
            }
            this.getConfigLogger().verbose(this.getAccountId(), "ARP update for key " + (String)kv.getKey() + " rejected (invalid data type)");
        }
        this.getConfigLogger().verbose(this.getAccountId(), "Completed ARP update for namespace key: " + newKey + "");
        StorageHelper.persist(editor);
        oldPrefs.edit().clear().apply();
        return newPrefs;
    }

    private boolean needsHandshakeForDomain(EventGroup eventGroup) {
        String domain = this.getDomainFromPrefsOrMetadata(eventGroup);
        return domain == null || this.mResponseFailureCount > 5;
    }

    private void notifyDisplayUnitsLoaded(final ArrayList<CleverTapDisplayUnit> displayUnits) {
        if (displayUnits != null && !displayUnits.isEmpty()) {
            if (this.displayUnitListenerWeakReference != null && this.displayUnitListenerWeakReference.get() != null) {
                Utils.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (CleverTapAPI.this.displayUnitListenerWeakReference != null && CleverTapAPI.this.displayUnitListenerWeakReference.get() != null) {
                            ((DisplayUnitListener)CleverTapAPI.this.displayUnitListenerWeakReference.get()).onDisplayUnitsLoaded(displayUnits);
                        }
                    }
                });
            } else {
                this.getConfigLogger().verbose(this.getAccountId(), "DisplayUnit : No registered listener, failed to notify");
            }
        } else {
            this.getConfigLogger().verbose(this.getAccountId(), "DisplayUnit : No Display Units found");
        }
    }

    private void notifyUserProfileInitialized(String deviceID) {
        String string = deviceID = deviceID != null ? deviceID : this.getCleverTapID();
        if (deviceID == null) {
            return;
        }
        try {
            SyncListener sl = this.getSyncListener();
            if (sl != null) {
                sl.profileDidInitialize(deviceID);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void notifyUserProfileInitialized() {
        this.notifyUserProfileInitialized(this.deviceInfo.getDeviceID());
    }

    private void onProductConfigFailed() {
        if (this.isProductConfigRequested) {
            if (this.ctProductConfigController != null) {
                this.ctProductConfigController.onFetchFailed();
            }
            this.isProductConfigRequested = false;
        }
    }

    private void onTokenRefresh() {
        if (this.getConfig().isAnalyticsOnly()) {
            Logger.d(this.getAccountId(), "Instance is Analytics Only not processing device token");
            return;
        }
        this.pushProviders.refreshAllTokens();
    }

    private String optOutKey() {
        String guid = this.getCleverTapID();
        if (guid == null) {
            return null;
        }
        return "OptOut:" + guid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseDisplayUnits(JSONArray messages) {
        if (messages == null || messages.length() == 0) {
            this.getConfigLogger().verbose(this.getAccountId(), "DisplayUnit : Can't parse Display Units, jsonArray is either empty or null");
            return;
        }
        Object object = this.displayUnitControllerLock;
        synchronized (object) {
            if (this.mCTDisplayUnitController == null) {
                this.mCTDisplayUnitController = new CTDisplayUnitController();
            }
        }
        ArrayList<CleverTapDisplayUnit> displayUnits = this.mCTDisplayUnitController.updateDisplayUnits(messages);
        this.notifyDisplayUnitsLoaded(displayUnits);
    }

    private void parseFeatureFlags(JSONObject responseKV) throws JSONException {
        JSONArray kvArray = responseKV.getJSONArray("kv");
        if (kvArray != null && this.ctFeatureFlagsController != null) {
            this.ctFeatureFlagsController.updateFeatureFlags(responseKV);
        }
    }

    private void parseProductConfigs(JSONObject responseKV) throws JSONException {
        JSONArray kvArray = responseKV.getJSONArray("kv");
        if (kvArray != null && this.ctProductConfigController != null) {
            this.productConfig().onFetchSuccess(responseKV);
        } else {
            this.onProductConfigFailed();
        }
    }

    private Date parseTimeToDate(String time) {
        String inputFormat = "HH:mm";
        SimpleDateFormat inputParser = new SimpleDateFormat("HH:mm", Locale.US);
        try {
            return inputParser.parse(time);
        }
        catch (ParseException e) {
            return new Date(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performHandshakeForDomain(Context context, EventGroup eventGroup, Runnable handshakeSuccessCallback) {
        String endpoint = this.getEndpoint(true, eventGroup);
        if (endpoint == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "Unable to perform handshake, endpoint is null");
        }
        this.getConfigLogger().verbose(this.getAccountId(), "Performing handshake with " + endpoint);
        HttpsURLConnection conn = null;
        try {
            conn = this.buildHttpsURLConnection(endpoint);
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                this.getConfigLogger().verbose(this.getAccountId(), "Invalid HTTP status code received for handshake - " + responseCode);
                return;
            }
            this.getConfigLogger().verbose(this.getAccountId(), "Received success from handshake :)");
            if (this.processIncomingHeaders(context, conn)) {
                this.getConfigLogger().verbose(this.getAccountId(), "We are not muted");
                handshakeSuccessCallback.run();
            }
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Failed to perform handshake!", t);
        }
        finally {
            if (conn != null) {
                try {
                    conn.getInputStream().close();
                    conn.disconnect();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Nullable
    private Future<?> postAsyncSafely(String name, final Runnable runnable) {
        Future<?> future = null;
        try {
            boolean executeSync;
            boolean bl = executeSync = Thread.currentThread().getId() == this.EXECUTOR_THREAD_ID;
            if (executeSync) {
                runnable.run();
            } else {
                future = this.es.submit(new Runnable(){

                    @Override
                    public void run() {
                        CleverTapAPI.this.EXECUTOR_THREAD_ID = Thread.currentThread().getId();
                        try {
                            runnable.run();
                        }
                        catch (Throwable t) {
                            CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "Executor service: Failed to complete the scheduled task", t);
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Failed to submit task to the executor service", t);
        }
        return future;
    }

    private void prepareNotificationForDisplay(JSONObject jsonObject) {
        this.getConfigLogger().debug(this.getAccountId(), "Preparing In-App for display: " + jsonObject.toString());
        this.runOnNotificationQueue(new NotificationPrepareRunnable(this, jsonObject));
    }

    private void processCustomPushNotification(final Bundle extras) {
        this.postAsyncSafely("customHandlePushAmplification", new Runnable(){

            @Override
            public void run() {
                String notifMessage = extras.getString("nm");
                String string = notifMessage = notifMessage != null ? notifMessage : "";
                if (notifMessage.isEmpty()) {
                    CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "Push notification message is empty, not rendering");
                    CleverTapAPI.this.loadDBAdapter(CleverTapAPI.this.context).storeUninstallTimestamp();
                    String pingFreq = extras.getString("pf", "");
                    if (!TextUtils.isEmpty((CharSequence)pingFreq)) {
                        CleverTapAPI.this.updatePingFrequencyIfNeeded(CleverTapAPI.this.context, Integer.parseInt(pingFreq));
                    }
                } else {
                    String wzrk_pid = extras.getString("wzrk_pid");
                    String ttl = extras.getString("wzrk_ttl", (System.currentTimeMillis() + 345600000L) / 1000L + "");
                    long wzrk_ttl = Long.parseLong(ttl);
                    DBAdapter dbAdapter = CleverTapAPI.this.loadDBAdapter(CleverTapAPI.this.context);
                    CleverTapAPI.this.getConfigLogger().verbose("Storing Push Notification..." + wzrk_pid + " - with ttl - " + ttl);
                    dbAdapter.storePushNotificationId(wzrk_pid, wzrk_ttl);
                }
            }
        });
    }

    private void processDiscardedEventsList(JSONObject response) {
        if (!response.has("d_e")) {
            this.getConfigLogger().verbose(this.getAccountId(), "ARP doesn't contain the Discarded Events key");
            return;
        }
        try {
            ArrayList<String> discardedEventsList = new ArrayList<String>();
            JSONArray discardedEventsArray = response.getJSONArray("d_e");
            if (discardedEventsArray != null) {
                for (int i = 0; i < discardedEventsArray.length(); ++i) {
                    discardedEventsList.add(discardedEventsArray.getString(i));
                }
            }
            if (this.validator != null) {
                this.validator.setDiscardedEvents(discardedEventsList);
            } else {
                this.getConfigLogger().verbose(this.getAccountId(), "Validator object is NULL");
            }
        }
        catch (JSONException e) {
            this.getConfigLogger().verbose(this.getAccountId(), "Error parsing discarded events list" + e.getLocalizedMessage());
        }
    }

    private void processDisplayUnitsResponse(JSONObject response) {
        if (response == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "DisplayUnit : Can't parse Display Unit Response, JSON response object is null");
            return;
        }
        if (!response.has("adUnit_notifs")) {
            this.getConfigLogger().verbose(this.getAccountId(), "DisplayUnit : JSON object doesn't contain the Display Units key");
            return;
        }
        try {
            this.getConfigLogger().verbose(this.getAccountId(), "DisplayUnit : Processing Display Unit response");
            this.parseDisplayUnits(response.getJSONArray("adUnit_notifs"));
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "DisplayUnit : Failed to parse response", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(Context context, JSONObject event, int eventType) {
        Boolean bl = this.eventLock;
        synchronized (bl) {
            try {
                String type;
                int n = activityCount = activityCount == 0 ? 1 : activityCount;
                if (eventType == 1) {
                    type = "page";
                } else if (eventType == 2) {
                    type = "ping";
                    this.attachMeta(event, context);
                    if (event.has("bk")) {
                        this.isBgPing = true;
                        event.remove("bk");
                    }
                    if (this.isLocationForGeofence()) {
                        event.put("gf", true);
                        this.setLocationForGeofence(false);
                        event.put("gfSDKVersion", this.getGeofenceSDKVersion());
                        this.setGeofenceSDKVersion(0);
                    }
                } else {
                    type = eventType == 3 ? "profile" : (eventType == 5 ? "data" : "event");
                }
                String currentActivityName = this.getScreenName();
                if (currentActivityName != null) {
                    event.put("n", (Object)currentActivityName);
                }
                int session = this.getCurrentSession();
                event.put("s", session);
                event.put("pg", activityCount);
                event.put("type", (Object)type);
                event.put("ep", System.currentTimeMillis() / 1000L);
                event.put("f", this.isFirstSession());
                event.put("lsl", this.getLastSessionLength());
                this.attachPackageNameIfRequired(context, event);
                ValidationResult vr = this.validationResultStack.popValidationResult();
                if (vr != null) {
                    event.put("wzrk_error", (Object)CTJsonConverter.getErrorObject(vr));
                }
                this.getLocalDataStore().setDataSyncFlag(event);
                this.queueEventToDB(context, event, eventType);
                this.updateLocalStore(context, event, eventType);
                this.scheduleQueueFlush(context);
            }
            catch (Throwable e) {
                this.getConfigLogger().verbose(this.getAccountId(), "Failed to queue event: " + event.toString(), e);
            }
        }
    }

    private void processFeatureFlagsResponse(JSONObject response) {
        if (response == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "Feature Flag : Can't parse Feature Flags Response, JSON response object is null");
            return;
        }
        if (!response.has("ff_notifs")) {
            this.getConfigLogger().verbose(this.getAccountId(), "Feature Flag : JSON object doesn't contain the Feature Flags key");
            return;
        }
        try {
            this.getConfigLogger().verbose(this.getAccountId(), "Feature Flag : Processing Feature Flags response");
            this.parseFeatureFlags(response.getJSONObject("ff_notifs"));
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Feature Flag : Failed to parse response", t);
        }
    }

    private void processGeofenceResponse(JSONObject response) {
        if (response == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "Geofences : Can't parse Geofences Response, JSON response object is null");
            return;
        }
        if (!response.has("geofences")) {
            this.getConfigLogger().verbose(this.getAccountId(), "Geofences : JSON object doesn't contain the Geofences key");
            return;
        }
        try {
            if (this.geofenceCallback != null) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("geofences", (Object)response.getJSONArray("geofences"));
                this.getConfigLogger().verbose(this.getAccountId(), "Geofences : Processing Geofences response");
                this.geofenceCallback.handleGeoFences(jsonObject);
            } else {
                this.getConfigLogger().debug(this.getAccountId(), "Geofences : Geofence SDK has not been initialized to handle the response");
            }
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Geofences : Failed to handle Geofences response", t);
        }
    }

    private void processInAppResponse(JSONObject response, final Context context) {
        try {
            JSONArray inappNotifs;
            this.getConfigLogger().verbose(this.getAccountId(), "InApp: Processing response");
            if (!response.has("inapp_notifs")) {
                this.getConfigLogger().verbose(this.getAccountId(), "InApp: Response JSON object doesn't contain the inapp key, failing");
                return;
            }
            int perSession = 10;
            int perDay = 10;
            if (response.has("imc") && response.get("imc") instanceof Integer) {
                perSession = response.getInt("imc");
            }
            if (response.has("imp") && response.get("imp") instanceof Integer) {
                perDay = response.getInt("imp");
            }
            if (this.inAppFCManager != null) {
                Logger.v("Updating InAppFC Limits");
                this.inAppFCManager.updateLimits(context, perDay, perSession);
            }
            try {
                inappNotifs = response.getJSONArray("inapp_notifs");
            }
            catch (JSONException e) {
                this.getConfigLogger().debug(this.getAccountId(), "InApp: In-app key didn't contain a valid JSON array");
                return;
            }
            SharedPreferences prefs = StorageHelper.getPreferences(context);
            SharedPreferences.Editor editor = prefs.edit();
            try {
                JSONArray inappsFromPrefs = new JSONArray(StorageHelper.getStringFromPrefs(context, this.config, "inApp", "[]"));
                if (inappNotifs != null && inappNotifs.length() > 0) {
                    for (int i = 0; i < inappNotifs.length(); ++i) {
                        try {
                            JSONObject inappNotif = inappNotifs.getJSONObject(i);
                            inappsFromPrefs.put((Object)inappNotif);
                            continue;
                        }
                        catch (JSONException e) {
                            Logger.v("InAppManager: Malformed inapp notification");
                        }
                    }
                }
                editor.putString(StorageHelper.storageKeyWithSuffix(this.config, "inApp"), inappsFromPrefs.toString());
                StorageHelper.persist(editor);
            }
            catch (Throwable e) {
                this.getConfigLogger().verbose(this.getAccountId(), "InApp: Failed to parse the in-app notifications properly");
                this.getConfigLogger().verbose(this.getAccountId(), "InAppManager: Reason: " + e.getMessage(), e);
            }
            this.runOnNotificationQueue(new Runnable(){

                @Override
                public void run() {
                    CleverTapAPI.this._showNotificationIfAvailable(context);
                }
            });
        }
        catch (Throwable t) {
            Logger.v("InAppManager: Failed to parse response", t);
        }
    }

    private void processInboxResponse(JSONObject response) {
        if (this.getConfig().isAnalyticsOnly()) {
            this.getConfigLogger().verbose(this.getAccountId(), "CleverTap instance is configured to analytics only, not processing inbox messages");
            return;
        }
        this.getConfigLogger().verbose(this.getAccountId(), "Inbox: Processing response");
        if (!response.has("inbox_notifs")) {
            this.getConfigLogger().verbose(this.getAccountId(), "Inbox: Response JSON object doesn't contain the inbox key");
            return;
        }
        try {
            this._processInboxMessages(response.getJSONArray("inbox_notifs"));
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "InboxResponse: Failed to parse response", t);
        }
    }

    private void processIncomingExperiments(JSONObject response) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        try {
            JSONArray experimentsArray = response.getJSONArray("ab_exps");
            if (this.ctABTestController != null) {
                this.ctABTestController.updateExperiments(experimentsArray);
            }
        }
        catch (JSONException e) {
            this.getConfigLogger().debug(this.config.getAccountId(), "Error parsing AB Testing response " + e.getLocalizedMessage());
        }
    }

    private boolean processIncomingHeaders(Context context, HttpsURLConnection conn) {
        String muteCommand = conn.getHeaderField("X-WZRK-MUTE");
        if (muteCommand != null && muteCommand.trim().length() > 0) {
            if (muteCommand.equals("true")) {
                this.setMuted(context, true);
                return false;
            }
            this.setMuted(context, false);
        }
        String domainName = conn.getHeaderField("X-WZRK-RD");
        Logger.v("Getting domain from header - " + domainName);
        if (domainName == null || domainName.trim().length() == 0) {
            return true;
        }
        String spikyDomainName = conn.getHeaderField("X-WZRK-SPIKY-RD");
        Logger.v("Getting spiky domain from header - " + spikyDomainName);
        this.setMuted(context, false);
        this.setDomain(context, domainName);
        Logger.v("Setting spiky domain from header as -" + spikyDomainName);
        if (spikyDomainName == null) {
            this.setSpikyDomain(context, domainName);
        } else {
            this.setSpikyDomain(context, spikyDomainName);
        }
        return true;
    }

    private void processProductConfigResponse(JSONObject response) {
        if (response == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "Product Config : Can't parse Product Config Response, JSON response object is null");
            this.onProductConfigFailed();
            return;
        }
        if (!response.has("pc_notifs")) {
            this.getConfigLogger().verbose(this.getAccountId(), "Product Config : JSON object doesn't contain the Product Config key");
            this.onProductConfigFailed();
            return;
        }
        try {
            this.getConfigLogger().verbose(this.getAccountId(), "Product Config : Processing Product Config response");
            this.parseProductConfigs(response.getJSONObject("pc_notifs"));
        }
        catch (Throwable t) {
            this.onProductConfigFailed();
            this.getConfigLogger().verbose(this.getAccountId(), "Product Config : Failed to parse Product Config response", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPushNotificationViewedEvent(Context context, JSONObject event) {
        Boolean bl = this.eventLock;
        synchronized (bl) {
            try {
                int session = this.getCurrentSession();
                event.put("s", session);
                event.put("type", (Object)"event");
                event.put("ep", System.currentTimeMillis() / 1000L);
                ValidationResult vr = this.validationResultStack.popValidationResult();
                if (vr != null) {
                    event.put("wzrk_error", (Object)CTJsonConverter.getErrorObject(vr));
                }
                this.getConfigLogger().verbose(this.getAccountId(), "Pushing Notification Viewed event onto DB");
                this.queuePushNotificationViewedEventToDB(context, event);
                this.getConfigLogger().verbose(this.getAccountId(), "Pushing Notification Viewed event onto queue flush");
                this.schedulePushNotificationViewedQueueFlush(context);
            }
            catch (Throwable t) {
                this.getConfigLogger().verbose(this.getAccountId(), "Failed to queue notification viewed event: " + event.toString(), t);
            }
        }
    }

    private void processResponse(Context context, String responseStr) {
        if (responseStr == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "Problem processing queue response, response is null");
            return;
        }
        try {
            JSONObject response;
            block63: {
                block62: {
                    this.getConfigLogger().verbose(this.getAccountId(), "Trying to process response: " + responseStr);
                    response = new JSONObject(responseStr);
                    try {
                        if (!this.config.isAnalyticsOnly()) {
                            this.processInAppResponse(response, context);
                        }
                    }
                    catch (Throwable t) {
                        this.getConfigLogger().verbose(this.getAccountId(), "Failed to process in-app notifications from the response!", t);
                    }
                    try {
                        if (response.has("g")) {
                            String deviceID = response.getString("g");
                            this.deviceInfo.forceUpdateDeviceId(deviceID);
                            this.getConfigLogger().verbose(this.getAccountId(), "Got a new device ID: " + deviceID);
                        }
                    }
                    catch (Throwable t) {
                        this.getConfigLogger().verbose(this.getAccountId(), "Failed to update device ID!", t);
                    }
                    try {
                        this.getLocalDataStore().syncWithUpstream(context, response);
                    }
                    catch (Throwable t) {
                        this.getConfigLogger().verbose(this.getAccountId(), "Failed to sync local cache with upstream", t);
                    }
                    try {
                        JSONObject arp;
                        if (!response.has("arp") || (arp = (JSONObject)response.get("arp")).length() <= 0) break block62;
                        if (this.ctProductConfigController != null) {
                            this.ctProductConfigController.setArpValue(arp);
                        }
                        try {
                            this.processDiscardedEventsList(arp);
                        }
                        catch (Throwable t) {
                            this.getConfigLogger().verbose("Error handling discarded events response: " + t.getLocalizedMessage());
                        }
                        this.handleARPUpdate(context, arp);
                    }
                    catch (Throwable t) {
                        this.getConfigLogger().verbose(this.getAccountId(), "Failed to process ARP", t);
                    }
                }
                try {
                    if (response.has("_i")) {
                        long i = response.getLong("_i");
                        this.setI(context, i);
                    }
                }
                catch (Throwable i) {
                    // empty catch block
                }
                try {
                    if (response.has("_j")) {
                        long j = response.getLong("_j");
                        this.setJ(context, j);
                    }
                }
                catch (Throwable j) {
                    // empty catch block
                }
                try {
                    JSONArray console;
                    if (response.has("console") && (console = (JSONArray)response.get("console")).length() > 0) {
                        for (int i = 0; i < console.length(); ++i) {
                            this.getConfigLogger().debug(this.getAccountId(), console.get(i).toString());
                        }
                    }
                }
                catch (Throwable console) {
                    // empty catch block
                }
                try {
                    int debugLevel;
                    if (response.has("dbg_lvl") && (debugLevel = response.getInt("dbg_lvl")) >= 0) {
                        CleverTapAPI.setDebugLevel(debugLevel);
                        this.getConfigLogger().verbose(this.getAccountId(), "Set debug level to " + debugLevel + " for this session (set by upstream)");
                    }
                }
                catch (Throwable debugLevel) {
                    // empty catch block
                }
                try {
                    if (this.inAppFCManager != null) {
                        this.inAppFCManager.processResponse(context, response);
                    }
                }
                catch (Throwable debugLevel) {
                    // empty catch block
                }
                if (!this.getConfig().isAnalyticsOnly()) {
                    try {
                        this.getConfigLogger().verbose(this.getAccountId(), "Processing inbox messages...");
                        this.processInboxResponse(response);
                    }
                    catch (Throwable t) {
                        this.getConfigLogger().verbose("Notification inbox exception: " + t.getLocalizedMessage());
                    }
                }
                if (!this.getConfig().isAnalyticsOnly()) {
                    try {
                        if (!response.has("pushamp_notifs")) break block63;
                        this.getConfigLogger().verbose(this.getAccountId(), "Processing pushamp messages...");
                        JSONObject pushAmpObject = response.getJSONObject("pushamp_notifs");
                        JSONArray pushNotifications = pushAmpObject.getJSONArray("list");
                        if (pushNotifications.length() > 0) {
                            this.getConfigLogger().verbose(this.getAccountId(), "Handling Push payload locally");
                            this.handlePushNotificationsInResponse(pushNotifications);
                        }
                        if (pushAmpObject.has("pf")) {
                            try {
                                int frequency = pushAmpObject.getInt("pf");
                                this.updatePingFrequencyIfNeeded(context, frequency);
                            }
                            catch (Throwable t) {
                                this.getConfigLogger().verbose("Error handling ping frequency in response : " + t.getMessage());
                            }
                        }
                        if (pushAmpObject.has("ack")) {
                            boolean ack = pushAmpObject.getBoolean("ack");
                            this.getConfigLogger().verbose("Received ACK -" + ack);
                            if (ack) {
                                JSONArray rtlArray = CTJsonConverter.getRenderedTargetList(this.dbAdapter);
                                String[] rtlStringArray = new String[]{};
                                if (rtlArray != null) {
                                    rtlStringArray = new String[rtlArray.length()];
                                }
                                for (int i = 0; i < rtlStringArray.length; ++i) {
                                    rtlStringArray[i] = rtlArray.getString(i);
                                }
                                this.getConfigLogger().verbose("Updating RTL values...");
                                this.dbAdapter.updatePushNotificationIds(rtlStringArray);
                            }
                        }
                    }
                    catch (Throwable pushAmpObject) {
                        // empty catch block
                    }
                }
            }
            if (!this.getConfig().isAnalyticsOnly()) {
                try {
                    if (response.has("ab_exps")) {
                        this.getConfigLogger().verbose(this.getAccountId(), "Processing ABTest experiments...");
                        this.processIncomingExperiments(response);
                    }
                }
                catch (Throwable t) {
                    this.getConfigLogger().verbose("Error handling AB Testing response : " + t.getMessage());
                }
            }
            if (!this.getConfig().isAnalyticsOnly()) {
                try {
                    this.getConfigLogger().verbose(this.getAccountId(), "Processing Display Unit items...");
                    this.processDisplayUnitsResponse(response);
                }
                catch (Throwable t) {
                    this.getConfigLogger().verbose("Error handling Display Unit response: " + t.getLocalizedMessage());
                }
            }
            if (!this.getConfig().isAnalyticsOnly()) {
                try {
                    this.getConfigLogger().verbose(this.getAccountId(), "Processing Feature Flags response...");
                    this.processFeatureFlagsResponse(response);
                }
                catch (Throwable t) {
                    this.getConfigLogger().verbose("Error handling Feature Flags response: " + t.getLocalizedMessage());
                }
            }
            if (!this.getConfig().isAnalyticsOnly()) {
                try {
                    this.getConfigLogger().verbose(this.getAccountId(), "Processing Product Config response...");
                    this.processProductConfigResponse(response);
                }
                catch (Throwable t) {
                    this.getConfigLogger().verbose("Error handling Product Config response: " + t.getLocalizedMessage());
                }
            }
            if (!this.getConfig().isAnalyticsOnly()) {
                try {
                    this.getConfigLogger().verbose(this.getAccountId(), "Processing GeoFences response...");
                    this.processGeofenceResponse(response);
                }
                catch (Throwable t) {
                    this.getConfigLogger().verbose("Error handling GeoFences response: " + t.getLocalizedMessage());
                }
            }
        }
        catch (Throwable t) {
            ++this.mResponseFailureCount;
            this.getConfigLogger().verbose(this.getAccountId(), "Problem process send queue response", t);
        }
    }

    private void pushAmazonRegistrationId(String token, boolean register) {
        this.pushProviders.handleToken(token, PushConstants.PushType.ADM, register);
    }

    private void pushAppLaunchedEvent() {
        if (this.isAppLaunchReportingDisabled()) {
            this.setAppLaunchPushed(true);
            this.getConfigLogger().debug(this.getAccountId(), "App Launched Events disabled in the Android Manifest file");
            return;
        }
        if (this.isAppLaunchPushed()) {
            this.getConfigLogger().verbose(this.getAccountId(), "App Launched has already been triggered. Will not trigger it ");
            return;
        }
        this.getConfigLogger().verbose(this.getAccountId(), "Firing App Launched event");
        this.setAppLaunchPushed(true);
        JSONObject event = new JSONObject();
        try {
            event.put("evtName", (Object)"App Launched");
            event.put("evtData", (Object)this.getAppLaunchedFields());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.queueEvent(this.context, event, 4);
    }

    private void pushBasicProfile(JSONObject baseProfile) {
        try {
            String guid = this.getCleverTapID();
            JSONObject profileEvent = new JSONObject();
            if (baseProfile != null && baseProfile.length() > 0) {
                Iterator i = baseProfile.keys();
                IdentityRepo iProfileHandler = IdentityRepoFactory.getRepo(this);
                LoginInfoProvider loginInfoProvider = new LoginInfoProvider(this);
                while (i.hasNext()) {
                    String next = i.next().toString();
                    Object value = null;
                    try {
                        value = baseProfile.getJSONObject(next);
                    }
                    catch (Throwable t) {
                        try {
                            value = baseProfile.get(next);
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                    if (value == null) continue;
                    profileEvent.put(next, value);
                    boolean isProfileKey = iProfileHandler.hasIdentity(next);
                    if (!isProfileKey) continue;
                    try {
                        loginInfoProvider.cacheGUIDForIdentifier(guid, next, value.toString());
                    }
                    catch (Throwable throwable) {}
                }
            }
            try {
                String cc;
                String carrier = this.deviceInfo.getCarrier();
                if (carrier != null && !carrier.equals("")) {
                    profileEvent.put("Carrier", (Object)carrier);
                }
                if ((cc = this.deviceInfo.getCountryCode()) != null && !cc.equals("")) {
                    profileEvent.put("cc", (Object)cc);
                }
                profileEvent.put("tz", (Object)TimeZone.getDefault().getID());
                JSONObject event = new JSONObject();
                event.put("profile", (Object)profileEvent);
                this.queueEvent(this.context, event, 3);
            }
            catch (JSONException e) {
                this.getConfigLogger().verbose(this.getAccountId(), "FATAL: Creating basic profile update event failed!");
            }
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Basic profile sync", t);
        }
    }

    private synchronized void pushDeepLink(Uri uri, boolean install) {
        if (uri == null) {
            return;
        }
        try {
            JSONObject referrer = UriHelper.getUrchinFromUri(uri);
            if (referrer.has("us")) {
                this.setSource(referrer.get("us").toString());
            }
            if (referrer.has("um")) {
                this.setMedium(referrer.get("um").toString());
            }
            if (referrer.has("uc")) {
                this.setCampaign(referrer.get("uc").toString());
            }
            referrer.put("referrer", (Object)uri.toString());
            if (install) {
                referrer.put("install", true);
            }
            this.recordPageEventWithExtras(referrer);
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Failed to push deep link", t);
        }
    }

    private void pushInitialEventsAsync() {
        this.postAsyncSafely("CleverTapAPI#pushInitialEventsAsync", new Runnable(){

            @Override
            public void run() {
                try {
                    CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "Queuing daily events");
                    CleverTapAPI.this.pushBasicProfile(null);
                }
                catch (Throwable t) {
                    CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "Daily profile sync failed", t);
                }
            }
        });
    }

    private Future<?> queueEvent(final Context context, final JSONObject event, final int eventType) {
        return this.postAsyncSafely("queueEvent", new Runnable(){

            @Override
            public void run() {
                if (CleverTapAPI.this.shouldDropEvent(event, eventType)) {
                    return;
                }
                if (CleverTapAPI.this.shouldDeferProcessingEvent(event, eventType)) {
                    CleverTapAPI.this.getConfigLogger().debug(CleverTapAPI.this.getAccountId(), "App Launched not yet processed, re-queuing event " + event + "after 2s");
                    CleverTapAPI.this.getHandlerUsingMainLooper().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            CleverTapAPI.this.postAsyncSafely("queueEventWithDelay", new Runnable(){

                                @Override
                                public void run() {
                                    CleverTapAPI.this.lazyCreateSession(context);
                                    CleverTapAPI.this.addToQueue(context, event, eventType);
                                }
                            });
                        }
                    }, 2000L);
                } else if (eventType == 7) {
                    CleverTapAPI.this.addToQueue(context, event, eventType);
                } else {
                    CleverTapAPI.this.lazyCreateSession(context);
                    CleverTapAPI.this.addToQueue(context, event, eventType);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueEventInternal(Context context, JSONObject event, DBAdapter.Table table) {
        Boolean bl = this.eventLock;
        synchronized (bl) {
            DBAdapter adapter = this.loadDBAdapter(context);
            int returnCode = adapter.storeObject(event, table);
            if (returnCode > 0) {
                this.getConfigLogger().debug(this.getAccountId(), "Queued event: " + event.toString());
                this.getConfigLogger().verbose(this.getAccountId(), "Queued event to DB table " + (Object)((Object)table) + ": " + event.toString());
            }
        }
    }

    private void queueEventToDB(Context context, JSONObject event, int type) {
        DBAdapter.Table table = type == 3 ? DBAdapter.Table.PROFILE_EVENTS : DBAdapter.Table.EVENTS;
        this.queueEventInternal(context, event, table);
    }

    private void queuePushNotificationViewedEventToDB(Context context, JSONObject event) {
        this.queueEventInternal(context, event, DBAdapter.Table.PUSH_NOTIFICATION_VIEWED);
    }

    private Future<?> raiseEventForGeofences(String eventName, JSONObject geofenceProperties) {
        Future<?> future = null;
        JSONObject event = new JSONObject();
        try {
            event.put("evtName", (Object)eventName);
            event.put("evtData", (Object)geofenceProperties);
            Location location = new Location("");
            location.setLatitude(geofenceProperties.getDouble("triggered_lat"));
            location.setLongitude(geofenceProperties.getDouble("triggered_lng"));
            geofenceProperties.remove("triggered_lat");
            geofenceProperties.remove("triggered_lng");
            this.locationFromUser = location;
            future = this.queueEvent(this.context, event, 4);
        }
        catch (JSONException e) {
            this.getConfigLogger().debug(this.getAccountId(), "Geofences : JSON Exception when raising GeoFence event " + eventName + " - " + e.getLocalizedMessage());
        }
        return future;
    }

    private void recordDeviceIDErrors() {
        for (ValidationResult validationResult : this.deviceInfo.getValidationResults()) {
            this.validationResultStack.pushValidationResult(validationResult);
        }
    }

    private void recordPageEventWithExtras(JSONObject extras) {
        try {
            JSONObject jsonObject = new JSONObject();
            if (extras != null && extras.length() > 0) {
                Iterator keys = extras.keys();
                while (keys.hasNext()) {
                    try {
                        String key = (String)keys.next();
                        jsonObject.put(key, (Object)extras.getString(key));
                    }
                    catch (ClassCastException classCastException) {}
                }
            }
            this.queueEvent(this.context, jsonObject, 1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void resetABTesting() {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        if (!this.config.isAnalyticsOnly() && !this.config.isABTestingEnabled()) {
            this.getConfigLogger().debug(this.config.getAccountId(), "AB Testing is not enabled for this instance");
            return;
        }
        if (this.ctABTestController != null) {
            this.ctABTestController.resetWithGuid(this.getCleverTapID());
        }
    }

    private void resetAlarmScheduler(Context context) {
        if (this.getPingFrequency(context) <= 0) {
            this.stopAlarmScheduler(context);
        } else {
            this.stopAlarmScheduler(context);
            this.createAlarmScheduler(context);
        }
    }

    private void resetDisplayUnits() {
        if (this.mCTDisplayUnitController != null) {
            this.mCTDisplayUnitController.reset();
        } else {
            this.getConfigLogger().verbose(this.getAccountId(), "DisplayUnit : Can't reset Display Units, DisplayUnitcontroller is null");
        }
    }

    private void resetFeatureFlags() {
        if (this.ctFeatureFlagsController != null && this.ctFeatureFlagsController.isInitialized()) {
            this.ctFeatureFlagsController.resetWithGuid(this.getCleverTapID());
            this.ctFeatureFlagsController.fetchFeatureFlags();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetInbox() {
        Object object = this.inboxControllerLock;
        synchronized (object) {
            this.ctInboxController = null;
        }
        this._initializeInbox();
    }

    private void resetProductConfigs() {
        if (this.config.isAnalyticsOnly()) {
            this.getConfigLogger().debug(this.config.getAccountId(), "Product Config is not enabled for this instance");
            return;
        }
        if (this.ctProductConfigController != null) {
            this.ctProductConfigController.resetSettings();
        }
        this.ctProductConfigController = new CTProductConfigController(this.context, this.getCleverTapID(), this.config, this);
        this.getConfigLogger().verbose(this.config.getAccountId(), "Product Config reset");
    }

    private void runInstanceJobWork(final Context context, final JobParameters parameters) {
        this.postAsyncSafely("runningJobService", new Runnable(){

            @Override
            public void run() {
                Date endTime;
                if (CleverTapAPI.this.pushProviders.isNotificationSupported()) {
                    Logger.v(CleverTapAPI.this.getAccountId(), "Token is not present, not running the Job");
                    return;
                }
                Calendar now = Calendar.getInstance();
                int hour = now.get(11);
                int minute = now.get(12);
                Date currentTime = CleverTapAPI.this.parseTimeToDate(hour + ":" + minute);
                Date startTime = CleverTapAPI.this.parseTimeToDate("22:00");
                if (CleverTapAPI.this.isTimeBetweenDNDTime(startTime, endTime = CleverTapAPI.this.parseTimeToDate("06:00"), currentTime)) {
                    Logger.v(CleverTapAPI.this.getAccountId(), "Job Service won't run in default DND hours");
                    return;
                }
                long lastTS = CleverTapAPI.this.loadDBAdapter(context).getLastUninstallTimestamp();
                if (lastTS == 0L || lastTS > System.currentTimeMillis() - 86400000L) {
                    try {
                        JSONObject eventObject = new JSONObject();
                        eventObject.put("bk", 1);
                        CleverTapAPI.this.queueEvent(context, eventObject, 2);
                        if (parameters == null) {
                            int pingFrequency = CleverTapAPI.this.getPingFrequency(context);
                            AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
                            Intent cancelIntent = new Intent("com.clevertap.BG_EVENT");
                            cancelIntent.setPackage(context.getPackageName());
                            PendingIntent alarmPendingIntent = PendingIntent.getService((Context)context, (int)CleverTapAPI.this.getAccountId().hashCode(), (Intent)cancelIntent, (int)0x8000000);
                            if (alarmManager != null) {
                                alarmManager.cancel(alarmPendingIntent);
                            }
                            Intent alarmIntent = new Intent("com.clevertap.BG_EVENT");
                            alarmIntent.setPackage(context.getPackageName());
                            PendingIntent alarmServicePendingIntent = PendingIntent.getService((Context)context, (int)CleverTapAPI.this.getAccountId().hashCode(), (Intent)alarmIntent, (int)0x8000000);
                            if (alarmManager != null && pingFrequency != -1) {
                                alarmManager.setInexactRepeating(2, SystemClock.elapsedRealtime() + (long)pingFrequency * 60000L, 60000L * (long)pingFrequency, alarmServicePendingIntent);
                            }
                        }
                    }
                    catch (JSONException e) {
                        Logger.v("Unable to raise background Ping event");
                    }
                }
            }
        });
    }

    private void runOnNotificationQueue(final Runnable runnable) {
        try {
            boolean executeSync;
            boolean bl = executeSync = Thread.currentThread().getId() == this.NOTIFICATION_THREAD_ID;
            if (executeSync) {
                runnable.run();
            } else {
                this.ns.submit(new Runnable(){

                    @Override
                    public void run() {
                        CleverTapAPI.this.NOTIFICATION_THREAD_ID = Thread.currentThread().getId();
                        try {
                            runnable.run();
                        }
                        catch (Throwable t) {
                            CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "Notification executor service: Failed to complete the scheduled task", t);
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Failed to submit task to the notification executor service", t);
        }
    }

    private void schedulePushNotificationViewedQueueFlush(final Context context) {
        if (this.pushNotificationViewedRunnable == null) {
            this.pushNotificationViewedRunnable = new Runnable(){

                @Override
                public void run() {
                    CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "Pushing Notification Viewed event onto queue flush async");
                    CleverTapAPI.this.flushQueueAsync(context, EventGroup.PUSH_NOTIFICATION_VIEWED);
                }
            };
        }
        this.getHandlerUsingMainLooper().removeCallbacks(this.pushNotificationViewedRunnable);
        this.getHandlerUsingMainLooper().post(this.pushNotificationViewedRunnable);
    }

    private void scheduleQueueFlush(final Context context) {
        if (this.commsRunnable == null) {
            this.commsRunnable = new Runnable(){

                @Override
                public void run() {
                    CleverTapAPI.this.flushQueueAsync(context, EventGroup.REGULAR);
                    CleverTapAPI.this.flushQueueAsync(context, EventGroup.PUSH_NOTIFICATION_VIEWED);
                }
            };
        }
        this.getHandlerUsingMainLooper().removeCallbacks(this.commsRunnable);
        this.getHandlerUsingMainLooper().postDelayed(this.commsRunnable, (long)this.getDelayFrequency());
        this.getConfigLogger().verbose(this.getAccountId(), "Scheduling delayed queue flush on main event loop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean sendQueue(Context context, EventGroup eventGroup, JSONArray queue) {
        boolean bl;
        URLConnection conn;
        block32: {
            block30: {
                boolean bl2;
                block31: {
                    String req;
                    String endpoint;
                    block28: {
                        boolean bl3;
                        block29: {
                            block26: {
                                boolean bl4;
                                block27: {
                                    if (queue == null || queue.length() <= 0) {
                                        return false;
                                    }
                                    if (this.getCleverTapID() == null) {
                                        this.getConfigLogger().debug(this.getAccountId(), "CleverTap Id not finalized, unable to send queue");
                                        return false;
                                    }
                                    conn = null;
                                    endpoint = this.getEndpoint(false, eventGroup);
                                    if (endpoint != null) break block26;
                                    this.getConfigLogger().debug(this.getAccountId(), "Problem configuring queue endpoint, unable to send queue");
                                    bl4 = false;
                                    if (conn == null) break block27;
                                    try {
                                        conn.getInputStream().close();
                                        ((HttpURLConnection)conn).disconnect();
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                                return bl4;
                            }
                            conn = this.buildHttpsURLConnection(endpoint);
                            req = this.insertHeader(context, queue);
                            if (req != null) break block28;
                            this.getConfigLogger().debug(this.getAccountId(), "Problem configuring queue request, unable to send queue");
                            bl3 = false;
                            if (conn == null) break block29;
                            try {
                                conn.getInputStream().close();
                                ((HttpURLConnection)conn).disconnect();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        return bl3;
                    }
                    this.getConfigLogger().debug(this.getAccountId(), "Send queue contains " + queue.length() + " items: " + req);
                    this.getConfigLogger().debug(this.getAccountId(), "Sending queue to: " + endpoint);
                    conn.setDoOutput(true);
                    conn.getOutputStream().write(req.getBytes("UTF-8"));
                    int responseCode = ((HttpURLConnection)conn).getResponseCode();
                    if (responseCode != 200) {
                        throw new IOException("Response code is not 200. It is " + responseCode);
                    }
                    String newDomain = conn.getHeaderField("X-WZRK-RD");
                    if (newDomain == null || newDomain.trim().length() <= 0 || !this.hasDomainChanged(newDomain)) break block30;
                    this.setDomain(context, newDomain);
                    this.getConfigLogger().debug(this.getAccountId(), "The domain has changed to " + newDomain + ". The request will be retried shortly.");
                    bl2 = false;
                    if (conn == null) break block31;
                    try {
                        conn.getInputStream().close();
                        ((HttpURLConnection)conn).disconnect();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            if (this.processIncomingHeaders(context, (HttpsURLConnection)conn)) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                String body = sb.toString();
                this.processResponse(context, body);
            }
            this.setLastRequestTimestamp(context, this.currentRequestTimestamp);
            this.setFirstRequestTimestampIfNeeded(context, this.currentRequestTimestamp);
            this.getConfigLogger().debug(this.getAccountId(), "Queue sent successfully");
            this.mResponseFailureCount = 0;
            this.networkRetryCount = 0;
            bl = true;
            if (conn == null) break block32;
            try {
                conn.getInputStream().close();
                ((HttpURLConnection)conn).disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return bl;
        catch (Throwable e) {
            try {
                this.getConfigLogger().debug(this.getAccountId(), "An exception occurred while sending the queue, will retry: " + e.getLocalizedMessage());
                ++this.mResponseFailureCount;
                ++this.networkRetryCount;
                this.scheduleQueueFlush(context);
                boolean bl5 = false;
                return bl5;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.getInputStream().close();
                        ((HttpURLConnection)conn).disconnect();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    private void setCurrentUserOptOutStateFromStorage() {
        String key = this.optOutKey();
        if (key == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "Unable to set current user OptOut state from storage: storage key is null");
            return;
        }
        boolean storedOptOut = StorageHelper.getBooleanFromPrefs(this.context, this.config, key);
        this.setCurrentUserOptedOut(storedOptOut);
        this.getConfigLogger().verbose(this.getAccountId(), "Set current user OptOut state from storage to: " + storedOptOut + " for key: " + key);
    }

    private void setDeviceNetworkInfoReportingFromStorage() {
        boolean enabled = StorageHelper.getBooleanFromPrefs(this.context, this.config, "NetworkInfo");
        this.getConfigLogger().verbose(this.getAccountId(), "Setting device network info reporting state from storage to " + enabled);
        this.enableNetworkInfoReporting = enabled;
    }

    private void setDomain(Context context, String domainName) {
        this.getConfigLogger().verbose(this.getAccountId(), "Setting domain to " + domainName);
        StorageHelper.putString(context, StorageHelper.storageKeyWithSuffix(this.config, "comms_dmn"), domainName);
    }

    private void setFirstRequestTimestampIfNeeded(Context context, int ts) {
        if (this.getFirstRequestTimestamp() > 0) {
            return;
        }
        StorageHelper.putInt(context, StorageHelper.storageKeyWithSuffix(this.config, "comms_first_ts"), ts);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private void setI(Context context, long i) {
        SharedPreferences prefs = StorageHelper.getPreferences(context, "IJ");
        SharedPreferences.Editor editor = prefs.edit();
        editor.putLong(StorageHelper.storageKeyWithSuffix(this.config, "comms_i"), i);
        StorageHelper.persist(editor);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private void setJ(Context context, long j) {
        SharedPreferences prefs = StorageHelper.getPreferences(context, "IJ");
        SharedPreferences.Editor editor = prefs.edit();
        editor.putLong(StorageHelper.storageKeyWithSuffix(this.config, "comms_j"), j);
        StorageHelper.persist(editor);
    }

    private void setLastRequestTimestamp(Context context, int ts) {
        StorageHelper.putInt(context, StorageHelper.storageKeyWithSuffix(this.config, "comms_last_ts"), ts);
    }

    private void setLastVisitTime() {
        EventDetail ed = this.getLocalDataStore().getEventDetail("App Launched");
        this.lastVisitTime = ed == null ? -1 : ed.getLastTime();
    }

    private void setMuted(final Context context, boolean mute) {
        if (mute) {
            int now = (int)(System.currentTimeMillis() / 1000L);
            StorageHelper.putInt(context, StorageHelper.storageKeyWithSuffix(this.config, "comms_mtd"), now);
            this.setDomain(context, null);
            this.postAsyncSafely("CommsManager#setMuted", new Runnable(){

                @Override
                public void run() {
                    CleverTapAPI.this.clearQueues(context);
                }
            });
        } else {
            StorageHelper.putInt(context, StorageHelper.storageKeyWithSuffix(this.config, "comms_mtd"), 0);
        }
    }

    private void setPingFrequency(Context context, int pingFrequency) {
        StorageHelper.putInt(context, "pf", pingFrequency);
    }

    private void setSpikyDomain(Context context, String spikyDomainName) {
        this.getConfigLogger().verbose(this.getAccountId(), "Setting spiky domain to " + spikyDomainName);
        StorageHelper.putString(context, StorageHelper.storageKeyWithSuffix(this.config, "comms_dmn_spiky"), spikyDomainName);
    }

    private boolean shouldDeferProcessingEvent(JSONObject event, int eventType) {
        if (this.getConfig().isCreatedPostAppLaunch()) {
            return false;
        }
        if (event.has("evtName")) {
            try {
                if (Arrays.asList(Constants.SYSTEM_EVENTS).contains(event.getString("evtName"))) {
                    return false;
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return eventType == 4 && !this.isAppLaunchPushed();
    }

    private boolean shouldDropEvent(JSONObject event, int eventType) {
        if (eventType == 7) {
            return false;
        }
        if (this.isCurrentUserOptedOut()) {
            String eventString = event == null ? "null" : event.toString();
            this.getConfigLogger().debug(this.getAccountId(), "Current user is opted out dropping event: " + eventString);
            return true;
        }
        if (this.isMuted()) {
            this.getConfigLogger().verbose(this.getAccountId(), "CleverTap is muted, dropping event - " + event.toString());
            return true;
        }
        return false;
    }

    private void showInAppNotificationIfAny() {
        if (!this.config.isAnalyticsOnly()) {
            this.runOnNotificationQueue(new Runnable(){

                @Override
                public void run() {
                    CleverTapAPI.this._showNotificationIfAvailable(CleverTapAPI.this.context);
                }
            });
        }
    }

    private void showNotificationIfAvailable(final Context context) {
        if (!this.config.isAnalyticsOnly()) {
            this.runOnNotificationQueue(new Runnable(){

                @Override
                public void run() {
                    CleverTapAPI.this._showNotificationIfAvailable(context);
                }
            });
        }
    }

    private void stopAlarmScheduler(Context context) {
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        Intent cancelIntent = new Intent("com.clevertap.BG_EVENT");
        cancelIntent.setPackage(context.getPackageName());
        PendingIntent alarmPendingIntent = PendingIntent.getService((Context)context, (int)this.getAccountId().hashCode(), (Intent)cancelIntent, (int)0x8000000);
        if (alarmManager != null && alarmPendingIntent != null) {
            alarmManager.cancel(alarmPendingIntent);
        }
    }

    private void triggerNotification(Context context, Bundle extras, String notifMessage, String notifTitle, int notificationId) {
        NotificationCompat.Builder nb;
        int priorityInt;
        int smallIcon;
        NotificationCompat.BigTextStyle style;
        PendingIntent pIntent;
        String icoPath;
        boolean requiresChannelId;
        String channelId;
        NotificationManager notificationManager;
        block75: {
            block74: {
                notificationManager = (NotificationManager)context.getSystemService("notification");
                if (notificationManager == null) {
                    String notificationManagerError = "Unable to render notification, Notification Manager is null.";
                    this.getConfigLogger().debug(this.getAccountId(), notificationManagerError);
                    return;
                }
                channelId = extras.getString("wzrk_cid", "");
                boolean bl = requiresChannelId = Build.VERSION.SDK_INT >= 26;
                if (Build.VERSION.SDK_INT >= 26) {
                    int messageCode = -1;
                    String value = "";
                    if (channelId.isEmpty()) {
                        messageCode = 8;
                        value = extras.toString();
                    } else if (notificationManager.getNotificationChannel(channelId) == null) {
                        messageCode = 9;
                        value = channelId;
                    }
                    if (messageCode != -1) {
                        ValidationResult channelIdError = ValidationResultFactory.create(512, messageCode, value);
                        this.getConfigLogger().debug(this.getAccountId(), channelIdError.getErrorDesc());
                        this.validationResultStack.pushValidationResult(channelIdError);
                        return;
                    }
                }
                icoPath = extras.getString("ico");
                Intent launchIntent = new Intent(context, CTPushNotificationReceiver.class);
                launchIntent.putExtras(extras);
                launchIntent.removeExtra("wzrk_acts");
                pIntent = PendingIntent.getBroadcast((Context)context, (int)((int)System.currentTimeMillis()), (Intent)launchIntent, (int)0x8000000);
                String bigPictureUrl = extras.getString("wzrk_bp");
                if (bigPictureUrl != null && bigPictureUrl.startsWith("http")) {
                    try {
                        Bitmap bpMap = Utils.getNotificationBitmap(bigPictureUrl, false, context);
                        if (bpMap == null) {
                            throw new Exception("Failed to fetch big picture!");
                        }
                        if (extras.containsKey("wzrk_nms")) {
                            String summaryText = extras.getString("wzrk_nms");
                            style = new NotificationCompat.BigPictureStyle().setSummaryText((CharSequence)summaryText).bigPicture(bpMap);
                            break block74;
                        }
                        style = new NotificationCompat.BigPictureStyle().setSummaryText((CharSequence)notifMessage).bigPicture(bpMap);
                    }
                    catch (Throwable t) {
                        style = new NotificationCompat.BigTextStyle().bigText((CharSequence)notifMessage);
                        this.getConfigLogger().verbose(this.getAccountId(), "Falling back to big text notification, couldn't fetch big picture", t);
                    }
                } else {
                    style = new NotificationCompat.BigTextStyle().bigText((CharSequence)notifMessage);
                }
            }
            try {
                String x = ManifestInfo.getInstance(context).getNotificationIcon();
                if (x == null) {
                    throw new IllegalArgumentException();
                }
                smallIcon = context.getResources().getIdentifier(x, "drawable", context.getPackageName());
                if (smallIcon == 0) {
                    throw new IllegalArgumentException();
                }
            }
            catch (Throwable t) {
                smallIcon = DeviceInfo.getAppIconAsIntId(context);
            }
            priorityInt = 0;
            String priority = extras.getString("pr");
            if (priority != null) {
                if (priority.equals("high")) {
                    priorityInt = 1;
                }
                if (priority.equals("max")) {
                    priorityInt = 2;
                }
            }
            if (notificationId == -1000) {
                try {
                    Object collapse_key = extras.get("wzrk_ck");
                    if (collapse_key == null) break block75;
                    if (collapse_key instanceof Number) {
                        notificationId = ((Number)collapse_key).intValue();
                        break block75;
                    }
                    if (!(collapse_key instanceof String)) break block75;
                    try {
                        notificationId = Integer.parseInt(collapse_key.toString());
                        this.getConfigLogger().debug(this.getAccountId(), "Converting collapse_key: " + collapse_key + " to notificationId int: " + notificationId);
                    }
                    catch (NumberFormatException e) {
                        notificationId = collapse_key.toString().hashCode();
                        this.getConfigLogger().debug(this.getAccountId(), "Converting collapse_key: " + collapse_key + " to notificationId int: " + notificationId);
                    }
                }
                catch (NumberFormatException collapse_key) {}
            } else {
                this.getConfigLogger().debug(this.getAccountId(), "Have user provided notificationId: " + notificationId + " won't use collapse_key (if any) as basis for notificationId");
            }
        }
        if (notificationId == -1000) {
            notificationId = (int)(Math.random() * 100.0);
            this.getConfigLogger().debug(this.getAccountId(), "Setting random notificationId: " + notificationId);
        }
        if (requiresChannelId) {
            String badgeCountParam;
            nb = new NotificationCompat.Builder(context, channelId);
            String badgeIconParam = extras.getString("wzrk_bi", null);
            if (badgeIconParam != null) {
                try {
                    int badgeIconType = Integer.parseInt(badgeIconParam);
                    if (badgeIconType >= 0) {
                        nb.setBadgeIconType(badgeIconType);
                    }
                }
                catch (Throwable badgeIconType) {
                    // empty catch block
                }
            }
            if ((badgeCountParam = extras.getString("wzrk_bc", null)) != null) {
                try {
                    int badgeCount = Integer.parseInt(badgeCountParam);
                    if (badgeCount >= 0) {
                        nb.setNumber(badgeCount);
                    }
                }
                catch (Throwable badgeCount) {
                    // empty catch block
                }
            }
            if (extras.containsKey("wzrk_st")) {
                nb.setSubText((CharSequence)extras.getString("wzrk_st"));
            }
        } else {
            nb = new NotificationCompat.Builder(context);
        }
        if (extras.containsKey("wzrk_clr")) {
            int color = Color.parseColor((String)extras.getString("wzrk_clr"));
            nb.setColor(color);
            nb.setColorized(true);
        }
        nb.setContentTitle((CharSequence)notifTitle).setContentText((CharSequence)notifMessage).setContentIntent(pIntent).setAutoCancel(true).setStyle((NotificationCompat.Style)style).setPriority(priorityInt).setSmallIcon(smallIcon);
        nb.setLargeIcon(Utils.getNotificationBitmap(icoPath, true, context));
        try {
            if (extras.containsKey("wzrk_sound")) {
                Uri soundUri = null;
                Object o = extras.get("wzrk_sound");
                if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
                    soundUri = RingtoneManager.getDefaultUri((int)2);
                } else if (o instanceof String) {
                    String s = (String)o;
                    if (s.equals("true")) {
                        soundUri = RingtoneManager.getDefaultUri((int)2);
                    } else if (!s.isEmpty()) {
                        if (s.contains(".mp3") || s.contains(".ogg") || s.contains(".wav")) {
                            s = s.substring(0, s.length() - 4);
                        }
                        soundUri = Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + s));
                    }
                }
                if (soundUri != null) {
                    nb.setSound(soundUri);
                }
            }
        }
        catch (Throwable t) {
            this.getConfigLogger().debug(this.getAccountId(), "Could not process sound parameter", t);
        }
        JSONArray actions = null;
        String actionsString = extras.getString("wzrk_acts");
        if (actionsString != null) {
            try {
                actions = new JSONArray(actionsString);
            }
            catch (Throwable t) {
                this.getConfigLogger().debug(this.getAccountId(), "error parsing notification actions: " + t.getLocalizedMessage());
            }
        }
        String intentServiceName = ManifestInfo.getInstance(context).getIntentServiceName();
        Class<?> clazz = null;
        if (intentServiceName != null) {
            try {
                clazz = Class.forName(intentServiceName);
            }
            catch (ClassNotFoundException e) {
                try {
                    clazz = Class.forName("com.clevertap.android.sdk.pushnotification.CTNotificationIntentService");
                }
                catch (ClassNotFoundException ex) {
                    Logger.d("No Intent Service found");
                }
            }
        } else {
            try {
                clazz = Class.forName("com.clevertap.android.sdk.pushnotification.CTNotificationIntentService");
            }
            catch (ClassNotFoundException ex) {
                Logger.d("No Intent Service found");
            }
        }
        boolean isCTIntentServiceAvailable = CleverTapAPI.isServiceAvailable(context, clazz);
        if (actions != null && actions.length() > 0) {
            for (int i = 0; i < actions.length(); ++i) {
                try {
                    Intent actionLaunchIntent;
                    boolean sendToCTIntentService;
                    JSONObject action = actions.getJSONObject(i);
                    String label = action.optString("l");
                    String dl = action.optString("dl");
                    String ico = action.optString("ico");
                    String id2 = action.optString("id");
                    boolean autoCancel = action.optBoolean("ac", true);
                    if (label.isEmpty() || id2.isEmpty()) {
                        this.getConfigLogger().debug(this.getAccountId(), "not adding push notification action: action label or id missing");
                        continue;
                    }
                    int icon = 0;
                    if (!ico.isEmpty()) {
                        try {
                            icon = context.getResources().getIdentifier(ico, "drawable", context.getPackageName());
                        }
                        catch (Throwable t) {
                            this.getConfigLogger().debug(this.getAccountId(), "unable to add notification action icon: " + t.getLocalizedMessage());
                        }
                    }
                    boolean bl = sendToCTIntentService = autoCancel && isCTIntentServiceAvailable;
                    if (sendToCTIntentService) {
                        actionLaunchIntent = new Intent("com.clevertap.PUSH_EVENT");
                        actionLaunchIntent.setPackage(context.getPackageName());
                        actionLaunchIntent.putExtra("ct_type", "com.clevertap.ACTION_BUTTON_CLICK");
                        if (!dl.isEmpty()) {
                            actionLaunchIntent.putExtra("dl", dl);
                        }
                    } else {
                        actionLaunchIntent = !dl.isEmpty() ? new Intent("android.intent.action.VIEW", Uri.parse((String)dl)) : context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
                    }
                    if (actionLaunchIntent != null) {
                        actionLaunchIntent.putExtras(extras);
                        actionLaunchIntent.removeExtra("wzrk_acts");
                        actionLaunchIntent.putExtra("actionId", id2);
                        actionLaunchIntent.putExtra("autoCancel", autoCancel);
                        actionLaunchIntent.putExtra("wzrk_c2a", id2);
                        actionLaunchIntent.putExtra("notificationId", notificationId);
                        actionLaunchIntent.setFlags(0x24000000);
                    }
                    int requestCode = (int)System.currentTimeMillis() + i;
                    PendingIntent actionIntent = sendToCTIntentService ? PendingIntent.getService((Context)context, (int)requestCode, (Intent)actionLaunchIntent, (int)0x8000000) : PendingIntent.getActivity((Context)context, (int)requestCode, (Intent)actionLaunchIntent, (int)0x8000000);
                    nb.addAction(icon, (CharSequence)label, actionIntent);
                    continue;
                }
                catch (Throwable t) {
                    this.getConfigLogger().debug(this.getAccountId(), "error adding notification action : " + t.getLocalizedMessage());
                }
            }
        }
        Notification n = nb.build();
        notificationManager.notify(notificationId, n);
        this.getConfigLogger().debug(this.getAccountId(), "Rendered notification: " + n.toString());
        String ttl = extras.getString("wzrk_ttl", (System.currentTimeMillis() + 345600000L) / 1000L + "");
        long wzrk_ttl = Long.parseLong(ttl);
        String wzrk_pid = extras.getString("wzrk_pid");
        DBAdapter dbAdapter = this.loadDBAdapter(context);
        this.getConfigLogger().verbose("Storing Push Notification..." + wzrk_pid + " - with ttl - " + ttl);
        dbAdapter.storePushNotificationId(wzrk_pid, wzrk_ttl);
        boolean notificationViewedEnabled = "true".equals(extras.getString("wzrk_rnv", ""));
        if (!notificationViewedEnabled) {
            ValidationResult notificationViewedError = ValidationResultFactory.create(512, 10, extras.toString());
            this.getConfigLogger().debug(notificationViewedError.getErrorDesc());
            this.validationResultStack.pushValidationResult(notificationViewedError);
            return;
        }
        this.pushNotificationViewedEvent(extras);
    }

    private void updateBlacklistedActivitySet() {
        if (this.inappActivityExclude == null) {
            this.inappActivityExclude = new HashSet();
            try {
                String activities = ManifestInfo.getInstance(this.context).getExcludedActivities();
                if (activities != null) {
                    String[] split;
                    for (String a : split = activities.split(",")) {
                        this.inappActivityExclude.add(a.trim());
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.getConfigLogger().debug(this.getAccountId(), "In-app notifications will not be shown on " + Arrays.toString(this.inappActivityExclude.toArray()));
        }
    }

    private QueueCursor updateCursorForDBObject(JSONObject dbObject, QueueCursor cursor) {
        if (dbObject == null) {
            return cursor;
        }
        Iterator keys = dbObject.keys();
        if (keys.hasNext()) {
            String key = (String)keys.next();
            cursor.setLastId(key);
            try {
                cursor.setData(dbObject.getJSONArray(key));
            }
            catch (JSONException e) {
                cursor.setLastId(null);
                cursor.setData(null);
            }
        }
        return cursor;
    }

    private void updateLocalStore(Context context, JSONObject event, int type) {
        if (type == 4) {
            this.getLocalDataStore().persistEvent(context, event, type);
        }
    }

    private void updatePingFrequencyIfNeeded(final Context context, int frequency) {
        this.getConfigLogger().verbose("Ping frequency received - " + frequency);
        this.getConfigLogger().verbose("Stored Ping Frequency - " + this.getPingFrequency(context));
        if (frequency != this.getPingFrequency(context)) {
            this.setPingFrequency(context, frequency);
            if (this.config.isBackgroundSync() && !this.config.isAnalyticsOnly()) {
                this.postAsyncSafely("createOrResetJobScheduler", new Runnable(){

                    @Override
                    public void run() {
                        if (Build.VERSION.SDK_INT >= 21) {
                            CleverTapAPI.this.getConfigLogger().verbose("Creating job");
                            CleverTapAPI.this.createOrResetJobScheduler(context);
                        } else {
                            CleverTapAPI.this.getConfigLogger().verbose("Resetting alarm");
                            CleverTapAPI.this.resetAlarmScheduler(context);
                        }
                    }
                });
            }
        }
    }

    @Deprecated
    static void handleInstallReferrer(Context context, Intent intent) {
        if (instances == null) {
            Logger.v("No CleverTap Instance found");
            CleverTapAPI instance = CleverTapAPI.getDefaultInstance(context);
            if (instance != null) {
                instance.pushInstallReferrer(intent);
            }
            return;
        }
        for (String accountId : instances.keySet()) {
            CleverTapAPI instance = instances.get(accountId);
            if (instance == null) continue;
            instance.pushInstallReferrer(intent);
        }
    }

    static boolean isAppForeground() {
        return appForeground;
    }

    public static void setAppForeground(boolean appForeground) {
        CleverTapAPI.appForeground = appForeground;
    }

    static void onActivityCreated(Activity activity) {
        CleverTapAPI.onActivityCreated(activity, null);
    }

    static void onActivityCreated(Activity activity, String cleverTapID) {
        String _accountId;
        Uri deepLink;
        Bundle notification;
        boolean alreadyProcessedByCleverTap;
        block20: {
            if (instances == null) {
                CleverTapAPI.createInstanceIfAvailable(activity.getApplicationContext(), null, cleverTapID);
            }
            if (instances == null) {
                Logger.v("Instances is null in onActivityCreated!");
                return;
            }
            alreadyProcessedByCleverTap = false;
            notification = null;
            deepLink = null;
            _accountId = null;
            try {
                Intent intent = activity.getIntent();
                deepLink = intent.getData();
                if (deepLink != null) {
                    Bundle queryArgs = UriHelper.getAllKeyValuePairs(deepLink.toString(), true);
                    _accountId = queryArgs.getString("wzrk_acct_id");
                }
            }
            catch (Throwable intent) {
                // empty catch block
            }
            try {
                notification = activity.getIntent().getExtras();
                if (notification == null || notification.isEmpty()) break block20;
                try {
                    boolean bl = alreadyProcessedByCleverTap = notification.containsKey("wzrk_from") && "CTPushNotificationReceiver".equals(notification.get("wzrk_from"));
                    if (alreadyProcessedByCleverTap) {
                        Logger.v("ActivityLifecycleCallback: Notification Clicked already processed for " + notification.toString() + ", dropping duplicate.");
                    }
                    if (notification.containsKey("wzrk_acct_id")) {
                        _accountId = (String)notification.get("wzrk_acct_id");
                    }
                }
                catch (Throwable intent) {}
            }
            catch (Throwable intent) {
                // empty catch block
            }
        }
        if (alreadyProcessedByCleverTap && deepLink == null) {
            return;
        }
        try {
            for (String accountId : instances.keySet()) {
                CleverTapAPI instance = instances.get(accountId);
                boolean shouldProcess = false;
                if (instance != null) {
                    boolean bl = shouldProcess = _accountId == null && instance.config.isDefaultInstance() || instance.getAccountId().equals(_accountId);
                }
                if (!shouldProcess) continue;
                if (notification != null && !notification.isEmpty() && notification.containsKey(NOTIFICATION_TAG)) {
                    instance.pushNotificationClickedEvent(notification);
                }
                if (deepLink != null) {
                    try {
                        instance.pushDeepLink(deepLink);
                    }
                    catch (Throwable throwable) {}
                }
                break;
            }
        }
        catch (Throwable t) {
            Logger.v("Throwable - " + t.getLocalizedMessage());
        }
    }

    private static boolean checkForExoPlayer() {
        boolean exoPlayerPresent = false;
        Class<?> className = null;
        try {
            className = Class.forName("com.google.android.exoplayer2.SimpleExoPlayer");
            className = Class.forName("com.google.android.exoplayer2.source.hls.HlsMediaSource");
            className = Class.forName("com.google.android.exoplayer2.ui.PlayerView");
            Logger.d("ExoPlayer is present");
            exoPlayerPresent = true;
        }
        catch (Throwable t) {
            Logger.d("ExoPlayer library files are missing!!!");
            Logger.d("Please add ExoPlayer dependencies to render InApp or Inbox messages playing video. For more information checkout CleverTap documentation.");
            if (className != null) {
                Logger.d("ExoPlayer classes not found " + className.getName());
            }
            Logger.d("ExoPlayer classes not found");
        }
        return exoPlayerPresent;
    }

    private static void checkPendingNotifications(final Context context, final CleverTapInstanceConfig config) {
        Logger.v(config.getAccountId(), "checking Pending Notifications");
        if (pendingNotifications != null && !pendingNotifications.isEmpty()) {
            try {
                final CTInAppNotification notification = pendingNotifications.get(0);
                pendingNotifications.remove(0);
                Handler mainHandler = new Handler(context.getMainLooper());
                mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        CleverTapAPI.showInApp(context, notification, config);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static CleverTapAPI createInstanceIfAvailable(Context context, String _accountId) {
        return CleverTapAPI.createInstanceIfAvailable(context, _accountId, null);
    }

    /*
     * Loose catch block
     */
    @Nullable
    private static CleverTapAPI createInstanceIfAvailable(Context context, String _accountId, String cleverTapID) {
        block8: {
            if (_accountId == null) {
                try {
                    return CleverTapAPI.getDefaultInstance(context, cleverTapID);
                }
                catch (Throwable t) {
                    Logger.v("Error creating shared Instance: ", t.getCause());
                    return null;
                }
            }
            String configJson = StorageHelper.getString(context, "instance:" + _accountId, "");
            if (configJson.isEmpty()) break block8;
            CleverTapInstanceConfig config = CleverTapInstanceConfig.createInstance(configJson);
            Logger.v("Inflated Instance Config: " + configJson);
            return config != null ? CleverTapAPI.instanceWithConfig(context, config, cleverTapID) : null;
            {
                catch (Throwable t) {
                    return null;
                }
            }
        }
        try {
            CleverTapAPI instance = CleverTapAPI.getDefaultInstance(context);
            return instance != null && instance.config.getAccountId().equals(_accountId) ? instance : null;
        }
        catch (Throwable t) {
            Logger.v("Error creating shared Instance: ", t.getCause());
            return null;
        }
    }

    private static ArrayList<CleverTapAPI> getAvailableInstances(Context context) {
        ArrayList<CleverTapAPI> apiArrayList = new ArrayList<CleverTapAPI>();
        if (instances == null || instances.isEmpty()) {
            CleverTapAPI cleverTapAPI = CleverTapAPI.getDefaultInstance(context);
            if (cleverTapAPI != null) {
                apiArrayList.add(cleverTapAPI);
            }
        } else {
            apiArrayList.addAll(instances.values());
        }
        return apiArrayList;
    }

    private static Activity getCurrentActivity() {
        return currentActivity == null ? null : (Activity)currentActivity.get();
    }

    private static void setCurrentActivity(@Nullable Activity activity) {
        if (activity == null) {
            currentActivity = null;
            return;
        }
        if (!activity.getLocalClassName().contains("InAppNotificationActivity")) {
            currentActivity = new WeakReference<Activity>(activity);
        }
    }

    private static String getCurrentActivityName() {
        Activity current = CleverTapAPI.getCurrentActivity();
        return current != null ? current.getLocalClassName() : null;
    }

    private static CleverTapInstanceConfig getDefaultConfig(Context context) {
        ManifestInfo manifest = ManifestInfo.getInstance(context);
        String accountId = manifest.getAccountId();
        String accountToken = manifest.getAcountToken();
        String accountRegion = manifest.getAccountRegion();
        if (accountId == null || accountToken == null) {
            Logger.i("Account ID or Account token is missing from AndroidManifest.xml, unable to create default instance");
            return null;
        }
        if (accountRegion == null) {
            Logger.i("Account Region not specified in the AndroidManifest - using default region");
        }
        return CleverTapInstanceConfig.createDefaultInstance(context, accountId, accountToken, accountRegion);
    }

    @Nullable
    private static CleverTapAPI getDefaultInstanceOrFirstOther(Context context) {
        CleverTapAPI instance;
        block1: {
            String accountId;
            instance = CleverTapAPI.getDefaultInstance(context);
            if (instance != null || instances == null || instances.isEmpty()) break block1;
            Iterator<String> iterator = instances.keySet().iterator();
            while (iterator.hasNext() && (instance = instances.get(accountId = iterator.next())) == null) {
            }
        }
        return instance;
    }

    @RequiresApi(api=21)
    private static JobInfo getJobInfo(int jobId, JobScheduler jobScheduler) {
        for (JobInfo jobInfo : jobScheduler.getAllPendingJobs()) {
            if (jobInfo.getId() != jobId) continue;
            return jobInfo;
        }
        return null;
    }

    private static SSLSocketFactory getPinnedCertsSslSocketfactory(SSLContext sslContext) {
        if (sslContext == null) {
            return null;
        }
        if (sslSocketFactory == null) {
            try {
                sslSocketFactory = sslContext.getSocketFactory();
                Logger.d("Pinning SSL session to DigiCertGlobalRoot CA certificate");
            }
            catch (Throwable e) {
                Logger.d("Issue in pinning SSL,", e);
            }
        }
        return sslSocketFactory;
    }

    private static synchronized SSLContext getSSLContext() {
        if (sslContext == null) {
            sslContext = new SSLContextBuilder().build();
        }
        return sslContext;
    }

    private static void inAppDidDismiss(Context context, CleverTapInstanceConfig config, CTInAppNotification inAppNotification) {
        Logger.v(config.getAccountId(), "Running inAppDidDismiss");
        if (currentlyDisplayingInApp != null && currentlyDisplayingInApp.getCampaignId().equals(inAppNotification.getCampaignId())) {
            currentlyDisplayingInApp = null;
            CleverTapAPI.checkPendingNotifications(context, config);
        }
    }

    private static boolean isServiceAvailable(Context context, Class clazz) {
        if (clazz == null) {
            return false;
        }
        PackageManager pm = context.getPackageManager();
        String packageName = context.getPackageName();
        try {
            ServiceInfo[] services;
            PackageInfo packageInfo = pm.getPackageInfo(packageName, 4);
            for (ServiceInfo serviceInfo : services = packageInfo.services) {
                if (!serviceInfo.name.equals(clazz.getName())) continue;
                Logger.v("Service " + serviceInfo.name + " found");
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.d("Intent Service name not found exception - " + e.getLocalizedMessage());
        }
        return false;
    }

    private static void showInApp(Context context, CTInAppNotification inAppNotification, CleverTapInstanceConfig config) {
        Logger.v(config.getAccountId(), "Attempting to show next In-App");
        if (!appForeground) {
            pendingNotifications.add(inAppNotification);
            Logger.v(config.getAccountId(), "Not in foreground, queueing this In App");
            return;
        }
        if (currentlyDisplayingInApp != null) {
            pendingNotifications.add(inAppNotification);
            Logger.v(config.getAccountId(), "In App already displaying, queueing this In App");
            return;
        }
        if (System.currentTimeMillis() / 1000L > inAppNotification.getTimeToLive()) {
            Logger.d("InApp has elapsed its time to live, not showing the InApp");
            return;
        }
        currentlyDisplayingInApp = inAppNotification;
        CTInAppBasePartialFragment inAppFragment = null;
        CTInAppType type = inAppNotification.getInAppType();
        switch (type) {
            case CTInAppTypeCoverHTML: 
            case CTInAppTypeInterstitialHTML: 
            case CTInAppTypeHalfInterstitialHTML: 
            case CTInAppTypeCover: 
            case CTInAppTypeHalfInterstitial: 
            case CTInAppTypeInterstitial: 
            case CTInAppTypeAlert: 
            case CTInAppTypeInterstitialImageOnly: 
            case CTInAppTypeHalfInterstitialImageOnly: 
            case CTInAppTypeCoverImageOnly: {
                Intent intent = new Intent(context, InAppNotificationActivity.class);
                intent.putExtra("inApp", (Parcelable)inAppNotification);
                Bundle configBundle = new Bundle();
                configBundle.putParcelable("config", (Parcelable)config);
                intent.putExtra("configBundle", configBundle);
                try {
                    Activity currentActivity = CleverTapAPI.getCurrentActivity();
                    if (currentActivity == null) {
                        throw new IllegalStateException("Current activity reference not found");
                    }
                    config.getLogger().verbose(config.getAccountId(), "calling InAppActivity for notification: " + inAppNotification.getJsonDescription());
                    currentActivity.startActivity(intent);
                    Logger.d("Displaying In-App: " + inAppNotification.getJsonDescription());
                }
                catch (Throwable t) {
                    Logger.v("Please verify the integration of your app. It is not setup to support in-app notifications yet.", t);
                }
                break;
            }
            case CTInAppTypeFooterHTML: {
                inAppFragment = new CTInAppHtmlFooterFragment();
                break;
            }
            case CTInAppTypeHeaderHTML: {
                inAppFragment = new CTInAppHtmlHeaderFragment();
                break;
            }
            case CTInAppTypeFooter: {
                inAppFragment = new CTInAppNativeFooterFragment();
                break;
            }
            case CTInAppTypeHeader: {
                inAppFragment = new CTInAppNativeHeaderFragment();
                break;
            }
            default: {
                Logger.d(config.getAccountId(), "Unknown InApp Type found: " + (Object)((Object)type));
                currentlyDisplayingInApp = null;
                return;
            }
        }
        if (inAppFragment != null) {
            Logger.d("Displaying In-App: " + inAppNotification.getJsonDescription());
            try {
                FragmentTransaction fragmentTransaction = ((FragmentActivity)CleverTapAPI.getCurrentActivity()).getSupportFragmentManager().beginTransaction();
                Bundle bundle = new Bundle();
                bundle.putParcelable("inApp", (Parcelable)inAppNotification);
                bundle.putParcelable("config", (Parcelable)config);
                inAppFragment.setArguments(bundle);
                fragmentTransaction.setCustomAnimations(0x10B0000, 0x10B0001);
                fragmentTransaction.add(0x1020002, (Fragment)inAppFragment, inAppNotification.getType());
                Logger.v(config.getAccountId(), "calling InAppFragment " + inAppNotification.getCampaignId());
                fragmentTransaction.commit();
            }
            catch (ClassCastException e) {
                Logger.v(config.getAccountId(), "Fragment not able to render, please ensure your Activity is an instance of AppCompatActivity" + e.getMessage());
            }
            catch (Throwable t) {
                Logger.v(config.getAccountId(), "Fragment not able to render", t);
            }
        }
    }

    static {
        debugLevel = LogLevel.INFO.intValue();
        appForeground = false;
        activityCount = 0;
        pendingNotifications = Collections.synchronizedList(new ArrayList());
        currentlyDisplayingInApp = null;
        initialAppEnteredForegroundTime = 0;
        isUIEditorEnabled = false;
        haveVideoPlayerSupport = CleverTapAPI.checkForExoPlayer();
    }

    private static enum EventGroup {
        REGULAR(""),
        PUSH_NOTIFICATION_VIEWED("-spiky");

        private final String httpResource;

        private EventGroup(String httpResource) {
            this.httpResource = httpResource;
        }
    }

    public static enum LogLevel {
        OFF(-1),
        INFO(0),
        DEBUG(2);

        private final int value;

        private LogLevel(int newValue) {
            this.value = newValue;
        }

        public int intValue() {
            return this.value;
        }
    }

    public static interface DevicePushTokenRefreshListener {
        public void devicePushTokenDidRefresh(String var1, PushConstants.PushType var2);
    }

    private final class NotificationPrepareRunnable
    implements Runnable {
        private final WeakReference<CleverTapAPI> cleverTapAPIWeakReference;
        private final JSONObject jsonObject;
        private final boolean videoSupport = haveVideoPlayerSupport;

        NotificationPrepareRunnable(CleverTapAPI cleverTapAPI2, JSONObject jsonObject) {
            this.cleverTapAPIWeakReference = new WeakReference<CleverTapAPI>(cleverTapAPI2);
            this.jsonObject = jsonObject;
        }

        @Override
        public void run() {
            CTInAppNotification inAppNotification = new CTInAppNotification().initWithJSON(this.jsonObject, this.videoSupport);
            if (inAppNotification.getError() != null) {
                CleverTapAPI.this.getConfigLogger().debug(CleverTapAPI.this.getAccountId(), "Unable to parse inapp notification " + inAppNotification.getError());
                return;
            }
            inAppNotification.listener = (CTInAppNotification.CTInAppNotificationListener)this.cleverTapAPIWeakReference.get();
            inAppNotification.prepareForDisplay();
        }
    }
}

