/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;

public final class ActivityLifecycleCallback {
    static boolean registered = false;

    @TargetApi(value=14)
    public static synchronized void register(Application application, final String cleverTapID) {
        if (application == null) {
            Logger.i("Application instance is null/system API is too old");
            return;
        }
        if (registered) {
            Logger.v("Lifecycle callbacks have already been registered");
            return;
        }
        registered = true;
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle bundle) {
                if (cleverTapID != null) {
                    CleverTapAPI.onActivityCreated(activity, cleverTapID);
                } else {
                    CleverTapAPI.onActivityCreated(activity);
                }
            }

            public void onActivityDestroyed(Activity activity) {
            }

            public void onActivityPaused(Activity activity) {
                CleverTapAPI.onActivityPaused();
            }

            public void onActivityResumed(Activity activity) {
                if (cleverTapID != null) {
                    CleverTapAPI.onActivityResumed(activity, cleverTapID);
                } else {
                    CleverTapAPI.onActivityResumed(activity);
                }
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
            }
        });
        Logger.i("Activity Lifecycle Callback successfully registered");
    }

    @TargetApi(value=14)
    public static synchronized void register(Application application) {
        ActivityLifecycleCallback.register(application, null);
    }
}

