/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.text.TextUtils;
import com.clevertap.android.sdk.CTInboxMessage;
import com.clevertap.android.sdk.CTInboxMessageContent;
import com.clevertap.android.sdk.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class CTMessageDAO {
    private String campaignId;
    private long date;
    private long expires;
    private String id;
    private JSONObject jsonData;
    private boolean read;
    private List<String> tags = new ArrayList<String>();
    private String userId;
    private JSONObject wzrkParams;

    CTMessageDAO() {
    }

    private CTMessageDAO(String id2, JSONObject jsonData, boolean read, long date, long expires, String userId, List<String> tags, String campaignId, JSONObject wzrkParams) {
        this.id = id2;
        this.jsonData = jsonData;
        this.read = read;
        this.date = date;
        this.expires = expires;
        this.userId = userId;
        this.tags = tags;
        this.campaignId = campaignId;
        this.wzrkParams = wzrkParams;
    }

    boolean containsVideoOrAudio() {
        CTInboxMessageContent content = new CTInboxMessage(this.toJSON()).getInboxMessageContents().get(0);
        return content.mediaIsVideo() || content.mediaIsAudio();
    }

    String getCampaignId() {
        return this.campaignId;
    }

    void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    long getDate() {
        return this.date;
    }

    void setDate(long date) {
        this.date = date;
    }

    long getExpires() {
        return this.expires;
    }

    void setExpires(long expires) {
        this.expires = expires;
    }

    String getId() {
        return this.id;
    }

    void setId(String id2) {
        this.id = id2;
    }

    JSONObject getJsonData() {
        return this.jsonData;
    }

    void setJsonData(JSONObject jsonData) {
        this.jsonData = jsonData;
    }

    String getTags() {
        return TextUtils.join((CharSequence)",", this.tags);
    }

    void setTags(String tags) {
        String[] tagsArray = tags.split(",");
        this.tags.addAll(Arrays.asList(tagsArray));
    }

    String getUserId() {
        return this.userId;
    }

    void setUserId(String userId) {
        this.userId = userId;
    }

    JSONObject getWzrkParams() {
        return this.wzrkParams;
    }

    void setWzrkParams(JSONObject wzrk_params) {
        this.wzrkParams = wzrk_params;
    }

    int isRead() {
        if (this.read) {
            return 1;
        }
        return 0;
    }

    void setRead(int read) {
        this.read = read == 1;
    }

    JSONObject toJSON() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("id", (Object)this.id);
            jsonObject.put("msg", (Object)this.jsonData);
            jsonObject.put("isRead", this.read);
            jsonObject.put("date", this.date);
            jsonObject.put("wzrk_ttl", this.expires);
            JSONArray jsonArray = new JSONArray();
            for (int i = 0; i < this.tags.size(); ++i) {
                jsonArray.put((Object)this.tags.get(i));
            }
            jsonObject.put("tags", (Object)jsonArray);
            jsonObject.put("wzrk_id", (Object)this.campaignId);
            jsonObject.put("wzrkParams", (Object)this.wzrkParams);
            return jsonObject;
        }
        catch (JSONException e) {
            Logger.v("Unable to convert CTMessageDao to JSON - " + e.getLocalizedMessage());
            return jsonObject;
        }
    }

    static CTMessageDAO initWithJSON(JSONObject inboxMessage, String userId) {
        try {
            String campaignId;
            String id2 = inboxMessage.has("_id") ? inboxMessage.getString("_id") : null;
            long date = inboxMessage.has("date") ? (long)inboxMessage.getInt("date") : System.currentTimeMillis() / 1000L;
            long expires = inboxMessage.has("wzrk_ttl") ? (long)inboxMessage.getInt("wzrk_ttl") : (System.currentTimeMillis() + 86400000L) / 1000L;
            JSONObject cellObject = inboxMessage.has("msg") ? inboxMessage.getJSONObject("msg") : null;
            ArrayList<String> tagsList = new ArrayList<String>();
            if (cellObject != null) {
                JSONArray tagsArray;
                JSONArray jSONArray = tagsArray = cellObject.has("tags") ? cellObject.getJSONArray("tags") : null;
                if (tagsArray != null) {
                    for (int i = 0; i < tagsArray.length(); ++i) {
                        tagsList.add(tagsArray.getString(i));
                    }
                }
            }
            String string = campaignId = inboxMessage.has("wzrk_id") ? inboxMessage.getString("wzrk_id") : "0_0";
            if (campaignId.equalsIgnoreCase("0_0")) {
                inboxMessage.put("wzrk_id", (Object)campaignId);
            }
            JSONObject wzrkParams = CTMessageDAO.getWzrkFields(inboxMessage);
            return id2 == null ? null : new CTMessageDAO(id2, cellObject, false, date, expires, userId, tagsList, campaignId, wzrkParams);
        }
        catch (JSONException e) {
            Logger.d("Unable to parse Notification inbox message to CTMessageDao - " + e.getLocalizedMessage());
            return null;
        }
    }

    private static JSONObject getWzrkFields(JSONObject root) throws JSONException {
        JSONObject fields = new JSONObject();
        Iterator iterator = root.keys();
        while (iterator.hasNext()) {
            String keyName = (String)iterator.next();
            if (!keyName.startsWith("wzrk_")) continue;
            fields.put(keyName, root.get(keyName));
        }
        return fields;
    }
}

