/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.pushnotification.fcm;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.PackageUtils;
import com.clevertap.android.sdk.pushnotification.CTPushProviderListener;
import com.clevertap.android.sdk.pushnotification.PushConstants;
import com.clevertap.android.sdk.pushnotification.fcm.IFcmSdkHandler;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;

public class FcmSdkHandlerImpl
implements IFcmSdkHandler {
    private final CTPushProviderListener listener;
    private ManifestInfo mManifestInfo;

    public FcmSdkHandlerImpl(CTPushProviderListener listener) {
        this.listener = listener;
        this.mManifestInfo = ManifestInfo.getInstance(listener.context());
    }

    @Override
    public PushConstants.PushType getPushType() {
        return PushConstants.PushType.FCM;
    }

    @Override
    public boolean isAvailable() {
        try {
            if (!PackageUtils.isGooglePlayServicesAvailable(this.listener.context())) {
                this.listener.config().log("PushProvider", PushConstants.FCM_LOG_TAG + "Google Play services is currently unavailable.");
                return false;
            }
            String senderId = this.getSenderId();
            if (TextUtils.isEmpty((CharSequence)senderId)) {
                this.listener.config().log("PushProvider", PushConstants.FCM_LOG_TAG + "The FCM sender ID is not set. Unable to register for FCM.");
                return false;
            }
        }
        catch (Throwable t) {
            this.listener.config().log("PushProvider", PushConstants.FCM_LOG_TAG + "Unable to register with FCM.", t);
            return false;
        }
        return true;
    }

    @Override
    public boolean isSupported() {
        return PackageUtils.isGooglePlayStoreAvailable(this.listener.context());
    }

    @Override
    public void requestToken() {
        try {
            FirebaseInstanceId.getInstance().getInstanceId().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<InstanceIdResult>(){

                public void onComplete(@NonNull Task<InstanceIdResult> task) {
                    if (!task.isSuccessful()) {
                        FcmSdkHandlerImpl.this.listener.config().log("PushProvider", PushConstants.FCM_LOG_TAG + "getInstanceId failed", task.getException());
                        FcmSdkHandlerImpl.this.listener.onNewToken(null, FcmSdkHandlerImpl.this.getPushType());
                        return;
                    }
                    String token = task.getResult() != null ? ((InstanceIdResult)task.getResult()).getToken() : null;
                    FcmSdkHandlerImpl.this.listener.config().log("PushProvider", PushConstants.FCM_LOG_TAG + "FCM token - " + token);
                    FcmSdkHandlerImpl.this.listener.onNewToken(token, FcmSdkHandlerImpl.this.getPushType());
                }
            });
        }
        catch (Throwable t) {
            this.listener.config().log("PushProvider", PushConstants.FCM_LOG_TAG + "Error requesting FCM token", t);
            this.listener.onNewToken(null, this.getPushType());
        }
    }

    String getFCMSenderID() {
        return this.mManifestInfo.getFCMSenderId();
    }

    String getSenderId() {
        String senderId = this.getFCMSenderID();
        if (!TextUtils.isEmpty((CharSequence)senderId)) {
            return senderId;
        }
        FirebaseApp app = FirebaseApp.getInstance();
        return app.getOptions().getGcmSenderId();
    }

    void setManifestInfo(ManifestInfo manifestInfo) {
        this.mManifestInfo = manifestInfo;
    }
}

