/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.ab_testing.uieditor;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewTreeObserver;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.ImageCache;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.ab_testing.models.CTABVariant;
import com.clevertap.android.sdk.ab_testing.uieditor.ResourceIds;
import com.clevertap.android.sdk.ab_testing.uieditor.SnapshotBuilder;
import com.clevertap.android.sdk.ab_testing.uieditor.ViewCaller;
import com.clevertap.android.sdk.ab_testing.uieditor.ViewEdit;
import com.clevertap.android.sdk.ab_testing.uieditor.ViewProperty;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UIEditor {
    private static final Class<?>[] EMPTY_PARAMS = new Class[0];
    private static final List<ViewEdit.PathElement> NEVER_MATCH_PATH = Collections.emptyList();
    private ActivitySet activitySet;
    private CleverTapInstanceConfig config;
    private Context context;
    private final Deque<UIChangeBinding> currentEdits;
    private final ArrayList<String> editorSessionImageUrls;
    private final Map<String, List<ViewEdit>> newEdits;
    private ResourceIds resourceIds;
    private SnapshotBuilder.ViewSnapshotConfig snapshotConfig;
    private final Handler uiThreadHandler;

    public UIEditor(Context context, CleverTapInstanceConfig config) {
        String resourcePackageName = config.getPackageName();
        if (resourcePackageName == null) {
            resourcePackageName = context.getPackageName();
        }
        this.resourceIds = new ResourceIds(resourcePackageName);
        this.config = config;
        this.uiThreadHandler = new Handler(Looper.getMainLooper());
        this.newEdits = new HashMap<String, List<ViewEdit>>();
        this.currentEdits = new ArrayDeque<UIChangeBinding>();
        this.activitySet = new ActivitySet();
        this.editorSessionImageUrls = new ArrayList();
        this.context = context;
    }

    public void addActivity(Activity activity) {
        this.activitySet.add(activity);
        this.handleNewEditsOnUiThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyVariants(Set<CTABVariant> variants, boolean isEditorSession) {
        HashMap edits = new HashMap();
        for (CTABVariant variant : variants) {
            for (CTABVariant.CTVariantAction action : variant.getActions()) {
                List<ViewEdit> mapElement;
                UIChange change = this.generateUIChange(action.getChange());
                if (change == null) continue;
                if (isEditorSession) {
                    this.editorSessionImageUrls.addAll(change.imageUrls);
                }
                variant.addImageUrls(change.imageUrls);
                String name = action.getActivityName();
                ViewEdit viewEdit = change.viewEdit;
                if (edits.containsKey(name)) {
                    mapElement = (List)edits.get(name);
                } else {
                    mapElement = new ArrayList();
                    edits.put(name, mapElement);
                }
                if (mapElement == null) continue;
                mapElement.add(viewEdit);
            }
        }
        this.clearEdits();
        Map<String, List<ViewEdit>> map = this.newEdits;
        synchronized (map) {
            this.newEdits.clear();
            this.newEdits.putAll(edits);
        }
        this.handleNewEditsOnUiThread();
    }

    public boolean loadSnapshotConfig(JSONObject data) {
        List<ViewProperty> properties;
        if (this.snapshotConfig == null && (properties = this.loadViewProperties(data)) != null) {
            this.snapshotConfig = new SnapshotBuilder.ViewSnapshotConfig(properties, this.resourceIds);
        }
        return this.snapshotConfig != null;
    }

    public void removeActivity(Activity activity) {
        this.activitySet.remove(activity);
    }

    public void stopVariants() {
        this.clearEdits();
        for (String assetUrl : this.editorSessionImageUrls) {
            ImageCache.removeBitmap(assetUrl, true);
        }
        this.editorSessionImageUrls.clear();
        this.snapshotConfig = null;
    }

    public void writeSnapshot(OutputStream out) {
        if (this.snapshotConfig == null) {
            this.getConfigLogger().debug("UIEditor: Unable to write snapshot, snapshot config not set");
            return;
        }
        try {
            SnapshotBuilder.writeSnapshot(this.snapshotConfig, this.activitySet, out, this.config);
        }
        catch (Throwable t) {
            this.getConfigLogger().debug("UIEditor: error writing snapshot", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyEdits(View rootView, List<ViewEdit> viewEdits) {
        Deque<UIChangeBinding> deque = this.currentEdits;
        synchronized (deque) {
            int size = viewEdits.size();
            for (int i = 0; i < size; ++i) {
                ViewEdit viewEdit = viewEdits.get(i);
                UIChangeBinding binding = new UIChangeBinding(rootView, viewEdit, this.uiThreadHandler);
                this.currentEdits.add(binding);
            }
        }
    }

    private Object castArgumentObject(Object jsonArgument, String type, List<String> imageUrls) {
        try {
            if (type == null) {
                return null;
            }
            switch (type) {
                case "java.lang.CharSequence": 
                case "boolean": 
                case "java.lang.Boolean": {
                    return jsonArgument;
                }
                case "int": 
                case "java.lang.Integer": {
                    return ((Number)jsonArgument).intValue();
                }
                case "float": 
                case "java.lang.Float": {
                    return Float.valueOf(((Number)jsonArgument).floatValue());
                }
                case "android.graphics.drawable.Drawable": 
                case "android.graphics.drawable.BitmapDrawable": {
                    return this.readBitmapDrawable((JSONObject)jsonArgument, imageUrls);
                }
                case "android.graphics.drawable.ColorDrawable": {
                    int colorValue = ((Number)jsonArgument).intValue();
                    return new ColorDrawable(colorValue);
                }
            }
            this.getConfigLogger().verbose(this.getAccountId(), "UIEditor: Unhandled argument object type: " + type);
            return null;
        }
        catch (ClassCastException e) {
            this.getConfigLogger().verbose(this.getAccountId(), "UIEditor: Error casting class while converting argument - " + e.getLocalizedMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Integer checkIds(int explicitId, String idName, ResourceIds idNameToId) {
        int idFromName;
        if (idName != null) {
            if (!idNameToId.knownIdName(idName)) {
                this.getConfigLogger().debug(this.getAccountId(), "UIEditor: Path element contains an id name not known to the system. No views will be matched.\nMake sure that you're not stripping your packages R class out with proguard.\nid name was \"" + idName + "\"");
                return null;
            }
            idFromName = idNameToId.idFromName(idName);
        } else {
            idFromName = -1;
        }
        if (idFromName != -1 && explicitId != -1 && idFromName != explicitId) {
            this.getConfigLogger().debug(this.getAccountId(), "UIEditor: Path contains both a named and an explicit id which don't match, can't match.");
            return null;
        }
        if (-1 != idFromName) {
            return idFromName;
        }
        return explicitId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearEdits() {
        Deque<UIChangeBinding> deque = this.currentEdits;
        synchronized (deque) {
            while (!this.currentEdits.isEmpty()) {
                this.currentEdits.removeLast().kill();
            }
        }
    }

    private List<ViewEdit.PathElement> generatePath(JSONArray pathDesc, ResourceIds idNameToId) throws JSONException {
        ArrayList<ViewEdit.PathElement> path = new ArrayList<ViewEdit.PathElement>();
        for (int i = 0; i < pathDesc.length(); ++i) {
            int prefix;
            JSONObject targetView = pathDesc.getJSONObject(i);
            String prefixCode = Utils.optionalStringKey(targetView, "prefix");
            String targetViewClass = Utils.optionalStringKey(targetView, "view_class");
            int targetIndex = targetView.optInt("index", -1);
            String targetDescription = Utils.optionalStringKey(targetView, "contentDescription");
            int targetExplicitId = targetView.optInt("id", -1);
            String targetIdName = Utils.optionalStringKey(targetView, "ct_id_name");
            String targetTag = Utils.optionalStringKey(targetView, "tag");
            if (prefixCode == null) {
                prefix = 0;
            } else if (prefixCode.equals("shortest")) {
                prefix = 1;
            } else {
                this.getConfigLogger().verbose(this.getAccountId(), "UIEditor: Unrecognized prefix type \"" + prefixCode + "\". No views will be matched");
                return NEVER_MATCH_PATH;
            }
            Integer targetIdOrNull = this.checkIds(targetExplicitId, targetIdName, idNameToId);
            if (targetIdOrNull == null) {
                return NEVER_MATCH_PATH;
            }
            int targetId = targetIdOrNull;
            path.add(new ViewEdit.PathElement(prefix, targetViewClass, targetIndex, targetId, targetDescription, targetTag));
        }
        return path;
    }

    private UIChange generateUIChange(JSONObject data) {
        ViewEdit viewEdit;
        ArrayList<String> imageUrls = new ArrayList<String>();
        try {
            ViewCaller mutator;
            ViewProperty prop;
            JSONArray pathDesc = data.getJSONArray("path");
            List<ViewEdit.PathElement> path = this.generatePath(pathDesc, this.resourceIds);
            if (path.size() == 0) {
                this.getConfigLogger().verbose("UIEditor: UI change path is empty: " + data.toString());
                return null;
            }
            if (data.getString("change_type").equals("property")) {
                Class<?> targetClass;
                JSONObject propertyDesc = data.getJSONObject("property");
                String targetClassName = propertyDesc.getString("classname");
                if (targetClassName == null) {
                    this.getConfigLogger().verbose("UIEditor: UI change target classname is missing: " + data.toString());
                    return null;
                }
                try {
                    targetClass = Class.forName(targetClassName);
                }
                catch (ClassNotFoundException e) {
                    this.getConfigLogger().verbose(this.getAccountId(), "UIEditor: Class not found while generating UI change - " + e.getLocalizedMessage());
                    return null;
                }
                prop = this.generateViewProperty(targetClass, data.getJSONObject("property"));
                JSONArray argsAndTypes = data.getJSONArray("args");
                Object[] methodArgs = new Object[argsAndTypes.length()];
                for (int i = 0; i < argsAndTypes.length(); ++i) {
                    JSONArray argPlusType = argsAndTypes.getJSONArray(i);
                    Object jsonArg = argPlusType.get(0);
                    String argType = argPlusType.getString(1);
                    methodArgs[i] = this.castArgumentObject(jsonArg, argType, imageUrls);
                }
                mutator = null;
                if (prop != null) {
                    mutator = prop.createMutator(methodArgs);
                }
                if (mutator == null) {
                    this.getConfigLogger().verbose("UIEditor: UI change unable to create mutator: " + data.toString());
                    return null;
                }
            } else {
                this.getConfigLogger().verbose("UIEditor: UI change type is unknown: " + data.toString());
                return null;
            }
            viewEdit = new ViewEdit(path, mutator, prop.accessor, this.context);
        }
        catch (NoSuchMethodException e) {
            this.getConfigLogger().verbose(this.getAccountId(), "UIEditor: No such method found while generating UI change - " + e.getLocalizedMessage());
            return null;
        }
        catch (JSONException e) {
            this.getConfigLogger().verbose(this.getAccountId(), "UIEditor: Unable to parse JSON while generating UI change - " + e.getLocalizedMessage());
            return null;
        }
        return new UIChange(viewEdit, imageUrls);
    }

    private ViewProperty generateViewProperty(Class<?> targetClass, JSONObject property) {
        try {
            String mutatorName;
            String propName = property.getString("name");
            ViewCaller accessor = null;
            if (property.has("get")) {
                JSONObject accessorConfig = property.getJSONObject("get");
                String accessorName = accessorConfig.getString("selector");
                String accessorResultTypeName = accessorConfig.getJSONObject("result").getString("type");
                Class<?> accessorResultType = Class.forName(accessorResultTypeName);
                accessor = new ViewCaller(targetClass, accessorName, EMPTY_PARAMS, accessorResultType);
            }
            if (property.has("set")) {
                JSONObject mutatorConfig = property.getJSONObject("set");
                mutatorName = mutatorConfig.getString("selector");
            } else {
                mutatorName = null;
            }
            return new ViewProperty(propName, targetClass, accessor, mutatorName);
        }
        catch (NoSuchMethodException e) {
            this.getConfigLogger().verbose("UIEditor: Error generating view property", e);
            return null;
        }
        catch (JSONException e) {
            this.getConfigLogger().verbose("UIEditor: Error generating view property", e);
            return null;
        }
        catch (ClassNotFoundException e) {
            this.getConfigLogger().verbose("UIEditor: Error generating view property", e);
            return null;
        }
    }

    private String getAccountId() {
        return this.config.getAccountId();
    }

    private Logger getConfigLogger() {
        return this.config.getLogger();
    }

    private Bitmap getOrFetchBitmap(String key) {
        this.initImageCache();
        return ImageCache.getOrFetchBitmap(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNewEdits() {
        for (Activity activity : this.activitySet.getAll()) {
            List<ViewEdit> wildcard;
            List<ViewEdit> specific;
            String activityName = activity.getClass().getCanonicalName();
            View rootView = activity.getWindow().getDecorView().getRootView();
            Map<String, List<ViewEdit>> map = this.newEdits;
            synchronized (map) {
                specific = this.newEdits.get(activityName);
                wildcard = this.newEdits.get(null);
            }
            if (specific != null) {
                this.applyEdits(rootView, specific);
            }
            if (wildcard == null) continue;
            this.applyEdits(rootView, wildcard);
        }
    }

    private void handleNewEditsOnUiThread() {
        if (Thread.currentThread() == this.uiThreadHandler.getLooper().getThread()) {
            this.handleNewEdits();
        } else {
            this.uiThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    UIEditor.this.handleNewEdits();
                }
            });
        }
    }

    private void initImageCache() {
        ImageCache.initWithPersistence(this.context);
    }

    private List<ViewProperty> loadViewProperties(JSONObject data) {
        ArrayList<ViewProperty> properties = new ArrayList<ViewProperty>();
        try {
            JSONObject config = data.getJSONObject("config");
            JSONArray classes = config.getJSONArray("classes");
            for (int i = 0; i < classes.length(); ++i) {
                JSONObject classDesc = classes.getJSONObject(i);
                String targetName = classDesc.getString("name");
                Class<?> targetClass = Class.forName(targetName);
                JSONArray props = classDesc.getJSONArray("properties");
                for (int j = 0; j < props.length(); ++j) {
                    JSONObject prop = props.getJSONObject(j);
                    ViewProperty desc = this.generateViewProperty(targetClass, prop);
                    properties.add(desc);
                }
            }
        }
        catch (JSONException e) {
            this.getConfigLogger().verbose("UIEditor: Error loading view properties json: " + data.toString());
            return null;
        }
        catch (ClassNotFoundException e) {
            this.getConfigLogger().verbose("UIEditor: Error loading view properties", e);
            return null;
        }
        return properties;
    }

    private Drawable readBitmapDrawable(JSONObject description, List<String> imageUrls) {
        try {
            boolean useBounds;
            int left;
            int right;
            int top;
            int bottom;
            String url = description.getString("url");
            if (description.isNull("dimensions")) {
                bottom = 0;
                top = 0;
                right = 0;
                left = 0;
                useBounds = false;
            } else {
                JSONObject dimensions = description.getJSONObject("dimensions");
                left = dimensions.getInt("left");
                right = dimensions.getInt("right");
                top = dimensions.getInt("top");
                bottom = dimensions.getInt("bottom");
                useBounds = true;
            }
            Bitmap image = this.getOrFetchBitmap(url);
            imageUrls.add(url);
            BitmapDrawable ret = new BitmapDrawable(Resources.getSystem(), image);
            if (useBounds) {
                ret.setBounds(left, top, right, bottom);
            }
            return ret;
        }
        catch (JSONException e) {
            this.getConfigLogger().verbose(this.getAccountId(), "UIEditor: Unable to parse JSON while reading Bitmap from payload - " + e.getLocalizedMessage());
            return null;
        }
    }

    class ActivitySet {
        private Set<Activity> activitySet = new HashSet<Activity>();

        ActivitySet() {
        }

        void add(Activity activity) {
            this.checkThreadState();
            this.activitySet.add(activity);
        }

        Set<Activity> getAll() {
            this.checkThreadState();
            return Collections.unmodifiableSet(this.activitySet);
        }

        boolean isEmpty() {
            this.checkThreadState();
            return this.activitySet.isEmpty();
        }

        void remove(Activity activity) {
            this.checkThreadState();
            this.activitySet.remove(activity);
        }

        private void checkThreadState() throws RuntimeException {
            if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
                throw new RuntimeException("Can't access ActivitySet when not on the UI thread");
            }
        }
    }

    private static class UIChangeBinding
    implements ViewTreeObserver.OnGlobalLayoutListener,
    Runnable {
        private boolean alive;
        private volatile boolean dying;
        private final Handler handler;
        private final ViewEdit viewEdit;
        private final WeakReference<View> viewRoot;

        UIChangeBinding(View viewRoot, ViewEdit edit, Handler uiThreadHandler) {
            this.viewEdit = edit;
            this.viewRoot = new WeakReference<View>(viewRoot);
            this.handler = uiThreadHandler;
            this.alive = true;
            this.dying = false;
            ViewTreeObserver observer = viewRoot.getViewTreeObserver();
            if (observer.isAlive()) {
                observer.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
            this.run();
        }

        public void onGlobalLayout() {
            this.run();
        }

        @Override
        public void run() {
            if (!this.alive) {
                return;
            }
            View viewRoot = (View)this.viewRoot.get();
            if (null == viewRoot || this.dying) {
                this.cleanUp();
                return;
            }
            this.viewEdit.run(viewRoot);
            this.handler.removeCallbacks((Runnable)this);
            this.handler.postDelayed((Runnable)this, 1000L);
        }

        private void cleanUp() {
            if (this.alive) {
                ViewTreeObserver observer;
                View viewRoot = (View)this.viewRoot.get();
                if (viewRoot != null && (observer = viewRoot.getViewTreeObserver()).isAlive()) {
                    observer.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.viewEdit.cleanup();
            }
            this.alive = false;
        }

        private void kill() {
            this.dying = true;
            this.handler.post((Runnable)this);
        }
    }

    private static class UIChange {
        final List<String> imageUrls;
        final ViewEdit viewEdit;

        private UIChange(ViewEdit viewEdit, List<String> urls) {
            this.viewEdit = viewEdit;
            this.imageUrls = urls;
        }
    }
}

