/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.ab_testing.gesture;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import com.clevertap.android.sdk.Logger;

public class ConnectionGesture
implements SensorEventListener {
    private static final float MINIMUM_GRAVITY = 7.8f;
    private static final float MAXIMUM_GRAVITY = 11.8f;
    private static final long MINIMUM_UP_DOWN_DURATION = 250000000L;
    private static final long MINIMUM_CANCEL_DURATION = 1000000000L;
    private static final int STATE_UP = -1;
    private static final int STATE_NONE = 0;
    private static final int STATE_DOWN = 1;
    private static final int TRIGGER_NONE = 0;
    private static final int TRIGGER_BEGIN = 1;
    private static final float SMOOTHING_FACTOR = 0.7f;
    private int gestureState = 0;
    private long lastTime = -1L;
    private final OnGestureListener listener;
    private final float[] smoothed = new float[3];
    private int triggerState = -1;

    public ConnectionGesture(OnGestureListener listener) {
        this.listener = listener;
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onSensorChanged(SensorEvent event) {
        float[] smoothedValues = this.smoothSamples(event.values);
        int oldState = this.gestureState;
        this.gestureState = 0;
        float totalGravitySquared = smoothedValues[0] * smoothedValues[0] + smoothedValues[1] * smoothedValues[1] + smoothedValues[2] * smoothedValues[2];
        float minimumGravitySquared = 60.840004f;
        float maximumGravitySquared = 139.24f;
        if (this.smoothed[2] > 7.8f && this.smoothed[2] < 11.8f) {
            this.gestureState = -1;
        }
        if (this.smoothed[2] < -7.8f && this.smoothed[2] > -11.8f) {
            this.gestureState = 1;
        }
        if (totalGravitySquared < 60.840004f || totalGravitySquared > 139.24f) {
            this.gestureState = 0;
        }
        if (oldState != this.gestureState) {
            this.lastTime = event.timestamp;
        }
        long durationNanos = event.timestamp - this.lastTime;
        switch (this.gestureState) {
            case 1: {
                if (durationNanos <= 250000000L || this.triggerState != 0) break;
                Logger.v("Connection gesture started");
                this.triggerState = 1;
                break;
            }
            case -1: {
                if (durationNanos <= 250000000L || this.triggerState != 1) break;
                Logger.v("Connection gesture completed");
                this.triggerState = 0;
                this.listener.onGesture();
                break;
            }
            case 0: {
                if (durationNanos <= 1000000000L || this.triggerState == 0) break;
                Logger.v("Connection gesture canceled");
                this.triggerState = 0;
            }
        }
    }

    private float[] smoothSamples(float[] samples) {
        for (int i = 0; i < 3; ++i) {
            float old = this.smoothed[i];
            this.smoothed[i] = old + 0.7f * (samples[i] - old);
        }
        return this.smoothed;
    }

    public static interface OnGestureListener {
        public void onGesture();
    }
}

