/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import com.clevertap.android.sdk.GifDecoder;

class GifImageView
extends AppCompatImageView
implements Runnable {
    private static final String TAG = "GifDecoderView";
    private boolean animating;
    private OnAnimationStart animationStartCallback = null;
    private OnAnimationStop animationStopCallback = null;
    private Thread animationThread;
    private OnFrameAvailable frameCallback = null;
    private long framesDisplayDuration = -1L;
    private GifDecoder gifDecoder;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private boolean renderFrame;
    private boolean shouldClear;
    private Bitmap tmpBitmap;
    private final Runnable cleanupRunnable = new Runnable(){

        @Override
        public void run() {
            GifImageView.this.tmpBitmap = null;
            GifImageView.this.gifDecoder = null;
            GifImageView.this.animationThread = null;
            GifImageView.this.shouldClear = false;
        }
    };
    private final Runnable updateResults = new Runnable(){

        @Override
        public void run() {
            if (GifImageView.this.tmpBitmap != null && !GifImageView.this.tmpBitmap.isRecycled()) {
                GifImageView.this.setImageBitmap(GifImageView.this.tmpBitmap);
                GifImageView.this.setScaleType(ImageView.ScaleType.FIT_CENTER);
            }
        }
    };

    public GifImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public GifImageView(Context context) {
        super(context);
    }

    public void clear() {
        this.animating = false;
        this.renderFrame = false;
        this.shouldClear = true;
        this.stopAnimation();
        this.handler.post(this.cleanupRunnable);
    }

    public int getFrameCount() {
        return this.gifDecoder.getFrameCount();
    }

    public long getFramesDisplayDuration() {
        return this.framesDisplayDuration;
    }

    public void setFramesDisplayDuration(long framesDisplayDuration) {
        this.framesDisplayDuration = framesDisplayDuration;
    }

    public int getGifHeight() {
        return this.gifDecoder.getHeight();
    }

    public int getGifWidth() {
        return this.gifDecoder.getWidth();
    }

    public OnAnimationStop getOnAnimationStop() {
        return this.animationStopCallback;
    }

    public void setOnAnimationStop(OnAnimationStop animationStop) {
        this.animationStopCallback = animationStop;
    }

    public OnFrameAvailable getOnFrameAvailable() {
        return this.frameCallback;
    }

    public void setOnFrameAvailable(OnFrameAvailable frameProcessor) {
        this.frameCallback = frameProcessor;
    }

    public void gotoFrame(int frame) {
        if (this.gifDecoder.getCurrentFrameIndex() == frame) {
            return;
        }
        if (this.gifDecoder.setFrameIndex(frame - 1) && !this.animating) {
            this.renderFrame = true;
            this.startAnimationThread();
        }
    }

    public boolean isAnimating() {
        return this.animating;
    }

    public void resetAnimation() {
        this.gifDecoder.resetLoopIndex();
        this.gotoFrame(0);
    }

    @Override
    public void run() {
        if (this.animationStartCallback != null) {
            this.animationStartCallback.onAnimationStart();
        }
        while (this.animating || this.renderFrame) {
            boolean advance = this.gifDecoder.advance();
            long frameDecodeTime = 0L;
            try {
                long before = System.nanoTime();
                this.tmpBitmap = this.gifDecoder.getNextFrame();
                if (this.frameCallback != null) {
                    this.tmpBitmap = this.frameCallback.onFrameAvailable(this.tmpBitmap);
                }
                frameDecodeTime = (System.nanoTime() - before) / 1000000L;
                this.handler.post(this.updateResults);
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException before) {
                // empty catch block
            }
            this.renderFrame = false;
            if (!this.animating || !advance) {
                this.animating = false;
                break;
            }
            try {
                int delay = this.gifDecoder.getNextDelay();
                delay = (int)((long)delay - frameDecodeTime);
                if (delay > 0) {
                    Thread.sleep(this.framesDisplayDuration > 0L ? this.framesDisplayDuration : (long)delay);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.animating) continue;
        }
        if (this.shouldClear) {
            this.handler.post(this.cleanupRunnable);
        }
        this.animationThread = null;
        if (this.animationStopCallback != null) {
            this.animationStopCallback.onAnimationStop();
        }
    }

    public void setBytes(byte[] bytes) {
        this.gifDecoder = new GifDecoder();
        try {
            this.gifDecoder.read(bytes);
        }
        catch (Exception e) {
            this.gifDecoder = null;
            return;
        }
        if (this.animating) {
            this.startAnimationThread();
        } else {
            this.gotoFrame(0);
        }
    }

    public void setOnAnimationStart(OnAnimationStart animationStart) {
        this.animationStartCallback = animationStart;
    }

    public void startAnimation() {
        this.animating = true;
        this.startAnimationThread();
    }

    public void stopAnimation() {
        this.animating = false;
        if (this.animationThread != null) {
            this.animationThread.interrupt();
            this.animationThread = null;
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.clear();
    }

    private boolean canStart() {
        return (this.animating || this.renderFrame) && this.gifDecoder != null && this.animationThread == null;
    }

    private void startAnimationThread() {
        if (this.canStart()) {
            this.animationThread = new Thread(this);
            this.animationThread.start();
        }
    }

    public static interface OnAnimationStart {
        public void onAnimationStart();
    }

    public static interface OnAnimationStop {
        public void onAnimationStop();
    }

    public static interface OnFrameAvailable {
        public Bitmap onFrameAvailable(Bitmap var1);
    }
}

