/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class CTExecutors {
    private static CTExecutors sInstance;
    private final Executor diskIO;
    private final Executor mainThread;

    public static synchronized CTExecutors getInstance() {
        if (sInstance == null) {
            sInstance = new CTExecutors(Executors.newSingleThreadExecutor(), new MainThreadExecutor());
        }
        return sInstance;
    }

    private CTExecutors(Executor diskIO, Executor mainThread) {
        this.diskIO = diskIO;
        this.mainThread = mainThread;
    }

    public Executor diskIO() {
        return this.diskIO;
    }

    public Executor mainThread() {
        return this.mainThread;
    }

    private static class MainThreadExecutor
    implements Executor {
        private final Handler mainThreadHandler = new Handler(Looper.getMainLooper());

        private MainThreadExecutor() {
        }

        @Override
        public void execute(@NonNull Runnable command) {
            this.mainThreadHandler.post(command);
        }
    }
}

