/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.app.Activity;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.fragment.app.FragmentActivity;
import com.clevertap.android.sdk.CTInAppBaseFragment;
import com.clevertap.android.sdk.CloseImageView;
import com.clevertap.android.sdk.InAppNotificationActivity;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.Utils;

public abstract class CTInAppBaseFullFragment
extends CTInAppBaseFragment {
    void addCloseImageView(final RelativeLayout relativeLayout, final CloseImageView closeImageView) {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                int margin = closeImageView.getMeasuredWidth() / 2;
                closeImageView.setX(relativeLayout.getRight() - margin);
                closeImageView.setY(relativeLayout.getTop() - margin);
            }
        });
    }

    @Override
    void cleanup() {
    }

    @Override
    void generateListener() {
        if ((FragmentActivity)this.context instanceof InAppNotificationActivity) {
            this.setListener((CTInAppBaseFragment.InAppListener)this.context);
        }
    }

    boolean isTablet() {
        if (Utils.isActivityDead((Activity)this.getActivity())) {
            return false;
        }
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        if (wm == null) {
            Logger.v("Screen size is null ");
            return false;
        }
        DisplayMetrics dm = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(dm);
        float yInches = (float)dm.heightPixels / dm.ydpi;
        float xInches = (float)dm.widthPixels / dm.xdpi;
        double diagonalInches = Math.sqrt(xInches * xInches + yInches * yInches);
        if (diagonalInches >= 7.0) {
            Logger.v("Screen size is : " + diagonalInches);
            return true;
        }
        Logger.v("Screen size is : " + diagonalInches);
        return false;
    }

    void redrawHalfInterstitialInApp(RelativeLayout relativeLayout, FrameLayout.LayoutParams layoutParams, CloseImageView closeImageView) {
        layoutParams.height = (int)((float)relativeLayout.getMeasuredWidth() * 1.3f);
        relativeLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.addCloseImageView(relativeLayout, closeImageView);
    }

    void redrawHalfInterstitialMobileInAppOnTablet(RelativeLayout relativeLayout, FrameLayout.LayoutParams layoutParams, CloseImageView closeImageView) {
        layoutParams.setMargins(this.getScaledPixels(140), this.getScaledPixels(140), this.getScaledPixels(140), this.getScaledPixels(140));
        layoutParams.width = relativeLayout.getMeasuredWidth() - this.getScaledPixels(210);
        layoutParams.height = (int)((float)layoutParams.width * 1.3f);
        relativeLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.addCloseImageView(relativeLayout, closeImageView);
    }

    void redrawInterstitialInApp(RelativeLayout relativeLayout, FrameLayout.LayoutParams layoutParams, CloseImageView closeImageView) {
        layoutParams.height = (int)((float)relativeLayout.getMeasuredWidth() * 1.78f);
        relativeLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.addCloseImageView(relativeLayout, closeImageView);
    }

    void redrawInterstitialMobileInAppOnTablet(RelativeLayout relativeLayout, FrameLayout.LayoutParams layoutParams, FrameLayout fl, CloseImageView closeImageView) {
        int requiredHeight;
        int aspectHeight = (int)((float)(relativeLayout.getMeasuredWidth() - this.getScaledPixels(200)) * 1.78f);
        if (aspectHeight > (requiredHeight = fl.getMeasuredHeight() - this.getScaledPixels(280))) {
            layoutParams.height = requiredHeight;
            layoutParams.width = (int)((float)requiredHeight / 1.78f);
        } else {
            layoutParams.height = aspectHeight;
            layoutParams.width = relativeLayout.getMeasuredWidth() - this.getScaledPixels(200);
        }
        layoutParams.setMargins(this.getScaledPixels(140), this.getScaledPixels(140), this.getScaledPixels(140), this.getScaledPixels(140));
        relativeLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.addCloseImageView(relativeLayout, closeImageView);
    }

    void redrawInterstitialTabletInApp(RelativeLayout relativeLayout, FrameLayout.LayoutParams layoutParams, FrameLayout fl, CloseImageView closeImageView) {
        int requiredHeight;
        int aspectHeight = (int)((float)relativeLayout.getMeasuredWidth() * 1.78f);
        if (aspectHeight > (requiredHeight = fl.getMeasuredHeight() - this.getScaledPixels(80))) {
            layoutParams.height = requiredHeight;
            layoutParams.width = (int)((float)requiredHeight / 1.78f);
        } else {
            layoutParams.height = aspectHeight;
        }
        relativeLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.addCloseImageView(relativeLayout, closeImageView);
    }

    void redrawLandscapeInterstitialInApp(RelativeLayout relativeLayout, FrameLayout.LayoutParams layoutParams, CloseImageView closeImageView) {
        layoutParams.width = (int)((float)relativeLayout.getMeasuredHeight() * 1.78f);
        layoutParams.gravity = 1;
        relativeLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.addCloseImageView(relativeLayout, closeImageView);
    }

    void redrawLandscapeInterstitialMobileInAppOnTablet(RelativeLayout relativeLayout, FrameLayout.LayoutParams layoutParams, FrameLayout fl, CloseImageView closeImageView) {
        int requiredWidth;
        int aspectWidth = (int)((float)relativeLayout.getMeasuredHeight() * 1.78f);
        if (aspectWidth > (requiredWidth = fl.getMeasuredWidth() - this.getScaledPixels(80))) {
            layoutParams.width = requiredWidth;
            layoutParams.height = (int)((float)requiredWidth / 1.78f);
        } else {
            layoutParams.width = aspectWidth;
        }
        layoutParams.gravity = 17;
        relativeLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.addCloseImageView(relativeLayout, closeImageView);
    }

    void redrawLandscapeInterstitialTabletInApp(RelativeLayout relativeLayout, FrameLayout.LayoutParams layoutParams, FrameLayout fl, CloseImageView closeImageView) {
        int requiredWidth;
        int aspectWidth = (int)((float)(relativeLayout.getMeasuredHeight() - this.getScaledPixels(120)) * 1.78f);
        if (aspectWidth > (requiredWidth = fl.getMeasuredWidth() - this.getScaledPixels(280))) {
            layoutParams.width = requiredWidth;
            layoutParams.height = (int)((float)requiredWidth / 1.78f);
        } else {
            layoutParams.width = aspectWidth;
            layoutParams.height = relativeLayout.getMeasuredHeight() - this.getScaledPixels(120);
        }
        layoutParams.setMargins(this.getScaledPixels(140), this.getScaledPixels(100), this.getScaledPixels(140), this.getScaledPixels(100));
        layoutParams.gravity = 17;
        relativeLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.addCloseImageView(relativeLayout, closeImageView);
    }
}

