/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.displayunits;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;

public enum CTDisplayUnitType {
    SIMPLE("simple"),
    SIMPLE_WITH_IMAGE("simple-image"),
    CAROUSEL("carousel"),
    CAROUSEL_WITH_IMAGE("carousel-image"),
    MESSAGE_WITH_ICON("message-icon"),
    CUSTOM_KEY_VALUE("custom-key-value");

    private final String type;

    private CTDisplayUnitType(String type) {
        this.type = type;
    }

    @Nullable
    public static CTDisplayUnitType type(String type) {
        if (!TextUtils.isEmpty((CharSequence)type)) {
            switch (type) {
                case "simple": {
                    return SIMPLE;
                }
                case "simple-image": {
                    return SIMPLE_WITH_IMAGE;
                }
                case "carousel": {
                    return CAROUSEL;
                }
                case "carousel-image": {
                    return CAROUSEL_WITH_IMAGE;
                }
                case "message-icon": {
                    return MESSAGE_WITH_ICON;
                }
                case "custom-key-value": {
                    return CUSTOM_KEY_VALUE;
                }
            }
        }
        Log.d((String)"DisplayUnit : ", (String)"Unsupported Display Unit Type");
        return null;
    }

    @NonNull
    public String toString() {
        return this.type;
    }
}

