/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.text.TextUtils;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.json.JSONObject;

public class FileUtils {
    public static void writeJsonToFile(Context context, CleverTapInstanceConfig config, String dirName, String fileName, JSONObject jsonObject) {
        block4: {
            try {
                if (jsonObject == null || TextUtils.isEmpty((CharSequence)dirName) || TextUtils.isEmpty((CharSequence)fileName)) {
                    return;
                }
                File file = new File(context.getFilesDir(), dirName);
                if (!file.exists() && !file.mkdir()) {
                    return;
                }
                File file1 = new File(file, fileName);
                FileWriter writer = new FileWriter(file1, false);
                writer.append(jsonObject.toString());
                writer.flush();
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (config == null) break block4;
                config.getLogger().verbose(config.getAccountId(), "writeFileOnInternalStorage: failed" + e.getLocalizedMessage());
            }
        }
    }

    public static String readFromFile(Context context, CleverTapInstanceConfig config, String fileNameWithPath) throws Exception {
        String content;
        block3: {
            content = "";
            try {
                String yourFilePath = context.getFilesDir() + "/" + fileNameWithPath;
                File yourFile = new File(yourFilePath);
                FileInputStream inputStream = new FileInputStream(yourFile);
                StringBuilder stringBuilder = new StringBuilder();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String receiveString = "";
                while ((receiveString = bufferedReader.readLine()) != null) {
                    stringBuilder.append(receiveString);
                }
                ((InputStream)inputStream).close();
                content = stringBuilder.toString();
            }
            catch (Exception e) {
                if (config == null) break block3;
                config.getLogger().verbose(config.getAccountId(), "[Exception While Reading: " + e.getLocalizedMessage());
            }
        }
        return content;
    }

    public static void deleteDirectory(Context context, CleverTapInstanceConfig config, String dirName) {
        block5: {
            if (TextUtils.isEmpty((CharSequence)dirName) || context == null) {
                return;
            }
            try {
                File file = new File(context.getFilesDir(), dirName);
                if (file.exists() && file.isDirectory()) {
                    String[] children;
                    for (String child : children = file.list()) {
                        new File(file, child).delete();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (config == null) break block5;
                config.getLogger().verbose(config.getAccountId(), "writeFileOnInternalStorage: failed" + dirName + " Error:" + e.getLocalizedMessage());
            }
        }
    }

    public static void deleteFile(Context context, CleverTapInstanceConfig config, String fileName) throws Exception {
        block8: {
            if (TextUtils.isEmpty((CharSequence)fileName) || context == null) {
                return;
            }
            try {
                File file = new File(context.getFilesDir(), fileName);
                if (file.exists()) {
                    if (file.delete()) {
                        if (config != null) {
                            config.getLogger().verbose(config.getAccountId(), "File Deleted:" + fileName);
                        }
                    } else if (config != null) {
                        config.getLogger().verbose(config.getAccountId(), "Failed to delete file" + fileName);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (config == null) break block8;
                config.getLogger().verbose(config.getAccountId(), "writeFileOnInternalStorage: failed" + fileName + " Error:" + e.getLocalizedMessage());
            }
        }
    }
}

