/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.product_config;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.util.Log;
import java.io.IOException;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParserException;

public class DefaultXmlParser {
    private static final String XML_TAG_ENTRY = "entry";
    private static final String XML_TAG_KEY = "key";
    private static final String XML_TAG_VALUE = "value";
    private static final int XML_TAG_TYPE_KEY = 0;
    private static final int XML_TAG_TYPE_VALUE = 1;

    static HashMap<String, String> getDefaultsFromXml(Context context, int resourceId) {
        HashMap<String, String> defaultsMap = new HashMap<String, String>();
        try {
            Resources resources = context.getResources();
            if (resources == null) {
                Log.e((String)"ProductConfig", (String)"Could not find the resources of the current context while trying to set defaults from an XML.");
                return defaultsMap;
            }
            XmlResourceParser xmlParser = resources.getXml(resourceId);
            String curTag = null;
            String key = null;
            String value = null;
            int eventType = xmlParser.getEventType();
            while (eventType != 1) {
                if (eventType == 2) {
                    curTag = xmlParser.getName();
                } else if (eventType != 3) {
                    if (eventType == 4 && curTag != null) {
                        int tagType = -1;
                        switch (curTag) {
                            case "key": {
                                tagType = 0;
                                break;
                            }
                            case "value": {
                                tagType = 1;
                            }
                        }
                        switch (tagType) {
                            case 0: {
                                key = xmlParser.getText();
                                break;
                            }
                            case 1: {
                                value = xmlParser.getText();
                                break;
                            }
                            default: {
                                Log.w((String)"Product Config : ", (String)"Encountered an unexpected tag while parsing the defaults XML.");
                                break;
                            }
                        }
                    }
                } else {
                    if (xmlParser.getName().equals(XML_TAG_ENTRY)) {
                        if (key != null && value != null) {
                            defaultsMap.put(key, value);
                        } else {
                            Log.w((String)"Product Config : ", (String)"An entry in the defaults XML has an invalid key and/or value tag.");
                        }
                        key = null;
                        value = null;
                    }
                    curTag = null;
                }
                eventType = xmlParser.next();
            }
        }
        catch (IOException | XmlPullParserException var11) {
            Log.e((String)"ProductConfig", (String)"Encountered an error while parsing the defaults XML file.", (Throwable)var11);
        }
        return defaultsMap;
    }
}

