/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.clevertap.android.sdk.CTInAppNotification;
import com.clevertap.android.sdk.CTInAppNotificationButton;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.CloseImageView;
import com.clevertap.android.sdk.Utils;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class CTInAppBaseFragment
extends Fragment {
    CTInAppNotification inAppNotification;
    CleverTapInstanceConfig config;
    private WeakReference<InAppListener> listenerWeakReference;
    CloseImageView closeImageView = null;
    int currentOrientation;
    Activity parent;
    AtomicBoolean isCleanedUp = new AtomicBoolean();

    void didClick(Bundle data, HashMap<String, String> keyValueMap) {
        InAppListener listener = this.getListener();
        if (listener != null) {
            listener.inAppNotificationDidClick(this.inAppNotification, data, keyValueMap);
        }
    }

    void setListener(InAppListener listener) {
        this.listenerWeakReference = new WeakReference<InAppListener>(listener);
    }

    InAppListener getListener() {
        InAppListener listener = null;
        try {
            listener = (InAppListener)this.listenerWeakReference.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (listener == null) {
            this.config.getLogger().verbose(this.config.getAccountId(), "InAppListener is null for notification: " + this.inAppNotification.getJsonDescription());
        }
        return listener;
    }

    abstract void cleanup();

    abstract void generateListener();

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.parent = activity;
        Bundle bundle = this.getArguments();
        this.inAppNotification = (CTInAppNotification)bundle.getParcelable("inApp");
        this.config = (CleverTapInstanceConfig)bundle.getParcelable("config");
        this.currentOrientation = this.getResources().getConfiguration().orientation;
        this.generateListener();
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.didShow(null);
    }

    void handleButtonClickAtIndex(int index) {
        try {
            CTInAppNotificationButton button = this.inAppNotification.getButtons().get(index);
            Bundle data = new Bundle();
            data.putString("wzrk_id", this.inAppNotification.getCampaignId());
            data.putString("wzrk_c2a", button.getText());
            this.didClick(data, button.getKeyValues());
            String actionUrl = button.getActionUrl();
            if (actionUrl != null) {
                this.fireUrlThroughIntent(actionUrl, data);
                return;
            }
            this.didDismiss(data);
        }
        catch (Throwable t) {
            this.config.getLogger().debug("Error handling notification button click: " + t.getCause());
            this.didDismiss(null);
        }
    }

    void didShow(Bundle data) {
        InAppListener listener = this.getListener();
        if (listener != null) {
            listener.inAppNotificationDidShow(this.inAppNotification, data);
        }
    }

    void didDismiss(Bundle data) {
        this.cleanup();
        InAppListener listener = this.getListener();
        if (listener != null && this.getActivity() != null && this.getActivity().getBaseContext() != null) {
            listener.inAppNotificationDidDismiss(this.getActivity().getBaseContext(), this.inAppNotification, data);
        }
    }

    void fireUrlThroughIntent(String url, Bundle formData) {
        try {
            Uri uri = Uri.parse((String)url.replace("\n", "").replace("\r", ""));
            Set queryParamSet = uri.getQueryParameterNames();
            Bundle queryBundle = new Bundle();
            if (queryParamSet != null && !queryParamSet.isEmpty()) {
                for (String queryName : queryParamSet) {
                    queryBundle.putString(queryName, uri.getQueryParameter(queryName));
                }
            }
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            if (!queryBundle.isEmpty()) {
                intent.putExtras(queryBundle);
            }
            Utils.setPackageNameFromResolveInfoList((Context)this.getActivity(), intent);
            this.startActivity(intent);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.didDismiss(formData);
    }

    int getScaledPixels(int raw) {
        return (int)TypedValue.applyDimension((int)1, (float)raw, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    class CTInAppNativeButtonClickListener
    implements View.OnClickListener {
        CTInAppNativeButtonClickListener() {
        }

        public void onClick(View view) {
            CTInAppBaseFragment.this.handleButtonClickAtIndex((Integer)view.getTag());
        }
    }

    static interface InAppListener {
        public void inAppNotificationDidShow(CTInAppNotification var1, Bundle var2);

        public void inAppNotificationDidClick(CTInAppNotification var1, Bundle var2, HashMap<String, String> var3);

        public void inAppNotificationDidDismiss(Context var1, CTInAppNotification var2, Bundle var3);
    }
}

