/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.ab_testing;

import com.clevertap.android.sdk.ab_testing.CTVar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;

final class CTVarCache {
    private final Map<String, CTVar> vars = new ConcurrentHashMap<String, CTVar>();

    CTVarCache() {
    }

    void registerVar(String name, CTVar.CTVarType type, Object value) {
        CTVar var = this.getVar(name);
        if (var == null) {
            this.vars.put(name, new CTVar(name, type, value));
        } else if (value != null) {
            var.update(type, value);
        }
    }

    CTVar getVar(String name) {
        return this.vars.get(name);
    }

    void clearVar(String name) {
        CTVar var = this.getVar(name);
        if (var != null) {
            var.clearValue();
        }
    }

    void reset() {
        for (String name : new HashMap<String, CTVar>(this.vars).keySet()) {
            this.clearVar(name);
        }
    }

    JSONArray serializeVars() {
        JSONArray serialized = new JSONArray();
        for (String name : new HashMap<String, CTVar>(this.vars).keySet()) {
            CTVar var = this.vars.get(name);
            if (var == null) continue;
            serialized.put((Object)var.toJSON());
        }
        return serialized;
    }
}

