/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk.ab_testing.uieditor;

import android.app.Activity;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.util.Base64OutputStream;
import android.util.DisplayMetrics;
import android.util.JsonWriter;
import android.util.LruCache;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ab_testing.uieditor.ResourceIds;
import com.clevertap.android.sdk.ab_testing.uieditor.UIEditor;
import com.clevertap.android.sdk.ab_testing.uieditor.ViewProperty;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONObject;

final class SnapshotBuilder {
    private static final int MAX_CLASS_CACHE_SIZE = 255;
    private static final Handler mainThreadHandler = new Handler(Looper.getMainLooper());
    private static final RootViewsGenerator rootViewsGenerator = new RootViewsGenerator();
    private static final ClassCache classCache = new ClassCache(255);

    SnapshotBuilder() {
    }

    private static Logger getConfigLogger(CleverTapInstanceConfig config) {
        return config.getLogger();
    }

    private static String getAccountId(CleverTapInstanceConfig config) {
        return config.getAccountId();
    }

    static void writeSnapshot(ViewSnapshotConfig snapshotConfig, UIEditor.ActivitySet liveActivities, OutputStream out, CleverTapInstanceConfig config) throws IOException {
        rootViewsGenerator.findInActivities(liveActivities);
        FutureTask<List<RootView>> rootViewsFuture = new FutureTask<List<RootView>>(rootViewsGenerator);
        mainThreadHandler.post(rootViewsFuture);
        OutputStreamWriter writer = new OutputStreamWriter(out);
        List<Object> rootViewList = Collections.emptyList();
        writer.write("[");
        try {
            rootViewList = rootViewsFuture.get(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            SnapshotBuilder.getConfigLogger(config).debug(SnapshotBuilder.getAccountId(config), "Screenshot interrupted.", e);
        }
        catch (TimeoutException e) {
            SnapshotBuilder.getConfigLogger(config).debug(SnapshotBuilder.getAccountId(config), "Screenshot timed out.", e);
        }
        catch (ExecutionException e) {
            SnapshotBuilder.getConfigLogger(config).verbose(SnapshotBuilder.getAccountId(config), "Screenshot error", e);
        }
        int viewCount = rootViewList.size();
        for (int i = 0; i < viewCount; ++i) {
            if (i > 0) {
                writer.write(",");
            }
            RootView rootView = (RootView)rootViewList.get(i);
            writer.write("{");
            writer.write("\"activity\":");
            writer.write(JSONObject.quote((String)rootView.activityName));
            writer.write(",");
            writer.write("\"scale\":");
            writer.write(String.format("%s", Float.valueOf(rootView.scale)));
            writer.write(",");
            writer.write("\"orientation\":");
            writer.write(JSONObject.quote((String)rootView.orientation));
            writer.write(",");
            writer.write("\"serialized_objects\":");
            JsonWriter j = new JsonWriter((Writer)writer);
            j.beginObject();
            j.name("rootObject").value((long)rootView.rootView.hashCode());
            j.name("objects");
            SnapshotBuilder.viewHierarchySnapshot(j, rootView.rootView, snapshotConfig);
            j.endObject();
            j.flush();
            writer.write(",");
            writer.write("\"screenshot\":");
            writer.flush();
            rootView.screenshot.writeJSON(Bitmap.CompressFormat.PNG, 100, out);
            writer.write("}");
        }
        writer.write("]");
        writer.flush();
    }

    private static void viewHierarchySnapshot(JsonWriter j, View rootView, ViewSnapshotConfig snapshotConfig) throws IOException {
        j.beginArray();
        SnapshotBuilder.viewSnapshot(j, rootView, snapshotConfig);
        j.endArray();
    }

    private static void viewSnapshot(JsonWriter j, View view, ViewSnapshotConfig snapshotConfig) throws IOException {
        ViewGroup group;
        int viewId = view.getId();
        String viewName = viewId == -1 ? null : snapshotConfig.resourceIds.nameForId(viewId);
        j.beginObject();
        j.name("hashCode").value((long)view.hashCode());
        j.name("id").value((long)viewId);
        j.name("ct_id_name").value(viewName);
        CharSequence contentDescription = view.getContentDescription();
        if (contentDescription == null) {
            j.name("contentDescription").nullValue();
        } else {
            j.name("contentDescription").value(contentDescription.toString());
        }
        Object tag = view.getTag();
        if (tag == null) {
            j.name("tag").nullValue();
        } else if (tag instanceof CharSequence) {
            j.name("tag").value(tag.toString());
        }
        j.name("top").value((long)view.getTop());
        j.name("left").value((long)view.getLeft());
        j.name("width").value((long)view.getWidth());
        j.name("height").value((long)view.getHeight());
        j.name("scrollX").value((long)view.getScrollX());
        j.name("scrollY").value((long)view.getScrollY());
        j.name("visibility").value((long)view.getVisibility());
        float transX = view.getTranslationX();
        float transY = view.getTranslationY();
        j.name("translationX").value((double)transX);
        j.name("translationY").value((double)transY);
        j.name("classes");
        j.beginArray();
        Class<?> klass = view.getClass();
        do {
            j.value((String)classCache.get(klass));
        } while ((klass = klass.getSuperclass()) != Object.class && klass != null);
        j.endArray();
        SnapshotBuilder.writeViewProperties(j, view, snapshotConfig);
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams instanceof RelativeLayout.LayoutParams) {
            RelativeLayout.LayoutParams relativeLayoutParams = (RelativeLayout.LayoutParams)layoutParams;
            int[] rules = relativeLayoutParams.getRules();
            j.name("layoutRules");
            j.beginArray();
            for (int rule : rules) {
                j.value((long)rule);
            }
            j.endArray();
        }
        j.name("subviews");
        j.beginArray();
        if (view instanceof ViewGroup) {
            group = (ViewGroup)view;
            int childCount = group.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = group.getChildAt(i);
                if (child == null) continue;
                j.value((long)child.hashCode());
            }
        }
        j.endArray();
        j.endObject();
        if (view instanceof ViewGroup) {
            group = (ViewGroup)view;
            int childCount = group.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = group.getChildAt(i);
                if (child == null) continue;
                SnapshotBuilder.viewSnapshot(j, child, snapshotConfig);
            }
        }
    }

    private static void writeViewProperties(JsonWriter j, View v, ViewSnapshotConfig snapshotConfig) throws IOException {
        Class<?> viewClass = v.getClass();
        for (ViewProperty desc : snapshotConfig.propertyDescriptionList) {
            Object value;
            if (!desc.target.isAssignableFrom(viewClass) || null == desc.accessor || null == (value = desc.accessor.invokeMethod(v))) continue;
            if (value instanceof Boolean) {
                j.name(desc.name).value(((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Number) {
                j.name(desc.name).value((Number)value);
                continue;
            }
            if (value instanceof ColorStateList) {
                j.name(desc.name).value((Number)((ColorStateList)value).getDefaultColor());
                continue;
            }
            if (value instanceof Drawable) {
                Drawable drawable2 = (Drawable)value;
                Rect bounds = drawable2.getBounds();
                j.name(desc.name);
                j.beginObject();
                j.name("classes");
                j.beginArray();
                Class<?> klass = drawable2.getClass();
                while (klass != Object.class) {
                    if (klass == null) continue;
                    j.value(klass.getCanonicalName());
                    klass = klass.getSuperclass();
                }
                j.endArray();
                j.name("dimensions");
                j.beginObject();
                j.name("left").value((long)bounds.left);
                j.name("right").value((long)bounds.right);
                j.name("top").value((long)bounds.top);
                j.name("bottom").value((long)bounds.bottom);
                j.endObject();
                if (drawable2 instanceof ColorDrawable) {
                    ColorDrawable colorDrawable = (ColorDrawable)drawable2;
                    j.name("color").value((long)colorDrawable.getColor());
                }
                j.endObject();
                continue;
            }
            j.name(desc.name).value(value.toString());
        }
    }

    private static class RootViewsGenerator
    implements Callable<List<RootView>> {
        private UIEditor.ActivitySet activitySet;
        private final List<RootView> rootViews;
        private final DisplayMetrics displayMetrics = new DisplayMetrics();
        private final Screenshot screenshot;
        private final int clientDensity = 160;

        RootViewsGenerator() {
            this.rootViews = new ArrayList<RootView>();
            this.screenshot = new Screenshot();
        }

        void findInActivities(UIEditor.ActivitySet activitySet) {
            this.activitySet = activitySet;
        }

        @Override
        public List<RootView> call() {
            this.rootViews.clear();
            Set<Activity> activities = this.activitySet.getAll();
            for (Activity activity : activities) {
                String activityName = activity.getClass().getCanonicalName();
                int orientation = activity.getResources().getConfiguration().orientation;
                View view = activity.getWindow().getDecorView().getRootView();
                activity.getWindowManager().getDefaultDisplay().getMetrics(this.displayMetrics);
                RootView rootView = new RootView(activityName, view, orientation);
                this.rootViews.add(rootView);
            }
            int viewCount = this.rootViews.size();
            for (int i = 0; i < viewCount; ++i) {
                RootView rootView = this.rootViews.get(i);
                this.takeScreenshot(rootView);
            }
            return this.rootViews;
        }

        private void takeScreenshot(RootView root) {
            View rootView = root.rootView;
            Bitmap bitmap = null;
            try {
                Method createSnapshot = View.class.getDeclaredMethod("createSnapshot", Bitmap.Config.class, Integer.TYPE, Boolean.TYPE);
                createSnapshot.setAccessible(true);
                bitmap = (Bitmap)createSnapshot.invoke((Object)rootView, Bitmap.Config.RGB_565, -1, false);
            }
            catch (NoSuchMethodException e) {
                Logger.v("Can't call createSnapshot, will use drawCache");
            }
            catch (IllegalArgumentException e) {
                Logger.v("Can't call createSnapshot with arguments");
            }
            catch (InvocationTargetException e) {
                Logger.v("Exception when calling createSnapshot", e.getLocalizedMessage());
            }
            catch (IllegalAccessException e) {
                Logger.v("Can't access createSnapshot, using drawCache");
            }
            catch (ClassCastException e) {
                Logger.v("createSnapshot didn't return a bitmap?", e.getLocalizedMessage());
            }
            Boolean originalCacheState = null;
            try {
                if (bitmap == null) {
                    originalCacheState = rootView.isDrawingCacheEnabled();
                    rootView.setDrawingCacheEnabled(true);
                    rootView.buildDrawingCache(true);
                    bitmap = rootView.getDrawingCache();
                }
            }
            catch (RuntimeException e) {
                Logger.v("Error taking a bitmap snapshot of view " + rootView + ", skipping", e);
            }
            float scale = 1.0f;
            if (bitmap != null) {
                int density = bitmap.getDensity();
                if (density != 0) {
                    scale = 160.0f / (float)density;
                }
                int rawWidth = bitmap.getWidth();
                int rawHeight = bitmap.getHeight();
                int destWidth = (int)((double)((float)bitmap.getWidth() * scale) + 0.5);
                int destHeight = (int)((double)((float)bitmap.getHeight() * scale) + 0.5);
                if (rawWidth > 0 && rawHeight > 0 && destWidth > 0 && destHeight > 0) {
                    this.screenshot.regenerate(destWidth, destHeight, 160, bitmap);
                }
            }
            if (originalCacheState != null && !originalCacheState.booleanValue()) {
                rootView.setDrawingCacheEnabled(false);
            }
            root.scale = scale;
            root.screenshot = this.screenshot;
        }
    }

    private static class Screenshot {
        private Bitmap cachedScreenshot = null;
        private final Paint paint = new Paint(2);

        Screenshot() {
        }

        synchronized void regenerate(int width, int height, int destDensity, Bitmap source) {
            if (null == this.cachedScreenshot || this.cachedScreenshot.getWidth() != width || this.cachedScreenshot.getHeight() != height) {
                try {
                    this.cachedScreenshot = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
                }
                catch (OutOfMemoryError e) {
                    this.cachedScreenshot = null;
                }
                if (this.cachedScreenshot != null) {
                    this.cachedScreenshot.setDensity(destDensity);
                }
            }
            if (this.cachedScreenshot != null) {
                Canvas scaledCanvas = new Canvas(this.cachedScreenshot);
                scaledCanvas.drawBitmap(source, 0.0f, 0.0f, this.paint);
            }
        }

        synchronized void writeJSON(Bitmap.CompressFormat format, int quality, OutputStream out) throws IOException {
            if (this.cachedScreenshot == null || this.cachedScreenshot.getWidth() == 0 || this.cachedScreenshot.getHeight() == 0) {
                out.write("null".getBytes());
            } else {
                out.write(34);
                Base64OutputStream imageOut = new Base64OutputStream(out, 2);
                this.cachedScreenshot.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)imageOut);
                imageOut.flush();
                out.write(34);
            }
        }
    }

    private static class RootView {
        private static final String UNSPECIFIED = "unspecified";
        private static final String LANDSCAPE = "landscape";
        private static final String PORTRAIT = "portrait";
        final String activityName;
        final View rootView;
        Screenshot screenshot;
        float scale;
        String orientation = "unspecified";

        RootView(String activityName, View rootView, int activityOrientation) {
            this.activityName = activityName;
            this.rootView = rootView;
            this.screenshot = null;
            this.scale = 1.0f;
            this.setOrientation(activityOrientation);
        }

        private void setOrientation(int orientation) {
            this.orientation = orientation == 2 ? LANDSCAPE : PORTRAIT;
        }
    }

    private static class ClassCache
    extends LruCache<Class<?>, String> {
        ClassCache(int maxSize) {
            super(maxSize);
        }

        protected String create(Class<?> klass) {
            return klass.getCanonicalName();
        }
    }

    static final class ViewSnapshotConfig {
        ResourceIds resourceIds;
        final List<ViewProperty> propertyDescriptionList;

        ViewSnapshotConfig(List<ViewProperty> propertyDescriptions, ResourceIds resourceIds) {
            this.resourceIds = resourceIds;
            this.propertyDescriptionList = propertyDescriptions;
        }
    }
}

