/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import com.clevertap.android.sdk.CTMessageDAO;
import com.clevertap.android.sdk.DBAdapter;
import com.clevertap.android.sdk.Logger;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;

class CTInboxController {
    private static ExecutorService es;
    private static long EXECUTOR_THREAD_ID;
    private ArrayList<CTMessageDAO> messages;
    private String userId;
    private DBAdapter dbAdapter;
    private boolean videoSupported;
    private final Object messagesLock = new Object();

    private static void postAsyncSafely(final String name, final Runnable runnable) {
        try {
            boolean executeSync;
            boolean bl = executeSync = Thread.currentThread().getId() == EXECUTOR_THREAD_ID;
            if (executeSync) {
                runnable.run();
            } else {
                es.submit(new Runnable(){

                    @Override
                    public void run() {
                        EXECUTOR_THREAD_ID = Thread.currentThread().getId();
                        try {
                            Logger.v("CTInboxController Executor Service: Starting task - " + name);
                            runnable.run();
                        }
                        catch (Throwable t) {
                            Logger.v("CTInboxController Executor Service: Failed to complete the scheduled task", t);
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            Logger.v("Failed to submit task to the executor service", t);
        }
    }

    CTInboxController(String guid, DBAdapter adapter, boolean videoSupported) {
        this.userId = guid;
        this.dbAdapter = adapter;
        this.messages = this.dbAdapter.getMessages(this.userId);
        this.videoSupported = videoSupported;
        if (es == null) {
            es = Executors.newFixedThreadPool(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CTMessageDAO findMessageById(String id2) {
        Object object = this.messagesLock;
        synchronized (object) {
            for (CTMessageDAO message : this.messages) {
                if (!message.getId().equals(id2)) continue;
                return message;
            }
        }
        Logger.v("Inbox Message for message id - " + id2 + " not found");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateMessages(JSONArray inboxMessages) {
        boolean haveUpdates = false;
        ArrayList<CTMessageDAO> newMessages = new ArrayList<CTMessageDAO>();
        for (int i = 0; i < inboxMessages.length(); ++i) {
            try {
                CTMessageDAO messageDAO = CTMessageDAO.initWithJSON(inboxMessages.getJSONObject(i), this.userId);
                if (messageDAO == null) continue;
                if (!this.videoSupported && messageDAO.containsVideoOrAudio()) {
                    Logger.d("Dropping inbox message containing video/audio as app does not support video. For more information checkout CleverTap documentation.");
                    continue;
                }
                newMessages.add(messageDAO);
                Logger.v("Inbox Message for message id - " + messageDAO.getId() + " added");
                continue;
            }
            catch (JSONException e) {
                Logger.d("Unable to update notification inbox messages - " + e.getLocalizedMessage());
            }
        }
        if (newMessages.size() > 0) {
            this.dbAdapter.upsertMessages(newMessages);
            haveUpdates = true;
            Logger.v("New Notification Inbox messages added");
            Object object = this.messagesLock;
            synchronized (object) {
                this.messages = this.dbAdapter.getMessages(this.userId);
                this.trimMessages();
            }
        }
        return haveUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deleteMessageWithId(final String messageId) {
        CTMessageDAO messageDAO = this.findMessageById(messageId);
        if (messageDAO == null) {
            return false;
        }
        Object object = this.messagesLock;
        synchronized (object) {
            this.messages.remove(messageDAO);
        }
        CTInboxController.postAsyncSafely("RunDeleteMessage", new Runnable(){

            @Override
            public void run() {
                CTInboxController.this.dbAdapter.deleteMessageForId(messageId, CTInboxController.this.userId);
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean markReadForMessageWithId(final String messageId) {
        CTMessageDAO messageDAO = this.findMessageById(messageId);
        if (messageDAO == null) {
            return false;
        }
        Object object = this.messagesLock;
        synchronized (object) {
            messageDAO.setRead(1);
        }
        CTInboxController.postAsyncSafely("RunMarkMessageRead", new Runnable(){

            @Override
            public void run() {
                CTInboxController.this.dbAdapter.markReadMessageForId(messageId, CTInboxController.this.userId);
            }
        });
        return true;
    }

    CTMessageDAO getMessageForId(String messageId) {
        return this.findMessageById(messageId);
    }

    int count() {
        return this.getMessages().size();
    }

    int unreadCount() {
        return this.getUnreadMessages().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<CTMessageDAO> getMessages() {
        Object object = this.messagesLock;
        synchronized (object) {
            this.trimMessages();
            return this.messages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<CTMessageDAO> getUnreadMessages() {
        ArrayList<CTMessageDAO> unread = new ArrayList<CTMessageDAO>();
        Object object = this.messagesLock;
        synchronized (object) {
            ArrayList<CTMessageDAO> messages = this.getMessages();
            for (CTMessageDAO message : messages) {
                if (message.isRead() != 0) continue;
                unread.add(message);
            }
        }
        return unread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimMessages() {
        ArrayList<CTMessageDAO> toDelete = new ArrayList<CTMessageDAO>();
        Object object = this.messagesLock;
        synchronized (object) {
            for (CTMessageDAO message : this.messages) {
                if (!this.videoSupported && message.containsVideoOrAudio()) {
                    Logger.d("Removing inbox message containing video/audio as app does not support video. For more information checkout CleverTap documentation.");
                    toDelete.add(message);
                    continue;
                }
                long expires = message.getExpires();
                boolean expired = expires > 0L && System.currentTimeMillis() / 1000L > expires;
                if (!expired) continue;
                Logger.v("Inbox Message: " + message.getId() + " is expired - removing");
                toDelete.add(message);
            }
            if (toDelete.size() <= 0) {
                return;
            }
            for (CTMessageDAO message : toDelete) {
                this.deleteMessageWithId(message.getId());
            }
        }
    }

    static {
        EXECUTOR_THREAD_ID = 0L;
    }
}

