/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.DBAdapter;
import com.clevertap.android.sdk.EventDetail;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.SyncListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class LocalDataStore {
    private Context context;
    private CleverTapInstanceConfig config;
    private DBAdapter dbAdapter;
    private final HashMap<String, Object> PROFILE_FIELDS_IN_THIS_SESSION = new HashMap();
    private final String eventNamespace = "local_events";
    private ExecutorService es;
    private static long EXECUTOR_THREAD_ID = 0L;
    private final HashMap<String, Integer> PROFILE_EXPIRY_MAP = new HashMap();

    LocalDataStore(Context context, CleverTapInstanceConfig config) {
        this.context = context;
        this.config = config;
        this.es = Executors.newFixedThreadPool(1);
        this.inflateLocalProfileAsync(context);
    }

    private Logger getConfigLogger() {
        return this.config.getLogger();
    }

    private String getConfigAccountId() {
        return this.config.getAccountId();
    }

    private void postAsyncSafely(final String name, final Runnable runnable) {
        try {
            boolean executeSync;
            boolean bl = executeSync = Thread.currentThread().getId() == EXECUTOR_THREAD_ID;
            if (executeSync) {
                runnable.run();
            } else {
                this.es.submit(new Runnable(){

                    @Override
                    public void run() {
                        EXECUTOR_THREAD_ID = Thread.currentThread().getId();
                        try {
                            LocalDataStore.this.getConfigLogger().verbose(LocalDataStore.this.getConfigAccountId(), "Local Data Store Executor service: Starting task - " + name);
                            runnable.run();
                        }
                        catch (Throwable t) {
                            LocalDataStore.this.getConfigLogger().verbose(LocalDataStore.this.getConfigAccountId(), "Executor service: Failed to complete the scheduled task", t);
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to submit task to the executor service", t);
        }
    }

    private void inflateLocalProfileAsync(final Context context) {
        final String accountID = this.config.getAccountId();
        this.postAsyncSafely("LocalDataStore#inflateLocalProfileAsync", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (LocalDataStore.this.dbAdapter == null) {
                    LocalDataStore.this.dbAdapter = new DBAdapter(context, LocalDataStore.this.config);
                }
                HashMap hashMap = LocalDataStore.this.PROFILE_FIELDS_IN_THIS_SESSION;
                synchronized (hashMap) {
                    try {
                        JSONObject profile = LocalDataStore.this.dbAdapter.fetchUserProfileById(accountID);
                        if (profile == null) {
                            return;
                        }
                        Iterator keys = profile.keys();
                        while (keys.hasNext()) {
                            try {
                                String key = (String)keys.next();
                                Object value = profile.get(key);
                                if (value instanceof JSONObject) {
                                    JSONObject jsonObject = profile.getJSONObject(key);
                                    LocalDataStore.this.PROFILE_FIELDS_IN_THIS_SESSION.put(key, jsonObject);
                                    continue;
                                }
                                if (value instanceof JSONArray) {
                                    JSONArray jsonArray = profile.getJSONArray(key);
                                    LocalDataStore.this.PROFILE_FIELDS_IN_THIS_SESSION.put(key, jsonArray);
                                    continue;
                                }
                                LocalDataStore.this.PROFILE_FIELDS_IN_THIS_SESSION.put(key, value);
                            }
                            catch (JSONException jSONException) {}
                        }
                        LocalDataStore.this.getConfigLogger().verbose(LocalDataStore.this.getConfigAccountId(), "Local Data Store - Inflated local profile " + LocalDataStore.this.PROFILE_FIELDS_IN_THIS_SESSION.toString());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        });
    }

    void setDataSyncFlag(JSONObject event) {
        try {
            String evtName;
            boolean enablePersonalisation = this.config.isPersonalizationEnabled();
            if (!enablePersonalisation) {
                event.put("dsync", false);
                return;
            }
            String eventType = event.getString("type");
            if ("event".equals(eventType) && "App Launched".equals(evtName = event.getString("evtName"))) {
                this.getConfigLogger().verbose(this.getConfigAccountId(), "Local cache needs to be updated (triggered by App Launched)");
                event.put("dsync", true);
                return;
            }
            if ("profile".equals(eventType)) {
                event.put("dsync", true);
                this.getConfigLogger().verbose(this.getConfigAccountId(), "Local cache needs to be updated (profile event)");
                return;
            }
            int now = (int)(System.currentTimeMillis() / 1000L);
            int expiresIn = this.getLocalCacheExpiryInterval(1200);
            int lastUpdate = this.getIntFromPrefs("local_cache_last_update", now);
            if (lastUpdate + expiresIn < now) {
                event.put("dsync", true);
                this.getConfigLogger().verbose(this.getConfigAccountId(), "Local cache needs to be updated");
            } else {
                event.put("dsync", false);
                this.getConfigLogger().verbose(this.getConfigAccountId(), "Local cache doesn't need to be updated");
            }
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to sync with upstream", t);
        }
    }

    private int getLocalCacheExpiryInterval(int defaultInterval) {
        return this.getIntFromPrefs("local_cache_expires_in", defaultInterval);
    }

    void persistEvent(Context context, JSONObject event, int type) {
        if (event == null) {
            return;
        }
        try {
            if (type == 4) {
                this.persistEvent(context, event);
            }
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to sync with upstream", t);
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private void persistEvent(Context context, JSONObject event) {
        try {
            String evtName = event.getString("evtName");
            if (evtName == null) {
                return;
            }
            String namespace = !this.config.isDefaultInstance() ? "local_events:" + this.config.getAccountId() : "local_events";
            SharedPreferences prefs = StorageHelper.getPreferences(context, namespace);
            int now = (int)(System.currentTimeMillis() / 1000L);
            String encoded = this.getStringFromPrefs(evtName, this.encodeEventDetails(now, now, 0), namespace);
            EventDetail ed = this.decodeEventDetails(evtName, encoded);
            String updateEncoded = this.encodeEventDetails(ed.getFirstTime(), now, ed.getCount() + 1);
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString(this.storageKeyWithSuffix(evtName), updateEncoded);
            StorageHelper.persist(editor);
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to persist event locally", t);
        }
    }

    private String encodeEventDetails(int first, int last, int count) {
        return count + "|" + first + "|" + last;
    }

    private EventDetail decodeEventDetails(String name, String encoded) {
        if (encoded == null) {
            return null;
        }
        String[] parts = encoded.split("\\|");
        return new EventDetail(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), name);
    }

    void syncWithUpstream(Context context, JSONObject response) {
        block20: {
            try {
                JSONObject eventUpdates = null;
                JSONObject profileUpdates = null;
                if (!response.has("evpr")) {
                    return;
                }
                JSONObject evpr = response.getJSONObject("evpr");
                if (evpr.has("profile")) {
                    JSONObject profile = evpr.getJSONObject("profile");
                    if (profile.has("_custom")) {
                        JSONObject custom = profile.getJSONObject("_custom");
                        profile.remove("_custom");
                        Iterator keys = custom.keys();
                        while (keys.hasNext()) {
                            String next = keys.next().toString();
                            Object value = null;
                            try {
                                value = custom.getJSONArray(next);
                            }
                            catch (Throwable t) {
                                try {
                                    value = custom.get(next);
                                }
                                catch (JSONException jSONException) {
                                    // empty catch block
                                }
                            }
                            if (value == null) continue;
                            profile.put(next, value);
                        }
                    }
                    profileUpdates = this.syncProfile(profile);
                }
                if (evpr.has("events")) {
                    eventUpdates = this.syncEventsFromUpstream(context, evpr.getJSONObject("events"));
                }
                if (evpr.has("expires_in")) {
                    int expiresIn = evpr.getInt("expires_in");
                    this.setLocalCacheExpiryInterval(context, expiresIn);
                }
                StorageHelper.putInt(context, this.storageKeyWithSuffix("local_cache_last_update"), (int)(System.currentTimeMillis() / 1000L));
                Boolean profileUpdatesNotEmpty = profileUpdates != null && profileUpdates.length() > 0;
                Boolean eventsUpdatesNotEmpty = eventUpdates != null && eventUpdates.length() > 0;
                if (!profileUpdatesNotEmpty.booleanValue() && !eventsUpdatesNotEmpty.booleanValue()) break block20;
                JSONObject updates = new JSONObject();
                if (profileUpdatesNotEmpty.booleanValue()) {
                    updates.put("profile", (Object)profileUpdates);
                }
                if (eventsUpdatesNotEmpty.booleanValue()) {
                    updates.put("events", (Object)eventUpdates);
                }
                SyncListener syncListener = null;
                try {
                    CleverTapAPI ct = CleverTapAPI.getDefaultInstance(context);
                    if (ct != null) {
                        syncListener = ct.getSyncListener();
                    }
                }
                catch (Throwable ct) {
                    // empty catch block
                }
                if (syncListener != null) {
                    try {
                        syncListener.profileDataUpdated(updates);
                    }
                    catch (Throwable t) {
                        this.getConfigLogger().verbose(this.getConfigAccountId(), "Execution of sync listener failed", t);
                    }
                }
            }
            catch (Throwable t) {
                this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to sync with upstream", t);
            }
        }
    }

    private JSONObject syncProfile(JSONObject remoteProfile) {
        JSONObject profileUpdates = new JSONObject();
        if (remoteProfile == null || remoteProfile.length() <= 0) {
            return profileUpdates;
        }
        try {
            JSONObject fieldsToUpdateLocally = new JSONObject();
            int now = (int)(System.currentTimeMillis() / 1000L);
            Iterator keys = remoteProfile.keys();
            while (keys.hasNext()) {
                try {
                    String key = keys.next().toString();
                    if (this.shouldPreferLocalProfileUpdateForKeyForTime(key, now).booleanValue()) {
                        this.getConfigLogger().verbose(this.getConfigAccountId(), "Rejecting upstream value for key " + key + " because our local cache prohibits it");
                        continue;
                    }
                    Object localValue = this.getProfileValueForKey(key);
                    Object remoteValue = remoteProfile.get(key);
                    if (this.profileValueIsEmpty(remoteValue).booleanValue()) {
                        remoteValue = null;
                    }
                    if (this.profileValuesAreEqual(remoteValue, localValue).booleanValue()) continue;
                    try {
                        JSONObject changesObject;
                        if (remoteValue != null) {
                            fieldsToUpdateLocally.put(key, remoteValue);
                        } else {
                            this.removeProfileField(key, true, true);
                        }
                        if ((changesObject = this.buildChangeFromOldValueToNewValue(localValue, remoteValue)) == null) continue;
                        profileUpdates.put(key, (Object)changesObject);
                    }
                    catch (Throwable t) {
                        this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to set profile updates", t);
                    }
                }
                catch (Throwable t) {
                    this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to update profile field", t);
                }
            }
            if (fieldsToUpdateLocally.length() > 0) {
                this.setProfileFields(fieldsToUpdateLocally, true);
            }
            return profileUpdates;
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to sync remote profile", t);
            return null;
        }
    }

    private JSONObject syncEventsFromUpstream(Context context, JSONObject events) {
        try {
            JSONObject eventUpdates = null;
            String namespace = !this.config.isDefaultInstance() ? "local_events:" + this.config.getAccountId() : "local_events";
            SharedPreferences prefs = StorageHelper.getPreferences(context, namespace);
            Iterator keys = events.keys();
            SharedPreferences.Editor editor = prefs.edit();
            while (keys.hasNext()) {
                int last;
                int first;
                int upstreamCount;
                String event = keys.next().toString();
                String encoded = this.getStringFromPrefs(event, this.encodeEventDetails(0, 0, 0), namespace);
                EventDetail ed = this.decodeEventDetails(event, encoded);
                JSONArray upstream = events.getJSONArray(event);
                if (upstream == null || upstream.length() < 3) {
                    this.getConfigLogger().verbose(this.getConfigAccountId(), "Corrupted upstream event detail");
                    continue;
                }
                try {
                    upstreamCount = upstream.getInt(0);
                    first = upstream.getInt(1);
                    last = upstream.getInt(2);
                }
                catch (Throwable t) {
                    this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to parse upstream event message: " + upstream.toString());
                    continue;
                }
                if (upstreamCount > ed.getCount()) {
                    editor.putString(this.storageKeyWithSuffix(event), this.encodeEventDetails(first, last, upstreamCount));
                    this.getConfigLogger().verbose(this.getConfigAccountId(), "Accepted update for event " + event + " from upstream");
                    try {
                        if (eventUpdates == null) {
                            eventUpdates = new JSONObject();
                        }
                        JSONObject evUpdate = new JSONObject();
                        JSONObject countUpdate = new JSONObject();
                        countUpdate.put("oldValue", ed.getCount());
                        countUpdate.put("newValue", upstreamCount);
                        evUpdate.put("count", (Object)countUpdate);
                        JSONObject firstUpdate = new JSONObject();
                        firstUpdate.put("oldValue", ed.getFirstTime());
                        firstUpdate.put("newValue", upstream.getInt(1));
                        evUpdate.put("firstTime", (Object)firstUpdate);
                        JSONObject lastUpdate = new JSONObject();
                        lastUpdate.put("oldValue", ed.getLastTime());
                        lastUpdate.put("newValue", upstream.getInt(2));
                        evUpdate.put("lastTime", (Object)lastUpdate);
                        eventUpdates.put(event, (Object)evUpdate);
                    }
                    catch (Throwable t) {
                        this.getConfigLogger().verbose(this.getConfigAccountId(), "Couldn't set event updates", t);
                    }
                    continue;
                }
                this.getConfigLogger().verbose(this.getConfigAccountId(), "Rejected update for event " + event + " from upstream");
            }
            StorageHelper.persist(editor);
            return eventUpdates;
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getConfigAccountId(), "Couldn't sync events from upstream", t);
            return null;
        }
    }

    private void setLocalCacheExpiryInterval(Context context, int ttl) {
        StorageHelper.putInt(context, this.storageKeyWithSuffix("local_cache_expires_in"), ttl);
    }

    private Boolean shouldPreferLocalProfileUpdateForKeyForTime(String key, int time) {
        int now = time <= 0 ? (int)(System.currentTimeMillis() / 1000L) : time;
        Integer keyValidUntil = this.getLocalProfileKeyExpiryTimeForKey(key);
        return keyValidUntil != null && keyValidUntil > now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getLocalProfileKeyExpiryTimeForKey(String key) {
        if (key == null) {
            return 0;
        }
        HashMap<String, Integer> hashMap = this.PROFILE_EXPIRY_MAP;
        synchronized (hashMap) {
            return this.PROFILE_EXPIRY_MAP.get(key);
        }
    }

    Object getProfileValueForKey(String key) {
        return this._getProfileProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _getProfileProperty(String key) {
        if (key == null) {
            return null;
        }
        HashMap<String, Object> hashMap = this.PROFILE_FIELDS_IN_THIS_SESSION;
        synchronized (hashMap) {
            try {
                return this.PROFILE_FIELDS_IN_THIS_SESSION.get(key);
            }
            catch (Throwable t) {
                this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to retrieve local profile property", t);
                return null;
            }
        }
    }

    private Boolean profileValueIsEmpty(Object value) {
        if (value == null) {
            return true;
        }
        Boolean isEmpty = false;
        if (value instanceof String) {
            isEmpty = ((String)value).trim().length() == 0;
        }
        if (value instanceof JSONArray) {
            isEmpty = ((JSONArray)value).length() <= 0;
        }
        return isEmpty;
    }

    private Boolean profileValuesAreEqual(Object value1, Object value2) {
        return this.stringify(value1).equals(this.stringify(value2));
    }

    private String stringify(Object value) {
        return value == null ? "" : value.toString();
    }

    void removeProfileFields(ArrayList<String> fields) {
        if (fields == null) {
            return;
        }
        this.removeProfileFields(fields, false);
    }

    private void removeProfileFields(ArrayList<String> fields, Boolean fromUpstream) {
        if (fields == null) {
            return;
        }
        for (String key : fields) {
            this.removeProfileField(key, fromUpstream, false);
        }
        this.persistLocalProfileAsync();
    }

    void removeProfileField(String key) {
        this.removeProfileField(key, false, true);
    }

    private void removeProfileField(String key, Boolean fromUpstream, boolean persist) {
        if (key == null) {
            return;
        }
        try {
            this._removeProfileField(key);
            if (!fromUpstream.booleanValue()) {
                this.updateLocalProfileKeyExpiryTime(key);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (persist) {
            this.persistLocalProfileAsync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _removeProfileField(String key) {
        if (key == null) {
            return;
        }
        HashMap<String, Object> hashMap = this.PROFILE_FIELDS_IN_THIS_SESSION;
        synchronized (hashMap) {
            try {
                this.PROFILE_FIELDS_IN_THIS_SESSION.remove(key);
            }
            catch (Throwable t) {
                this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to remove local profile value for key " + key, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLocalProfileKeyExpiryTime(String key) {
        if (key == null) {
            return;
        }
        HashMap<String, Integer> hashMap = this.PROFILE_EXPIRY_MAP;
        synchronized (hashMap) {
            this.PROFILE_EXPIRY_MAP.put(key, this.calculateLocalKeyExpiryTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLocalProfileKeyExpiryTime(String key) {
        if (key == null) {
            return;
        }
        HashMap<String, Integer> hashMap = this.PROFILE_EXPIRY_MAP;
        synchronized (hashMap) {
            this.PROFILE_EXPIRY_MAP.remove(key);
        }
    }

    private int calculateLocalKeyExpiryTime() {
        int now = (int)(System.currentTimeMillis() / 1000L);
        return now + this.getLocalCacheExpiryInterval(0);
    }

    private void persistLocalProfileAsync() {
        final String profileID = this.config.getAccountId();
        this.postAsyncSafely("LocalDataStore#persistLocalProfileAsync", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashMap hashMap = LocalDataStore.this.PROFILE_FIELDS_IN_THIS_SESSION;
                synchronized (hashMap) {
                    long status = LocalDataStore.this.dbAdapter.storeUserProfile(profileID, new JSONObject((Map)LocalDataStore.this.PROFILE_FIELDS_IN_THIS_SESSION));
                    LocalDataStore.this.getConfigLogger().verbose(LocalDataStore.this.getConfigAccountId(), "Persist Local Profile complete with status " + status + " for id " + profileID);
                }
            }
        });
    }

    private JSONObject buildChangeFromOldValueToNewValue(Object oldValue, Object newValue) {
        if (oldValue == null && newValue == null) {
            return null;
        }
        JSONObject keyUpdates = new JSONObject();
        try {
            Object _newVal = newValue != null ? newValue : Integer.valueOf(-1);
            keyUpdates.put("newValue", _newVal);
            if (oldValue != null) {
                keyUpdates.put("oldValue", oldValue);
            }
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to create profile changed values object", t);
            return null;
        }
        return keyUpdates;
    }

    void setProfileFields(JSONObject fields) {
        this.setProfileFields(fields, false);
    }

    private void setProfileFields(JSONObject fields, Boolean fromUpstream) {
        if (fields == null) {
            return;
        }
        try {
            Iterator keys = fields.keys();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                this.setProfileField(key, fields.get(key), fromUpstream, false);
            }
            this.persistLocalProfileAsync();
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to set profile fields", t);
        }
    }

    void setProfileField(String key, Object value) {
        this.setProfileField(key, value, false, true);
    }

    private void setProfileField(String key, Object value, Boolean fromUpstream, boolean persist) {
        if (key == null || value == null) {
            return;
        }
        try {
            this._setProfileField(key, value);
            if (!fromUpstream.booleanValue()) {
                this.updateLocalProfileKeyExpiryTime(key);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (persist) {
            this.persistLocalProfileAsync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setProfileField(String key, Object value) {
        if (key == null || value == null) {
            return;
        }
        HashMap<String, Object> hashMap = this.PROFILE_FIELDS_IN_THIS_SESSION;
        synchronized (hashMap) {
            this.PROFILE_FIELDS_IN_THIS_SESSION.put(key, value);
        }
    }

    EventDetail getEventDetail(String eventName) {
        try {
            if (!this.isPersonalisationEnabled()) {
                return null;
            }
            String namespace = !this.config.isDefaultInstance() ? "local_events:" + this.config.getAccountId() : "local_events";
            return this.decodeEventDetails(eventName, this.getStringFromPrefs(eventName, null, namespace));
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to retrieve local event detail", t);
            return null;
        }
    }

    private boolean isPersonalisationEnabled() {
        return this.config.isPersonalizationEnabled();
    }

    Object getProfileProperty(String key) {
        return this.getProfileValueForKey(key);
    }

    Map<String, EventDetail> getEventHistory(Context context) {
        try {
            String namespace = !this.config.isDefaultInstance() ? "local_events:" + this.config.getAccountId() : "local_events";
            SharedPreferences prefs = StorageHelper.getPreferences(context, namespace);
            Map all = prefs.getAll();
            HashMap<String, EventDetail> out = new HashMap<String, EventDetail>();
            for (String eventName : all.keySet()) {
                out.put(eventName, this.decodeEventDetails(eventName, all.get(eventName).toString()));
            }
            return out;
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to retrieve local event history", t);
            return null;
        }
    }

    void changeUser() {
        this.resetLocalProfileSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetLocalProfileSync() {
        HashMap<String, Object> hashMap = this.PROFILE_EXPIRY_MAP;
        synchronized (hashMap) {
            this.PROFILE_EXPIRY_MAP.clear();
        }
        hashMap = this.PROFILE_FIELDS_IN_THIS_SESSION;
        synchronized (hashMap) {
            this.PROFILE_FIELDS_IN_THIS_SESSION.clear();
        }
        String accountID = this.getUserProfileID();
        this.dbAdapter.removeUserProfile(accountID);
    }

    private String getUserProfileID() {
        return this.config.getAccountId();
    }

    private String storageKeyWithSuffix(String key) {
        return key + ":" + this.config.getAccountId();
    }

    private String getStringFromPrefs(String rawKey, String defaultValue, String nameSpace) {
        if (this.config.isDefaultInstance()) {
            String _new = StorageHelper.getString(this.context, nameSpace, this.storageKeyWithSuffix(rawKey), defaultValue);
            return _new != null ? _new : StorageHelper.getString(this.context, nameSpace, rawKey, defaultValue);
        }
        return StorageHelper.getString(this.context, nameSpace, this.storageKeyWithSuffix(rawKey), defaultValue);
    }

    private int getIntFromPrefs(String rawKey, int defaultValue) {
        if (this.config.isDefaultInstance()) {
            int dummy = -1000;
            int _new = StorageHelper.getInt(this.context, this.storageKeyWithSuffix(rawKey), dummy);
            return _new != dummy ? _new : StorageHelper.getInt(this.context, rawKey, defaultValue);
        }
        return StorageHelper.getInt(this.context, this.storageKeyWithSuffix(rawKey), defaultValue);
    }
}

