/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.clevertap.android.sdk.CTInboxActivity;
import com.clevertap.android.sdk.CTInboxListViewFragment;
import com.clevertap.android.sdk.CTInboxMessage;
import com.clevertap.android.sdk.CTInboxMessageContent;
import com.clevertap.android.sdk.R;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.ui.PlayerView;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Util;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.Date;

class CTInboxBaseMessageViewHolder
extends RecyclerView.ViewHolder {
    RelativeLayout relativeLayout;
    RelativeLayout clickLayout;
    LinearLayout ctaLinearLayout;
    LinearLayout bodyRelativeLayout;
    FrameLayout frameLayout;
    Context context;
    ImageView mediaImage;
    ImageView squareImage;
    FrameLayout progressBarFrameLayout;
    private ImageView muteIcon;
    RelativeLayout mediaLayout;
    private WeakReference<CTInboxListViewFragment> parentWeakReference;
    private CTInboxMessage message;
    private CTInboxMessageContent firstContentItem;
    private boolean requiresMediaPlayer;

    CTInboxListViewFragment getParent() {
        return (CTInboxListViewFragment)((Object)this.parentWeakReference.get());
    }

    CTInboxBaseMessageViewHolder(@NonNull View itemView) {
        super(itemView);
    }

    void configureWithMessage(CTInboxMessage inboxMessage, CTInboxListViewFragment parent, int position) {
        this.context = parent.getContext();
        this.parentWeakReference = new WeakReference<CTInboxListViewFragment>(parent);
        this.message = inboxMessage;
        this.firstContentItem = this.message.getInboxMessageContents().get(0);
        this.requiresMediaPlayer = this.firstContentItem.mediaIsAudio() || this.firstContentItem.mediaIsVideo();
    }

    String calculateDisplayTimestamp(long time) {
        long now = System.currentTimeMillis() / 1000L;
        long diff = now - time;
        if (diff < 60L) {
            return "Just Now";
        }
        if (diff > 60L && diff < 3540L) {
            return diff / 60L + " mins ago";
        }
        if (diff > 3540L && diff < 81420L) {
            return diff / 3600L > 1L ? diff / 3600L + " hours ago" : diff / 3600L + " hour ago";
        }
        if (diff > 86400L && diff < 172800L) {
            return "Yesterday";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd MMM");
        return sdf.format(new Date(time));
    }

    void hideTwoButtons(Button mainButton, Button secondaryButton, Button tertiaryButton) {
        secondaryButton.setVisibility(8);
        tertiaryButton.setVisibility(8);
        LinearLayout.LayoutParams mainLayoutParams = new LinearLayout.LayoutParams(0, -1, 6.0f);
        mainButton.setLayoutParams((ViewGroup.LayoutParams)mainLayoutParams);
        LinearLayout.LayoutParams secondaryLayoutParams = new LinearLayout.LayoutParams(0, -1, 0.0f);
        secondaryButton.setLayoutParams((ViewGroup.LayoutParams)secondaryLayoutParams);
        LinearLayout.LayoutParams tertiaryLayoutParams = new LinearLayout.LayoutParams(0, -1, 0.0f);
        tertiaryButton.setLayoutParams((ViewGroup.LayoutParams)tertiaryLayoutParams);
    }

    void hideOneButton(Button mainButton, Button secondaryButton, Button tertiaryButton) {
        tertiaryButton.setVisibility(8);
        LinearLayout.LayoutParams mainLayoutParams = new LinearLayout.LayoutParams(0, -1, 3.0f);
        mainButton.setLayoutParams((ViewGroup.LayoutParams)mainLayoutParams);
        LinearLayout.LayoutParams secondaryLayoutParams = new LinearLayout.LayoutParams(0, -1, 3.0f);
        secondaryButton.setLayoutParams((ViewGroup.LayoutParams)secondaryLayoutParams);
        LinearLayout.LayoutParams tertiaryLayoutParams = new LinearLayout.LayoutParams(0, -1, 0.0f);
        tertiaryButton.setLayoutParams((ViewGroup.LayoutParams)tertiaryLayoutParams);
    }

    private FrameLayout getLayoutForMediaPlayer() {
        return this.frameLayout;
    }

    int getImageBackgroundColor() {
        return 0;
    }

    boolean needsMediaPlayer() {
        return this.requiresMediaPlayer;
    }

    boolean shouldAutoPlay() {
        return this.firstContentItem.mediaIsVideo();
    }

    void playerReady() {
        FrameLayout frameLayout = this.getLayoutForMediaPlayer();
        frameLayout.setVisibility(0);
        if (this.muteIcon != null) {
            this.muteIcon.setVisibility(0);
        }
        if (this.progressBarFrameLayout != null) {
            this.progressBarFrameLayout.setVisibility(8);
        }
    }

    void playerRemoved() {
        FrameLayout frameLayout;
        if (this.progressBarFrameLayout != null) {
            this.progressBarFrameLayout.setVisibility(8);
        }
        if (this.muteIcon != null) {
            this.muteIcon.setVisibility(8);
        }
        if ((frameLayout = this.getLayoutForMediaPlayer()) != null) {
            frameLayout.removeAllViews();
        }
    }

    void playerBuffering() {
        if (this.progressBarFrameLayout != null) {
            this.progressBarFrameLayout.setVisibility(0);
        }
    }

    boolean addMediaPlayer(PlayerView videoSurfaceView) {
        int height;
        int width;
        if (!this.requiresMediaPlayer) {
            return false;
        }
        FrameLayout frameLayout = this.getLayoutForMediaPlayer();
        if (frameLayout == null) {
            return false;
        }
        frameLayout.removeAllViews();
        frameLayout.setVisibility(8);
        final Resources resources = this.context.getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        if (CTInboxActivity.orientation == 2) {
            if (this.message.getOrientation().equalsIgnoreCase("l")) {
                width = Math.round((float)this.mediaImage.getMeasuredHeight() * 1.76f);
                height = this.mediaImage.getMeasuredHeight();
            } else {
                width = height = this.squareImage.getMeasuredHeight();
            }
        } else {
            width = resources.getDisplayMetrics().widthPixels;
            height = this.message.getOrientation().equalsIgnoreCase("l") ? Math.round((float)width * 0.5625f) : width;
        }
        videoSurfaceView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(width, height));
        frameLayout.addView((View)videoSurfaceView);
        frameLayout.setBackgroundColor(Color.parseColor((String)this.message.getBgColor()));
        if (this.progressBarFrameLayout != null) {
            this.progressBarFrameLayout.setVisibility(0);
        }
        final SimpleExoPlayer player = (SimpleExoPlayer)videoSurfaceView.getPlayer();
        float currentVolume = player.getVolume();
        if (this.firstContentItem.mediaIsVideo()) {
            this.muteIcon = new ImageView(this.context);
            this.muteIcon.setVisibility(8);
            if (currentVolume > 0.0f) {
                this.muteIcon.setImageDrawable(this.context.getResources().getDrawable(R.drawable.ct_volume_on));
            } else {
                this.muteIcon.setImageDrawable(this.context.getResources().getDrawable(R.drawable.ct_volume_off));
            }
            int iconWidth = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)displayMetrics);
            int iconHeight = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)displayMetrics);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(iconWidth, iconHeight);
            int iconTop = (int)TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)displayMetrics);
            int iconRight = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)displayMetrics);
            layoutParams.setMargins(0, iconTop, iconRight, 0);
            layoutParams.gravity = 0x800005;
            this.muteIcon.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.muteIcon.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    float currentVolume = player.getVolume();
                    if (currentVolume > 0.0f) {
                        player.setVolume(0.0f);
                        CTInboxBaseMessageViewHolder.this.muteIcon.setImageDrawable(resources.getDrawable(R.drawable.ct_volume_off));
                    } else if (currentVolume == 0.0f) {
                        player.setVolume(1.0f);
                        CTInboxBaseMessageViewHolder.this.muteIcon.setImageDrawable(resources.getDrawable(R.drawable.ct_volume_on));
                    }
                }
            });
            frameLayout.addView((View)this.muteIcon);
        }
        videoSurfaceView.requestFocus();
        videoSurfaceView.setShowBuffering(false);
        DefaultBandwidthMeter defaultBandwidthMeter = new DefaultBandwidthMeter();
        DefaultDataSourceFactory dataSourceFactory = new DefaultDataSourceFactory(this.context, Util.getUserAgent((Context)this.context, (String)this.context.getPackageName()), (TransferListener)defaultBandwidthMeter);
        String uriString = this.firstContentItem.getMedia();
        if (uriString != null) {
            HlsMediaSource hlsMediaSource = new HlsMediaSource.Factory((DataSource.Factory)dataSourceFactory).createMediaSource(Uri.parse((String)uriString));
            player.prepare((MediaSource)hlsMediaSource);
            if (this.firstContentItem.mediaIsAudio()) {
                videoSurfaceView.showController();
                player.setPlayWhenReady(false);
                player.setVolume(1.0f);
            } else if (this.firstContentItem.mediaIsVideo()) {
                player.setPlayWhenReady(true);
                player.setVolume(currentVolume);
            }
        }
        return true;
    }
}

