/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlarmManager;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.location.Location;
import android.location.LocationManager;
import android.media.AudioAttributes;
import android.media.RingtoneManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.NotificationCompat;
import com.clevertap.android.sdk.CTBackgroundJobService;
import com.clevertap.android.sdk.CTInAppBaseFragment;
import com.clevertap.android.sdk.CTInAppBasePartialFragment;
import com.clevertap.android.sdk.CTInAppHtmlFooterFragment;
import com.clevertap.android.sdk.CTInAppHtmlHeaderFragment;
import com.clevertap.android.sdk.CTInAppNativeFooterFragment;
import com.clevertap.android.sdk.CTInAppNativeHeaderFragment;
import com.clevertap.android.sdk.CTInAppNotification;
import com.clevertap.android.sdk.CTInAppType;
import com.clevertap.android.sdk.CTInboxActivity;
import com.clevertap.android.sdk.CTInboxController;
import com.clevertap.android.sdk.CTInboxListener;
import com.clevertap.android.sdk.CTInboxMessage;
import com.clevertap.android.sdk.CTInboxStyleConfig;
import com.clevertap.android.sdk.CTMessageDAO;
import com.clevertap.android.sdk.CTNotificationIntentService;
import com.clevertap.android.sdk.CTPushNotificationReceiver;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Constants;
import com.clevertap.android.sdk.DBAdapter;
import com.clevertap.android.sdk.DataHandler;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.EventDetail;
import com.clevertap.android.sdk.EventHandler;
import com.clevertap.android.sdk.InAppFCManager;
import com.clevertap.android.sdk.InAppNotificationActivity;
import com.clevertap.android.sdk.InAppNotificationListener;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestInfo;
import com.clevertap.android.sdk.ManifestValidator;
import com.clevertap.android.sdk.NotificationInfo;
import com.clevertap.android.sdk.ProfileHandler;
import com.clevertap.android.sdk.PushType;
import com.clevertap.android.sdk.QueueCursor;
import com.clevertap.android.sdk.SSLContextBuilder;
import com.clevertap.android.sdk.SessionHandler;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.SyncListener;
import com.clevertap.android.sdk.UTMDetail;
import com.clevertap.android.sdk.UriHelper;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.ValidationResult;
import com.clevertap.android.sdk.Validator;
import com.clevertap.android.sdk.exceptions.CleverTapMetaDataNotFoundException;
import com.clevertap.android.sdk.exceptions.CleverTapPermissionsNotSatisfied;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.plus.model.people.Person;
import com.google.firebase.iid.FirebaseInstanceId;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CleverTapAPI
implements CTInAppNotification.CTInAppNotificationListener,
InAppNotificationActivity.InAppActivityListener,
CTInAppBaseFragment.InAppListener,
CTInboxActivity.InboxActivityListener {
    @Deprecated
    public static final String CHARGED_EVENT = "Charged";
    public static final String NOTIFICATION_TAG = "wzrk_pn";
    private static int debugLevel = LogLevel.INFO.intValue();
    private static final Boolean pendingValidationResultsLock = true;
    private static CleverTapInstanceConfig defaultConfig;
    private static HashMap<String, CleverTapAPI> instances;
    private static boolean appForeground;
    private static int activityCount;
    private String currentScreenName = "";
    private static ArrayList<CTInAppNotification> pendingNotifications;
    private Runnable pendingInappRunnable = null;
    private static CTInAppNotification currentlyDisplayingInApp;
    private static WeakReference<Activity> currentActivity;
    private static int initialAppEnteredForegroundTime;
    private static SSLContext sslContext;
    private static SSLSocketFactory sslSocketFactory;
    private static String sdkVersion;
    static boolean haveVideoPlayerSupport;
    private DBAdapter dbAdapter;
    private Context context;
    private LocalDataStore localDataStore;
    private CleverTapInstanceConfig config;
    private int mResponseFailureCount = 0;
    private int currentRequestTimestamp = 0;
    private Location locationFromUser = null;
    private SyncListener syncListener = null;
    private ArrayList<PushType> enabledPushTypes = null;
    private long appLastSeen = 0L;
    private int currentSessionId = 0;
    private boolean firstSession = false;
    private int lastSessionLength = 0;
    private String source = null;
    private String medium = null;
    private String campaign = null;
    private JSONObject wzrkParams = null;
    private int lastVisitTime;
    private final HashMap<String, Object> notificationIdTagMap = new HashMap();
    private final HashMap<String, Object> notificationViewedIdTagMap = new HashMap();
    private DeviceInfo deviceInfo;
    private DevicePushTokenRefreshListener tokenRefreshListener;
    private boolean appLaunchPushed = false;
    private final Object appLaunchPushedLock = new Object();
    private Handler handlerUsingMainLooper;
    private ExecutorService es;
    private ExecutorService ns;
    private Runnable commsRunnable = null;
    private Validator validator;
    private final Object optOutFlagLock = new Object();
    private boolean currentUserOptedOut = false;
    private final HashMap<String, Integer> installReferrerMap = new HashMap(8);
    private boolean enableNetworkInfoReporting = false;
    private ArrayList<ValidationResult> pendingValidationResults = new ArrayList();
    private HashSet<String> inappActivityExclude = null;
    private InAppNotificationListener inAppNotificationListener;
    private InAppFCManager inAppFCManager;
    private int lastLocationPingTime = 0;
    private final Object tokenLock = new Object();
    private final Object notificationMapLock = new Object();
    private boolean havePushedDeviceToken = false;
    private String processingUserLoginIdentifier = null;
    private final Boolean processingUserLoginLock = true;
    private long EXECUTOR_THREAD_ID = 0L;
    private long NOTIFICATION_THREAD_ID = 0L;
    private final Boolean eventLock = true;
    private boolean offline = false;
    private CTInboxController ctInboxController;
    private final Object inboxControllerLock = new Object();
    private CTInboxListener inboxListener;
    private boolean isBgPing = false;
    @Deprecated
    public final EventHandler event;
    @Deprecated
    public final ProfileHandler profile;
    @Deprecated
    public final DataHandler data;
    @Deprecated
    public final SessionHandler session;

    private static boolean checkForExoPlayer() {
        boolean exoPlayerPresent = false;
        Class<?> className = null;
        try {
            className = Class.forName("com.google.android.exoplayer2.ExoPlayerFactory");
            className = Class.forName("com.google.android.exoplayer2.source.hls.HlsMediaSource");
            className = Class.forName("com.google.android.exoplayer2.ui.PlayerView");
            Logger.d("ExoPlayer is present");
            exoPlayerPresent = true;
        }
        catch (Throwable t) {
            Logger.d("ExoPlayer library files are missing!!!");
            Logger.d("Please add ExoPlayer dependencies to render InApp or Inbox messages playing video. For more information checkout CleverTap documentation.");
            if (className != null) {
                Logger.d("ExoPlayer classes not found " + className.getName());
            }
            Logger.d("ExoPlayer classes not found");
        }
        return exoPlayerPresent;
    }

    private CleverTapAPI(final Context context, final CleverTapInstanceConfig config) {
        this.config = new CleverTapInstanceConfig(config);
        this.context = context;
        this.handlerUsingMainLooper = new Handler(Looper.getMainLooper());
        this.es = Executors.newFixedThreadPool(1);
        this.ns = Executors.newFixedThreadPool(1);
        this.localDataStore = new LocalDataStore(context, config);
        this.deviceInfo = DeviceInfo.initWithConfig(context, config);
        this.validator = new Validator();
        this.inAppFCManager = new InAppFCManager(context, config);
        this.postAsyncSafely("CleverTapAPI#initializeDeviceInfo", new Runnable(){

            @Override
            public void run() {
                CleverTapAPI.this.initializeDeviceInfo();
                if (config.isDefaultInstance()) {
                    CleverTapAPI.this.manifestAsyncValidation();
                }
            }
        });
        int now = (int)System.currentTimeMillis() / 1000;
        if (now - initialAppEnteredForegroundTime > 5) {
            this.config.setCreatedPostAppLaunch();
        }
        this.event = new EventHandler(this);
        this.profile = new ProfileHandler(this);
        this.data = new DataHandler(this);
        this.session = new SessionHandler(this);
        this.setLastVisitTime();
        this.postAsyncSafely("setStatesAsync", new Runnable(){

            @Override
            public void run() {
                CleverTapAPI.this.setDeviceNetworkInfoReportingFromStorage();
                CleverTapAPI.this.setCurrentUserOptOutStateFromStorage();
            }
        });
        this.postAsyncSafely("saveConfigtoSharedPrefs", new Runnable(){

            @Override
            public void run() {
                String configJson = config.toJSONString();
                if (configJson == null) {
                    Logger.v("Unable to save config to SharedPrefs, config Json is null");
                    return;
                }
                StorageHelper.putString(context, CleverTapAPI.this.storageKeyWithSuffix("instance"), configJson);
            }
        });
        if (this.config.isBackgroundSync() && !this.config.isAnalyticsOnly()) {
            this.postAsyncSafely("createOrResetJobScheduler", new Runnable(){

                @Override
                public void run() {
                    if (Build.VERSION.SDK_INT >= 21) {
                        CleverTapAPI.this.createOrResetJobScheduler(context);
                    } else {
                        CleverTapAPI.this.createAlarmScheduler(context);
                    }
                }
            });
        }
        Logger.i("CleverTap SDK initialized with accountId: " + config.getAccountId() + " accountToken: " + config.getAccountToken() + " accountRegion: " + config.getAccountRegion());
    }

    private void initializeDeviceInfo() {
        this.deviceInfo.initDeviceID();
    }

    private LocalDataStore getLocalDataStore() {
        return this.localDataStore;
    }

    private CleverTapInstanceConfig getConfig() {
        return this.config;
    }

    private Logger getConfigLogger() {
        return this.getConfig().getLogger();
    }

    private String getAccountId() {
        return this.config.getAccountId();
    }

    static void onActivityCreated(Activity activity) {
        String _accountId;
        Uri deepLink;
        Bundle notification;
        boolean alreadyProcessedByCleverTap;
        block17: {
            if (instances == null) {
                CleverTapAPI.createInstanceIfAvailable((Context)activity, null);
            }
            if (instances == null) {
                Logger.v("Instances is null in onActivityCreated!");
                return;
            }
            alreadyProcessedByCleverTap = false;
            notification = null;
            deepLink = null;
            _accountId = null;
            try {
                Intent intent = activity.getIntent();
                deepLink = intent.getData();
                if (deepLink != null) {
                    Bundle queryArgs = UriHelper.getAllKeyValuePairs(deepLink.toString(), true);
                    _accountId = queryArgs.getString("wzrk_acct_id");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                notification = activity.getIntent().getExtras();
                if (notification == null || notification.isEmpty()) break block17;
                try {
                    boolean bl = alreadyProcessedByCleverTap = notification.containsKey("wzrk_from") && "CTPushNotificationReceiver".equals(notification.get("wzrk_from"));
                    if (alreadyProcessedByCleverTap) {
                        Logger.v("ActivityLifecycleCallback: Notification Clicked already processed for " + notification.toString() + ", dropping duplicate.");
                    }
                    if (notification.containsKey("wzrk_acct_id")) {
                        _accountId = (String)notification.get("wzrk_acct_id");
                    }
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (alreadyProcessedByCleverTap && deepLink == null) {
            return;
        }
        for (String accountId : instances.keySet()) {
            CleverTapAPI instance = instances.get(accountId);
            boolean shouldProcess = false;
            if (instance != null) {
                boolean bl = shouldProcess = _accountId == null && instance.config.isDefaultInstance() || instance.getAccountId().equals(_accountId);
            }
            if (!shouldProcess) continue;
            if (notification != null && !notification.isEmpty() && notification.containsKey(NOTIFICATION_TAG)) {
                instance.pushNotificationClickedEvent(notification);
            }
            if (deepLink == null) break;
            try {
                instance.pushDeepLink(deepLink);
            }
            catch (Throwable throwable) {}
            break;
        }
    }

    public static void onActivityResumed(Activity activity) {
        if (instances == null) {
            CleverTapAPI.createInstanceIfAvailable((Context)activity, null);
        }
        CleverTapAPI.setAppForeground(true);
        if (instances == null) {
            Logger.v("Instances is null in onActivityResumed!");
            return;
        }
        String currentActivityName = CleverTapAPI.getCurrentActivityName();
        CleverTapAPI.setCurrentActivity(activity);
        if (currentActivityName == null || !currentActivityName.equals(activity.getLocalClassName())) {
            ++activityCount;
        }
        if (initialAppEnteredForegroundTime <= 0) {
            initialAppEnteredForegroundTime = (int)System.currentTimeMillis() / 1000;
        }
        for (String accountId : instances.keySet()) {
            CleverTapAPI instance = instances.get(accountId);
            try {
                if (instance == null) continue;
                instance.activityResumed(activity);
            }
            catch (Throwable throwable) {}
        }
    }

    public static void onActivityPaused() {
        if (instances == null) {
            return;
        }
        for (String accountId : instances.keySet()) {
            CleverTapAPI instance = instances.get(accountId);
            try {
                if (instance == null) continue;
                instance.activityPaused();
            }
            catch (Throwable throwable) {}
        }
    }

    static void handleNotificationClicked(Context context, Bundle notification) {
        if (notification == null) {
            return;
        }
        String _accountId = null;
        try {
            _accountId = notification.getString("wzrk_acct_id");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (instances == null) {
            CleverTapAPI instance = CleverTapAPI.createInstanceIfAvailable(context, _accountId);
            if (instance != null) {
                instance.pushNotificationClickedEvent(notification);
            }
            return;
        }
        for (String accountId : instances.keySet()) {
            CleverTapAPI instance = instances.get(accountId);
            boolean shouldProcess = false;
            if (instance != null) {
                boolean bl = shouldProcess = _accountId == null && instance.config.isDefaultInstance() || instance.getAccountId().equals(_accountId);
            }
            if (!shouldProcess) continue;
            instance.pushNotificationClickedEvent(notification);
            break;
        }
    }

    @Nullable
    public static CleverTapAPI getInstance(Context context) throws CleverTapMetaDataNotFoundException, CleverTapPermissionsNotSatisfied {
        sdkVersion = "!SDK-VERSION-STRING!:com.clevertap.android:clevertap-android-sdk:3.4.3.0";
        return CleverTapAPI.getDefaultInstance(context);
    }

    @Nullable
    public static CleverTapAPI getDefaultInstance(Context context) {
        sdkVersion = "!SDK-VERSION-STRING!:com.clevertap.android:clevertap-android-sdk:3.4.3.0";
        if (defaultConfig == null) {
            ManifestInfo manifest = ManifestInfo.getInstance(context);
            String accountId = manifest.getAccountId();
            String accountToken = manifest.getAcountToken();
            String accountRegion = manifest.getAccountRegion();
            if (accountId == null || accountToken == null) {
                Logger.i("Account ID or Account token is missing from AndroidManifest.xml, unable to create default instance");
                return null;
            }
            if (accountRegion == null) {
                Logger.i("Account Region not specified in the AndroidManifest - using default region");
            }
            defaultConfig = CleverTapInstanceConfig.createDefaultInstance(context, accountId, accountToken, accountRegion);
            defaultConfig.setDebugLevel(CleverTapAPI.getDebugLevel());
        }
        return CleverTapAPI.instanceWithConfig(context, defaultConfig);
    }

    public static CleverTapAPI instanceWithConfig(Context context, @NonNull CleverTapInstanceConfig config) {
        CleverTapAPI instance;
        if (config == null) {
            Logger.v("CleverTapInstanceConfig cannot be null");
            return null;
        }
        if (instances == null) {
            instances = new HashMap();
        }
        if ((instance = instances.get(config.getAccountId())) == null) {
            instance = new CleverTapAPI(context, config);
            instances.put(config.getAccountId(), instance);
        }
        return instance;
    }

    private void activityPaused() {
        CleverTapAPI.setAppForeground(false);
        this.appLastSeen = System.currentTimeMillis();
        this.getConfigLogger().verbose(this.getAccountId(), "App in background");
        int now = (int)(System.currentTimeMillis() / 1000L);
        if (this.inCurrentSession()) {
            try {
                StorageHelper.putInt(this.context, this.storageKeyWithSuffix("sexe"), now);
                this.getConfigLogger().verbose(this.getAccountId(), "Updated session time: " + now);
            }
            catch (Throwable t) {
                this.getConfigLogger().verbose(this.getAccountId(), "Failed to update session time time: " + t.getMessage());
            }
        }
    }

    private void checkTimeoutSession() {
        if (this.appLastSeen <= 0L) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.appLastSeen > 1200000L) {
            this.getConfigLogger().verbose(this.getAccountId(), "Session Timed Out");
            this.destroySession();
            CleverTapAPI.setCurrentActivity(null);
        }
    }

    private void destroySession() {
        this.currentSessionId = 0;
        this.setAppLaunchPushed(false);
        this.getConfigLogger().verbose(this.getAccountId(), "Session destroyed; Session ID is now 0");
        this.clearSource();
        this.clearMedium();
        this.clearCampaign();
        this.clearWzrkParams();
    }

    private boolean inCurrentSession() {
        return this.currentSessionId > 0;
    }

    private void activityResumed(Activity activity) {
        this.getConfigLogger().verbose(this.getAccountId(), "App in foreground");
        this.checkTimeoutSession();
        if (!this.isAppLaunchPushed()) {
            this.pushAppLaunchedEvent();
            this.onTokenRefresh();
        }
        if (!this.inCurrentSession()) {
            this.pushInitialEventsAsync();
        }
        this.checkPendingInAppNotifications(activity);
    }

    private void pushAppLaunchedEvent() {
        if (this.isAppLaunchReportingDisabled()) {
            this.setAppLaunchPushed(true);
            this.getConfigLogger().debug(this.getAccountId(), "App Launched Events disabled in the Android Manifest file");
            return;
        }
        if (this.isAppLaunchPushed()) {
            this.getConfigLogger().verbose(this.getAccountId(), "App Launched has already been triggered. Will not trigger it ");
            return;
        }
        this.getConfigLogger().verbose(this.getAccountId(), "Firing App Launched event");
        this.setAppLaunchPushed(true);
        JSONObject event = new JSONObject();
        try {
            event.put("evtName", (Object)"App Launched");
            event.put("evtData", (Object)this.getAppLaunchedFields());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.queueEvent(this.context, event, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAppLaunchPushed(boolean pushed) {
        Object object = this.appLaunchPushedLock;
        synchronized (object) {
            this.appLaunchPushed = pushed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAppLaunchPushed() {
        Object object = this.appLaunchPushedLock;
        synchronized (object) {
            return this.appLaunchPushed;
        }
    }

    private boolean isAppLaunchReportingDisabled() {
        return this.config.isDisableAppLaunchedEvent();
    }

    private static Activity getCurrentActivity() {
        return currentActivity == null ? null : (Activity)currentActivity.get();
    }

    private static void setCurrentActivity(@Nullable Activity activity) {
        if (activity == null) {
            currentActivity = null;
            return;
        }
        if (!activity.getLocalClassName().contains("InAppNotificationActivity")) {
            currentActivity = new WeakReference<Activity>(activity);
        }
    }

    private static String getCurrentActivityName() {
        Activity current = CleverTapAPI.getCurrentActivity();
        return current != null ? current.getLocalClassName() : null;
    }

    private void checkPendingInAppNotifications(Activity activity) {
        boolean canShow = this.canShowInAppOnActivity();
        if (canShow) {
            if (this.pendingInappRunnable != null) {
                this.getConfigLogger().verbose(this.getAccountId(), "Found a pending inapp runnable. Scheduling it");
                this.getHandlerUsingMainLooper().postDelayed(this.pendingInappRunnable, 200L);
                this.pendingInappRunnable = null;
            } else {
                this.showNotificationIfAvailable(this.context);
            }
        } else {
            Logger.d("In-app notifications will not be shown for this activity (" + (activity != null ? activity.getLocalClassName() : "") + ")");
        }
    }

    private void pushInitialEventsAsync() {
        this.postAsyncSafely("CleverTapAPI#pushInitialEventsAsync", new Runnable(){

            @Override
            public void run() {
                try {
                    CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "Queuing daily events");
                    CleverTapAPI.this.pushBasicProfile(null);
                }
                catch (Throwable t) {
                    CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "Daily profile sync failed", t);
                }
            }
        });
    }

    static void tokenRefresh(Context context) {
        if (instances == null) {
            CleverTapAPI instance = CleverTapAPI.getDefaultInstance(context);
            if (instance != null) {
                instance.onTokenRefresh();
            }
            return;
        }
        for (String accountId : instances.keySet()) {
            CleverTapAPI instance = instances.get(accountId);
            if (instance.getConfig().isAnalyticsOnly()) {
                Logger.d(accountId, "Instance is Analytics Only not processing device token");
                continue;
            }
            instance.onTokenRefresh();
        }
    }

    private void onTokenRefresh() {
        if (this.enabledPushTypes == null) {
            this.enabledPushTypes = this.deviceInfo.getEnabledPushTypes();
        }
        if (this.enabledPushTypes == null) {
            return;
        }
        for (PushType pushType : this.enabledPushTypes) {
            switch (pushType) {
                case GCM: {
                    this.doGCMRefresh();
                    break;
                }
                case FCM: {
                    this.doFCMRefresh();
                    break;
                }
            }
        }
    }

    private void doFCMRefresh() {
        final DeviceInfo _deviceInfo = this.deviceInfo;
        this.postAsyncSafely("FcmManager#doFCMRefresh", new Runnable(){

            @Override
            public void run() {
                try {
                    if (CleverTapAPI.this.getConfig().isAnalyticsOnly()) {
                        CleverTapAPI.this.getConfigLogger().debug(CleverTapAPI.this.getAccountId(), "Instance is set for Analytics only, not refreshing token");
                        return;
                    }
                    String freshToken = CleverTapAPI.this.FCMGetFreshToken(_deviceInfo.getFCMSenderID());
                    if (freshToken == null) {
                        return;
                    }
                    CleverTapAPI.this.cacheFCMToken(freshToken);
                    CleverTapAPI.this.pushFCMDeviceToken(freshToken, true, true);
                    try {
                        CleverTapAPI.this.deviceTokenDidRefresh(freshToken, PushType.FCM);
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable t) {
                    CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "FcmManager: FCM Token error", t);
                }
            }
        });
    }

    private void doGCMRefresh() {
        final DeviceInfo _deviceInfo = this.deviceInfo;
        this.postAsyncSafely("GcmManager#doGCMRefresh", new Runnable(){

            @Override
            public void run() {
                try {
                    if (CleverTapAPI.this.getConfig().isAnalyticsOnly()) {
                        CleverTapAPI.this.getConfigLogger().debug(CleverTapAPI.this.getAccountId(), "Instance is set for Analytics only, will not request push token");
                        return;
                    }
                    String freshToken = CleverTapAPI.this.GCMGetFreshToken(_deviceInfo.getGCMSenderID());
                    if (freshToken == null) {
                        return;
                    }
                    CleverTapAPI.this.cacheGCMToken(freshToken);
                    CleverTapAPI.this.pushGCMDeviceToken(freshToken, true, true);
                    try {
                        CleverTapAPI.this.deviceTokenDidRefresh(freshToken, PushType.GCM);
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable t) {
                    CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "GcmManager: GCM Token error", t);
                }
            }
        });
    }

    private String FCMGetFreshToken(String senderID) {
        String token = null;
        try {
            if (senderID != null) {
                this.getConfigLogger().verbose(this.getAccountId(), "FcmManager: Requesting a FCM token with Sender Id - " + senderID);
                token = FirebaseInstanceId.getInstance().getToken(senderID, "FCM");
            } else {
                this.getConfigLogger().verbose(this.getAccountId(), "FcmManager: Requesting a FCM token");
                token = FirebaseInstanceId.getInstance().getToken();
            }
            this.getConfigLogger().info(this.getAccountId(), "FCM token: " + token);
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "FcmManager: Error requesting FCM token", t);
        }
        return token;
    }

    private String GCMGetFreshToken(String senderID) {
        this.getConfigLogger().verbose(this.getAccountId(), "GcmManager: Requesting a GCM token for Sender ID - " + senderID);
        String token = null;
        try {
            token = InstanceID.getInstance((Context)this.context).getToken(senderID, "GCM", null);
            this.getConfigLogger().info(this.getAccountId(), "GCM token : " + token);
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "GcmManager: Error requesting GCM token", t);
        }
        return token;
    }

    private void cacheFCMToken(String token) {
        try {
            if (token == null || this.alreadyHaveFCMToken(token)) {
                return;
            }
            SharedPreferences prefs = this.getPreferences();
            if (prefs == null) {
                return;
            }
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString(this.storageKeyWithSuffix("fcm_token"), token);
            StorageHelper.persist(editor);
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "FcmManager: Unable to cache FCM Token", t);
        }
    }

    private void cacheGCMToken(String token) {
        try {
            if (token == null || this.alreadyHaveGCMToken(token)) {
                return;
            }
            SharedPreferences prefs = this.getPreferences();
            if (prefs == null) {
                return;
            }
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString(this.storageKeyWithSuffix("registration_id"), token);
            StorageHelper.persist(editor);
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "GcmManager: Unable to cache GCM Token", t);
        }
    }

    private boolean alreadyHaveFCMToken(String newToken) {
        if (newToken == null) {
            return false;
        }
        String cachedToken = this.getCachedFCMToken();
        return cachedToken != null && cachedToken.equals(newToken);
    }

    private boolean alreadyHaveGCMToken(String newToken) {
        if (newToken == null) {
            return false;
        }
        String cachedToken = this.getCachedGCMToken();
        return cachedToken != null && cachedToken.equals(newToken);
    }

    private String getCachedFCMToken() {
        SharedPreferences prefs = this.getPreferences();
        return prefs == null ? null : this.getStringFromPrefs("fcm_token", null);
    }

    private String getCachedGCMToken() {
        SharedPreferences prefs = this.getPreferences();
        return prefs == null ? null : this.getStringFromPrefs("registration_id", null);
    }

    private String storageKeyWithSuffix(String key) {
        return key + ":" + this.getConfig().getAccountId();
    }

    private SharedPreferences getPreferences() {
        try {
            return this.context == null ? null : StorageHelper.getPreferences(this.context);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private String getStringFromPrefs(String rawKey, String defaultValue) {
        if (this.config.isDefaultInstance()) {
            String _new = StorageHelper.getString(this.context, this.storageKeyWithSuffix(rawKey), defaultValue);
            return _new != null ? _new : StorageHelper.getString(this.context, rawKey, defaultValue);
        }
        return StorageHelper.getString(this.context, this.storageKeyWithSuffix(rawKey), defaultValue);
    }

    private int getIntFromPrefs(String rawKey, int defaultValue) {
        if (this.config.isDefaultInstance()) {
            int dummy = -1000;
            int _new = StorageHelper.getInt(this.context, this.storageKeyWithSuffix(rawKey), dummy);
            return _new != dummy ? _new : StorageHelper.getInt(this.context, rawKey, defaultValue);
        }
        return StorageHelper.getInt(this.context, this.storageKeyWithSuffix(rawKey), defaultValue);
    }

    private boolean getBooleanFromPrefs(String rawKey) {
        if (this.config.isDefaultInstance()) {
            boolean _new = StorageHelper.getBoolean(this.context, this.storageKeyWithSuffix(rawKey), false);
            return !_new ? StorageHelper.getBoolean(this.context, rawKey, false) : _new;
        }
        return StorageHelper.getBoolean(this.context, this.storageKeyWithSuffix(rawKey), false);
    }

    private long getLongFromPrefs(String rawKey, int defaultValue, String nameSpace) {
        if (this.config.isDefaultInstance()) {
            long dummy = -1000L;
            long _new = StorageHelper.getLong(this.context, nameSpace, this.storageKeyWithSuffix(rawKey), dummy);
            return _new != dummy ? _new : StorageHelper.getLong(this.context, nameSpace, rawKey, defaultValue);
        }
        return StorageHelper.getLong(this.context, nameSpace, this.storageKeyWithSuffix(rawKey), defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushGCMDeviceToken(String token, boolean register, boolean forceUpdate) {
        Object object = this.tokenLock;
        synchronized (object) {
            if (this.havePushedDeviceToken && !forceUpdate) {
                this.getConfigLogger().debug(this.getAccountId(), "GcmManager: skipping device token push - already sent.");
                return;
            }
            try {
                String string = token = token != null ? token : this.getCachedGCMToken();
                if (token == null) {
                    return;
                }
                this.pushDeviceToken(this.context, token, register, PushType.GCM);
                this.havePushedDeviceToken = true;
            }
            catch (Throwable t) {
                this.getConfigLogger().verbose(this.getAccountId(), "GcmManager: pushing device token failed", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushFCMDeviceToken(String token, boolean register, boolean forceUpdate) {
        Object object = this.tokenLock;
        synchronized (object) {
            if (this.havePushedDeviceToken && !forceUpdate) {
                this.getConfigLogger().verbose(this.getAccountId(), "FcmManager: skipping device token push - already sent.");
                return;
            }
            try {
                String string = token = token != null ? token : this.getCachedFCMToken();
                if (token == null) {
                    return;
                }
                this.pushDeviceToken(this.context, token, register, PushType.FCM);
                this.havePushedDeviceToken = true;
            }
            catch (Throwable t) {
                this.getConfigLogger().verbose(this.getAccountId(), "FcmManager: pushing device token failed", t);
            }
        }
    }

    private void deviceTokenDidRefresh(String token, PushType type) {
        if (this.tokenRefreshListener != null) {
            this.getConfigLogger().debug(this.getAccountId(), "Notifying devicePushTokenDidRefresh: " + token);
            this.tokenRefreshListener.devicePushTokenDidRefresh(token, type);
        }
    }

    public static void setDebugLevel(int level) {
        debugLevel = level;
    }

    public static void setDebugLevel(LogLevel level) {
        debugLevel = level.intValue();
    }

    public static int getDebugLevel() {
        return debugLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushValidationResult(ValidationResult vr) {
        Boolean bl = pendingValidationResultsLock;
        synchronized (bl) {
            try {
                int len = this.pendingValidationResults.size();
                if (len > 50) {
                    ArrayList<ValidationResult> trimmed = new ArrayList<ValidationResult>();
                    for (int i = 10; i < len; ++i) {
                        trimmed.add(this.pendingValidationResults.get(i));
                    }
                    trimmed.add(vr);
                    this.pendingValidationResults = trimmed;
                } else {
                    this.pendingValidationResults.add(vr);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setOffline(boolean value) {
        this.offline = value;
        if (this.offline) {
            this.getConfigLogger().debug(this.getAccountId(), "CleverTap Instance has been set to offline, won't send events queue");
        } else {
            this.getConfigLogger().debug(this.getAccountId(), "CleverTap Instance has been set to online, sending events queue");
            this.flush();
        }
    }

    private boolean isOffline() {
        return this.offline;
    }

    public void enableDeviceNetworkInfoReporting(boolean value) {
        this.enableNetworkInfoReporting = value;
        StorageHelper.putBoolean(this.context, this.storageKeyWithSuffix("NetworkInfo"), this.enableNetworkInfoReporting);
        this.getConfigLogger().verbose(this.getAccountId(), "Device Network Information reporting set to " + this.enableNetworkInfoReporting);
    }

    private void setDeviceNetworkInfoReportingFromStorage() {
        boolean enabled = this.getBooleanFromPrefs("NetworkInfo");
        this.getConfigLogger().verbose(this.getAccountId(), "Setting device network info reporting state from storage to " + enabled);
        this.enableNetworkInfoReporting = enabled;
    }

    private void manifestAsyncValidation() {
        this.postAsyncSafely("Manifest Validation", new Runnable(){

            @Override
            public void run() {
                ManifestValidator.validate(CleverTapAPI.this.context, CleverTapAPI.this.deviceInfo);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCurrentUserOptedOut() {
        Object object = this.optOutFlagLock;
        synchronized (object) {
            return this.currentUserOptedOut;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentUserOptedOut(boolean enable) {
        Object object = this.optOutFlagLock;
        synchronized (object) {
            this.currentUserOptedOut = enable;
        }
    }

    public void setOptOut(boolean userOptOut) {
        final boolean enable = userOptOut;
        this.postAsyncSafely("setOptOut", new Runnable(){

            @Override
            public void run() {
                HashMap<String, Object> optOutMap = new HashMap<String, Object>();
                optOutMap.put("ct_optout", enable);
                if (enable) {
                    CleverTapAPI.this.pushProfile(optOutMap);
                    CleverTapAPI.this.setCurrentUserOptedOut(true);
                } else {
                    CleverTapAPI.this.setCurrentUserOptedOut(false);
                    CleverTapAPI.this.pushProfile(optOutMap);
                }
                String key = CleverTapAPI.this.optOutKey();
                if (key == null) {
                    CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "Unable to persist user OptOut state, storage key is null");
                    return;
                }
                StorageHelper.putBoolean(CleverTapAPI.this.context, CleverTapAPI.this.storageKeyWithSuffix(key), enable);
                CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "Set current user OptOut state to: " + enable);
            }
        });
    }

    private String optOutKey() {
        String guid = this.getCleverTapID();
        if (guid == null) {
            return null;
        }
        return "OptOut:" + guid;
    }

    private void setCurrentUserOptOutStateFromStorage() {
        String key = this.optOutKey();
        if (key == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "Unable to set current user OptOut state from storage: storage key is null");
            return;
        }
        boolean storedOptOut = this.getBooleanFromPrefs(key);
        this.setCurrentUserOptedOut(storedOptOut);
        this.getConfigLogger().verbose(this.getAccountId(), "Set current user OptOut state from storage to: " + storedOptOut + " for key: " + key);
    }

    public String getCleverTapID() {
        return this.deviceInfo.getDeviceID();
    }

    public String getCleverTapAttributionIdentifier() {
        return this.deviceInfo.getAttributionID();
    }

    public String getDevicePushToken(PushType type) {
        switch (type) {
            case GCM: {
                return this.getCachedGCMToken();
            }
            case FCM: {
                return this.getCachedFCMToken();
            }
        }
        return null;
    }

    static boolean isAppForeground() {
        return appForeground;
    }

    public static void setAppForeground(boolean appForeground) {
        CleverTapAPI.appForeground = appForeground;
    }

    public void pushDeepLink(Uri uri) {
        this.pushDeepLink(uri, false);
    }

    private synchronized void pushDeepLink(Uri uri, boolean install) {
        if (uri == null) {
            return;
        }
        try {
            JSONObject referrer = UriHelper.getUrchinFromUri(uri);
            if (referrer.has("us")) {
                this.setSource(referrer.get("us").toString());
            }
            if (referrer.has("um")) {
                this.setMedium(referrer.get("um").toString());
            }
            if (referrer.has("uc")) {
                this.setCampaign(referrer.get("uc").toString());
            }
            referrer.put("referrer", (Object)uri.toString());
            if (install) {
                referrer.put("install", true);
            }
            this.recordPageEventWithExtras(referrer);
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Failed to push deep link", t);
        }
    }

    private void recordPageEventWithExtras(JSONObject extras) {
        try {
            JSONObject jsonObject = new JSONObject();
            if (extras != null && extras.length() > 0) {
                Iterator keys = extras.keys();
                while (keys.hasNext()) {
                    try {
                        String key = (String)keys.next();
                        jsonObject.put(key, (Object)extras.getString(key));
                    }
                    catch (ClassCastException classCastException) {}
                }
            }
            this.queueEvent(this.context, jsonObject, 1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean shouldDeferProcessingEvent(JSONObject event, int eventType) {
        if (this.getConfig().isCreatedPostAppLaunch()) {
            return false;
        }
        if (event.has("evtName")) {
            try {
                if (Arrays.asList(Constants.SYSTEM_EVENTS).contains(event.getString("evtName"))) {
                    return false;
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return eventType == 4 && !this.isAppLaunchPushed();
    }

    private void queueEvent(final Context context, final JSONObject event, final int eventType) {
        this.postAsyncSafely("queueEvent", new Runnable(){

            @Override
            public void run() {
                if (CleverTapAPI.this.isCurrentUserOptedOut()) {
                    String eventString = event == null ? "null" : event.toString();
                    CleverTapAPI.this.getConfigLogger().debug(CleverTapAPI.this.getAccountId(), "Current user is opted out dropping event: " + eventString);
                    return;
                }
                if (CleverTapAPI.this.shouldDeferProcessingEvent(event, eventType)) {
                    CleverTapAPI.this.getConfigLogger().debug(CleverTapAPI.this.getAccountId(), "App Launched not yet processed, re-queuing event " + event + "after 2s");
                    CleverTapAPI.this.getHandlerUsingMainLooper().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            CleverTapAPI.this.postAsyncSafely("queueEventWithDelay", new Runnable(){

                                @Override
                                public void run() {
                                    CleverTapAPI.this.lazyCreateSession(context);
                                    CleverTapAPI.this.addToQueue(context, event, eventType);
                                }
                            });
                        }
                    }, 2000L);
                } else {
                    CleverTapAPI.this.lazyCreateSession(context);
                    CleverTapAPI.this.addToQueue(context, event, eventType);
                }
            }
        });
    }

    private void lazyCreateSession(Context context) {
        if (!this.inCurrentSession()) {
            this.createSession(context);
            this.pushInitialEventsAsync();
        }
    }

    private void createSession(Context context) {
        this.currentSessionId = (int)(System.currentTimeMillis() / 1000L);
        this.getConfigLogger().verbose(this.getAccountId(), "Session created with ID: " + this.currentSessionId);
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        int lastSessionID = this.getIntFromPrefs("lastSessionId", 0);
        int lastSessionTime = this.getIntFromPrefs("sexe", 0);
        if (lastSessionTime > 0) {
            this.lastSessionLength = lastSessionTime - lastSessionID;
        }
        this.getConfigLogger().verbose(this.getAccountId(), "Last session length: " + this.lastSessionLength + " seconds");
        if (lastSessionID == 0) {
            this.firstSession = true;
        }
        SharedPreferences.Editor editor = prefs.edit().putInt(this.storageKeyWithSuffix("lastSessionId"), this.currentSessionId);
        StorageHelper.persist(editor);
    }

    private int getCurrentSession() {
        return this.currentSessionId;
    }

    private void addToQueue(Context context, JSONObject event, int eventType) {
        if (this.isMuted()) {
            return;
        }
        this.processEvent(context, event, eventType);
    }

    private boolean isMuted() {
        int muteTS;
        int now = (int)(System.currentTimeMillis() / 1000L);
        return now - (muteTS = this.getIntFromPrefs("comms_mtd", 0)) < 86400;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(Context context, JSONObject event, int eventType) {
        Boolean bl = this.eventLock;
        synchronized (bl) {
            try {
                String type;
                int n = activityCount = activityCount == 0 ? 1 : activityCount;
                if (eventType == 1) {
                    type = "page";
                } else if (eventType == 2) {
                    type = "ping";
                    this.attachMeta(event, context);
                    if (event.has("bk")) {
                        this.isBgPing = true;
                        event.remove("bk");
                    }
                } else {
                    type = eventType == 3 ? "profile" : (eventType == 5 ? "data" : "event");
                }
                String currentActivityName = this.getScreenName();
                if (currentActivityName != null) {
                    event.put("n", (Object)currentActivityName);
                }
                int session = this.getCurrentSession();
                event.put("s", session);
                event.put("pg", activityCount);
                event.put("type", (Object)type);
                event.put("ep", System.currentTimeMillis() / 1000L);
                event.put("f", this.isFirstSession());
                event.put("lsl", this.getLastSessionLength());
                this.attachPackageNameIfRequired(context, event);
                ValidationResult vr = this.popValidationResult();
                if (vr != null) {
                    event.put("wzrk_error", (Object)this.getErrorObject(vr));
                }
                this.getLocalDataStore().setDataSyncFlag(event);
                this.queueEventToDB(context, event, eventType);
                this.updateLocalStore(context, event, eventType);
                this.scheduleQueueFlush(context);
            }
            catch (Throwable e) {
                this.getConfigLogger().verbose(this.getAccountId(), "Failed to queue event: " + event.toString(), e);
            }
        }
    }

    private int getLastSessionLength() {
        return this.lastSessionLength;
    }

    private boolean isFirstSession() {
        return this.firstSession;
    }

    private void attachPackageNameIfRequired(Context context, JSONObject event) {
        try {
            String type = event.getString("type");
            if ("event".equals(type) && "App Launched".equals(event.getString("evtName"))) {
                event.put("pai", (Object)context.getPackageName());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void attachMeta(JSONObject o, Context context) {
        try {
            o.put("mc", Utils.getMemoryConsumption());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            o.put("nt", (Object)Utils.getCurrentNetworkType(context));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void recordScreen(String screenName) {
        if (screenName == null || !this.currentScreenName.isEmpty() && this.currentScreenName.equals(screenName)) {
            return;
        }
        this.getConfigLogger().debug(this.getAccountId(), "Screen changed to " + screenName);
        this.currentScreenName = screenName;
        this.recordPageEventWithExtras(null);
    }

    private String getScreenName() {
        return this.currentScreenName.equals("") ? null : this.currentScreenName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationResult popValidationResult() {
        ValidationResult vr = null;
        Boolean bl = pendingValidationResultsLock;
        synchronized (bl) {
            try {
                if (!this.pendingValidationResults.isEmpty()) {
                    vr = this.pendingValidationResults.remove(0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vr;
    }

    private JSONObject getErrorObject(ValidationResult vr) {
        JSONObject error = new JSONObject();
        try {
            error.put("c", vr.getErrorCode());
            error.put("d", (Object)vr.getErrorDesc());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return error;
    }

    public void enablePersonalization() {
        this.config.enablePersonalization(true);
    }

    public void disablePersonalization() {
        this.config.enablePersonalization(false);
    }

    private void queueEventToDB(Context context, JSONObject event, int type) {
        DBAdapter.Table table = type == 3 ? DBAdapter.Table.PROFILE_EVENTS : DBAdapter.Table.EVENTS;
        this.queueEventInternal(context, event, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueEventInternal(Context context, JSONObject event, DBAdapter.Table table) {
        Boolean bl = this.eventLock;
        synchronized (bl) {
            DBAdapter adapter = this.loadDBAdapter(context);
            int returnCode = adapter.storeObject(event, table);
            if (returnCode > 0) {
                this.getConfigLogger().debug(this.getAccountId(), "Queued event: " + event.toString());
                this.getConfigLogger().verbose(this.getAccountId(), "Queued event to DB table " + (Object)((Object)table) + ": " + event.toString());
            }
        }
    }

    private DBAdapter loadDBAdapter(Context context) {
        if (this.dbAdapter == null) {
            this.dbAdapter = new DBAdapter(context, this.config);
            this.dbAdapter.cleanupStaleEvents(DBAdapter.Table.EVENTS);
            this.dbAdapter.cleanupStaleEvents(DBAdapter.Table.PROFILE_EVENTS);
            this.dbAdapter.cleanUpPushNotifications();
        }
        return this.dbAdapter;
    }

    private void updateLocalStore(Context context, JSONObject event, int type) {
        if (type == 4) {
            this.getLocalDataStore().persistEvent(context, event, type);
        }
    }

    private void scheduleQueueFlush(final Context context) {
        if (this.commsRunnable == null) {
            this.commsRunnable = new Runnable(){

                @Override
                public void run() {
                    CleverTapAPI.this.flushQueueAsync(context);
                }
            };
        }
        this.getHandlerUsingMainLooper().removeCallbacks(this.commsRunnable);
        this.getHandlerUsingMainLooper().postDelayed(this.commsRunnable, 1000L);
        this.getConfigLogger().verbose(this.getAccountId(), "Scheduling delayed queue flush on main event loop");
    }

    private void flushQueueAsync(final Context context) {
        this.postAsyncSafely("CommsManager#flushQueueAsync", new Runnable(){

            @Override
            public void run() {
                CleverTapAPI.this.flushQueueSync(context);
            }
        });
    }

    private void flushQueueSync(final Context context) {
        if (!this.isNetworkOnline(context)) {
            this.getConfigLogger().verbose(this.getAccountId(), "Network connectivity unavailable. Will retry later");
            return;
        }
        if (this.isOffline()) {
            this.getConfigLogger().debug(this.getAccountId(), "CleverTap Instance has been set to offline, won't send events queue");
            return;
        }
        if (this.needsHandshakeForDomain()) {
            this.mResponseFailureCount = 0;
            this.setDomain(context, null);
            this.performHandshakeForDomain(context, new Runnable(){

                @Override
                public void run() {
                    CleverTapAPI.this.flushDBQueue(context);
                }
            });
        } else {
            this.flushDBQueue(context);
        }
    }

    private boolean isNetworkOnline(Context context) {
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            if (cm == null) {
                return true;
            }
            NetworkInfo netInfo = cm.getActiveNetworkInfo();
            return netInfo != null && netInfo.isConnected();
        }
        catch (Throwable ignore) {
            return true;
        }
    }

    private boolean needsHandshakeForDomain() {
        String domain = this.getDomainFromPrefsOrMetadata();
        return domain == null || this.mResponseFailureCount > 5;
    }

    private String getDomainFromPrefsOrMetadata() {
        try {
            String region = this.config.getAccountRegion();
            if (region != null && region.trim().length() > 0) {
                this.mResponseFailureCount = 0;
                return region.trim().toLowerCase() + "." + "wzrkt.com";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.getStringFromPrefs("comms_dmn", null);
    }

    private void setDomain(Context context, String domainName) {
        this.getConfigLogger().verbose(this.getAccountId(), "Setting domain to " + domainName);
        StorageHelper.putString(context, this.storageKeyWithSuffix("comms_dmn"), domainName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performHandshakeForDomain(Context context, Runnable handshakeSuccessCallback) {
        if (this.isMuted()) {
            return;
        }
        String endpoint = this.getEndpoint(true);
        if (endpoint == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "Unable to perform handshake, endpoint is null");
        }
        this.getConfigLogger().verbose(this.getAccountId(), "Performing handshake with " + endpoint);
        HttpsURLConnection conn = null;
        try {
            conn = this.buildHttpsURLConnection(endpoint);
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                this.getConfigLogger().verbose(this.getAccountId(), "Invalid HTTP status code received for handshake - " + responseCode);
                return;
            }
            this.getConfigLogger().verbose(this.getAccountId(), "Received success from handshake :)");
            if (this.processIncomingHeaders(context, conn)) {
                this.getConfigLogger().verbose(this.getAccountId(), "We are not muted");
                handshakeSuccessCallback.run();
            }
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Failed to perform handshake!", t);
        }
        finally {
            if (conn != null) {
                try {
                    conn.getInputStream().close();
                    conn.disconnect();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private String getEndpoint(boolean defaultToHandshakeURL) {
        String domain = this.getDomain(defaultToHandshakeURL);
        if (domain == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "Unable to configure endpoint, domain is null");
            return null;
        }
        String accountId = this.getAccountId();
        if (accountId == null) {
            this.getConfigLogger().verbose(this.getAccountId(), "Unable to configure endpoint, accountID is null");
            return null;
        }
        String endpoint = "https://" + domain + "?os=Android&t=" + this.deviceInfo.getSdkVersion();
        endpoint = endpoint + "&z=" + accountId;
        boolean needsHandshake = this.needsHandshakeForDomain();
        if (needsHandshake) {
            return endpoint;
        }
        this.currentRequestTimestamp = (int)(System.currentTimeMillis() / 1000L);
        endpoint = endpoint + "&ts=" + this.currentRequestTimestamp;
        return endpoint;
    }

    private HttpsURLConnection buildHttpsURLConnection(String endpoint) throws IOException {
        SSLContext _sslContext;
        URL url = new URL(endpoint);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        conn.setRequestProperty("X-CleverTap-Account-ID", this.getAccountId());
        conn.setRequestProperty("X-CleverTap-Token", this.config.getAccountToken());
        conn.setInstanceFollowRedirects(false);
        if (this.config.isSslPinningEnabled() && (_sslContext = CleverTapAPI.getSSLContext()) != null) {
            conn.setSSLSocketFactory(CleverTapAPI.getPinnedCertsSslSocketfactory(_sslContext));
        }
        return conn;
    }

    private static synchronized SSLContext getSSLContext() {
        if (sslContext == null) {
            sslContext = new SSLContextBuilder().build();
        }
        return sslContext;
    }

    private static SSLSocketFactory getPinnedCertsSslSocketfactory(SSLContext sslContext) {
        if (sslContext == null) {
            return null;
        }
        if (sslSocketFactory == null) {
            try {
                sslSocketFactory = sslContext.getSocketFactory();
                Logger.d("Pinning SSL session to DigiCertGlobalRoot CA certificate");
            }
            catch (Throwable e) {
                Logger.d("Issue in pinning SSL,", e);
            }
        }
        return sslSocketFactory;
    }

    private String getDomain(boolean defaultToHandshakeURL) {
        boolean emptyDomain;
        String domain = this.getDomainFromPrefsOrMetadata();
        boolean bl = emptyDomain = domain == null || domain.trim().length() == 0;
        if (emptyDomain && !defaultToHandshakeURL) {
            return null;
        }
        domain = emptyDomain ? "wzrkt.com/hello" : domain + "/a1";
        return domain;
    }

    private boolean processIncomingHeaders(Context context, HttpsURLConnection conn) {
        String domainName;
        String muteCommand = conn.getHeaderField("X-WZRK-MUTE");
        if (muteCommand != null && muteCommand.trim().length() > 0) {
            if (muteCommand.equals("true")) {
                this.setMuted(context, true);
                return false;
            }
            this.setMuted(context, false);
        }
        if ((domainName = conn.getHeaderField("X-WZRK-RD")) == null || domainName.trim().length() == 0) {
            return true;
        }
        this.setMuted(context, false);
        this.setDomain(context, domainName);
        return true;
    }

    private void setMuted(final Context context, boolean mute) {
        if (mute) {
            int now = (int)(System.currentTimeMillis() / 1000L);
            StorageHelper.putInt(context, this.storageKeyWithSuffix("comms_mtd"), now);
            this.setDomain(context, null);
            this.postAsyncSafely("CommsManager#setMuted", new Runnable(){

                @Override
                public void run() {
                    CleverTapAPI.this.clearQueues(context);
                }
            });
        } else {
            StorageHelper.putInt(context, this.storageKeyWithSuffix("comms_mtd"), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearQueues(Context context) {
        Boolean bl = this.eventLock;
        synchronized (bl) {
            DBAdapter adapter = this.loadDBAdapter(context);
            DBAdapter.Table tableName = DBAdapter.Table.EVENTS;
            adapter.removeEvents(tableName);
            tableName = DBAdapter.Table.PROFILE_EVENTS;
            adapter.removeEvents(tableName);
            this.clearUserContext(context);
        }
    }

    private void clearUserContext(Context context) {
        this.clearIJ(context);
        this._clearARP(context);
        this.clearFirstRequestTimestampIfNeeded(context);
        this.clearLastRequestTimestamp(context);
    }

    private void clearIJ(Context context) {
        SharedPreferences prefs = StorageHelper.getPreferences(context, "IJ");
        SharedPreferences.Editor editor = prefs.edit();
        editor.clear();
        StorageHelper.persist(editor);
    }

    private void _clearARP(Context context) {
        String nameSpaceKey = this.getNamespaceARPKey();
        if (nameSpaceKey == null) {
            return;
        }
        SharedPreferences prefs = StorageHelper.getPreferences(context, nameSpaceKey);
        SharedPreferences.Editor editor = prefs.edit();
        editor.clear();
        StorageHelper.persist(editor);
    }

    private String getNamespaceARPKey() {
        String accountId = this.getAccountId();
        if (accountId == null) {
            return null;
        }
        return "ARP:" + accountId;
    }

    private void clearFirstRequestTimestampIfNeeded(Context context) {
        StorageHelper.putInt(context, this.storageKeyWithSuffix("comms_first_ts"), 0);
    }

    private void clearLastRequestTimestamp(Context context) {
        StorageHelper.putInt(context, this.storageKeyWithSuffix("comms_last_ts"), 0);
    }

    private void flushDBQueue(Context context) {
        this.getConfigLogger().verbose(this.getAccountId(), "Somebody has invoked me to send the queue to CleverTap servers");
        QueueCursor previousCursor = null;
        boolean loadMore = true;
        while (loadMore) {
            QueueCursor cursor = this.getQueuedEvents(context, 50, previousCursor);
            if (cursor == null || cursor.isEmpty().booleanValue()) {
                this.getConfigLogger().verbose(this.getAccountId(), "No events in the queue, bailing");
                break;
            }
            previousCursor = cursor;
            JSONArray queue = cursor.getData();
            if (queue == null || queue.length() <= 0) {
                this.getConfigLogger().verbose(this.getAccountId(), "No events in the queue, bailing");
                break;
            }
            loadMore = this.sendQueue(context, queue);
        }
    }

    private QueueCursor getQueuedEvents(Context context, int batchSize, QueueCursor previousCursor) {
        return this.getQueuedDBEvents(context, batchSize, previousCursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueCursor getQueuedDBEvents(Context context, int batchSize, QueueCursor previousCursor) {
        Boolean bl = this.eventLock;
        synchronized (bl) {
            QueueCursor newCursor = this.getQueueCursor(context, DBAdapter.Table.EVENTS, batchSize, previousCursor);
            if (newCursor.isEmpty().booleanValue() && newCursor.getTableName().equals((Object)DBAdapter.Table.EVENTS)) {
                newCursor = this.getQueueCursor(context, DBAdapter.Table.PROFILE_EVENTS, batchSize, null);
            }
            return newCursor.isEmpty() != false ? null : newCursor;
        }
    }

    private QueueCursor updateCursorForDBObject(JSONObject dbObject, QueueCursor cursor) {
        if (dbObject == null) {
            return cursor;
        }
        Iterator keys = dbObject.keys();
        if (keys.hasNext()) {
            String key = (String)keys.next();
            cursor.setLastId(key);
            try {
                cursor.setData(dbObject.getJSONArray(key));
            }
            catch (JSONException e) {
                cursor.setLastId(null);
                cursor.setData(null);
            }
        }
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueCursor getQueueCursor(Context context, DBAdapter.Table table, int batchSize, QueueCursor previousCursor) {
        Boolean bl = this.eventLock;
        synchronized (bl) {
            DBAdapter.Table tableName;
            DBAdapter adapter = this.loadDBAdapter(context);
            DBAdapter.Table table2 = tableName = previousCursor != null ? previousCursor.getTableName() : table;
            if (previousCursor != null) {
                adapter.cleanupEventsFromLastId(previousCursor.getLastId(), previousCursor.getTableName());
            }
            QueueCursor newCursor = new QueueCursor();
            newCursor.setTableName(tableName);
            JSONObject queuedDBEvents = adapter.fetchEvents(tableName, batchSize);
            newCursor = this.updateCursorForDBObject(queuedDBEvents, newCursor);
            return newCursor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean sendQueue(Context context, JSONArray queue) {
        boolean bl;
        URLConnection conn;
        block32: {
            block30: {
                boolean bl2;
                block31: {
                    String req;
                    String endpoint;
                    block28: {
                        boolean bl3;
                        block29: {
                            block26: {
                                boolean bl4;
                                block27: {
                                    if (queue == null || queue.length() <= 0) {
                                        return false;
                                    }
                                    if (this.getCleverTapID() == null) {
                                        this.getConfigLogger().debug(this.getAccountId(), "CleverTap Id not finalized, unable to send queue");
                                        return false;
                                    }
                                    conn = null;
                                    endpoint = this.getEndpoint(false);
                                    if (endpoint != null) break block26;
                                    this.getConfigLogger().debug(this.getAccountId(), "Problem configuring queue endpoint, unable to send queue");
                                    bl4 = false;
                                    if (conn == null) break block27;
                                    try {
                                        conn.getInputStream().close();
                                        ((HttpURLConnection)conn).disconnect();
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                                return bl4;
                            }
                            conn = this.buildHttpsURLConnection(endpoint);
                            req = this.insertHeader(context, queue);
                            if (req != null) break block28;
                            this.getConfigLogger().debug(this.getAccountId(), "Problem configuring queue request, unable to send queue");
                            bl3 = false;
                            if (conn == null) break block29;
                            try {
                                conn.getInputStream().close();
                                ((HttpURLConnection)conn).disconnect();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        return bl3;
                    }
                    this.getConfigLogger().debug(this.getAccountId(), "Send queue contains " + queue.length() + " items: " + req);
                    this.getConfigLogger().debug(this.getAccountId(), "Sending queue to: " + endpoint);
                    conn.setDoOutput(true);
                    conn.getOutputStream().write(req.getBytes("UTF-8"));
                    int responseCode = ((HttpURLConnection)conn).getResponseCode();
                    if (responseCode != 200) {
                        throw new IOException("Response code is not 200. It is " + responseCode);
                    }
                    String newDomain = conn.getHeaderField("X-WZRK-RD");
                    if (newDomain == null || newDomain.trim().length() <= 0 || !this.hasDomainChanged(newDomain)) break block30;
                    this.setDomain(context, newDomain);
                    this.getConfigLogger().debug(this.getAccountId(), "The domain has changed to " + newDomain + ". The request will be retried shortly.");
                    bl2 = false;
                    if (conn == null) break block31;
                    try {
                        conn.getInputStream().close();
                        ((HttpURLConnection)conn).disconnect();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            if (this.processIncomingHeaders(context, (HttpsURLConnection)conn)) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                String body = sb.toString();
                this.processResponse(context, body);
            }
            this.setLastRequestTimestamp(context, this.currentRequestTimestamp);
            this.setFirstRequestTimestampIfNeeded(context, this.currentRequestTimestamp);
            this.getConfigLogger().debug(this.getAccountId(), "Queue sent successfully");
            this.mResponseFailureCount = 0;
            bl = true;
            if (conn == null) break block32;
            try {
                conn.getInputStream().close();
                ((HttpURLConnection)conn).disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return bl;
        catch (Throwable e) {
            try {
                this.getConfigLogger().debug(this.getAccountId(), "An exception occurred while sending the queue, will retry: " + e.getLocalizedMessage());
                ++this.mResponseFailureCount;
                this.scheduleQueueFlush(context);
                boolean bl5 = false;
                return bl5;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.getInputStream().close();
                        ((HttpURLConnection)conn).disconnect();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    private String insertHeader(Context context, JSONArray arr) {
        try {
            long j;
            JSONObject header = new JSONObject();
            String deviceId = this.getCleverTapID();
            if (deviceId != null && !deviceId.equals("")) {
                header.put("g", (Object)deviceId);
            } else {
                this.getConfigLogger().verbose(this.getAccountId(), "CRITICAL: Couldn't finalise on a device ID!");
            }
            header.put("type", (Object)"meta");
            JSONObject appFields = this.getAppLaunchedFields();
            header.put("af", (Object)appFields);
            long i = this.getI();
            if (i > 0L) {
                header.put("_i", i);
            }
            if ((j = this.getJ()) > 0L) {
                header.put("_j", j);
            }
            String accountId = this.getAccountId();
            String token = this.config.getAccountToken();
            if (accountId == null || token == null) {
                this.getConfigLogger().debug(this.getAccountId(), "Account ID/token not found, unable to configure queue request");
                return null;
            }
            header.put("id", (Object)accountId);
            header.put("tk", (Object)token);
            header.put("l_ts", this.getLastRequestTimestamp());
            header.put("f_ts", this.getFirstRequestTimestamp());
            header.put("ddnd", !this.deviceInfo.getNotificationsEnabledForUser() || this.getCachedGCMToken() == null && this.getCachedFCMToken() == null);
            if (this.isBgPing) {
                header.put("bk", 1);
                this.isBgPing = false;
            }
            header.put("rtl", (Object)this.getRenderedTargetList());
            try {
                JSONObject arp = this.getARP(context);
                if (arp != null && arp.length() > 0) {
                    header.put("arp", (Object)arp);
                }
            }
            catch (Throwable t) {
                this.getConfigLogger().verbose(this.getAccountId(), "Failed to attach ARP", t);
            }
            JSONObject ref = new JSONObject();
            try {
                String utmCampaign;
                String utmMedium;
                String utmSource = this.getSource();
                if (utmSource != null) {
                    ref.put("us", (Object)utmSource);
                }
                if ((utmMedium = this.getMedium()) != null) {
                    ref.put("um", (Object)utmMedium);
                }
                if ((utmCampaign = this.getCampaign()) != null) {
                    ref.put("uc", (Object)utmCampaign);
                }
                if (ref.length() > 0) {
                    header.put("ref", (Object)ref);
                }
            }
            catch (Throwable t) {
                this.getConfigLogger().verbose(this.getAccountId(), "Failed to attach ref", t);
            }
            JSONObject wzrkParams = this.getWzrkParams();
            if (wzrkParams != null && wzrkParams.length() > 0) {
                header.put("wzrk_ref", (Object)wzrkParams);
            }
            this.inAppFCManager.attachToHeader(context, header);
            return "[" + header.toString() + ", " + arr.toString().substring(1);
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "CommsManager: Failed to attach header", t);
            return arr.toString();
        }
    }

    private boolean hasDomainChanged(String newDomain) {
        String oldDomain = this.getStringFromPrefs("comms_dmn", null);
        return !newDomain.equals(oldDomain);
    }

    private void processResponse(final Context context, String responseStr) {
        block44: {
            if (responseStr == null) {
                this.getConfigLogger().verbose(this.getAccountId(), "Problem processing queue response, response is null");
                return;
            }
            try {
                this.getConfigLogger().verbose(this.getAccountId(), "Trying to process response: " + responseStr);
                JSONObject response = new JSONObject(responseStr);
                try {
                    if (!this.config.isAnalyticsOnly()) {
                        this.processInAppResponse(response, context);
                    }
                }
                catch (Throwable t) {
                    this.getConfigLogger().verbose(this.getAccountId(), "Failed to process in-app notifications from the response!", t);
                }
                try {
                    if (response.has("g")) {
                        String deviceID = response.getString("g");
                        this.deviceInfo.forceUpdateDeviceId(deviceID);
                        this.getConfigLogger().verbose(this.getAccountId(), "Got a new device ID: " + deviceID);
                    }
                }
                catch (Throwable t) {
                    this.getConfigLogger().verbose(this.getAccountId(), "Failed to update device ID!", t);
                }
                try {
                    this.getLocalDataStore().syncWithUpstream(context, response);
                }
                catch (Throwable t) {
                    this.getConfigLogger().verbose(this.getAccountId(), "Failed to sync local cache with upstream", t);
                }
                try {
                    JSONObject arp;
                    if (response.has("arp") && (arp = (JSONObject)response.get("arp")).length() > 0) {
                        this.handleARPUpdate(context, arp);
                    }
                }
                catch (Throwable t) {
                    this.getConfigLogger().verbose(this.getAccountId(), "Failed to process ARP", t);
                }
                try {
                    if (response.has("_i")) {
                        long i = response.getLong("_i");
                        this.setI(context, i);
                    }
                }
                catch (Throwable i) {
                    // empty catch block
                }
                try {
                    if (response.has("_j")) {
                        long j = response.getLong("_j");
                        this.setJ(context, j);
                    }
                }
                catch (Throwable j) {
                    // empty catch block
                }
                try {
                    JSONArray console;
                    if (response.has("console") && (console = (JSONArray)response.get("console")).length() > 0) {
                        for (int i = 0; i < console.length(); ++i) {
                            this.getConfigLogger().debug(this.getAccountId(), console.get(i).toString());
                        }
                    }
                }
                catch (Throwable console) {
                    // empty catch block
                }
                try {
                    int debugLevel;
                    if (response.has("dbg_lvl") && (debugLevel = response.getInt("dbg_lvl")) >= 0) {
                        CleverTapAPI.setDebugLevel(debugLevel);
                        this.getConfigLogger().verbose(this.getAccountId(), "Set debug level to " + debugLevel + " for this session (set by upstream)");
                    }
                }
                catch (Throwable debugLevel) {
                    // empty catch block
                }
                try {
                    this.inAppFCManager.processResponse(context, response);
                }
                catch (Throwable debugLevel) {
                    // empty catch block
                }
                if (!this.getConfig().isAnalyticsOnly()) {
                    try {
                        this.getConfigLogger().verbose(this.getAccountId(), "Processing inbox messages...");
                        this.processInboxResponse(response);
                    }
                    catch (Throwable t) {
                        this.getConfigLogger().verbose("Notification inbox exception: " + t.getLocalizedMessage());
                    }
                }
                if (this.getConfig().isAnalyticsOnly()) break block44;
                try {
                    if (!response.has("pushamp_notifs")) break block44;
                    this.getConfigLogger().verbose(this.getAccountId(), "Processing pushamp messages...");
                    JSONObject pushAmpObject = response.getJSONObject("pushamp_notifs");
                    JSONArray pushNotifications = pushAmpObject.getJSONArray("list");
                    if (pushNotifications.length() > 0) {
                        this.getConfigLogger().verbose(this.getAccountId(), "Handling Push payload locally");
                        this.handlePushNotificationsInResponse(pushNotifications);
                    }
                    if (pushAmpObject.has("pf")) {
                        try {
                            int frequency = pushAmpObject.getInt("pf");
                            this.getConfigLogger().verbose("Ping frequency received - " + frequency);
                            this.getConfigLogger().verbose("Stored Ping Frequency - " + this.getPingFrequency(context));
                            if (frequency != this.getPingFrequency(context)) {
                                this.setPingFrequency(context, frequency);
                                if (this.config.isBackgroundSync() && !this.config.isAnalyticsOnly()) {
                                    this.postAsyncSafely("createOrResetJobScheduler", new Runnable(){

                                        @Override
                                        public void run() {
                                            if (Build.VERSION.SDK_INT >= 21) {
                                                CleverTapAPI.this.getConfigLogger().verbose("Creating job");
                                                CleverTapAPI.this.createOrResetJobScheduler(context);
                                            } else {
                                                CleverTapAPI.this.getConfigLogger().verbose("Resetting alarm");
                                                CleverTapAPI.this.resetAlarmScheduler(context);
                                            }
                                        }
                                    });
                                }
                            }
                        }
                        catch (Throwable t) {
                            this.getConfigLogger().verbose("Error handling ping frequency in response : " + t.getMessage());
                        }
                    }
                    if (pushAmpObject.has("ack")) {
                        boolean ack = pushAmpObject.getBoolean("ack");
                        this.getConfigLogger().verbose("Received ACK -" + ack);
                        if (ack) {
                            JSONArray rtlArray = this.getRenderedTargetList();
                            String[] rtlStringArray = new String[]{};
                            if (rtlArray != null) {
                                rtlStringArray = new String[rtlArray.length()];
                            }
                            for (int i = 0; i < rtlStringArray.length; ++i) {
                                rtlStringArray[i] = rtlArray.getString(i);
                            }
                            this.getConfigLogger().verbose("Updating RTL values...");
                            this.dbAdapter.updatePushNotificationIds(rtlStringArray);
                        }
                    }
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable t) {
                ++this.mResponseFailureCount;
                this.getConfigLogger().verbose(this.getAccountId(), "Problem process send queue response", t);
            }
        }
    }

    private int getPingFrequency(Context context) {
        return StorageHelper.getInt(context, "pf", 240);
    }

    private void setPingFrequency(Context context, int pingFrequency) {
        StorageHelper.putInt(context, "pf", pingFrequency);
    }

    private JSONArray getRenderedTargetList() {
        String[] pushIds = this.dbAdapter.fetchPushNotificationIds();
        JSONArray renderedTargets = new JSONArray();
        for (int i = 0; i < pushIds.length; ++i) {
            Logger.v("RTL IDs -" + pushIds[i]);
            renderedTargets.put((Object)pushIds[i]);
        }
        return renderedTargets;
    }

    private void processInAppResponse(JSONObject response, final Context context) {
        try {
            JSONArray inappNotifs;
            this.getConfigLogger().verbose(this.getAccountId(), "InApp: Processing response");
            if (!response.has("inapp_notifs")) {
                this.getConfigLogger().verbose(this.getAccountId(), "InApp: Response JSON object doesn't contain the inapp key, bailing");
                return;
            }
            int perSession = 10;
            int perDay = 10;
            if (response.has("imc") && response.get("imc") instanceof Integer) {
                perSession = response.getInt("imc");
            }
            if (response.has("imp") && response.get("imp") instanceof Integer) {
                perDay = response.getInt("imp");
            }
            this.inAppFCManager.updateLimits(context, perDay, perSession);
            try {
                inappNotifs = response.getJSONArray("inapp_notifs");
            }
            catch (JSONException e) {
                this.getConfigLogger().debug(this.getAccountId(), "InApp: In-app key didn't contain a valid JSON array");
                return;
            }
            SharedPreferences prefs = StorageHelper.getPreferences(context);
            SharedPreferences.Editor editor = prefs.edit();
            try {
                JSONArray inappsFromPrefs = new JSONArray(this.getStringFromPrefs("inApp", "[]"));
                if (inappNotifs != null && inappNotifs.length() > 0) {
                    for (int i = 0; i < inappNotifs.length(); ++i) {
                        try {
                            JSONObject inappNotif = inappNotifs.getJSONObject(i);
                            inappsFromPrefs.put((Object)inappNotif);
                            continue;
                        }
                        catch (JSONException e) {
                            Logger.v("InAppManager: Malformed inapp notification");
                        }
                    }
                }
                editor.putString(this.storageKeyWithSuffix("inApp"), inappsFromPrefs.toString());
                StorageHelper.persist(editor);
            }
            catch (Throwable e) {
                this.getConfigLogger().verbose(this.getAccountId(), "InApp: Failed to parse the in-app notifications properly");
                this.getConfigLogger().verbose(this.getAccountId(), "InAppManager: Reason: " + e.getMessage(), e);
            }
            this.runOnNotificationQueue(new Runnable(){

                @Override
                public void run() {
                    CleverTapAPI.this._showNotificationIfAvailable(context);
                }
            });
        }
        catch (Throwable t) {
            Logger.v("InAppManager: Failed to parse response", t);
        }
    }

    private void showNotificationIfAvailable(final Context context) {
        if (!this.config.isAnalyticsOnly()) {
            this.runOnNotificationQueue(new Runnable(){

                @Override
                public void run() {
                    CleverTapAPI.this._showNotificationIfAvailable(context);
                }
            });
        }
    }

    private void _showNotificationIfAvailable(Context context) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        try {
            if (!this.canShowInAppOnActivity()) {
                Logger.v("Not showing notification on blacklisted activity");
                return;
            }
            CleverTapAPI.checkPendingNotifications(context, this.config);
            JSONArray inapps = new JSONArray(this.getStringFromPrefs("inApp", "[]"));
            if (inapps.length() < 1) {
                return;
            }
            JSONObject inapp = inapps.getJSONObject(0);
            this.prepareNotificationForDisplay(inapp);
            JSONArray inappsUpdated = new JSONArray();
            for (int i = 0; i < inapps.length(); ++i) {
                if (i == 0) continue;
                inappsUpdated.put(inapps.get(i));
            }
            SharedPreferences.Editor editor = prefs.edit().putString(this.storageKeyWithSuffix("inApp"), inappsUpdated.toString());
            StorageHelper.persist(editor);
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "InApp: Couldn't parse JSON array string from prefs", t);
        }
    }

    private void prepareNotificationForDisplay(JSONObject jsonObject) {
        this.getConfigLogger().debug(this.getAccountId(), "Preparing In-App for display: " + jsonObject.toString());
        this.runOnNotificationQueue(new NotificationPrepareRunnable(this, jsonObject));
    }

    @Override
    public void notificationReady(final CTInAppNotification inAppNotification) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            this.getHandlerUsingMainLooper().post(new Runnable(){

                @Override
                public void run() {
                    CleverTapAPI.this.notificationReady(inAppNotification);
                }
            });
            return;
        }
        if (inAppNotification.getError() != null) {
            this.getConfigLogger().debug(this.getAccountId(), "Unable to process inapp notification " + inAppNotification.getError());
            return;
        }
        this.getConfigLogger().debug(this.getAccountId(), "Notification ready: " + inAppNotification.getJsonDescription());
        this.displayNotification(inAppNotification);
    }

    private void displayNotification(final CTInAppNotification inAppNotification) {
        boolean goFromListener;
        if (Looper.myLooper() != Looper.getMainLooper()) {
            this.getHandlerUsingMainLooper().post(new Runnable(){

                @Override
                public void run() {
                    CleverTapAPI.this.displayNotification(inAppNotification);
                }
            });
            return;
        }
        if (!this.inAppFCManager.canShow(inAppNotification)) {
            this.getConfigLogger().verbose(this.getAccountId(), "InApp has been rejected by FC, not showing " + inAppNotification.getCampaignId());
            this.showInAppNotificationIfAny();
            return;
        }
        this.inAppFCManager.didShow(this.context, inAppNotification);
        InAppNotificationListener listener = this.getInAppNotificationListener();
        if (listener != null) {
            HashMap<String, Object> kvs = inAppNotification.getCustomExtras() != null ? Utils.convertJSONObjectToHashMap(inAppNotification.getCustomExtras()) : new HashMap();
            goFromListener = listener.beforeShow(kvs);
        } else {
            goFromListener = true;
        }
        if (!goFromListener) {
            this.getConfigLogger().verbose(this.getAccountId(), "Application has decided to not show this in-app notification: " + inAppNotification.getCampaignId());
            this.showInAppNotificationIfAny();
            return;
        }
        CleverTapAPI.showInApp(this.context, inAppNotification, this.config);
    }

    private static void inAppDidDismiss(Context context, CleverTapInstanceConfig config, CTInAppNotification inAppNotification) {
        Logger.v(config.getAccountId(), "Running inAppDidDismiss");
        if (currentlyDisplayingInApp != null && currentlyDisplayingInApp.getCampaignId().equals(inAppNotification.getCampaignId())) {
            currentlyDisplayingInApp = null;
            CleverTapAPI.checkPendingNotifications(context, config);
        }
    }

    private static void checkPendingNotifications(final Context context, final CleverTapInstanceConfig config) {
        Logger.v(config.getAccountId(), "checking Pending Notifications");
        if (pendingNotifications != null && !pendingNotifications.isEmpty()) {
            try {
                final CTInAppNotification notification = pendingNotifications.get(0);
                pendingNotifications.remove(0);
                Handler mainHandler = new Handler(context.getMainLooper());
                mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        CleverTapAPI.showInApp(context, notification, config);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void showInApp(Context context, CTInAppNotification inAppNotification, CleverTapInstanceConfig config) {
        Logger.v(config.getAccountId(), "Attempting to show next In-App");
        if (!appForeground) {
            pendingNotifications.add(inAppNotification);
            Logger.v(config.getAccountId(), "Not in foreground, queueing this In App");
            return;
        }
        if (currentlyDisplayingInApp != null) {
            pendingNotifications.add(inAppNotification);
            Logger.v(config.getAccountId(), "In App already displaying, queueing this In App");
            return;
        }
        currentlyDisplayingInApp = inAppNotification;
        CTInAppBasePartialFragment inAppFragment = null;
        CTInAppType type = inAppNotification.getInAppType();
        switch (type) {
            case CTInAppTypeCoverHTML: 
            case CTInAppTypeInterstitialHTML: 
            case CTInAppTypeHalfInterstitialHTML: 
            case CTInAppTypeCover: 
            case CTInAppTypeHalfInterstitial: 
            case CTInAppTypeInterstitial: 
            case CTInAppTypeAlert: 
            case CTInAppTypeInterstitialImageOnly: 
            case CTInAppTypeHalfInterstitialImageOnly: 
            case CTInAppTypeCoverImageOnly: {
                Intent intent = new Intent(context, InAppNotificationActivity.class);
                intent.putExtra("inApp", (Parcelable)inAppNotification);
                intent.putExtra("config", (Parcelable)config);
                try {
                    Activity currentActivity = CleverTapAPI.getCurrentActivity();
                    if (currentActivity == null) {
                        throw new IllegalStateException("Current activity reference not found");
                    }
                    config.getLogger().verbose(config.getAccountId(), "calling InAppActivity for notification: " + inAppNotification.getJsonDescription());
                    currentActivity.startActivity(intent);
                    Logger.d("Displaying In-App: " + inAppNotification.getJsonDescription());
                }
                catch (Throwable t) {
                    Logger.v("Please verify the integration of your app. It is not setup to support in-app notifications yet.", t);
                }
                break;
            }
            case CTInAppTypeFooterHTML: {
                inAppFragment = new CTInAppHtmlFooterFragment();
                break;
            }
            case CTInAppTypeHeaderHTML: {
                inAppFragment = new CTInAppHtmlHeaderFragment();
                break;
            }
            case CTInAppTypeFooter: {
                inAppFragment = new CTInAppNativeFooterFragment();
                break;
            }
            case CTInAppTypeHeader: {
                inAppFragment = new CTInAppNativeHeaderFragment();
                break;
            }
            default: {
                Logger.d(config.getAccountId(), "Unknown InApp Type found: " + (Object)((Object)type));
                currentlyDisplayingInApp = null;
                return;
            }
        }
        if (inAppFragment != null) {
            Logger.d("Displaying In-App: " + inAppNotification.getJsonDescription());
            try {
                FragmentTransaction fragmentTransaction = CleverTapAPI.getCurrentActivity().getFragmentManager().beginTransaction();
                Bundle bundle = new Bundle();
                bundle.putParcelable("inApp", (Parcelable)inAppNotification);
                bundle.putParcelable("config", (Parcelable)config);
                inAppFragment.setArguments(bundle);
                fragmentTransaction.setCustomAnimations(0x10B0000, 0x10B0001);
                fragmentTransaction.add(0x1020002, (Fragment)inAppFragment);
                Logger.v(config.getAccountId(), "calling InAppFragment " + inAppNotification.getCampaignId());
                fragmentTransaction.commit();
            }
            catch (Throwable t) {
                Logger.v(config.getAccountId(), "Fragment not able to render", t);
            }
        }
    }

    private void showInAppNotificationIfAny() {
        if (!this.config.isAnalyticsOnly()) {
            this.runOnNotificationQueue(new Runnable(){

                @Override
                public void run() {
                    CleverTapAPI.this._showNotificationIfAvailable(CleverTapAPI.this.context);
                }
            });
        }
    }

    public void setInAppNotificationListener(InAppNotificationListener inAppNotificationListener) {
        this.inAppNotificationListener = inAppNotificationListener;
    }

    public InAppNotificationListener getInAppNotificationListener() {
        return this.inAppNotificationListener;
    }

    private boolean canShowInAppOnActivity() {
        this.updateBlacklistedActivitySet();
        for (String blacklistedActivity : this.inappActivityExclude) {
            String currentActivityName = CleverTapAPI.getCurrentActivityName();
            if (currentActivityName == null || !currentActivityName.contains(blacklistedActivity)) continue;
            return false;
        }
        return true;
    }

    private void updateBlacklistedActivitySet() {
        if (this.inappActivityExclude == null) {
            this.inappActivityExclude = new HashSet();
            try {
                String activities = ManifestInfo.getInstance(this.context).getExcludedActivities();
                if (activities != null) {
                    String[] split;
                    for (String a : split = activities.split(",")) {
                        this.inappActivityExclude.add(a.trim());
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.getConfigLogger().debug(this.getAccountId(), "In-app notifications will not be shown on " + Arrays.toString(this.inappActivityExclude.toArray()));
        }
    }

    private void setLastRequestTimestamp(Context context, int ts) {
        StorageHelper.putInt(context, this.storageKeyWithSuffix("comms_last_ts"), ts);
    }

    private void setFirstRequestTimestampIfNeeded(Context context, int ts) {
        if (this.getFirstRequestTimestamp() > 0) {
            return;
        }
        StorageHelper.putInt(context, this.storageKeyWithSuffix("comms_first_ts"), ts);
    }

    private int getFirstRequestTimestamp() {
        return this.getIntFromPrefs("comms_first_ts", 0);
    }

    private int getLastRequestTimestamp() {
        return this.getIntFromPrefs("comms_last_ts", 0);
    }

    private JSONObject getAppLaunchedFields() {
        try {
            JSONObject evtData = new JSONObject();
            evtData.put("Build", (Object)(this.deviceInfo.getBuild() + ""));
            evtData.put("Version", (Object)this.deviceInfo.getVersionName());
            evtData.put("OS Version", (Object)this.deviceInfo.getOsVersion());
            evtData.put("SDK Version", this.deviceInfo.getSdkVersion());
            if (this.locationFromUser != null) {
                evtData.put("Latitude", this.locationFromUser.getLatitude());
                evtData.put("Longitude", this.locationFromUser.getLongitude());
            }
            if (this.deviceInfo.getGoogleAdID() != null) {
                String baseAdIDKey = "GoogleAdID";
                String adIDKey = this.deviceIsMultiUser() ? "mt_" + baseAdIDKey : baseAdIDKey;
                evtData.put(adIDKey, (Object)this.deviceInfo.getGoogleAdID());
                evtData.put("GoogleAdIDLimit", this.deviceInfo.isLimitAdTrackingEnabled());
            }
            try {
                evtData.put("Make", (Object)this.deviceInfo.getManufacturer());
                evtData.put("Model", (Object)this.deviceInfo.getModel());
                evtData.put("Carrier", (Object)this.deviceInfo.getCarrier());
                evtData.put("useIP", this.enableNetworkInfoReporting);
                evtData.put("OS", (Object)this.deviceInfo.getOsName());
                evtData.put("wdt", this.deviceInfo.getWidth());
                evtData.put("hgt", this.deviceInfo.getHeight());
                evtData.put("dpi", this.deviceInfo.getDPI());
                String cc = this.deviceInfo.getCountryCode();
                if (cc != null && !cc.equals("")) {
                    evtData.put("cc", (Object)cc);
                }
                if (this.enableNetworkInfoReporting) {
                    String radio;
                    String bluetoothVersion;
                    Boolean isBluetoothEnabled;
                    Boolean isWifi = this.deviceInfo.isWifiConnected();
                    if (isWifi != null) {
                        evtData.put("wifi", (Object)isWifi);
                    }
                    if ((isBluetoothEnabled = this.deviceInfo.isBluetoothEnabled()) != null) {
                        evtData.put("BluetoothEnabled", (Object)isBluetoothEnabled);
                    }
                    if ((bluetoothVersion = this.deviceInfo.getBluetoothVersion()) != null) {
                        evtData.put("BluetoothVersion", (Object)bluetoothVersion);
                    }
                    if ((radio = this.deviceInfo.getNetworkType()) != null) {
                        evtData.put("Radio", (Object)radio);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return evtData;
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Failed to construct App Launched event", t);
            return new JSONObject();
        }
    }

    private JSONObject getARP(Context context) {
        try {
            String nameSpaceKey = this.getNamespaceARPKey();
            if (nameSpaceKey == null) {
                return null;
            }
            SharedPreferences prefs = StorageHelper.getPreferences(context, nameSpaceKey);
            Map all = prefs.getAll();
            Iterator iter = all.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry kv = iter.next();
                Object o = kv.getValue();
                if (!(o instanceof Number) || ((Number)o).intValue() != -1) continue;
                iter.remove();
            }
            JSONObject ret = new JSONObject(all);
            this.getConfigLogger().verbose(this.getAccountId(), "Fetched ARP for namespace key: " + nameSpaceKey + " values: " + all.toString());
            return ret;
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Failed to construct ARP object", t);
            return null;
        }
    }

    private long getI() {
        return this.getLongFromPrefs("comms_i", 0, "IJ");
    }

    private long getJ() {
        return this.getLongFromPrefs("comms_j", 0, "IJ");
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private void setJ(Context context, long j) {
        SharedPreferences prefs = StorageHelper.getPreferences(context, "IJ");
        SharedPreferences.Editor editor = prefs.edit();
        editor.putLong(this.storageKeyWithSuffix("comms_j"), j);
        StorageHelper.persist(editor);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private void setI(Context context, long i) {
        SharedPreferences prefs = StorageHelper.getPreferences(context, "IJ");
        SharedPreferences.Editor editor = prefs.edit();
        editor.putLong(this.storageKeyWithSuffix("comms_i"), i);
        StorageHelper.persist(editor);
    }

    private void handleARPUpdate(Context context, JSONObject arp) {
        if (arp == null || arp.length() == 0) {
            return;
        }
        String nameSpaceKey = this.getNamespaceARPKey();
        if (nameSpaceKey == null) {
            return;
        }
        SharedPreferences prefs = StorageHelper.getPreferences(context, nameSpaceKey);
        SharedPreferences.Editor editor = prefs.edit();
        Iterator keys = arp.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                Object o = arp.get(key);
                if (o instanceof Number) {
                    int update = ((Number)o).intValue();
                    editor.putInt(key, update);
                    continue;
                }
                if (o instanceof String) {
                    if (((String)o).length() < 100) {
                        editor.putString(key, (String)o);
                        continue;
                    }
                    this.getConfigLogger().verbose(this.getAccountId(), "ARP update for key " + key + " rejected (string value too long)");
                    continue;
                }
                if (o instanceof Boolean) {
                    editor.putBoolean(key, ((Boolean)o).booleanValue());
                    continue;
                }
                this.getConfigLogger().verbose(this.getAccountId(), "ARP update for key " + key + " rejected (invalid data type)");
            }
            catch (JSONException jSONException) {}
        }
        this.getConfigLogger().verbose(this.getAccountId(), "Completed ARP update for namespace key: " + nameSpaceKey + "");
        StorageHelper.persist(editor);
    }

    private boolean deviceIsMultiUser() {
        JSONObject cachedGUIDs = this.getCachedGUIDs();
        return cachedGUIDs.length() > 1;
    }

    private JSONObject getCachedGUIDs() {
        JSONObject cache = null;
        String json = this.getStringFromPrefs("cachedGUIDsKey", null);
        if (json != null) {
            try {
                cache = new JSONObject(json);
            }
            catch (Throwable t) {
                this.getConfigLogger().verbose(this.getAccountId(), "Error reading guid cache: " + t.toString());
            }
        }
        return cache != null ? cache : new JSONObject();
    }

    public SyncListener getSyncListener() {
        return this.syncListener;
    }

    public void setSyncListener(SyncListener syncListener) {
        this.syncListener = syncListener;
    }

    public DevicePushTokenRefreshListener getDevicePushTokenRefreshListener() {
        return this.tokenRefreshListener;
    }

    public void setDevicePushTokenRefreshListener(DevicePushTokenRefreshListener tokenRefreshListener) {
        this.tokenRefreshListener = tokenRefreshListener;
    }

    private void pushBasicProfile(JSONObject baseProfile) {
        try {
            String guid = this.getCleverTapID();
            JSONObject profileEvent = new JSONObject();
            if (baseProfile != null && baseProfile.length() > 0) {
                Iterator i = baseProfile.keys();
                while (i.hasNext()) {
                    String next = i.next().toString();
                    Object value = null;
                    try {
                        value = baseProfile.getJSONObject(next);
                    }
                    catch (Throwable t) {
                        try {
                            value = baseProfile.get(next);
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                    if (value == null) continue;
                    profileEvent.put(next, value);
                    if (!Constants.PROFILE_IDENTIFIER_KEYS.contains(next)) continue;
                    try {
                        this.cacheGUIDForIdentifier(guid, next, value.toString());
                    }
                    catch (Throwable throwable) {}
                }
            }
            try {
                String cc;
                String carrier = this.deviceInfo.getCarrier();
                if (carrier != null && !carrier.equals("")) {
                    profileEvent.put("Carrier", (Object)carrier);
                }
                if ((cc = this.deviceInfo.getCountryCode()) != null && !cc.equals("")) {
                    profileEvent.put("cc", (Object)cc);
                }
                profileEvent.put("tz", (Object)TimeZone.getDefault().getID());
                JSONObject event = new JSONObject();
                event.put("profile", (Object)profileEvent);
                this.queueEvent(this.context, event, 3);
            }
            catch (JSONException e) {
                this.getConfigLogger().verbose(this.getAccountId(), "FATAL: Creating basic profile update event failed!");
            }
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Basic profile sync", t);
        }
    }

    private void cacheGUIDForIdentifier(String guid, String key, String identifier) {
        if (guid == null || key == null || identifier == null) {
            return;
        }
        String cacheKey = key + "_" + identifier;
        JSONObject cache = this.getCachedGUIDs();
        try {
            cache.put(cacheKey, (Object)guid);
            this.setCachedGUIDs(cache);
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Error caching guid: " + t.toString());
        }
    }

    private void setCachedGUIDs(JSONObject cachedGUIDs) {
        if (cachedGUIDs == null) {
            return;
        }
        try {
            StorageHelper.putString(this.context, this.storageKeyWithSuffix("cachedGUIDsKey"), cachedGUIDs.toString());
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Error persisting guid cache: " + t.toString());
        }
    }

    public void pushProfile(final Map<String, Object> profile) {
        if (profile == null || profile.isEmpty()) {
            return;
        }
        this.postAsyncSafely("profilePush", new Runnable(){

            @Override
            public void run() {
                CleverTapAPI.this._push(profile);
            }
        });
    }

    private void _push(Map<String, Object> profile) {
        if (profile == null || profile.isEmpty()) {
            return;
        }
        try {
            JSONObject customProfile = new JSONObject();
            JSONObject fieldsToUpdateLocally = new JSONObject();
            for (String key : profile.keySet()) {
                Object value = profile.get(key);
                ValidationResult vr = this.validator.cleanObjectKey(key);
                key = vr.getObject().toString();
                if (vr.getErrorCode() != 0) {
                    this.pushValidationResult(vr);
                }
                if (key == null || key.isEmpty()) {
                    ValidationResult keyError = new ValidationResult();
                    keyError.setErrorCode(512);
                    String keyErr = "Profile push key is empty";
                    keyError.setErrorDesc("Profile push key is empty");
                    this.pushValidationResult(keyError);
                    this.getConfigLogger().debug(this.getAccountId(), "Profile push key is empty");
                    continue;
                }
                try {
                    vr = this.validator.cleanObjectValue(value, Validator.ValidationContext.Profile);
                }
                catch (Throwable e) {
                    ValidationResult error = new ValidationResult();
                    error.setErrorCode(512);
                    String err = "Object value wasn't a primitive (" + value + ") for profile field " + key;
                    error.setErrorDesc(err);
                    this.pushValidationResult(error);
                    this.getConfigLogger().debug(this.getAccountId(), err);
                    continue;
                }
                value = vr.getObject();
                if (vr.getErrorCode() != 0) {
                    this.pushValidationResult(vr);
                }
                if (key.equalsIgnoreCase("Phone")) {
                    try {
                        String _value;
                        value = value.toString();
                        String countryCode = this.deviceInfo.getCountryCode();
                        if ((countryCode == null || countryCode.isEmpty()) && !(_value = (String)value).startsWith("+")) {
                            ValidationResult error = new ValidationResult();
                            error.setErrorCode(512);
                            String err = "Device country code not available and profile phone: " + value + " does not appear to start with country code";
                            error.setErrorDesc(err);
                            this.pushValidationResult(error);
                            this.getConfigLogger().debug(this.getAccountId(), err);
                        }
                        this.getConfigLogger().verbose(this.getAccountId(), "Profile phone is: " + value + " device country code is: " + (countryCode != null ? countryCode : "null"));
                    }
                    catch (Exception e) {
                        this.pushValidationResult(new ValidationResult(512, "Invalid phone number"));
                        this.getConfigLogger().debug(this.getAccountId(), "Invalid phone number: " + e.getLocalizedMessage());
                        continue;
                    }
                }
                fieldsToUpdateLocally.put(key, value);
                customProfile.put(key, value);
            }
            this.getConfigLogger().verbose(this.getAccountId(), "Constructed custom profile: " + customProfile.toString());
            if (fieldsToUpdateLocally.length() > 0) {
                this.getLocalDataStore().setProfileFields(fieldsToUpdateLocally);
            }
            this.pushBasicProfile(customProfile);
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Failed to push profile", t);
        }
    }

    private synchronized void setSource(String source) {
        if (this.source == null) {
            this.source = source;
        }
    }

    private synchronized void setMedium(String medium) {
        if (this.medium == null) {
            this.medium = medium;
        }
    }

    private synchronized void setCampaign(String campaign) {
        if (this.campaign == null) {
            this.campaign = campaign;
        }
    }

    private synchronized void setWzrkParams(JSONObject wzrkParams) {
        if (this.wzrkParams == null) {
            this.wzrkParams = wzrkParams;
        }
    }

    private synchronized void clearSource() {
        this.source = null;
    }

    private synchronized void clearMedium() {
        this.medium = null;
    }

    private synchronized void clearCampaign() {
        this.campaign = null;
    }

    private synchronized void clearWzrkParams() {
        this.wzrkParams = null;
    }

    private synchronized String getSource() {
        return this.source;
    }

    private synchronized String getMedium() {
        return this.medium;
    }

    private synchronized String getCampaign() {
        return this.campaign;
    }

    private synchronized JSONObject getWzrkParams() {
        return this.wzrkParams;
    }

    private void setLastVisitTime() {
        EventDetail ed = this.getLocalDataStore().getEventDetail("App Launched");
        this.lastVisitTime = ed == null ? -1 : ed.getLastTime();
    }

    public int getTotalVisits() {
        EventDetail ed = this.getLocalDataStore().getEventDetail("App Launched");
        if (ed != null) {
            return ed.getCount();
        }
        return 0;
    }

    public int getScreenCount() {
        return activityCount;
    }

    public int getTimeElapsed() {
        int currentSession = this.getCurrentSession();
        if (currentSession == 0) {
            return -1;
        }
        int now = (int)(System.currentTimeMillis() / 1000L);
        return now - currentSession;
    }

    public int getPreviousVisitTime() {
        return this.lastVisitTime;
    }

    public UTMDetail getUTMDetails() {
        UTMDetail ud = new UTMDetail();
        ud.setSource(this.source);
        ud.setMedium(this.medium);
        ud.setCampaign(this.campaign);
        return ud;
    }

    public void setMultiValuesForKey(final String key, final ArrayList<String> values) {
        this.postAsyncSafely("setMultiValuesForKey", new Runnable(){

            @Override
            public void run() {
                CleverTapAPI.this._handleMultiValues(values, key, "$set");
            }
        });
    }

    public void addMultiValueForKey(String key, String value) {
        if (value == null || value.isEmpty()) {
            this._generateEmptyMultiValueError(key);
            return;
        }
        this.addMultiValuesForKey(key, new ArrayList<String>(Collections.singletonList(value)));
    }

    public void addMultiValuesForKey(final String key, final ArrayList<String> values) {
        this.postAsyncSafely("addMultiValuesForKey", new Runnable(){

            @Override
            public void run() {
                String command = CleverTapAPI.this.getLocalDataStore().getProfileValueForKey(key) != null ? "$add" : "$set";
                CleverTapAPI.this._handleMultiValues(values, key, command);
            }
        });
    }

    public void removeMultiValueForKey(String key, String value) {
        if (value == null || value.isEmpty()) {
            this._generateEmptyMultiValueError(key);
            return;
        }
        this.removeMultiValuesForKey(key, new ArrayList<String>(Collections.singletonList(value)));
    }

    public void removeMultiValuesForKey(final String key, final ArrayList<String> values) {
        this.postAsyncSafely("removeMultiValuesForKey", new Runnable(){

            @Override
            public void run() {
                CleverTapAPI.this._handleMultiValues(values, key, "$remove");
            }
        });
    }

    public void removeValueForKey(final String key) {
        this.postAsyncSafely("removeValueForKey", new Runnable(){

            @Override
            public void run() {
                CleverTapAPI.this._removeValueForKey(key);
            }
        });
    }

    private void _removeValueForKey(String key) {
        try {
            key = key == null ? "" : key;
            ValidationResult vr = this.validator.cleanObjectKey(key);
            key = vr.getObject().toString();
            if (key.isEmpty()) {
                ValidationResult error = new ValidationResult();
                error.setErrorCode(512);
                error.setErrorDesc("Key is empty, profile removeValueForKey aborted.");
                this.pushValidationResult(error);
                this.getConfigLogger().debug(this.getAccountId(), "Key is empty, profile removeValueForKey aborted");
                return;
            }
            if (vr.getErrorCode() != 0) {
                this.pushValidationResult(vr);
            }
            this.getLocalDataStore().removeProfileField(key);
            JSONObject command = new JSONObject().put("$delete", true);
            JSONObject update = new JSONObject().put(key, (Object)command);
            this.pushBasicProfile(update);
            this.getConfigLogger().verbose(this.getAccountId(), "removing value for key " + key + " from user profile");
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Failed to remove profile value for key " + key, t);
        }
    }

    private String getGraphUserPropertySafely(JSONObject graphUser, String key, String def) {
        try {
            String prop = (String)graphUser.get(key);
            if (prop != null) {
                return prop;
            }
            return def;
        }
        catch (Throwable t) {
            return def;
        }
    }

    public void pushFacebookUser(final JSONObject graphUser) {
        this.postAsyncSafely("pushFacebookUser", new Runnable(){

            @Override
            public void run() {
                CleverTapAPI.this._pushFacebookUser(graphUser);
            }
        });
    }

    private void _pushFacebookUser(JSONObject graphUser) {
        try {
            String education;
            String work;
            if (graphUser == null) {
                return;
            }
            String name = this.getGraphUserPropertySafely(graphUser, "name", "");
            try {
                ValidationResult vr = this.validator.cleanObjectValue(name, Validator.ValidationContext.Profile);
                name = vr.getObject().toString();
                if (vr.getErrorCode() != 0) {
                    this.pushValidationResult(vr);
                }
            }
            catch (IllegalArgumentException e) {
                name = "";
            }
            String gender = this.getGraphUserPropertySafely(graphUser, "gender", null);
            gender = gender != null ? (gender.toLowerCase().startsWith("m") ? "M" : (gender.toLowerCase().startsWith("f") ? "F" : "")) : null;
            String email = this.getGraphUserPropertySafely(graphUser, "email", "");
            String birthday = this.getGraphUserPropertySafely(graphUser, "birthday", null);
            if (birthday != null) {
                if (birthday.matches("^../..")) {
                    birthday = "";
                } else {
                    try {
                        Date date = Constants.FB_DOB_DATE_FORMAT.parse(birthday);
                        birthday = "$D_" + (int)(date.getTime() / 1000L);
                    }
                    catch (ParseException e) {
                        birthday = "";
                    }
                }
            }
            try {
                JSONArray workArray = graphUser.getJSONArray("work");
                work = workArray.length() > 0 ? "Y" : "N";
            }
            catch (Throwable t) {
                work = null;
            }
            try {
                JSONArray eduArray = graphUser.getJSONArray("education");
                String fbEdu = eduArray.getJSONObject(eduArray.length() - 1).getString("type");
                education = fbEdu.toLowerCase().contains("high school") ? "School" : (fbEdu.toLowerCase().contains("college") ? "College" : (fbEdu.toLowerCase().contains("graduate school") ? "Graduate" : ""));
            }
            catch (Throwable t) {
                education = null;
            }
            String id2 = this.getGraphUserPropertySafely(graphUser, "id", "");
            String married = this.getGraphUserPropertySafely(graphUser, "relationship_status", null);
            if (married != null) {
                married = married.equalsIgnoreCase("married") ? "Y" : "N";
            }
            JSONObject profile = new JSONObject();
            if (id2 != null && id2.length() > 3) {
                profile.put("FBID", (Object)id2);
            }
            if (name != null && name.length() > 3) {
                profile.put("Name", (Object)name);
            }
            if (email != null && email.length() > 3) {
                profile.put("Email", (Object)email);
            }
            if (gender != null && !gender.trim().equals("")) {
                profile.put("Gender", (Object)gender);
            }
            if (education != null && !education.trim().equals("")) {
                profile.put("Education", (Object)education);
            }
            if (work != null && !work.trim().equals("")) {
                profile.put("Employed", (Object)work);
            }
            if (birthday != null && birthday.length() > 3) {
                profile.put("DOB", (Object)birthday);
            }
            if (married != null && !married.trim().equals("")) {
                profile.put("Married", (Object)married);
            }
            this.pushBasicProfile(profile);
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Failed to parse graph user object successfully", t);
        }
    }

    public void pushGooglePlusPerson(final Person person) {
        this.postAsyncSafely("pushGooglePlusPerson", new Runnable(){

            @Override
            public void run() {
                CleverTapAPI.this._pushGooglePlusPerson(person);
            }
        });
    }

    private void _pushGooglePlusPerson(Person person) {
        if (person == null) {
            return;
        }
        try {
            String name = "";
            if (person.hasDisplayName()) {
                try {
                    name = person.getDisplayName();
                    ValidationResult vr = this.validator.cleanObjectValue(name, Validator.ValidationContext.Profile);
                    name = vr.getObject().toString();
                    if (vr.getErrorCode() != 0) {
                        this.pushValidationResult(vr);
                    }
                }
                catch (Throwable t) {
                    name = "";
                }
            }
            String gender = null;
            if (person.hasGender()) {
                if (person.getGender() == 0) {
                    gender = "M";
                } else if (person.getGender() == 1) {
                    gender = "F";
                }
            }
            String birthday = null;
            if (person.hasBirthday()) {
                try {
                    Date date = Constants.GP_DOB_DATE_FORMAT.parse(person.getBirthday());
                    birthday = "$D_" + (int)(date.getTime() / 1000L);
                }
                finally {
                    String work = null;
                }
            }
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "FATAL: Creating G+ profile update event failed!");
        }
    }

    public Object getProperty(String name) {
        if (!this.config.isPersonalizationEnabled()) {
            return null;
        }
        return this.getLocalDataStore().getProfileProperty(name);
    }

    private Object _getProfilePropertyIgnorePersonalizationFlag(String key) {
        return this.getLocalDataStore().getProfileValueForKey(key);
    }

    private void _handleMultiValues(ArrayList<String> values, String key, String command) {
        Object _key;
        String cleanKey;
        if (key == null) {
            return;
        }
        if (values == null || values.isEmpty()) {
            this._generateEmptyMultiValueError(key);
            return;
        }
        ValidationResult vr = this.validator.cleanMultiValuePropertyKey(key);
        if (vr.getErrorCode() != 0) {
            this.pushValidationResult(vr);
        }
        String string = cleanKey = (_key = vr.getObject()) != null ? vr.getObject().toString() : null;
        if (cleanKey == null || cleanKey.isEmpty()) {
            this._generateInvalidMultiValueKeyError(key);
            return;
        }
        key = cleanKey;
        try {
            JSONArray currentValues = this._constructExistingMultiValue(key, command);
            JSONArray newValues = this._cleanMultiValues(values, key);
            this._validateAndPushMultiValue(currentValues, newValues, values, key, command);
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Error handling multi value operation for key " + key, t);
        }
    }

    private JSONArray _constructExistingMultiValue(String key, String command) {
        Boolean remove = command.equals("$remove");
        Boolean add = command.equals("$add");
        if (!remove.booleanValue() && !add.booleanValue()) {
            return new JSONArray();
        }
        Object existing = this._getProfilePropertyIgnorePersonalizationFlag(key);
        if (existing == null) {
            if (remove.booleanValue()) {
                return null;
            }
            return new JSONArray();
        }
        if (existing instanceof JSONArray) {
            return (JSONArray)existing;
        }
        JSONArray _default = add != false ? new JSONArray() : null;
        String stringified = this._stringifyAndCleanScalarProfilePropValue(existing);
        return stringified != null ? new JSONArray().put((Object)stringified) : _default;
    }

    private String _stringifyScalarProfilePropValue(Object value) {
        String val = null;
        try {
            val = value.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    private String _stringifyAndCleanScalarProfilePropValue(Object value) {
        String val = this._stringifyScalarProfilePropValue(value);
        if (val != null) {
            Object _value;
            ValidationResult vr = this.validator.cleanMultiValuePropertyValue(val);
            if (vr.getErrorCode() != 0) {
                this.pushValidationResult(vr);
            }
            val = (_value = vr.getObject()) != null ? vr.getObject().toString() : null;
        }
        return val;
    }

    private JSONArray _cleanMultiValues(ArrayList<String> values, String key) {
        try {
            if (values == null || key == null) {
                return null;
            }
            JSONArray cleanedValues = new JSONArray();
            for (String value : values) {
                Object _value;
                value = value == null ? "" : value;
                ValidationResult vr = this.validator.cleanMultiValuePropertyValue(value);
                if (vr.getErrorCode() != 0) {
                    this.pushValidationResult(vr);
                }
                String string = value = (_value = vr.getObject()) != null ? vr.getObject().toString() : null;
                if (value == null || value.isEmpty()) {
                    this._generateEmptyMultiValueError(key);
                    return null;
                }
                cleanedValues.put((Object)value);
            }
            return cleanedValues;
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Error cleaning multi values for key " + key, t);
            this._generateEmptyMultiValueError(key);
            return null;
        }
    }

    private void _validateAndPushMultiValue(JSONArray currentValues, JSONArray newValues, ArrayList<String> originalValues, String key, String command) {
        try {
            JSONArray localValues;
            if (currentValues == null || newValues == null || originalValues == null || key == null || command == null) {
                return;
            }
            String mergeOperation = command.equals("$remove") ? "multiValuePropertyRemoveValues" : "multiValuePropertyAddValues";
            ValidationResult vr = this.validator.mergeMultiValuePropertyForKey(currentValues, newValues, mergeOperation, key);
            if (vr.getErrorCode() != 0) {
                this.pushValidationResult(vr);
            }
            if ((localValues = (JSONArray)vr.getObject()) == null || localValues.length() <= 0) {
                this.getLocalDataStore().removeProfileField(key);
            } else {
                this.getLocalDataStore().setProfileField(key, localValues);
            }
            JSONObject commandObj = new JSONObject();
            commandObj.put(command, (Object)new JSONArray(originalValues));
            JSONObject fields = new JSONObject();
            fields.put(key, (Object)commandObj);
            this.pushBasicProfile(fields);
            this.getConfigLogger().verbose(this.getAccountId(), "Constructed multi-value profile push: " + fields.toString());
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Error pushing multiValue for key " + key, t);
        }
    }

    private void _generateEmptyMultiValueError(String key) {
        ValidationResult error = new ValidationResult();
        String msg = "Invalid multi value for key " + key + ", profile multi value operation aborted.";
        error.setErrorCode(512);
        error.setErrorDesc(msg);
        this.pushValidationResult(error);
        this.getConfigLogger().debug(this.getAccountId(), msg);
    }

    private void _generateInvalidMultiValueKeyError(String key) {
        ValidationResult error = new ValidationResult();
        error.setErrorCode(523);
        error.setErrorDesc("Invalid multi-value property key " + key);
        this.pushValidationResult(error);
        this.getConfigLogger().debug(this.getAccountId(), "Invalid multi-value property key " + key + " profile multi value operation aborted");
    }

    @Deprecated
    public void pushNotificationEvent(Bundle extras) {
        this.pushNotificationClickedEvent(extras);
    }

    public void pushNotificationClickedEvent(final Bundle extras) {
        boolean shouldProcess;
        if (this.config.isAnalyticsOnly()) {
            this.getConfigLogger().debug(this.getAccountId(), "is Analytics Only - will not process Notification Clicked event.");
            return;
        }
        if (extras == null || extras.isEmpty() || extras.get(NOTIFICATION_TAG) == null) {
            this.getConfigLogger().debug(this.getAccountId(), "Push notification: " + (extras == null ? "NULL" : extras.toString()) + " not from CleverTap - will not process Notification Clicked event.");
            return;
        }
        String accountId = null;
        try {
            accountId = extras.getString("wzrk_acct_id");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean bl = shouldProcess = accountId == null && this.config.isDefaultInstance() || this.getAccountId().equals(accountId);
        if (!shouldProcess) {
            this.getConfigLogger().debug(this.getAccountId(), "Push notification not targeted at this instance, not processing Notification Clicked Event");
            return;
        }
        if (extras.containsKey("wzrk_inapp")) {
            this.pendingInappRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        Logger.v("Received in-app via push payload: " + extras.getString("wzrk_inapp"));
                        JSONObject r = new JSONObject();
                        JSONArray inappNotifs = new JSONArray();
                        r.put("inapp_notifs", (Object)inappNotifs);
                        inappNotifs.put((Object)new JSONObject(extras.getString("wzrk_inapp")));
                        CleverTapAPI.this.processInAppResponse(r, CleverTapAPI.this.context);
                    }
                    catch (Throwable t) {
                        Logger.v("Failed to display inapp notification from push notification payload", t);
                    }
                }
            };
            return;
        }
        if (extras.containsKey("wzrk_inbox")) {
            this.pendingInappRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        Logger.v("Received inbox via push payload: " + extras.getString("wzrk_inbox"));
                        JSONObject r = new JSONObject();
                        JSONArray inappNotifs = new JSONArray();
                        r.put("inbox_notifs", (Object)inappNotifs);
                        JSONObject testPushObject = new JSONObject(extras.getString("wzrk_inbox"));
                        testPushObject.put("_id", (Object)String.valueOf(System.currentTimeMillis() / 1000L));
                        inappNotifs.put((Object)testPushObject);
                        CleverTapAPI.this.processInboxResponse(r);
                    }
                    catch (Throwable t) {
                        Logger.v("Failed to process inbox message from push notification payload", t);
                    }
                }
            };
            return;
        }
        if (!extras.containsKey("wzrk_id") || extras.getString("wzrk_id") == null) {
            this.getConfigLogger().debug(this.getAccountId(), "Push notification ID Tag is null, not processing Notification Clicked event for:  " + extras.toString());
            return;
        }
        boolean isDuplicate = this.checkDuplicateNotificationIds(extras, this.notificationIdTagMap, 5000);
        if (isDuplicate) {
            this.getConfigLogger().debug(this.getAccountId(), "Already processed Notification Clicked event for " + extras.toString() + ", dropping duplicate.");
            return;
        }
        JSONObject event = new JSONObject();
        JSONObject notif = new JSONObject();
        try {
            for (String x : extras.keySet()) {
                if (!x.startsWith("wzrk_")) continue;
                Object value = extras.get(x);
                notif.put(x, value);
            }
            event.put("evtName", (Object)"Notification Clicked");
            event.put("evtData", (Object)notif);
            this.queueEvent(this.context, event, 4);
            try {
                this.setWzrkParams(this.getWzrkFields(extras));
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDuplicateNotificationIds(Bundle extras, HashMap<String, Object> notificationTagMap, int interval) {
        Object object = this.notificationMapLock;
        synchronized (object) {
            boolean isDupe = false;
            try {
                long timestamp;
                String notificationIdTag = extras.getString("wzrk_id");
                long now = System.currentTimeMillis();
                if (notificationTagMap.containsKey(notificationIdTag) && now - (timestamp = ((Long)notificationTagMap.get(notificationIdTag)).longValue()) < (long)interval) {
                    isDupe = true;
                }
                notificationTagMap.put(notificationIdTag, now);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return isDupe;
        }
    }

    private JSONObject getWzrkFields(Bundle root) throws JSONException {
        JSONObject fields = new JSONObject();
        for (String s : root.keySet()) {
            Object o = root.get(s);
            if (o instanceof Bundle) {
                JSONObject wzrkFields = this.getWzrkFields((Bundle)o);
                Iterator keys = wzrkFields.keys();
                while (keys.hasNext()) {
                    String k = (String)keys.next();
                    fields.put(k, wzrkFields.get(k));
                }
                continue;
            }
            if (!s.startsWith("wzrk_")) continue;
            fields.put(s, root.get(s));
        }
        return fields;
    }

    private JSONObject getWzrkFields(CTInAppNotification root) throws JSONException {
        JSONObject fields = new JSONObject();
        JSONObject jsonObject = root.getJsonDescription();
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String keyName = (String)iterator.next();
            if (!keyName.startsWith("wzrk_")) continue;
            fields.put(keyName, jsonObject.get(keyName));
        }
        return fields;
    }

    private JSONObject getWzrkFields(CTInboxMessage root) {
        return root.getWzrkParams();
    }

    public void pushChargedEvent(HashMap<String, Object> chargeDetails, ArrayList<HashMap<String, Object>> items) {
        if (chargeDetails == null || items == null) {
            this.getConfigLogger().debug(this.getAccountId(), "Invalid Charged event: details and or items is null");
            return;
        }
        if (items.size() > 50) {
            ValidationResult error = new ValidationResult();
            error.setErrorCode(522);
            error.setErrorDesc("Charged event contained more than 50 items.");
            this.getConfigLogger().debug(this.getAccountId(), "Charged event contained more than 50 items.");
            this.pushValidationResult(error);
        }
        JSONObject evtData = new JSONObject();
        JSONObject chargedEvent = new JSONObject();
        try {
            ValidationResult vr;
            for (String key : chargeDetails.keySet()) {
                Object value = chargeDetails.get(key);
                vr = this.validator.cleanObjectKey(key);
                key = vr.getObject().toString();
                if (vr.getErrorCode() != 0) {
                    chargedEvent.put("wzrk_error", (Object)this.getErrorObject(vr));
                }
                try {
                    vr = this.validator.cleanObjectValue(value, Validator.ValidationContext.Event);
                }
                catch (IllegalArgumentException e) {
                    ValidationResult error = new ValidationResult();
                    error.setErrorCode(511);
                    String err = "For event Charged: Property value for property " + key + " wasn't a primitive (" + value + ")";
                    error.setErrorDesc(err);
                    this.pushValidationResult(error);
                    this.getConfigLogger().debug(this.getAccountId(), err);
                    continue;
                }
                value = vr.getObject();
                if (vr.getErrorCode() != 0) {
                    chargedEvent.put("wzrk_error", (Object)this.getErrorObject(vr));
                }
                evtData.put(key, value);
            }
            JSONArray jsonItemsArray = new JSONArray();
            for (HashMap<String, Object> map : items) {
                JSONObject itemDetails = new JSONObject();
                for (String key : map.keySet()) {
                    Object value = map.get(key);
                    vr = this.validator.cleanObjectKey(key);
                    key = vr.getObject().toString();
                    if (vr.getErrorCode() != 0) {
                        chargedEvent.put("wzrk_error", (Object)this.getErrorObject(vr));
                    }
                    try {
                        vr = this.validator.cleanObjectValue(value, Validator.ValidationContext.Event);
                    }
                    catch (IllegalArgumentException e) {
                        ValidationResult error = new ValidationResult();
                        error.setErrorCode(511);
                        String err = "An item's object value for key " + key + " wasn't a primitive (" + value + ")";
                        error.setErrorDesc(err);
                        this.getConfigLogger().debug(this.getAccountId(), err);
                        this.pushValidationResult(error);
                        continue;
                    }
                    value = vr.getObject();
                    if (vr.getErrorCode() != 0) {
                        chargedEvent.put("wzrk_error", (Object)this.getErrorObject(vr));
                    }
                    itemDetails.put(key, value);
                }
                jsonItemsArray.put((Object)itemDetails);
            }
            evtData.put("Items", (Object)jsonItemsArray);
            chargedEvent.put("evtName", (Object)CHARGED_EVENT);
            chargedEvent.put("evtData", (Object)evtData);
            this.queueEvent(this.context, chargedEvent, 4);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void pushEvent(String eventName, Map<String, Object> eventActions) {
        if (eventName == null || eventName.equals("")) {
            return;
        }
        ValidationResult validationResult = this.validator.isRestrictedEventName(eventName);
        if (validationResult.getErrorCode() > 0) {
            this.pushValidationResult(validationResult);
            return;
        }
        if (eventActions == null) {
            eventActions = new HashMap<String, Object>();
        }
        JSONObject event = new JSONObject();
        try {
            ValidationResult vr = this.validator.cleanEventName(eventName);
            if (vr.getErrorCode() != 0) {
                event.put("wzrk_error", (Object)this.getErrorObject(vr));
            }
            eventName = vr.getObject().toString();
            JSONObject actions = new JSONObject();
            for (String key : eventActions.keySet()) {
                Object value = eventActions.get(key);
                vr = this.validator.cleanObjectKey(key);
                key = vr.getObject().toString();
                if (vr.getErrorCode() != 0) {
                    event.put("wzrk_error", (Object)this.getErrorObject(vr));
                }
                try {
                    vr = this.validator.cleanObjectValue(value, Validator.ValidationContext.Event);
                }
                catch (IllegalArgumentException e) {
                    ValidationResult error = new ValidationResult();
                    error.setErrorCode(512);
                    String err = "For event \"" + eventName + "\": Property value for property " + key + " wasn't a primitive (" + value + ")";
                    error.setErrorDesc(err);
                    this.getConfigLogger().debug(this.getAccountId(), err);
                    this.pushValidationResult(error);
                    continue;
                }
                value = vr.getObject();
                if (vr.getErrorCode() != 0) {
                    event.put("wzrk_error", (Object)this.getErrorObject(vr));
                }
                actions.put(key, value);
            }
            event.put("evtName", (Object)eventName);
            event.put("evtData", (Object)actions);
            this.queueEvent(this.context, event, 4);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void pushEvent(String eventName) {
        if (eventName == null || eventName.trim().equals("")) {
            return;
        }
        this.pushEvent(eventName, null);
    }

    public void pushNotificationViewedEvent(Bundle extras) {
        if (extras == null || extras.isEmpty() || extras.get(NOTIFICATION_TAG) == null) {
            this.getConfigLogger().debug(this.getAccountId(), "Push notification: " + (extras == null ? "NULL" : extras.toString()) + " not from CleverTap - will not process Notification Viewed event.");
            return;
        }
        if (!extras.containsKey("wzrk_id") || extras.getString("wzrk_id") == null) {
            this.getConfigLogger().debug(this.getAccountId(), "Push notification ID Tag is null, not processing Notification Viewed event for:  " + extras.toString());
            return;
        }
        boolean isDuplicate = this.checkDuplicateNotificationIds(extras, this.notificationViewedIdTagMap, 2000);
        if (isDuplicate) {
            this.getConfigLogger().debug(this.getAccountId(), "Already processed Notification Viewed event for " + extras.toString() + ", dropping duplicate.");
            return;
        }
        JSONObject event = new JSONObject();
        try {
            JSONObject notif = this.getWzrkFields(extras);
            event.put("evtName", (Object)"Notification Viewed");
            event.put("evtData", (Object)notif);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.queueEvent(this.context, event, 4);
    }

    void pushInAppNotificationStateEvent(boolean clicked, CTInAppNotification data, Bundle customData) {
        JSONObject event = new JSONObject();
        try {
            JSONObject notif = this.getWzrkFields(data);
            if (customData != null) {
                for (String x : customData.keySet()) {
                    Object value = customData.get(x);
                    if (value == null) continue;
                    notif.put(x, value);
                }
            }
            if (clicked) {
                try {
                    this.setWzrkParams(notif);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                event.put("evtName", (Object)"Notification Clicked");
            } else {
                event.put("evtName", (Object)"Notification Viewed");
            }
            event.put("evtData", (Object)notif);
            this.queueEvent(this.context, event, 4);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void pushInboxMessageStateEvent(boolean clicked, CTInboxMessage data, Bundle customData) {
        JSONObject event = new JSONObject();
        try {
            JSONObject notif = this.getWzrkFields(data);
            if (customData != null) {
                for (String x : customData.keySet()) {
                    Object value = customData.get(x);
                    if (value == null) continue;
                    notif.put(x, value);
                }
            }
            if (clicked) {
                try {
                    this.setWzrkParams(notif);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                event.put("evtName", (Object)"Notification Clicked");
            } else {
                event.put("evtName", (Object)"Notification Viewed");
            }
            event.put("evtData", (Object)notif);
            this.queueEvent(this.context, event, 4);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public EventDetail getDetails(String event) {
        return this.getLocalDataStore().getEventDetail(event);
    }

    public Map<String, EventDetail> getHistory() {
        return this.getLocalDataStore().getEventHistory(this.context);
    }

    public int getFirstTime(String event) {
        EventDetail eventDetail = this.getLocalDataStore().getEventDetail(event);
        if (eventDetail != null) {
            return eventDetail.getFirstTime();
        }
        return -1;
    }

    public int getLastTime(String event) {
        EventDetail eventDetail = this.getLocalDataStore().getEventDetail(event);
        if (eventDetail != null) {
            return eventDetail.getLastTime();
        }
        return -1;
    }

    public int getCount(String event) {
        EventDetail eventDetail = this.getLocalDataStore().getEventDetail(event);
        if (eventDetail != null) {
            return eventDetail.getCount();
        }
        return -1;
    }

    public void pushError(String errorMessage, int errorCode) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("Error Message", errorMessage);
        props.put("Error Code", errorCode);
        try {
            String activityName = CleverTapAPI.getCurrentActivityName();
            if (activityName != null) {
                props.put("Location", activityName);
            } else {
                props.put("Location", "Unknown");
            }
        }
        catch (Throwable t) {
            props.put("Location", "Unknown");
        }
        this.pushEvent("Error Occurred", props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUserLogin(final Map<String, Object> profile) {
        if (profile == null) {
            return;
        }
        try {
            String currentGUID = this.getCleverTapID();
            if (currentGUID == null) {
                return;
            }
            boolean haveIdentifier = false;
            String cachedGUID = null;
            for (String string : profile.keySet()) {
                Object value = profile.get(string);
                if (!Constants.PROFILE_IDENTIFIER_KEYS.contains(string)) continue;
                try {
                    String identifier = value.toString();
                    if (identifier == null || identifier.length() <= 0) continue;
                    haveIdentifier = true;
                    cachedGUID = this.getGUIDForIdentifier(string, identifier);
                    if (cachedGUID == null) continue;
                    break;
                }
                catch (Throwable throwable) {
                }
            }
            if (!haveIdentifier || this.isAnonymousDevice()) {
                this.getConfigLogger().debug(this.getAccountId(), "onUserLogin: no identifier provided or device is anonymous, pushing on current user profile");
                this.pushProfile(profile);
                return;
            }
            if (cachedGUID != null && cachedGUID.equals(currentGUID)) {
                this.getConfigLogger().debug(this.getAccountId(), "onUserLogin: " + profile.toString() + " maps to current device id " + currentGUID + " pushing on current profile");
                this.pushProfile(profile);
                return;
            }
            String profileToString = profile.toString();
            if (this.isProcessUserLoginWithIdentifier(profileToString)) {
                this.getConfigLogger().debug(this.getAccountId(), "Already processing onUserLogin for " + profileToString);
                return;
            }
            Boolean bl = this.processingUserLoginLock;
            synchronized (bl) {
                this.processingUserLoginIdentifier = profileToString;
            }
            this.getConfigLogger().verbose(this.getAccountId(), "onUserLogin: queuing reset profile for " + profileToString + " with Cached GUID " + (cachedGUID != null ? cachedGUID : "NULL"));
            final String string = cachedGUID;
            final DeviceInfo _deviceInfo = this.deviceInfo;
            this.postAsyncSafely("resetProfile", new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object g;
                        CleverTapAPI.this.setCurrentUserOptedOut(false);
                        CleverTapAPI.this.forcePushDeviceToken(false);
                        CleverTapAPI.this.flushQueueSync(CleverTapAPI.this.context);
                        CleverTapAPI.this.clearQueues(CleverTapAPI.this.context);
                        CleverTapAPI.this.getLocalDataStore().changeUser();
                        CleverTapAPI.this.inAppFCManager.changeUser(CleverTapAPI.this.context);
                        activityCount = 1;
                        CleverTapAPI.this.destroySession();
                        if (string != null) {
                            _deviceInfo.forceUpdateDeviceId(string);
                            CleverTapAPI.this.notifyUserProfileInitialized(string);
                        } else {
                            g = _deviceInfo.forceNewDeviceID();
                            CleverTapAPI.this.notifyUserProfileInitialized((String)g);
                        }
                        CleverTapAPI.this.setCurrentUserOptOutStateFromStorage();
                        CleverTapAPI.this.forcePushAppLaunchedEvent();
                        CleverTapAPI.this.pushProfile(profile);
                        CleverTapAPI.this.forcePushDeviceToken(true);
                        g = CleverTapAPI.this.processingUserLoginLock;
                        synchronized (g) {
                            CleverTapAPI.this.processingUserLoginIdentifier = null;
                        }
                        CleverTapAPI.this.resetInbox();
                    }
                    catch (Throwable t) {
                        CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "Reset Profile error", t);
                    }
                }
            });
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "onUserLogin failed", t);
        }
    }

    private String getGUIDForIdentifier(String key, String identifier) {
        if (key == null || identifier == null) {
            return null;
        }
        String cacheKey = key + "_" + identifier;
        JSONObject cache = this.getCachedGUIDs();
        try {
            return cache.getString(cacheKey);
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Error reading guid cache: " + t.toString());
            return null;
        }
    }

    private boolean isAnonymousDevice() {
        JSONObject cachedGUIDs = this.getCachedGUIDs();
        return cachedGUIDs.length() <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isProcessUserLoginWithIdentifier(String identifier) {
        Boolean bl = this.processingUserLoginLock;
        synchronized (bl) {
            return this.processingUserLoginIdentifier != null && this.processingUserLoginIdentifier.equals(identifier);
        }
    }

    private void forcePushDeviceToken(boolean register) {
        this.pushDeviceToken(register, true);
    }

    private void pushDeviceToken(boolean register, boolean force) {
        if (this.enabledPushTypes == null) {
            return;
        }
        for (PushType pushType : this.enabledPushTypes) {
            switch (pushType) {
                case GCM: {
                    this.pushGCMDeviceToken(null, register, force);
                    break;
                }
                case FCM: {
                    this.pushFCMDeviceToken(null, register, force);
                    break;
                }
            }
        }
    }

    private void forcePushAppLaunchedEvent() {
        this.setAppLaunchPushed(false);
        this.pushAppLaunchedEvent();
    }

    public void flush() {
        this.flushQueueAsync(this.context);
    }

    public void pushGcmRegistrationId(String gcmId, boolean register) {
        this.pushDeviceToken(gcmId, register, PushType.GCM);
    }

    public void pushFcmRegistrationId(String fcmId, boolean register) {
        this.pushDeviceToken(fcmId, register, PushType.FCM);
    }

    private void pushDeviceToken(String token, boolean register, PushType type) {
        this.pushDeviceToken(this.context, token, register, type);
    }

    private void pushDeviceToken(Context context, String token, boolean register, PushType type) {
        if (token == null || type == null) {
            return;
        }
        JSONObject event = new JSONObject();
        JSONObject data = new JSONObject();
        try {
            String action = register ? "register" : "unregister";
            data.put("action", (Object)action);
            data.put("id", (Object)token);
            data.put("type", (Object)type.toString());
            event.put("data", (Object)data);
            this.getConfigLogger().verbose(this.getAccountId(), "DataHandler: pushing device token with action " + action + " and type " + type.toString());
            this.queueEvent(context, event, 5);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private Handler getHandlerUsingMainLooper() {
        return this.handlerUsingMainLooper;
    }

    private void postAsyncSafely(String name, final Runnable runnable) {
        try {
            boolean executeSync;
            boolean bl = executeSync = Thread.currentThread().getId() == this.EXECUTOR_THREAD_ID;
            if (executeSync) {
                runnable.run();
            } else {
                this.es.submit(new Runnable(){

                    @Override
                    public void run() {
                        CleverTapAPI.this.EXECUTOR_THREAD_ID = Thread.currentThread().getId();
                        try {
                            runnable.run();
                        }
                        catch (Throwable t) {
                            CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "Executor service: Failed to complete the scheduled task", t);
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Failed to submit task to the executor service", t);
        }
    }

    @Override
    public void inAppNotificationDidShow(Context context, CTInAppNotification inAppNotification, Bundle formData) {
        this.pushInAppNotificationStateEvent(false, inAppNotification, formData);
    }

    @Override
    public void inAppNotificationDidClick(Context context, CTInAppNotification inAppNotification, Bundle formData) {
        this.pushInAppNotificationStateEvent(true, inAppNotification, formData);
    }

    @Override
    public void inAppNotificationDidDismiss(final Context context, final CTInAppNotification inAppNotification, Bundle formData) {
        inAppNotification.didDismiss();
        this.inAppFCManager.didDismiss(inAppNotification);
        this.getConfigLogger().verbose(this.getAccountId(), "InApp Dismissed: " + inAppNotification.getCampaignId());
        try {
            InAppNotificationListener listener = this.getInAppNotificationListener();
            if (listener != null) {
                HashMap<String, Object> notifKVS = inAppNotification.getCustomExtras() != null ? Utils.convertJSONObjectToHashMap(inAppNotification.getCustomExtras()) : new HashMap();
                Logger.v("Calling the in-app listener on behalf of " + this.source);
                if (formData != null) {
                    listener.onDismissed(notifKVS, Utils.convertBundleObjectToHashMap(formData));
                } else {
                    listener.onDismissed(notifKVS, null);
                }
            }
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Failed to call the in-app notification listener", t);
        }
        this.runOnNotificationQueue(new Runnable(){

            @Override
            public void run() {
                CleverTapAPI.inAppDidDismiss(context, CleverTapAPI.this.getConfig(), inAppNotification);
                CleverTapAPI.this._showNotificationIfAvailable(context);
            }
        });
    }

    private void runOnNotificationQueue(final Runnable runnable) {
        try {
            boolean executeSync;
            boolean bl = executeSync = Thread.currentThread().getId() == this.NOTIFICATION_THREAD_ID;
            if (executeSync) {
                runnable.run();
            } else {
                this.ns.submit(new Runnable(){

                    @Override
                    public void run() {
                        CleverTapAPI.this.NOTIFICATION_THREAD_ID = Thread.currentThread().getId();
                        try {
                            runnable.run();
                        }
                        catch (Throwable t) {
                            CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "Notification executor service: Failed to complete the scheduled task", t);
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "Failed to submit task to the notification executor service", t);
        }
    }

    private void notifyUserProfileInitialized(String deviceID) {
        String string = deviceID = deviceID != null ? deviceID : this.getCleverTapID();
        if (deviceID == null) {
            return;
        }
        try {
            SyncListener sl = this.getSyncListener();
            if (sl != null) {
                sl.profileDidInitialize(deviceID);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * Loose catch block
     */
    @Nullable
    private static CleverTapAPI createInstanceIfAvailable(Context context, String _accountId) {
        block8: {
            if (_accountId == null) {
                try {
                    return CleverTapAPI.getDefaultInstance(context);
                }
                catch (Throwable t) {
                    Logger.v("Error creating shared Instance: ", t.getCause());
                    return null;
                }
            }
            String configJson = StorageHelper.getString(context, "instance:" + _accountId, "");
            if (configJson.isEmpty()) break block8;
            CleverTapInstanceConfig config = CleverTapInstanceConfig.createInstance(configJson);
            Logger.v("Inflated Instance Config: " + configJson);
            return config != null ? CleverTapAPI.instanceWithConfig(context, config) : null;
            {
                catch (Throwable t) {
                    return null;
                }
            }
        }
        try {
            CleverTapAPI instance = CleverTapAPI.getDefaultInstance(context);
            return instance != null && instance.config.getAccountId().equals(_accountId) ? instance : null;
        }
        catch (Throwable t) {
            Logger.v("Error creating shared Instance: ", t.getCause());
            return null;
        }
    }

    @Nullable
    private static CleverTapAPI getDefaultInstanceOrFirstOther(Context context) {
        CleverTapAPI instance;
        block1: {
            String accountId;
            instance = CleverTapAPI.getDefaultInstance(context);
            if (instance != null || instances == null || instances.isEmpty()) break block1;
            Iterator<String> iterator = instances.keySet().iterator();
            while (iterator.hasNext() && (instance = instances.get(accountId = iterator.next())) == null) {
            }
        }
        return instance;
    }

    private void handlePushNotificationsInResponse(JSONArray pushNotifications) {
        try {
            for (int i = 0; i < pushNotifications.length(); ++i) {
                Bundle pushBundle = new Bundle();
                JSONObject pushObject = pushNotifications.getJSONObject(i);
                if (pushObject.has("wzrk_acct_id")) {
                    pushBundle.putString("wzrk_acct_id", pushObject.getString("wzrk_acct_id"));
                }
                if (pushObject.has("wzrk_acts")) {
                    pushBundle.putString("wzrk_acts", pushObject.getString("wzrk_acts"));
                }
                if (pushObject.has("nm")) {
                    pushBundle.putString("nm", pushObject.getString("nm"));
                }
                if (pushObject.has("nt")) {
                    pushBundle.putString("nt", pushObject.getString("nt"));
                }
                if (pushObject.has("wzrk_bp")) {
                    pushBundle.putString("wzrk_bp", pushObject.getString("wzrk_bp"));
                }
                if (pushObject.has("pr")) {
                    pushBundle.putString("pr", pushObject.getString("pr"));
                }
                if (pushObject.has("wzrk_pivot")) {
                    pushBundle.putString("wzrk_pivot", pushObject.getString("wzrk_pivot"));
                }
                if (pushObject.has("wzrk_sound")) {
                    pushBundle.putString("wzrk_sound", pushObject.getString("wzrk_sound"));
                }
                if (pushObject.has("wzrk_cid")) {
                    pushBundle.putString("wzrk_cid", pushObject.getString("wzrk_cid"));
                }
                if (pushObject.has("wzrk_bc")) {
                    pushBundle.putString("wzrk_bc", pushObject.getString("wzrk_bc"));
                }
                if (pushObject.has("wzrk_bi")) {
                    pushBundle.putString("wzrk_bi", pushObject.getString("wzrk_bi"));
                }
                if (pushObject.has("wzrk_id")) {
                    pushBundle.putString("wzrk_id", pushObject.getString("wzrk_id"));
                }
                if (pushObject.has(NOTIFICATION_TAG)) {
                    pushBundle.putString(NOTIFICATION_TAG, pushObject.getString(NOTIFICATION_TAG));
                }
                if (pushObject.has("ico")) {
                    pushBundle.putString("ico", pushObject.getString("ico"));
                }
                if (pushObject.has("wzrk_ck")) {
                    pushBundle.putString("wzrk_ck", pushObject.getString("wzrk_ck"));
                }
                if (pushObject.has("wzrk_dl")) {
                    pushBundle.putString("wzrk_dl", pushObject.getString("wzrk_dl"));
                }
                if (pushObject.has("wzrk_pid")) {
                    pushBundle.putString("wzrk_pid", pushObject.getString("wzrk_pid"));
                }
                if (pushObject.has("wzrk_ttl")) {
                    pushBundle.putLong("wzrk_ttl", pushObject.getLong("wzrk_ttl"));
                }
                Iterator iterator = pushObject.keys();
                while (iterator.hasNext()) {
                    String key = iterator.next().toString();
                    pushBundle.putString(key, pushObject.getString(key));
                }
                if (!pushBundle.isEmpty() && !this.dbAdapter.doesPushNotificationIdExist(pushObject.getString("wzrk_pid"))) {
                    this.getConfigLogger().verbose("Creating Push Notification locally");
                    CleverTapAPI.createNotification(this.context, pushBundle);
                    continue;
                }
                this.getConfigLogger().verbose(this.getAccountId(), "Push Notification already shown, ignoring local notification :" + pushObject.getString("wzrk_pid"));
            }
        }
        catch (JSONException e) {
            this.getConfigLogger().verbose(this.getAccountId(), "Error parsing push notification JSON");
        }
    }

    public static NotificationInfo getNotificationInfo(Bundle extras) {
        if (extras == null) {
            return new NotificationInfo(false, false);
        }
        boolean fromCleverTap = extras.containsKey(NOTIFICATION_TAG);
        boolean shouldRender = fromCleverTap && extras.containsKey("nm");
        return new NotificationInfo(fromCleverTap, shouldRender);
    }

    public static void createNotification(Context context, Bundle extras) {
        CleverTapAPI.createNotification(context, extras, -1000);
    }

    public static void createNotification(Context context, Bundle extras, int notificationId) {
        String _accountId = extras.getString("wzrk_acct_id");
        if (instances == null) {
            CleverTapAPI instance = CleverTapAPI.createInstanceIfAvailable(context, _accountId);
            if (instance != null) {
                instance._createNotification(context, extras, notificationId);
            }
            return;
        }
        for (String accountId : instances.keySet()) {
            CleverTapAPI instance = instances.get(accountId);
            boolean shouldProcess = false;
            if (instance != null) {
                boolean bl = shouldProcess = _accountId == null && instance.config.isDefaultInstance() || instance.getAccountId().equals(_accountId);
            }
            if (!shouldProcess) continue;
            try {
                instance._createNotification(context, extras, notificationId);
            }
            catch (Throwable throwable) {}
            break;
        }
    }

    private void _createNotification(final Context context, final Bundle extras, final int notificationId) {
        if (extras == null || extras.get(NOTIFICATION_TAG) == null) {
            return;
        }
        if (this.config.isAnalyticsOnly()) {
            this.getConfigLogger().debug(this.getAccountId(), "Instance is set for Analytics only, cannot create notification");
            return;
        }
        try {
            this.postAsyncSafely("CleverTapAPI#_createNotification", new Runnable(){

                @Override
                public void run() {
                    try {
                        CleverTapAPI.this.getConfigLogger().debug(CleverTapAPI.this.getAccountId(), "Handling notification: " + extras.toString());
                        CleverTapAPI.this.dbAdapter = CleverTapAPI.this.loadDBAdapter(context);
                        if (extras.getString("wzrk_pid") != null && CleverTapAPI.this.dbAdapter.doesPushNotificationIdExist(extras.getString("wzrk_pid"))) {
                            CleverTapAPI.this.getConfigLogger().debug(CleverTapAPI.this.getAccountId(), "Push Notification Already rendered, not showing again");
                            return;
                        }
                        if (extras.containsKey("d") && "y".equals(extras.getString("d"))) {
                            int r = (int)(Math.random() * 10.0);
                            if (r != 8) {
                                return;
                            }
                            JSONObject event = new JSONObject();
                            try {
                                JSONObject actions = new JSONObject();
                                for (String x : extras.keySet()) {
                                    Object value = extras.get(x);
                                    actions.put(x, value);
                                }
                                event.put("evtName", (Object)"wzrk_d");
                                event.put("evtData", (Object)actions);
                                CleverTapAPI.this.queueEvent(context, event, 4);
                            }
                            catch (JSONException jSONException) {
                                // empty catch block
                            }
                            return;
                        }
                        String notifMessage = extras.getString("nm");
                        String string = notifMessage = notifMessage != null ? notifMessage : "";
                        if (notifMessage.isEmpty()) {
                            CleverTapAPI.this.getConfigLogger().verbose(CleverTapAPI.this.getAccountId(), "Push notification message is empty, not rendering");
                            CleverTapAPI.this.loadDBAdapter(context).storeUninstallTimestamp();
                            return;
                        }
                        String notifTitle = extras.getString("nt", "");
                        notifTitle = notifTitle.isEmpty() ? context.getApplicationInfo().name : notifTitle;
                        CleverTapAPI.this.triggerNotification(context, extras, notifMessage, notifTitle, notificationId);
                    }
                    catch (Throwable t) {
                        CleverTapAPI.this.getConfigLogger().debug(CleverTapAPI.this.getAccountId(), "Couldn't render notification: ", t);
                    }
                }
            });
        }
        catch (Throwable t) {
            this.getConfigLogger().debug(this.getAccountId(), "Failed to process push notification", t);
        }
    }

    private void triggerNotification(Context context, Bundle extras, String notifMessage, String notifTitle, int notificationId) {
        NotificationCompat.Builder nb;
        int priorityInt;
        int smallIcon;
        NotificationCompat.BigTextStyle style2;
        PendingIntent pIntent;
        String icoPath;
        block62: {
            block61: {
                icoPath = extras.getString("ico");
                Intent launchIntent = new Intent(context, CTPushNotificationReceiver.class);
                launchIntent.putExtras(extras);
                launchIntent.removeExtra("wzrk_acts");
                launchIntent.setFlags(0x24000000);
                pIntent = PendingIntent.getBroadcast((Context)context, (int)((int)System.currentTimeMillis()), (Intent)launchIntent, (int)0x8000000);
                String bigPictureUrl = extras.getString("wzrk_bp");
                if (bigPictureUrl != null && bigPictureUrl.startsWith("http")) {
                    try {
                        Bitmap bpMap = Utils.getNotificationBitmap(bigPictureUrl, false, context);
                        if (bpMap == null) {
                            throw new Exception("Failed to fetch big picture!");
                        }
                        if (extras.containsKey("wzrk_nms")) {
                            String summaryText = extras.getString("wzrk_nms");
                            style2 = new NotificationCompat.BigPictureStyle().setSummaryText((CharSequence)summaryText).bigPicture(bpMap);
                            break block61;
                        }
                        style2 = new NotificationCompat.BigPictureStyle().setSummaryText((CharSequence)notifMessage).bigPicture(bpMap);
                    }
                    catch (Throwable t) {
                        style2 = new NotificationCompat.BigTextStyle().bigText((CharSequence)notifMessage);
                        this.getConfigLogger().verbose(this.getAccountId(), "Falling back to big text notification, couldn't fetch big picture", t);
                    }
                } else {
                    style2 = new NotificationCompat.BigTextStyle().bigText((CharSequence)notifMessage);
                }
            }
            try {
                String x = ManifestInfo.getInstance(context).getNotificationIcon();
                if (x == null) {
                    throw new IllegalArgumentException();
                }
                smallIcon = context.getResources().getIdentifier(x, "drawable", context.getPackageName());
                if (smallIcon == 0) {
                    throw new IllegalArgumentException();
                }
            }
            catch (Throwable t) {
                smallIcon = DeviceInfo.getAppIconAsIntId(context);
            }
            priorityInt = 0;
            String priority = extras.getString("pr");
            if (priority != null) {
                if (priority.equals("high")) {
                    priorityInt = 1;
                }
                if (priority.equals("max")) {
                    priorityInt = 2;
                }
            }
            if (notificationId == -1000) {
                try {
                    Object collapse_key = extras.get("wzrk_ck");
                    if (collapse_key == null) break block62;
                    if (collapse_key instanceof Number) {
                        notificationId = ((Number)collapse_key).intValue();
                        break block62;
                    }
                    if (!(collapse_key instanceof String)) break block62;
                    try {
                        notificationId = Integer.parseInt(collapse_key.toString());
                        this.getConfigLogger().debug(this.getAccountId(), "Converting collapse_key: " + collapse_key + " to notificationId int: " + notificationId);
                    }
                    catch (NumberFormatException e) {
                        notificationId = collapse_key.toString().hashCode();
                        this.getConfigLogger().debug(this.getAccountId(), "Converting collapse_key: " + collapse_key + " to notificationId int: " + notificationId);
                    }
                }
                catch (NumberFormatException collapse_key) {}
            } else {
                this.getConfigLogger().debug(this.getAccountId(), "Have user provided notificationId: " + notificationId + " won't use collapse_key (if any) as basis for notificationId");
            }
        }
        if (notificationId == -1000) {
            notificationId = (int)(Math.random() * 100.0);
            this.getConfigLogger().debug(this.getAccountId(), "Setting random notificationId: " + notificationId);
        }
        if (context.getApplicationInfo().targetSdkVersion >= 26) {
            String badgeCountParam;
            String channelId = extras.getString("wzrk_cid", "");
            if (channelId.isEmpty()) {
                this.getConfigLogger().debug(this.getAccountId(), "ChannelId is empty for notification: " + extras.toString());
            }
            nb = new NotificationCompat.Builder(context, channelId);
            String badgeIconParam = extras.getString("wzrk_bi", null);
            if (badgeIconParam != null) {
                try {
                    int badgeIconType = Integer.parseInt(badgeIconParam);
                    if (badgeIconType >= 0) {
                        nb.setBadgeIconType(badgeIconType);
                    }
                }
                catch (Throwable badgeIconType) {
                    // empty catch block
                }
            }
            if ((badgeCountParam = extras.getString("wzrk_bc", null)) != null) {
                try {
                    int badgeCount = Integer.parseInt(badgeCountParam);
                    if (badgeCount >= 0) {
                        nb.setNumber(badgeCount);
                    }
                }
                catch (Throwable badgeCount) {
                    // empty catch block
                }
            }
            if (extras.containsKey("wzrk_st")) {
                nb.setSubText((CharSequence)extras.getString("wzrk_st"));
            }
        } else {
            nb = new NotificationCompat.Builder(context);
        }
        if (extras.containsKey("wzrk_clr")) {
            int color = Color.parseColor((String)extras.getString("wzrk_clr"));
            nb.setColor(color);
            nb.setColorized(true);
        }
        nb.setContentTitle((CharSequence)notifTitle).setContentText((CharSequence)notifMessage).setContentIntent(pIntent).setAutoCancel(true).setStyle((NotificationCompat.Style)style2).setPriority(priorityInt).setSmallIcon(smallIcon);
        nb.setLargeIcon(Utils.getNotificationBitmap(icoPath, true, context));
        try {
            if (extras.containsKey("wzrk_sound")) {
                Uri soundUri = null;
                Object o = extras.get("wzrk_sound");
                if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
                    soundUri = RingtoneManager.getDefaultUri((int)2);
                } else if (o instanceof String) {
                    String s = (String)o;
                    if (s.equals("true")) {
                        soundUri = RingtoneManager.getDefaultUri((int)2);
                    } else if (!s.isEmpty()) {
                        if (s.contains(".mp3") || s.contains(".ogg") || s.contains(".wav")) {
                            s = s.substring(0, s.length() - 4);
                        }
                        soundUri = Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + s));
                    }
                }
                if (soundUri != null) {
                    nb.setSound(soundUri);
                }
            }
        }
        catch (Throwable t) {
            this.getConfigLogger().debug(this.getAccountId(), "Could not process sound parameter", t);
        }
        JSONArray actions = null;
        String actionsString = extras.getString("wzrk_acts");
        if (actionsString != null) {
            try {
                actions = new JSONArray(actionsString);
            }
            catch (Throwable t) {
                this.getConfigLogger().debug(this.getAccountId(), "error parsing notification actions: " + t.getLocalizedMessage());
            }
        }
        boolean isCTIntentServiceAvailable = CleverTapAPI.isServiceAvailable(context, "com.clevertap.PUSH_EVENT", CTNotificationIntentService.class);
        if (actions != null && actions.length() > 0) {
            for (int i = 0; i < actions.length(); ++i) {
                try {
                    Intent actionLaunchIntent;
                    boolean sendToCTIntentService;
                    JSONObject action = actions.getJSONObject(i);
                    String label = action.optString("l");
                    String dl = action.optString("dl");
                    String ico = action.optString("ico");
                    String id2 = action.optString("id");
                    boolean autoCancel = action.optBoolean("ac", true);
                    if (label.isEmpty() || id2.isEmpty()) {
                        this.getConfigLogger().debug(this.getAccountId(), "not adding push notification action: action label or id missing");
                        continue;
                    }
                    int icon = 0;
                    if (!ico.isEmpty()) {
                        try {
                            icon = context.getResources().getIdentifier(ico, "drawable", context.getPackageName());
                        }
                        catch (Throwable t) {
                            this.getConfigLogger().debug(this.getAccountId(), "unable to add notification action icon: " + t.getLocalizedMessage());
                        }
                    }
                    boolean bl = sendToCTIntentService = autoCancel && isCTIntentServiceAvailable;
                    if (sendToCTIntentService) {
                        actionLaunchIntent = new Intent("com.clevertap.PUSH_EVENT");
                        actionLaunchIntent.setPackage(context.getPackageName());
                        actionLaunchIntent.putExtra("ct_type", "com.clevertap.ACTION_BUTTON_CLICK");
                        if (!dl.isEmpty()) {
                            actionLaunchIntent.putExtra("dl", dl);
                        }
                    } else {
                        actionLaunchIntent = !dl.isEmpty() ? new Intent("android.intent.action.VIEW", Uri.parse((String)dl)) : context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
                    }
                    if (actionLaunchIntent != null) {
                        actionLaunchIntent.putExtras(extras);
                        actionLaunchIntent.removeExtra("wzrk_acts");
                        actionLaunchIntent.putExtra("actionId", id2);
                        actionLaunchIntent.putExtra("autoCancel", autoCancel);
                        actionLaunchIntent.putExtra("wzrk_c2a", id2);
                        actionLaunchIntent.putExtra("notificationId", notificationId);
                        actionLaunchIntent.setFlags(0x24000000);
                    }
                    int requestCode = (int)System.currentTimeMillis() + i;
                    PendingIntent actionIntent = sendToCTIntentService ? PendingIntent.getService((Context)context, (int)requestCode, (Intent)actionLaunchIntent, (int)0x8000000) : PendingIntent.getActivity((Context)context, (int)requestCode, (Intent)actionLaunchIntent, (int)0x8000000);
                    nb.addAction(icon, (CharSequence)label, actionIntent);
                    continue;
                }
                catch (Throwable t) {
                    this.getConfigLogger().debug(this.getAccountId(), "error adding notification action : " + t.getLocalizedMessage());
                }
            }
        }
        Notification n = nb.build();
        this.getConfigLogger().debug(this.getAccountId(), "Building notification: " + n.toString() + ", with notificationId: " + String.valueOf(notificationId));
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (notificationManager != null) {
            notificationManager.notify(notificationId, n);
            String ttl = extras.getString("wzrk_ttl", (System.currentTimeMillis() + 345600000L) / 1000L + "");
            long wzrk_ttl = Long.parseLong(ttl);
            String wzrk_pid = extras.getString("wzrk_pid");
            DBAdapter dbAdapter = this.loadDBAdapter(context);
            this.getConfigLogger().verbose("Storing Push Notification..." + wzrk_pid + " - with ttl - " + ttl);
            dbAdapter.storePushNotificationId(wzrk_pid, wzrk_ttl);
        }
    }

    private static boolean isServiceAvailable(Context context, String action, Class clazz) {
        Intent intent;
        PackageManager packageManager = context.getPackageManager();
        List resolveInfo = packageManager.queryIntentServices(intent = new Intent(action), 0);
        if (resolveInfo.size() > 0) {
            Logger.v("" + clazz.getName() + " is available");
            return true;
        }
        Logger.v("" + clazz.getName() + " is NOT available");
        return false;
    }

    public static void createNotificationChannel(final Context context, final String channelId, final CharSequence channelName, final String channelDescription, final int importance, final boolean showBadge) {
        final CleverTapAPI instance = CleverTapAPI.getDefaultInstanceOrFirstOther(context);
        if (instance == null) {
            Logger.v("No CleverTap Instance found in CleverTapAPI#createNotificatonChannel");
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                instance.postAsyncSafely("createNotificationChannel", new Runnable(){

                    @Override
                    @RequiresApi(api=26)
                    public void run() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        if (notificationManager == null) {
                            return;
                        }
                        NotificationChannel notificationChannel = new NotificationChannel(channelId, channelName, importance);
                        notificationChannel.setDescription(channelDescription);
                        notificationChannel.setShowBadge(showBadge);
                        notificationManager.createNotificationChannel(notificationChannel);
                        instance.getConfigLogger().info(instance.getAccountId(), "Notification channel " + channelName.toString() + " has been created");
                    }
                });
            }
        }
        catch (Throwable t) {
            instance.getConfigLogger().verbose(instance.getAccountId(), "Failure creating Notification Channel", t);
        }
    }

    public static void createNotificationChannel(final Context context, final String channelId, final CharSequence channelName, final String channelDescription, final int importance, final String groupId, final boolean showBadge) {
        final CleverTapAPI instance = CleverTapAPI.getDefaultInstanceOrFirstOther(context);
        if (instance == null) {
            Logger.v("No CleverTap Instance found in CleverTapAPI#createNotificatonChannel");
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                instance.postAsyncSafely("creatingNotificationChannel", new Runnable(){

                    @Override
                    @RequiresApi(api=26)
                    public void run() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        if (notificationManager == null) {
                            return;
                        }
                        NotificationChannel notificationChannel = new NotificationChannel(channelId, channelName, importance);
                        notificationChannel.setDescription(channelDescription);
                        notificationChannel.setGroup(groupId);
                        notificationChannel.setShowBadge(showBadge);
                        notificationManager.createNotificationChannel(notificationChannel);
                        instance.getConfigLogger().info(instance.getAccountId(), "Notification channel " + channelName.toString() + " has been created");
                    }
                });
            }
        }
        catch (Throwable t) {
            instance.getConfigLogger().verbose(instance.getAccountId(), "Failure creating Notification Channel", t);
        }
    }

    public static void createNotificationChannel(final Context context, final String channelId, final CharSequence channelName, final String channelDescription, final int importance, final boolean showBadge, final String sound) {
        final CleverTapAPI instance = CleverTapAPI.getDefaultInstanceOrFirstOther(context);
        if (instance == null) {
            Logger.v("No CleverTap Instance found in CleverTapAPI#createNotificatonChannel");
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                instance.postAsyncSafely("createNotificationChannel", new Runnable(){

                    @Override
                    @RequiresApi(api=26)
                    public void run() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        if (notificationManager == null) {
                            return;
                        }
                        String soundfile = "";
                        Uri soundUri = null;
                        if (!sound.isEmpty()) {
                            if (sound.contains(".mp3") || sound.contains(".ogg") || sound.contains(".wav")) {
                                soundfile = sound.substring(0, sound.length() - 4);
                            } else {
                                instance.getConfigLogger().debug(instance.getAccountId(), "Sound file name not supported");
                            }
                            if (!soundfile.isEmpty()) {
                                soundUri = Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + soundfile));
                            }
                        }
                        NotificationChannel notificationChannel = new NotificationChannel(channelId, channelName, importance);
                        notificationChannel.setDescription(channelDescription);
                        notificationChannel.setShowBadge(showBadge);
                        if (soundUri != null) {
                            notificationChannel.setSound(soundUri, new AudioAttributes.Builder().setUsage(5).build());
                        } else {
                            instance.getConfigLogger().debug(instance.getAccountId(), "Sound file not found, notification channel will be created without custom sound");
                        }
                        notificationManager.createNotificationChannel(notificationChannel);
                        instance.getConfigLogger().info(instance.getAccountId(), "Notification channel " + channelName.toString() + " has been created");
                    }
                });
            }
        }
        catch (Throwable t) {
            instance.getConfigLogger().verbose(instance.getAccountId(), "Failure creating Notification Channel", t);
        }
    }

    public static void createNotificationChannel(final Context context, final String channelId, final CharSequence channelName, final String channelDescription, final int importance, final String groupId, final boolean showBadge, final String sound) {
        final CleverTapAPI instance = CleverTapAPI.getDefaultInstanceOrFirstOther(context);
        if (instance == null) {
            Logger.v("No CleverTap Instance found in CleverTapAPI#createNotificatonChannel");
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                instance.postAsyncSafely("creatingNotificationChannel", new Runnable(){

                    @Override
                    @RequiresApi(api=26)
                    public void run() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        if (notificationManager == null) {
                            return;
                        }
                        String soundfile = "";
                        Uri soundUri = null;
                        if (!sound.isEmpty()) {
                            if (sound.contains(".mp3") || sound.contains(".ogg") || sound.contains(".wav")) {
                                soundfile = sound.substring(0, sound.length() - 4);
                            } else {
                                instance.getConfigLogger().debug(instance.getAccountId(), "Sound file name not supported");
                            }
                            if (!soundfile.isEmpty()) {
                                soundUri = Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + soundfile));
                            }
                        }
                        NotificationChannel notificationChannel = new NotificationChannel(channelId, channelName, importance);
                        notificationChannel.setDescription(channelDescription);
                        notificationChannel.setGroup(groupId);
                        notificationChannel.setShowBadge(showBadge);
                        if (soundUri != null) {
                            notificationChannel.setSound(soundUri, new AudioAttributes.Builder().setUsage(5).build());
                        } else {
                            instance.getConfigLogger().debug(instance.getAccountId(), "Sound file not found, notification channel will be created without custom sound");
                        }
                        notificationManager.createNotificationChannel(notificationChannel);
                        instance.getConfigLogger().info(instance.getAccountId(), "Notification channel " + channelName.toString() + " has been created");
                    }
                });
            }
        }
        catch (Throwable t) {
            instance.getConfigLogger().verbose(instance.getAccountId(), "Failure creating Notification Channel", t);
        }
    }

    public static void createNotificationChannelGroup(final Context context, final String groupId, final CharSequence groupName) {
        final CleverTapAPI instance = CleverTapAPI.getDefaultInstanceOrFirstOther(context);
        if (instance == null) {
            Logger.v("No CleverTap Instance found in CleverTapAPI#createNotificationChannelGroup");
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                instance.postAsyncSafely("creatingNotificationChannelGroup", new Runnable(){

                    @Override
                    @RequiresApi(api=26)
                    public void run() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        if (notificationManager == null) {
                            return;
                        }
                        notificationManager.createNotificationChannelGroup(new NotificationChannelGroup(groupId, groupName));
                        instance.getConfigLogger().info(instance.getAccountId(), "Notification channel group " + groupName.toString() + " has been created");
                    }
                });
            }
        }
        catch (Throwable t) {
            instance.getConfigLogger().verbose(instance.getAccountId(), "Failure creating Notification Channel Group", t);
        }
    }

    public static void deleteNotificationChannel(final Context context, final String channelId) {
        final CleverTapAPI instance = CleverTapAPI.getDefaultInstanceOrFirstOther(context);
        if (instance == null) {
            Logger.v("No CleverTap Instance found in CleverTapAPI#deleteNotificationChannel");
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                instance.postAsyncSafely("deletingNotificationChannel", new Runnable(){

                    @Override
                    @RequiresApi(api=26)
                    public void run() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        if (notificationManager == null) {
                            return;
                        }
                        notificationManager.deleteNotificationChannel(channelId);
                        instance.getConfigLogger().info(instance.getAccountId(), "Notification channel " + channelId + " has been deleted");
                    }
                });
            }
        }
        catch (Throwable t) {
            instance.getConfigLogger().verbose(instance.getAccountId(), "Failure deleting Notification Channel", t);
        }
    }

    public static void deleteNotificationChannelGroup(final Context context, final String groupId) {
        final CleverTapAPI instance = CleverTapAPI.getDefaultInstanceOrFirstOther(context);
        if (instance == null) {
            Logger.v("No CleverTap Instance found in CleverTapAPI#deleteNotificationChannelGroup");
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                instance.postAsyncSafely("deletingNotificationChannelGroup", new Runnable(){

                    @Override
                    @RequiresApi(api=26)
                    public void run() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        if (notificationManager == null) {
                            return;
                        }
                        notificationManager.deleteNotificationChannelGroup(groupId);
                        instance.getConfigLogger().info(instance.getAccountId(), "Notification channel group " + groupId + " has been deleted");
                    }
                });
            }
        }
        catch (Throwable t) {
            instance.getConfigLogger().verbose(instance.getAccountId(), "Failure deleting Notification Channel Group", t);
        }
    }

    static void handleInstallReferrer(Context context, Intent intent) {
        if (instances == null) {
            Logger.v("No CleverTap Instance found");
            CleverTapAPI instance = CleverTapAPI.getDefaultInstance(context);
            if (instance != null) {
                instance.pushInstallReferrer(intent);
            }
            return;
        }
        for (String accountId : instances.keySet()) {
            CleverTapAPI instance = instances.get(accountId);
            if (instance == null) continue;
            instance.pushInstallReferrer(intent);
        }
    }

    public void pushInstallReferrer(Intent intent) {
        try {
            String url;
            Bundle extras = intent.getExtras();
            if (extras == null || !extras.containsKey("referrer")) {
                return;
            }
            try {
                url = URLDecoder.decode(extras.getString("referrer"), "UTF-8");
                this.getConfigLogger().verbose(this.getAccountId(), "Referrer received: " + url);
            }
            catch (Throwable e) {
                return;
            }
            if (url == null) {
                return;
            }
            int now = (int)(System.currentTimeMillis() / 1000L);
            if (this.installReferrerMap.containsKey(url) && now - this.installReferrerMap.get(url) < 10) {
                this.getConfigLogger().verbose(this.getAccountId(), "Skipping install referrer due to duplicate within 10 seconds");
                return;
            }
            this.installReferrerMap.put(url, now);
            Uri uri = Uri.parse((String)("wzrk://track?install=true&" + url));
            this.pushDeepLink(uri, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized void pushInstallReferrer(String source, String medium, String campaign) {
        if (source == null && medium == null && campaign == null) {
            return;
        }
        try {
            int status = StorageHelper.getInt(this.context, "app_install_status", 0);
            if (status != 0) {
                Logger.d("Install referrer has already been set. Will not override it");
                return;
            }
            StorageHelper.putInt(this.context, "app_install_status", 1);
            if (source != null) {
                source = Uri.encode((String)source);
            }
            if (medium != null) {
                medium = Uri.encode((String)medium);
            }
            if (campaign != null) {
                campaign = Uri.encode((String)campaign);
            }
            String uriStr = "wzrk://track?install=true";
            if (source != null) {
                uriStr = uriStr + "&utm_source=" + source;
            }
            if (medium != null) {
                uriStr = uriStr + "&utm_medium=" + medium;
            }
            if (campaign != null) {
                uriStr = uriStr + "&utm_campaign=" + campaign;
            }
            Uri uri = Uri.parse((String)uriStr);
            this.pushDeepLink(uri, true);
        }
        catch (Throwable t) {
            Logger.v("Failed to push install referrer", t);
        }
    }

    public static void changeCredentials(String accountID, String token) {
        CleverTapAPI.changeCredentials(accountID, token, null);
    }

    public static void changeCredentials(String accountID, String token, String region) {
        if (defaultConfig != null) {
            Logger.i("CleverTap SDK already initialized with accountID:" + defaultConfig.getAccountId() + " and token:" + defaultConfig.getAccountToken() + ". Cannot change credentials to " + accountID + " and " + token);
            return;
        }
        ManifestInfo.changeCredentials(accountID, token, region);
    }

    public Location getLocation() {
        return this._getLocation();
    }

    public void setLocation(Location location) {
        this._setLocation(location);
    }

    @Deprecated
    public void updateLocation(Location location) {
        this._setLocation(location);
    }

    private void _setLocation(Location location) {
        if (location == null) {
            return;
        }
        this.locationFromUser = location;
        Logger.v("Location updated (" + location.getLatitude() + ", " + location.getLongitude() + ")");
        if (!CleverTapAPI.isAppForeground()) {
            return;
        }
        int now = (int)(System.currentTimeMillis() / 1000L);
        if (now > this.lastLocationPingTime + 10) {
            this.queueEvent(this.context, new JSONObject(), 2);
            this.lastLocationPingTime = now;
            Logger.v("Queuing location ping event for location (" + location.getLatitude() + ", " + location.getLongitude() + ")");
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private Location _getLocation() {
        try {
            LocationManager lm = (LocationManager)this.context.getSystemService("location");
            if (lm == null) {
                Logger.d("Location Manager is null.");
                return null;
            }
            List providers = lm.getProviders(true);
            Location bestLocation = null;
            Location l = null;
            for (String provider : providers) {
                try {
                    l = lm.getLastKnownLocation(provider);
                }
                catch (SecurityException e) {
                    Logger.v("Location security exception", e);
                }
                if (l == null || bestLocation != null && !(l.getAccuracy() < bestLocation.getAccuracy())) continue;
                bestLocation = l;
            }
            return bestLocation;
        }
        catch (Throwable t) {
            Logger.v("Couldn't get user's location", t);
            return null;
        }
    }

    private void processInboxResponse(JSONObject response) {
        if (this.getConfig().isAnalyticsOnly()) {
            this.getConfigLogger().verbose(this.getAccountId(), "CleverTap instance is configured to analytics only, not processing inbox messages");
            return;
        }
        this.getConfigLogger().verbose(this.getAccountId(), "Inbox: Processing response");
        if (!response.has("inbox_notifs")) {
            this.getConfigLogger().verbose(this.getAccountId(), "Inbox: Response JSON object doesn't contain the inbox key");
            return;
        }
        try {
            this._processInboxMessages(response.getJSONArray("inbox_notifs"));
        }
        catch (Throwable t) {
            this.getConfigLogger().verbose(this.getAccountId(), "InboxResponse: Failed to parse response", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _processInboxMessages(JSONArray messages) {
        Object object = this.inboxControllerLock;
        synchronized (object) {
            boolean update;
            if (this.ctInboxController == null) {
                this._initializeInbox();
            }
            if (this.ctInboxController != null && (update = this.ctInboxController.updateMessages(messages))) {
                this._notifyInboxMessagesDidUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initializeInbox() {
        Object object = this.inboxControllerLock;
        synchronized (object) {
            if (this.ctInboxController != null) {
                this._notifyInboxInitialized();
                return;
            }
            this.ctInboxController = new CTInboxController(this.getCleverTapID(), this.loadDBAdapter(this.context), haveVideoPlayerSupport);
            this._notifyInboxInitialized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetInbox() {
        Object object = this.inboxControllerLock;
        synchronized (object) {
            this.ctInboxController = null;
        }
        this._initializeInbox();
    }

    public void setCTNotificationInboxListener(CTInboxListener notificationInboxListener) {
        this.inboxListener = notificationInboxListener;
    }

    public CTInboxListener getCTNotificationInboxListener() {
        return this.inboxListener;
    }

    private void _notifyInboxInitialized() {
        if (this.inboxListener != null) {
            this.inboxListener.inboxDidInitialize();
        }
    }

    private void _notifyInboxMessagesDidUpdate() {
        if (this.inboxListener != null) {
            this.inboxListener.inboxMessagesDidUpdate();
        }
    }

    public void initializeInbox() {
        if (this.getConfig().isAnalyticsOnly()) {
            this.getConfigLogger().debug(this.getAccountId(), "Instance is analytics only, not initializing Notification Inbox");
            return;
        }
        this.postAsyncSafely("initializeInbox", new Runnable(){

            @Override
            public void run() {
                CleverTapAPI.this._initializeInbox();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInboxMessageCount() {
        Object object = this.inboxControllerLock;
        synchronized (object) {
            if (this.ctInboxController != null) {
                return this.ctInboxController.count();
            }
            this.getConfigLogger().debug(this.getAccountId(), "Notification Inbox not initialized");
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInboxMessageUnreadCount() {
        Object object = this.inboxControllerLock;
        synchronized (object) {
            if (this.ctInboxController != null) {
                return this.ctInboxController.unreadCount();
            }
            this.getConfigLogger().debug(this.getAccountId(), "Notification Inbox not initialized");
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CTInboxMessage getInboxMessageForId(String messageId) {
        Object object = this.inboxControllerLock;
        synchronized (object) {
            if (this.ctInboxController != null) {
                CTMessageDAO message = this.ctInboxController.getMessageForId(messageId);
                CTInboxMessage cTInboxMessage = message != null ? new CTInboxMessage(message.toJSON()) : null;
                return cTInboxMessage;
            }
            this.getConfigLogger().debug(this.getAccountId(), "Notification Inbox not initialized");
            return null;
        }
    }

    public void deleteInboxMessage(final CTInboxMessage message) {
        this.postAsyncSafely("deleteInboxMessage", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = CleverTapAPI.this.inboxControllerLock;
                synchronized (object) {
                    if (CleverTapAPI.this.ctInboxController != null) {
                        boolean update = CleverTapAPI.this.ctInboxController.deleteMessageWithId(message.getMessageId());
                        if (update) {
                            CleverTapAPI.this._notifyInboxMessagesDidUpdate();
                        }
                    } else {
                        CleverTapAPI.this.getConfigLogger().debug(CleverTapAPI.this.getAccountId(), "Notification Inbox not initialized");
                    }
                }
            }
        });
    }

    public void markReadInboxMessage(final CTInboxMessage message) {
        this.postAsyncSafely("markReadInboxMessage", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = CleverTapAPI.this.inboxControllerLock;
                synchronized (object) {
                    if (CleverTapAPI.this.ctInboxController != null) {
                        boolean read = CleverTapAPI.this.ctInboxController.markReadForMessageWithId(message.getMessageId());
                        if (read) {
                            CleverTapAPI.this._notifyInboxMessagesDidUpdate();
                        }
                    } else {
                        CleverTapAPI.this.getConfigLogger().debug(CleverTapAPI.this.getAccountId(), "Notification Inbox not initialized");
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<CTInboxMessage> getUnreadInboxMessages() {
        ArrayList<CTInboxMessage> inboxMessageArrayList = new ArrayList<CTInboxMessage>();
        Object object = this.inboxControllerLock;
        synchronized (object) {
            if (this.ctInboxController != null) {
                ArrayList<CTMessageDAO> messageDAOArrayList = this.ctInboxController.getUnreadMessages();
                for (CTMessageDAO messageDAO : messageDAOArrayList) {
                    inboxMessageArrayList.add(new CTInboxMessage(messageDAO.toJSON()));
                }
                return inboxMessageArrayList;
            }
            this.getConfigLogger().debug(this.getAccountId(), "Notification Inbox not initialized");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<CTInboxMessage> getAllInboxMessages() {
        ArrayList<CTInboxMessage> inboxMessageArrayList = new ArrayList<CTInboxMessage>();
        Object object = this.inboxControllerLock;
        synchronized (object) {
            if (this.ctInboxController != null) {
                ArrayList<CTMessageDAO> messageDAOArrayList = this.ctInboxController.getMessages();
                for (CTMessageDAO messageDAO : messageDAOArrayList) {
                    Logger.v("CTMessage Dao - " + messageDAO.toJSON().toString());
                    inboxMessageArrayList.add(new CTInboxMessage(messageDAO.toJSON()));
                }
                return inboxMessageArrayList;
            }
            this.getConfigLogger().debug(this.getAccountId(), "Notification Inbox not initialized");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showAppInbox(CTInboxStyleConfig styleConfig) {
        Object object = this.inboxControllerLock;
        synchronized (object) {
            if (this.ctInboxController == null) {
                this.getConfigLogger().debug(this.getAccountId(), "Notification Inbox not initialized");
                return;
            }
        }
        CTInboxStyleConfig _styleConfig = new CTInboxStyleConfig(styleConfig);
        Intent intent = new Intent(this.context, CTInboxActivity.class);
        intent.putExtra("styleConfig", (Parcelable)_styleConfig);
        intent.putExtra("config", (Parcelable)this.config);
        try {
            Activity currentActivity = CleverTapAPI.getCurrentActivity();
            if (currentActivity == null) {
                throw new IllegalStateException("Current activity reference not found");
            }
            currentActivity.startActivity(intent);
            Logger.d("Displaying Notification Inbox");
        }
        catch (Throwable t) {
            Logger.v("Please verify the integration of your app. It is not setup to support Notification Inbox yet.", t);
        }
    }

    public void showAppInbox() {
        CTInboxStyleConfig styleConfig = new CTInboxStyleConfig();
        this.showAppInbox(styleConfig);
    }

    @Override
    public void messageDidShow(CTInboxActivity ctInboxActivity, final CTInboxMessage inboxMessage, final Bundle data) {
        this.postAsyncSafely("handleMessageDidShow", new Runnable(){

            @Override
            public void run() {
                CTInboxMessage message = CleverTapAPI.this.getInboxMessageForId(inboxMessage.getMessageId());
                if (!message.isRead()) {
                    CleverTapAPI.this.markReadInboxMessage(inboxMessage);
                    CleverTapAPI.this.pushInboxMessageStateEvent(false, inboxMessage, data);
                }
            }
        });
    }

    @Override
    public void messageDidClick(CTInboxActivity ctInboxActivity, CTInboxMessage inboxMessage, Bundle data) {
        this.pushInboxMessageStateEvent(true, inboxMessage, data);
    }

    private void createAlarmScheduler(Context context) {
        int pingFrequency = this.getPingFrequency(context);
        if (pingFrequency > 0) {
            AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
            Intent intent = new Intent("com.clevertap.BG_EVENT");
            intent.setPackage(context.getPackageName());
            PendingIntent alarmPendingIntent = PendingIntent.getService((Context)context, (int)this.getAccountId().hashCode(), (Intent)intent, (int)0x8000000);
            if (alarmManager != null) {
                alarmManager.setInexactRepeating(2, SystemClock.elapsedRealtime(), 60000L * (long)pingFrequency, alarmPendingIntent);
            }
        }
    }

    private void resetAlarmScheduler(Context context) {
        if (this.getPingFrequency(context) <= 0) {
            this.stopAlarmScheduler(context);
        } else {
            this.stopAlarmScheduler(context);
            this.createAlarmScheduler(context);
        }
    }

    private void stopAlarmScheduler(Context context) {
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        Intent cancelIntent = new Intent("com.clevertap.BG_EVENT");
        cancelIntent.setPackage(context.getPackageName());
        PendingIntent alarmPendingIntent = PendingIntent.getService((Context)context, (int)this.getAccountId().hashCode(), (Intent)cancelIntent, (int)0x8000000);
        if (alarmManager != null && alarmPendingIntent != null) {
            alarmManager.cancel(alarmPendingIntent);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    @RequiresApi(api=21)
    private void createOrResetJobScheduler(Context context) {
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (jobScheduler == null) {
            return;
        }
        int pingFrequency = this.getPingFrequency(context);
        int existingJobId = StorageHelper.getInt(context, "pfjobid", -1);
        if (existingJobId < 0 && pingFrequency < 0) {
            return;
        }
        if (pingFrequency < 0) {
            jobScheduler.cancel(existingJobId);
            StorageHelper.putInt(context, "pfjobid", -1);
            return;
        }
        ComponentName componentName = new ComponentName(context, CTBackgroundJobService.class);
        boolean needsCreate = existingJobId < 0 && pingFrequency > 0;
        JobInfo existingJobInfo = CleverTapAPI.getJobInfo(existingJobId, jobScheduler);
        if (existingJobInfo != null && existingJobInfo.getIntervalMillis() != (long)pingFrequency * 60000L) {
            jobScheduler.cancel(existingJobId);
            StorageHelper.putInt(context, "pfjobid", -1);
            needsCreate = true;
        }
        if (needsCreate) {
            JobInfo jobInfo;
            int resultCode;
            int jobid = this.getAccountId().hashCode();
            JobInfo.Builder builder = new JobInfo.Builder(jobid, componentName);
            builder.setRequiredNetworkType(1);
            builder.setRequiresCharging(false);
            if (Build.VERSION.SDK_INT >= 24) {
                builder.setPeriodic((long)pingFrequency * 60000L, 300000L);
            } else {
                builder.setPeriodic((long)(pingFrequency * 60 * 1000));
            }
            if (Build.VERSION.SDK_INT >= 26) {
                builder.setRequiresBatteryNotLow(true);
            }
            if (this.deviceInfo.testPermission(context, "android.permission.RECEIVE_BOOT_COMPLETED")) {
                builder.setPersisted(true);
            }
            if ((resultCode = jobScheduler.schedule(jobInfo = builder.build())) == 1) {
                Logger.d(this.getAccountId(), "Job scheduled - " + jobid);
                StorageHelper.putInt(context, "pfjobid", jobid);
            } else {
                Logger.d(this.getAccountId(), "Job not scheduled - " + jobid);
            }
        }
    }

    static void runJobWork(Context context, JobParameters parameters) {
        if (instances == null) {
            CleverTapAPI instance = CleverTapAPI.getDefaultInstance(context);
            if (instance != null) {
                if (instance.getConfig().isBackgroundSync()) {
                    instance.runInstanceJobWork(context, parameters);
                } else {
                    Logger.d("Instance doesn't allow Background sync, not running the Job");
                }
            }
            return;
        }
        for (String accountId : instances.keySet()) {
            CleverTapAPI instance = instances.get(accountId);
            if (instance != null && instance.getConfig().isAnalyticsOnly()) {
                Logger.d(accountId, "Instance is Analytics Only not running the Job");
                continue;
            }
            if (instance == null || !instance.getConfig().isBackgroundSync()) {
                Logger.d(accountId, "Instance doesn't allow Background sync, not running the Job");
                continue;
            }
            instance.runInstanceJobWork(context, parameters);
        }
    }

    static void runBackgroundIntentService(Context context) {
        if (instances == null) {
            CleverTapAPI instance = CleverTapAPI.getDefaultInstance(context);
            if (instance != null) {
                if (instance.getConfig().isBackgroundSync()) {
                    instance.runInstanceJobWork(context, null);
                } else {
                    Logger.d("Instance doesn't allow Background sync, not running the Job");
                }
            }
            return;
        }
        for (String accountId : instances.keySet()) {
            CleverTapAPI instance = instances.get(accountId);
            if (instance == null) continue;
            if (instance.getConfig().isAnalyticsOnly()) {
                Logger.d(accountId, "Instance is Analytics Only not processing device token");
                continue;
            }
            if (!instance.getConfig().isBackgroundSync()) {
                Logger.d(accountId, "Instance doesn't allow Background sync, not running the Job");
                continue;
            }
            instance.runInstanceJobWork(context, null);
        }
    }

    private void runInstanceJobWork(final Context context, final JobParameters parameters) {
        this.postAsyncSafely("runningJobService", new Runnable(){

            @Override
            public void run() {
                Date endTime;
                if (CleverTapAPI.this.getCachedFCMToken() == null && CleverTapAPI.this.getCachedGCMToken() == null) {
                    Logger.v(CleverTapAPI.this.getAccountId(), "Token is not present, not running the Job");
                    return;
                }
                Calendar now = Calendar.getInstance();
                int hour = now.get(11);
                int minute = now.get(12);
                Date currentTime = CleverTapAPI.this.parseTimeToDate(hour + ":" + minute);
                Date startTime = CleverTapAPI.this.parseTimeToDate("22:00");
                if (CleverTapAPI.this.isTimeBetweenDNDTime(startTime, endTime = CleverTapAPI.this.parseTimeToDate("06:00"), currentTime)) {
                    Logger.v(CleverTapAPI.this.getAccountId(), "Job Service won't run in default DND hours");
                    return;
                }
                long lastTS = CleverTapAPI.this.loadDBAdapter(context).getLastUninstallTimestamp();
                if (lastTS == 0L || lastTS > System.currentTimeMillis() - 86400000L) {
                    try {
                        JSONObject eventObject = new JSONObject();
                        eventObject.put("bk", 1);
                        CleverTapAPI.this.queueEvent(context, eventObject, 2);
                        if (parameters == null) {
                            int pingFrequency = CleverTapAPI.this.getPingFrequency(context);
                            AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
                            Intent cancelIntent = new Intent("com.clevertap.BG_EVENT");
                            cancelIntent.setPackage(context.getPackageName());
                            PendingIntent alarmPendingIntent = PendingIntent.getService((Context)context, (int)CleverTapAPI.this.getAccountId().hashCode(), (Intent)cancelIntent, (int)0x8000000);
                            if (alarmManager != null) {
                                alarmManager.cancel(alarmPendingIntent);
                            }
                            Intent alarmIntent = new Intent("com.clevertap.BG_EVENT");
                            alarmIntent.setPackage(context.getPackageName());
                            PendingIntent alarmServicePendingIntent = PendingIntent.getService((Context)context, (int)CleverTapAPI.this.getAccountId().hashCode(), (Intent)alarmIntent, (int)0x8000000);
                            if (alarmManager != null && pingFrequency != -1) {
                                alarmManager.setInexactRepeating(2, SystemClock.elapsedRealtime() + (long)pingFrequency * 60000L, 60000L * (long)pingFrequency, alarmServicePendingIntent);
                            }
                        }
                    }
                    catch (JSONException e) {
                        Logger.v("Unable to raise background Ping event");
                    }
                }
            }
        });
    }

    @RequiresApi(api=21)
    private static JobInfo getJobInfo(int jobId, JobScheduler jobScheduler) {
        for (JobInfo jobInfo : jobScheduler.getAllPendingJobs()) {
            if (jobInfo.getId() != jobId) continue;
            return jobInfo;
        }
        return null;
    }

    private Date parseTimeToDate(String time) {
        String inputFormat = "HH:mm";
        SimpleDateFormat inputParser = new SimpleDateFormat("HH:mm", Locale.US);
        try {
            return inputParser.parse(time);
        }
        catch (ParseException e) {
            return new Date(0L);
        }
    }

    private boolean isTimeBetweenDNDTime(Date startTime, Date stopTime, Date currentTime) {
        Calendar startTimeCalendar = Calendar.getInstance();
        startTimeCalendar.setTime(startTime);
        Calendar currentTimeCalendar = Calendar.getInstance();
        currentTimeCalendar.setTime(currentTime);
        Calendar stopTimeCalendar = Calendar.getInstance();
        stopTimeCalendar.setTime(stopTime);
        if (stopTime.compareTo(startTime) < 0) {
            if (currentTimeCalendar.compareTo(stopTimeCalendar) < 0) {
                currentTimeCalendar.add(5, 1);
            }
            stopTimeCalendar.add(5, 1);
        }
        return currentTimeCalendar.compareTo(startTimeCalendar) >= 0 && currentTimeCalendar.compareTo(stopTimeCalendar) < 0;
    }

    static {
        appForeground = false;
        activityCount = 0;
        pendingNotifications = new ArrayList();
        currentlyDisplayingInApp = null;
        initialAppEnteredForegroundTime = 0;
        haveVideoPlayerSupport = CleverTapAPI.checkForExoPlayer();
    }

    private final class NotificationPrepareRunnable
    implements Runnable {
        private final WeakReference<CleverTapAPI> cleverTapAPIWeakReference;
        private final JSONObject jsonObject;
        private boolean videoSupport = haveVideoPlayerSupport;

        NotificationPrepareRunnable(CleverTapAPI cleverTapAPI2, JSONObject jsonObject) {
            this.cleverTapAPIWeakReference = new WeakReference<CleverTapAPI>(cleverTapAPI2);
            this.jsonObject = jsonObject;
        }

        @Override
        public void run() {
            CTInAppNotification inAppNotification = new CTInAppNotification().initWithJSON(this.jsonObject, this.videoSupport);
            if (inAppNotification.getError() != null) {
                CleverTapAPI.this.getConfigLogger().debug(CleverTapAPI.this.getAccountId(), "Unable to parse inapp notification " + inAppNotification.getError());
                return;
            }
            inAppNotification.listener = (CTInAppNotification.CTInAppNotificationListener)this.cleverTapAPIWeakReference.get();
            inAppNotification.prepareForDisplay();
        }
    }

    public static interface DevicePushTokenRefreshListener {
        public void devicePushTokenDidRefresh(String var1, PushType var2);
    }

    public static enum LogLevel {
        OFF(-1),
        INFO(0),
        DEBUG(2);

        private final int value;

        private LogLevel(int newValue) {
            this.value = newValue;
        }

        public int intValue() {
            return this.value;
        }
    }
}

