/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.util.Log;
import com.clevertap.android.sdk.CleverTapAPI;

final class Logger {
    private int debugLevel;

    Logger(int level) {
        this.debugLevel = level;
    }

    private int getDebugLevel() {
        return this.debugLevel;
    }

    private static int getStaticDebugLevel() {
        return CleverTapAPI.getDebugLevel();
    }

    static void d(String message) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.d((String)"CleverTap", (String)message);
        }
    }

    static void d(String suffix, String message) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.d((String)("CleverTap:" + suffix), (String)message);
        }
    }

    static void d(String suffix, String message, Throwable t) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.d((String)("CleverTap:" + suffix), (String)message, (Throwable)t);
        }
    }

    static void d(String message, Throwable t) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.d((String)"CleverTap", (String)message, (Throwable)t);
        }
    }

    void debug(String message) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.d((String)"CleverTap", (String)message);
        }
    }

    void debug(String suffix, String message) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.d((String)("CleverTap:" + suffix), (String)message);
        }
    }

    void debug(String suffix, String message, Throwable t) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.d((String)("CleverTap:" + suffix), (String)message, (Throwable)t);
        }
    }

    void debug(String message, Throwable t) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.d((String)"CleverTap", (String)message, (Throwable)t);
        }
    }

    static void v(String message) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.DEBUG.intValue()) {
            Log.v((String)"CleverTap", (String)message);
        }
    }

    static void v(String suffix, String message) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.DEBUG.intValue()) {
            Log.v((String)("CleverTap:" + suffix), (String)message);
        }
    }

    static void v(String suffix, String message, Throwable t) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.DEBUG.intValue()) {
            Log.v((String)("CleverTap:" + suffix), (String)message, (Throwable)t);
        }
    }

    static void v(String message, Throwable t) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.DEBUG.intValue()) {
            Log.v((String)"CleverTap", (String)message, (Throwable)t);
        }
    }

    void verbose(String message) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.DEBUG.intValue()) {
            Log.v((String)"CleverTap", (String)message);
        }
    }

    void verbose(String suffix, String message) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.DEBUG.intValue()) {
            Log.v((String)("CleverTap:" + suffix), (String)message);
        }
    }

    void verbose(String suffix, String message, Throwable t) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.DEBUG.intValue()) {
            Log.v((String)("CleverTap:" + suffix), (String)message, (Throwable)t);
        }
    }

    void verbose(String message, Throwable t) {
        if (Logger.getStaticDebugLevel() > CleverTapAPI.LogLevel.DEBUG.intValue()) {
            Log.v((String)"CleverTap", (String)message, (Throwable)t);
        }
    }

    static void i(String message) {
        if (Logger.getStaticDebugLevel() >= CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.i((String)"CleverTap", (String)message);
        }
    }

    static void i(String suffix, String message) {
        if (Logger.getStaticDebugLevel() >= CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.i((String)("CleverTap:" + suffix), (String)message);
        }
    }

    static void i(String suffix, String message, Throwable t) {
        if (Logger.getStaticDebugLevel() >= CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.i((String)("CleverTap:" + suffix), (String)message, (Throwable)t);
        }
    }

    static void i(String message, Throwable t) {
        if (Logger.getStaticDebugLevel() >= CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.i((String)"CleverTap", (String)message, (Throwable)t);
        }
    }

    void info(String message) {
        if (this.getDebugLevel() >= CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.i((String)"CleverTap", (String)message);
        }
    }

    void info(String suffix, String message) {
        if (this.getDebugLevel() >= CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.i((String)("CleverTap:" + suffix), (String)message);
        }
    }

    void info(String suffix, String message, Throwable t) {
        if (this.getDebugLevel() >= CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.i((String)("CleverTap:" + suffix), (String)message, (Throwable)t);
        }
    }

    void info(String message, Throwable t) {
        if (this.getDebugLevel() >= CleverTapAPI.LogLevel.INFO.intValue()) {
            Log.i((String)"CleverTap", (String)message, (Throwable)t);
        }
    }
}

