/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.clevertap.android.sdk.CTCarouselMessageViewHolder;
import com.clevertap.android.sdk.CTIconMessageViewHolder;
import com.clevertap.android.sdk.CTInboxBaseMessageViewHolder;
import com.clevertap.android.sdk.CTInboxListViewFragment;
import com.clevertap.android.sdk.CTInboxMessage;
import com.clevertap.android.sdk.CTSimpleMessageViewHolder;
import com.clevertap.android.sdk.R;
import java.util.ArrayList;

class CTInboxMessageAdapter
extends RecyclerView.Adapter {
    private ArrayList<CTInboxMessage> inboxMessages;
    private CTInboxListViewFragment fragment;
    private static final int SIMPLE = 0;
    private static final int ICON = 1;
    private static final int CAROUSEL = 2;
    private static final int IMAGE_CAROUSEL = 3;

    CTInboxMessageAdapter(ArrayList<CTInboxMessage> inboxMessages, CTInboxListViewFragment fragment) {
        this.inboxMessages = inboxMessages;
        this.fragment = fragment;
    }

    @NonNull
    public CTInboxBaseMessageViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        switch (viewType) {
            case 0: {
                View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.inbox_simple_message_layout, viewGroup, false);
                return new CTSimpleMessageViewHolder(view);
            }
            case 1: {
                View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.inbox_icon_message_layout, viewGroup, false);
                return new CTIconMessageViewHolder(view);
            }
            case 2: 
            case 3: {
                View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.inbox_carousel_layout, viewGroup, false);
                return new CTCarouselMessageViewHolder(view);
            }
        }
        return null;
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int i) {
        CTInboxMessage inboxMessage = this.inboxMessages.get(i);
        CTInboxBaseMessageViewHolder _viewHolder = (CTInboxBaseMessageViewHolder)viewHolder;
        _viewHolder.configureWithMessage(inboxMessage, this.fragment, i);
    }

    public int getItemCount() {
        return this.inboxMessages.size();
    }

    public int getItemViewType(int position) {
        switch (this.inboxMessages.get(position).getType()) {
            case SimpleMessage: {
                return 0;
            }
            case IconMessage: {
                return 1;
            }
            case CarouselMessage: {
                return 2;
            }
            case CarouselImageMessage: {
                return 3;
            }
        }
        return -1;
    }
}

