/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.design.widget.TabLayout;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.clevertap.android.sdk.CTInboxListViewFragment;
import com.clevertap.android.sdk.CTInboxMessage;
import com.clevertap.android.sdk.CTInboxStyleConfig;
import com.clevertap.android.sdk.CTInboxTabAdapter;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.R;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class CTInboxActivity
extends FragmentActivity
implements CTInboxListViewFragment.InboxListener {
    CTInboxTabAdapter inboxTabAdapter;
    TabLayout tabLayout;
    ViewPager viewPager;
    CTInboxStyleConfig styleConfig;
    static int orientation;
    private CleverTapInstanceConfig config;
    private WeakReference<InboxActivityListener> listenerWeakReference;

    private String getFragmentTag() {
        return this.config.getAccountId() + ":CT_INBOX_LIST_VIEW_FRAGMENT";
    }

    void setListener(InboxActivityListener listener) {
        this.listenerWeakReference = new WeakReference<InboxActivityListener>(listener);
    }

    InboxActivityListener getListener() {
        InboxActivityListener listener = null;
        try {
            listener = (InboxActivityListener)this.listenerWeakReference.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (listener == null) {
            this.config.getLogger().verbose(this.config.getAccountId(), "InboxActivityListener is null for notification inbox ");
        }
        return listener;
    }

    public void onCreate(Bundle savedInstanceState) {
        CleverTapAPI cleverTapAPI;
        super.onCreate(savedInstanceState);
        try {
            Bundle extras = this.getIntent().getExtras();
            if (extras == null) {
                throw new IllegalArgumentException();
            }
            this.styleConfig = (CTInboxStyleConfig)extras.getParcelable("styleConfig");
            this.config = (CleverTapInstanceConfig)extras.getParcelable("config");
            cleverTapAPI = CleverTapAPI.instanceWithConfig(this.getApplicationContext(), this.config);
            if (cleverTapAPI != null) {
                this.setListener(cleverTapAPI);
            }
            orientation = this.getResources().getConfiguration().orientation;
        }
        catch (Throwable t) {
            Logger.v("Cannot find a valid notification inbox bundle to show!", t);
            return;
        }
        this.setContentView(R.layout.inbox_activity);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        toolbar.setTitle((CharSequence)this.styleConfig.getNavBarTitle());
        toolbar.setTitleTextColor(Color.parseColor((String)this.styleConfig.getNavBarTitleColor()));
        toolbar.setBackgroundColor(Color.parseColor((String)this.styleConfig.getNavBarColor()));
        Drawable drawable2 = this.getResources().getDrawable(R.drawable.ic_arrow_back_white_24dp);
        drawable2.setColorFilter(Color.parseColor((String)this.styleConfig.getBackButtonColor()), PorterDuff.Mode.SRC_IN);
        toolbar.setNavigationIcon(drawable2);
        toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CTInboxActivity.this.finish();
            }
        });
        LinearLayout linearLayout = (LinearLayout)this.findViewById(R.id.inbox_linear_layout);
        linearLayout.setBackgroundColor(Color.parseColor((String)this.styleConfig.getInboxBackgroundColor()));
        this.tabLayout = (TabLayout)linearLayout.findViewById(R.id.tab_layout);
        this.viewPager = (ViewPager)linearLayout.findViewById(R.id.view_pager);
        TextView noMessageView = (TextView)this.findViewById(R.id.no_message_view);
        Bundle bundle = new Bundle();
        bundle.putParcelable("config", (Parcelable)this.config);
        bundle.putParcelable("styleConfig", (Parcelable)this.styleConfig);
        if (!this.styleConfig.isUsingTabs()) {
            this.viewPager.setVisibility(8);
            this.tabLayout.setVisibility(8);
            FrameLayout listViewFragmentLayout = (FrameLayout)this.findViewById(R.id.list_view_fragment);
            listViewFragmentLayout.setVisibility(0);
            if (cleverTapAPI != null && cleverTapAPI.getInboxMessageCount() == 0) {
                noMessageView.setBackgroundColor(Color.parseColor((String)this.styleConfig.getInboxBackgroundColor()));
                noMessageView.setVisibility(0);
            } else {
                boolean fragmentExists = false;
                noMessageView.setVisibility(8);
                for (Fragment fragment : this.getSupportFragmentManager().getFragments()) {
                    if (fragment.getTag() == null || fragment.getTag().equalsIgnoreCase(this.getFragmentTag())) continue;
                    fragmentExists = true;
                }
                if (!fragmentExists) {
                    CTInboxListViewFragment listView = new CTInboxListViewFragment();
                    listView.setArguments(bundle);
                    this.getSupportFragmentManager().beginTransaction().add(R.id.list_view_fragment, (Fragment)listView, this.getFragmentTag()).commit();
                }
            }
        } else {
            this.viewPager.setVisibility(0);
            ArrayList<String> tabs = this.styleConfig.getTabs();
            this.inboxTabAdapter = new CTInboxTabAdapter(this.getSupportFragmentManager(), tabs.size() + 1);
            this.tabLayout.setVisibility(0);
            this.tabLayout.setTabGravity(0);
            this.tabLayout.setTabMode(1);
            this.tabLayout.setSelectedTabIndicatorColor(Color.parseColor((String)this.styleConfig.getSelectedTabIndicatorColor()));
            this.tabLayout.setTabTextColors(Color.parseColor((String)this.styleConfig.getUnselectedTabColor()), Color.parseColor((String)this.styleConfig.getSelectedTabColor()));
            this.tabLayout.setBackgroundColor(Color.parseColor((String)this.styleConfig.getTabBackgroundColor()));
            Bundle _allBundle = (Bundle)bundle.clone();
            _allBundle.putInt("position", 0);
            CTInboxListViewFragment all = new CTInboxListViewFragment();
            all.setArguments(_allBundle);
            this.inboxTabAdapter.addFragment(all, "ALL", 0);
            for (int i = 0; i < tabs.size(); ++i) {
                String filter = tabs.get(i);
                int pos = i + 1;
                Bundle _bundle = (Bundle)bundle.clone();
                _bundle.putInt("position", pos);
                _bundle.putString("filter", filter);
                CTInboxListViewFragment frag = new CTInboxListViewFragment();
                frag.setArguments(_bundle);
                this.inboxTabAdapter.addFragment(frag, filter, pos);
                this.viewPager.setOffscreenPageLimit(pos);
            }
            this.viewPager.setAdapter((PagerAdapter)this.inboxTabAdapter);
            this.inboxTabAdapter.notifyDataSetChanged();
            this.viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new TabLayout.TabLayoutOnPageChangeListener(this.tabLayout));
            this.tabLayout.addOnTabSelectedListener((TabLayout.BaseOnTabSelectedListener)new TabLayout.OnTabSelectedListener(){

                public void onTabSelected(TabLayout.Tab tab) {
                    CTInboxListViewFragment fragment = (CTInboxListViewFragment)CTInboxActivity.this.inboxTabAdapter.getItem(tab.getPosition());
                    if (fragment != null && fragment.getMediaRecyclerView() != null) {
                        fragment.getMediaRecyclerView().onRestartPlayer();
                    }
                }

                public void onTabUnselected(TabLayout.Tab tab) {
                    CTInboxListViewFragment fragment = (CTInboxListViewFragment)CTInboxActivity.this.inboxTabAdapter.getItem(tab.getPosition());
                    if (fragment != null && fragment.getMediaRecyclerView() != null) {
                        fragment.getMediaRecyclerView().onPausePlayer();
                    }
                }

                public void onTabReselected(TabLayout.Tab tab) {
                }
            });
            this.tabLayout.setupWithViewPager(this.viewPager);
        }
    }

    @Override
    public void messageDidShow(Context baseContext, CTInboxMessage inboxMessage, Bundle data) {
        this.didShow(data, inboxMessage);
    }

    @Override
    public void messageDidClick(Context baseContext, CTInboxMessage inboxMessage, Bundle data) {
        this.didClick(data, inboxMessage);
    }

    void didClick(Bundle data, CTInboxMessage inboxMessage) {
        InboxActivityListener listener = this.getListener();
        if (listener != null) {
            listener.messageDidClick(this, inboxMessage, data);
        }
    }

    void didShow(Bundle data, CTInboxMessage inboxMessage) {
        InboxActivityListener listener = this.getListener();
        if (listener != null) {
            listener.messageDidShow(this, inboxMessage, data);
        }
    }

    protected void onDestroy() {
        if (this.styleConfig.isUsingTabs()) {
            List allFragments = this.getSupportFragmentManager().getFragments();
            for (Fragment fragment : allFragments) {
                if (!(fragment instanceof CTInboxListViewFragment)) continue;
                Logger.d("Removing fragment - " + fragment.toString());
                this.getSupportFragmentManager().getFragments().remove(fragment);
            }
        }
        super.onDestroy();
    }

    static interface InboxActivityListener {
        public void messageDidShow(CTInboxActivity var1, CTInboxMessage var2, Bundle var3);

        public void messageDidClick(CTInboxActivity var1, CTInboxMessage var2, Bundle var3);
    }
}

