/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.design.widget.TabLayout;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.clevertap.android.sdk.CTInboxListViewFragment;
import com.clevertap.android.sdk.CTInboxMessage;
import com.clevertap.android.sdk.CTInboxStyleConfig;
import com.clevertap.android.sdk.CTInboxTabAdapter;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.R;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class CTInboxActivity
extends FragmentActivity
implements CTInboxListViewFragment.InboxListener {
    private CleverTapInstanceConfig config;
    private WeakReference<InboxActivityListener> listenerWeakReference;

    private String getFragmentTag() {
        return this.config.getAccountId() + ":CT_INBOX_LIST_VIEW_FRAGMENT";
    }

    void setListener(InboxActivityListener listener) {
        this.listenerWeakReference = new WeakReference<InboxActivityListener>(listener);
    }

    InboxActivityListener getListener() {
        InboxActivityListener listener = null;
        try {
            listener = (InboxActivityListener)this.listenerWeakReference.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (listener == null) {
            this.config.getLogger().verbose(this.config.getAccountId(), "InboxActivityListener is null for notification inbox ");
        }
        return listener;
    }

    public void onCreate(Bundle savedInstanceState) {
        CleverTapAPI cleverTapAPI;
        CTInboxStyleConfig styleConfig;
        super.onCreate(savedInstanceState);
        try {
            Bundle extras = this.getIntent().getExtras();
            if (extras == null) {
                throw new IllegalArgumentException();
            }
            styleConfig = (CTInboxStyleConfig)extras.getParcelable("styleConfig");
            this.config = (CleverTapInstanceConfig)extras.getParcelable("config");
            cleverTapAPI = CleverTapAPI.instanceWithConfig(this.getApplicationContext(), this.config);
            if (cleverTapAPI != null) {
                this.setListener(cleverTapAPI);
            }
        }
        catch (Throwable t) {
            Logger.v("Cannot find a valid notification inbox bundle to show!", t);
            return;
        }
        this.setContentView(R.layout.inbox_activity);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        toolbar.setTitle((CharSequence)styleConfig.getNavBarTitle());
        toolbar.setTitleTextColor(Color.parseColor((String)styleConfig.getNavBarTitleColor()));
        toolbar.setBackgroundColor(Color.parseColor((String)styleConfig.getNavBarColor()));
        Drawable drawable2 = this.getResources().getDrawable(R.drawable.ic_arrow_back_white_24dp);
        drawable2.setColorFilter(Color.parseColor((String)styleConfig.getBackButtonColor()), PorterDuff.Mode.SRC_IN);
        toolbar.setNavigationIcon(drawable2);
        toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CTInboxActivity.this.finish();
            }
        });
        LinearLayout linearLayout = (LinearLayout)this.findViewById(R.id.inbox_linear_layout);
        linearLayout.setBackgroundColor(Color.parseColor((String)styleConfig.getInboxBackgroundColor()));
        TabLayout tabLayout = (TabLayout)linearLayout.findViewById(R.id.tab_layout);
        ViewPager viewPager = (ViewPager)linearLayout.findViewById(R.id.view_pager);
        TextView noMessageView = (TextView)this.findViewById(R.id.no_message_view);
        Bundle bundle = new Bundle();
        bundle.putParcelable("config", (Parcelable)this.config);
        bundle.putParcelable("styleConfig", (Parcelable)styleConfig);
        if (!styleConfig.isUsingTabs()) {
            viewPager.setVisibility(8);
            tabLayout.setVisibility(8);
            FrameLayout listViewFragmentLayout = (FrameLayout)this.findViewById(R.id.list_view_fragment);
            listViewFragmentLayout.setVisibility(0);
            if (cleverTapAPI != null && cleverTapAPI.getInboxMessageCount() == 0) {
                noMessageView.setBackgroundColor(Color.parseColor((String)styleConfig.getInboxBackgroundColor()));
                noMessageView.setVisibility(0);
            } else {
                noMessageView.setVisibility(8);
                CTInboxListViewFragment listView = new CTInboxListViewFragment();
                listView.setArguments(bundle);
                this.getSupportFragmentManager().beginTransaction().add(R.id.list_view_fragment, (Fragment)listView, this.getFragmentTag()).commit();
            }
        } else {
            viewPager.setVisibility(0);
            final CTInboxTabAdapter inboxTabAdapter = new CTInboxTabAdapter(this.getSupportFragmentManager());
            tabLayout.setVisibility(0);
            tabLayout.setSelectedTabIndicatorColor(Color.parseColor((String)styleConfig.getSelectedTabIndicatorColor()));
            tabLayout.setTabTextColors(Color.parseColor((String)styleConfig.getUnselectedTabColor()), Color.parseColor((String)styleConfig.getSelectedTabColor()));
            tabLayout.setBackgroundColor(Color.parseColor((String)styleConfig.getTabBackgroundColor()));
            tabLayout.addTab(tabLayout.newTab().setText((CharSequence)"ALL"));
            Bundle _allBundle = (Bundle)bundle.clone();
            _allBundle.putInt("position", 0);
            CTInboxListViewFragment all = new CTInboxListViewFragment();
            all.setArguments(_allBundle);
            inboxTabAdapter.addFragment(all, "ALL");
            ArrayList<String> tabs = styleConfig.getTabs();
            for (int i = 0; i < tabs.size(); ++i) {
                String filter = tabs.get(i);
                int pos = i + 1;
                Bundle _bundle = (Bundle)bundle.clone();
                _bundle.putInt("position", pos);
                _bundle.putString("filter", filter);
                CTInboxListViewFragment frag = new CTInboxListViewFragment();
                frag.setArguments(_bundle);
                inboxTabAdapter.addFragment(frag, filter);
                viewPager.setOffscreenPageLimit(pos);
            }
            viewPager.setAdapter((PagerAdapter)inboxTabAdapter);
            viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new TabLayout.TabLayoutOnPageChangeListener(tabLayout));
            tabLayout.addOnTabSelectedListener((TabLayout.BaseOnTabSelectedListener)new TabLayout.OnTabSelectedListener(){

                public void onTabSelected(TabLayout.Tab tab) {
                    CTInboxListViewFragment fragment = (CTInboxListViewFragment)inboxTabAdapter.getItem(tab.getPosition());
                    if (fragment != null && fragment.mediaRecyclerView != null) {
                        fragment.mediaRecyclerView.playVideo();
                    }
                }

                public void onTabUnselected(TabLayout.Tab tab) {
                    CTInboxListViewFragment fragment = (CTInboxListViewFragment)inboxTabAdapter.getItem(tab.getPosition());
                    if (fragment != null && fragment.mediaRecyclerView != null) {
                        fragment.mediaRecyclerView.stop();
                    }
                }

                public void onTabReselected(TabLayout.Tab tab) {
                }
            });
            tabLayout.setupWithViewPager(viewPager);
        }
    }

    @Override
    public void messageDidShow(Context baseContext, CTInboxMessage inboxMessage, Bundle data) {
        this.didShow(data, inboxMessage);
    }

    @Override
    public void messageDidClick(Context baseContext, CTInboxMessage inboxMessage, Bundle data) {
        this.didClick(data, inboxMessage);
    }

    void didClick(Bundle data, CTInboxMessage inboxMessage) {
        InboxActivityListener listener = this.getListener();
        if (listener != null) {
            listener.messageDidClick(this, inboxMessage, data);
        }
    }

    void didShow(Bundle data, CTInboxMessage inboxMessage) {
        InboxActivityListener listener = this.getListener();
        if (listener != null) {
            listener.messageDidShow(this, inboxMessage, data);
        }
    }

    static interface InboxActivityListener {
        public void messageDidShow(CTInboxActivity var1, CTInboxMessage var2, Bundle var3);

        public void messageDidClick(CTInboxActivity var1, CTInboxMessage var2, Bundle var3);
    }
}

