/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.telephony.TelephonyManager;
import com.clevertap.android.sdk.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

final class Utils {
    Utils() {
    }

    static long getMemoryConsumption() {
        long free = Runtime.getRuntime().freeMemory();
        long total = Runtime.getRuntime().totalMemory();
        return total - free;
    }

    static HashMap<String, Object> convertBundleObjectToHashMap(Bundle b) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String s : b.keySet()) {
            Object o = b.get(s);
            if (o instanceof Bundle) {
                map.putAll(Utils.convertBundleObjectToHashMap((Bundle)o));
                continue;
            }
            map.put(s, b.get(s));
        }
        return map;
    }

    static HashMap<String, Object> convertJSONObjectToHashMap(JSONObject b) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keys = b.keys();
        while (keys.hasNext()) {
            try {
                String s = (String)keys.next();
                Object o = b.get(s);
                if (o instanceof JSONObject) {
                    map.putAll(Utils.convertJSONObjectToHashMap((JSONObject)o));
                    continue;
                }
                map.put(s, b.get(s));
            }
            catch (Throwable throwable) {}
        }
        return map;
    }

    static String getCurrentNetworkType(Context context) {
        try {
            ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connManager == null) {
                return "Unavailable";
            }
            NetworkInfo mWifi = connManager.getNetworkInfo(1);
            if (mWifi.isConnected()) {
                return "WiFi";
            }
            TelephonyManager teleMan = (TelephonyManager)context.getSystemService("phone");
            if (teleMan == null) {
                return "Unavailable";
            }
            int networkType = teleMan.getNetworkType();
            switch (networkType) {
                case 4: {
                    return "CDMA";
                }
                case 2: {
                    return "EDGE";
                }
                case 1: {
                    return "GPRS";
                }
                case 3: 
                case 8: 
                case 9: 
                case 10: 
                case 15: {
                    return "3G";
                }
                case 13: {
                    return "LTE";
                }
            }
            return "Unknown";
        }
        catch (Throwable t) {
            return "Unavailable";
        }
    }

    static Bitmap getNotificationBitmap(String icoPath, boolean fallbackToAppIcon, Context context) throws NullPointerException {
        Bitmap ic;
        if (icoPath == null || icoPath.equals("")) {
            return fallbackToAppIcon ? Utils.getAppIcon(context) : null;
        }
        if (!icoPath.startsWith("http")) {
            icoPath = "http://static.wizrocket.com/android/ico//" + icoPath;
        }
        return (ic = Utils.getBitmapFromURL(icoPath)) != null ? ic : (fallbackToAppIcon ? Utils.getAppIcon(context) : null);
    }

    private static Bitmap getAppIcon(Context context) throws NullPointerException {
        try {
            Drawable logo = context.getPackageManager().getApplicationLogo(context.getApplicationInfo());
            if (logo == null) {
                throw new Exception("Logo is null");
            }
            return Utils.drawableToBitmap(logo);
        }
        catch (Exception e) {
            return Utils.drawableToBitmap(context.getPackageManager().getApplicationIcon(context.getApplicationInfo()));
        }
    }

    static Bitmap drawableToBitmap(Drawable drawable2) throws NullPointerException {
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Bitmap getBitmapFromURL(String srcUrl) {
        srcUrl = srcUrl.replace("///", "/");
        srcUrl = srcUrl.replace("//", "/");
        srcUrl = srcUrl.replace("http:/", "http://");
        srcUrl = srcUrl.replace("https:/", "https://");
        HttpURLConnection connection = null;
        try {
            URL url = new URL(srcUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.connect();
            InputStream input = connection.getInputStream();
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)input);
            return bitmap;
        }
        catch (IOException e) {
            Logger.v("Couldn't download the notification icon. URL was: " + srcUrl);
            Bitmap bitmap = null;
            return bitmap;
        }
        finally {
            try {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (Throwable t) {
                Logger.v("Couldn't close connection!", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] getByteArrayFromImageURL(String srcUrl) {
        srcUrl = srcUrl.replace("///", "/");
        srcUrl = srcUrl.replace("//", "/");
        srcUrl = srcUrl.replace("http:/", "http://");
        srcUrl = srcUrl.replace("https:/", "https://");
        HttpURLConnection connection = null;
        try {
            int bytesRead;
            URL url = new URL(srcUrl);
            connection = (HttpsURLConnection)url.openConnection();
            InputStream is = connection.getInputStream();
            byte[] buffer = new byte[8192];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((bytesRead = is.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            Logger.v("Error processing image bytes from url: " + srcUrl);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (Throwable t) {
                Logger.v("Couldn't close connection!", t);
            }
        }
    }
}

