/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.EventDetail;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.SessionManager;
import com.clevertap.android.sdk.UTMDetail;
import org.json.JSONObject;

public final class SessionHandler {
    private final Context context;
    private int lastVisitTime;
    private static String source = null;
    private static String medium = null;
    private static String campaign = null;
    private static JSONObject wzrkParams = null;

    static synchronized void setSource(String source) {
        if (SessionHandler.source == null) {
            SessionHandler.source = source;
        }
    }

    static synchronized void setMedium(String medium) {
        if (SessionHandler.medium == null) {
            SessionHandler.medium = medium;
        }
    }

    static synchronized void setCampaign(String campaign) {
        if (SessionHandler.campaign == null) {
            SessionHandler.campaign = campaign;
        }
    }

    static synchronized void setWzrkParams(JSONObject wzrkParams) {
        if (SessionHandler.wzrkParams == null) {
            SessionHandler.wzrkParams = wzrkParams;
        }
    }

    static synchronized void clearSource() {
        source = null;
    }

    static synchronized void clearMedium() {
        medium = null;
    }

    static synchronized void clearCampaign() {
        campaign = null;
    }

    static synchronized void clearWzrkParams() {
        wzrkParams = null;
    }

    static synchronized String getSource() {
        return source;
    }

    static synchronized String getMedium() {
        return medium;
    }

    static synchronized String getCampaign() {
        return campaign;
    }

    static synchronized JSONObject getWzrkParams() {
        return wzrkParams;
    }

    SessionHandler(final Context context) {
        this.context = context;
        CleverTapAPI.postAsyncSafely("SessionHandler#setLastVisitTime", new Runnable(){

            @Override
            public void run() {
                SessionHandler.this.setLastVisitTime(context);
            }
        });
    }

    private void setLastVisitTime(Context context) {
        EventDetail ed = LocalDataStore.getEventDetail(context, "App Launched");
        this.lastVisitTime = ed == null ? -1 : ed.getLastTime();
    }

    public int getTotalVisits() {
        EventDetail ed = LocalDataStore.getEventDetail(this.context, "App Launched");
        if (ed != null) {
            return ed.getCount();
        }
        return 0;
    }

    public int getScreenCount() {
        return CleverTapAPI.activityCount;
    }

    public int getTimeElapsed() {
        int currentSession = SessionManager.getCurrentSession();
        if (currentSession == 0) {
            return -1;
        }
        int now = (int)(System.currentTimeMillis() / 1000L);
        return now - currentSession;
    }

    public int getPreviousVisitTime() {
        return this.lastVisitTime;
    }

    public UTMDetail getUTMDetails() {
        UTMDetail ud = new UTMDetail();
        ud.setSource(source);
        ud.setMedium(medium);
        ud.setCampaign(campaign);
        return ud;
    }
}

