/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.DataHandler;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.PushType;
import com.clevertap.android.sdk.StorageHelper;
import com.google.firebase.iid.FirebaseInstanceId;

public class FcmManager {
    private static Context context = null;
    private static final Object LOCK = new Object();
    private static final String FCM_PROPERTY_REG_ID = "fcm_token";
    private static boolean havePushedDeviceToken = false;

    static void initializeWithContext(Context context) {
        FcmManager.context = context;
        FcmManager.doFCMRefresh();
    }

    static void onTokenRefresh() {
        FcmManager.doFCMRefresh();
    }

    static String getDeviceToken() {
        return FcmManager.getCachedFCMToken();
    }

    private static void doFCMRefresh() {
        CleverTapAPI.postAsyncSafely("FcmManager#doFCMRefresh", new Runnable(){

            @Override
            public void run() {
                try {
                    if (!FcmManager.isGooglePlayServicesAvailable()) {
                        Logger.d("FcmManager: Play Services unavailable, unable to request FCM token");
                        return;
                    }
                    String freshToken = FcmManager.FCMGetFreshToken();
                    if (freshToken == null) {
                        return;
                    }
                    FcmManager.cacheFCMToken(freshToken);
                    FcmManager.pushDeviceToken(freshToken, true, true);
                    try {
                        CleverTapAPI.getInstance(context).deviceTokenDidRefresh(freshToken, PushType.FCM);
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable t) {
                    Logger.v("FcmManager: FCM Token error", t);
                }
            }
        });
    }

    private static boolean isGooglePlayServicesAvailable() {
        return DeviceInfo.isGooglePlayServicesAvailable();
    }

    private static String FCMGetFreshToken() {
        Logger.v("FcmManager: Requesting a FCM token");
        String token = null;
        try {
            token = FirebaseInstanceId.getInstance().getToken();
            Logger.i("FCM token : " + token);
        }
        catch (Throwable t) {
            Logger.v("FcmManager: Error requesting FCM token", t);
        }
        return token;
    }

    private static SharedPreferences getPreferences() {
        try {
            return context == null ? null : StorageHelper.getPreferences(context);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static String getCachedFCMToken() {
        SharedPreferences prefs = FcmManager.getPreferences();
        return prefs == null ? null : prefs.getString(FCM_PROPERTY_REG_ID, null);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private static void cacheFCMToken(String token) {
        try {
            if (token == null || FcmManager.alreadyHaveFCMToken(token)) {
                return;
            }
            SharedPreferences prefs = FcmManager.getPreferences();
            if (prefs == null) {
                return;
            }
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString(FCM_PROPERTY_REG_ID, token);
            StorageHelper.persist(editor);
        }
        catch (Throwable t) {
            Logger.v("FcmManager: Unable to cache FCM Token", t);
        }
    }

    private static boolean alreadyHaveFCMToken(String newToken) {
        if (newToken == null) {
            return false;
        }
        String cachedToken = FcmManager.getCachedFCMToken();
        return cachedToken != null && cachedToken.equals(newToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void pushDeviceToken(String token, boolean register, boolean forceUpdate) {
        Object object = LOCK;
        synchronized (object) {
            if (havePushedDeviceToken && !forceUpdate) {
                Logger.v("FcmManager: skipping device token push - already sent.");
                return;
            }
            try {
                String string = token = token != null ? token : FcmManager.getCachedFCMToken();
                if (token == null) {
                    return;
                }
                DataHandler.pushDeviceToken(context, token, register, PushType.FCM);
                havePushedDeviceToken = true;
            }
            catch (Throwable t) {
                Logger.v("FcmManager: pushing device token failed", t);
            }
        }
    }
}

