/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.DataHandler;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.PushType;
import com.clevertap.android.sdk.StorageHelper;
import com.google.android.gms.iid.InstanceID;

public final class GcmManager {
    private static Context context = null;
    private static final Object LOCK = new Object();
    private static final String GCM_PROPERTY_REG_ID = "registration_id";
    private static boolean havePushedDeviceToken = false;

    static void initializeWithContext(Context context) {
        GcmManager.context = context;
        GcmManager.doGCMRefresh();
    }

    static void onTokenRefresh() {
        GcmManager.doGCMRefresh();
    }

    static String getDeviceToken() {
        return GcmManager.getCachedGCMToken();
    }

    private static void doGCMRefresh() {
        CleverTapAPI.postAsyncSafely("GcmManager#doGCMRefresh", new Runnable(){

            @Override
            public void run() {
                try {
                    String senderID = GcmManager.getGCMSenderID();
                    if (senderID == null) {
                        Logger.d("GcmManager: GCM Sender ID unknown, unable to request GCM token");
                        return;
                    }
                    if (!GcmManager.isGooglePlayServicesAvailable()) {
                        Logger.d("GcmManager: Play Services unavailable, unable to request GCM token");
                        return;
                    }
                    String freshToken = GcmManager.GCMGetFreshToken(senderID);
                    if (freshToken == null) {
                        return;
                    }
                    GcmManager.cacheGCMToken(freshToken);
                    GcmManager.pushDeviceToken(freshToken, true, true);
                    try {
                        CleverTapAPI.getInstance(context).deviceTokenDidRefresh(freshToken, PushType.GCM);
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable t) {
                    Logger.v("GcmManager: GCM Token error", t);
                }
            }
        });
    }

    private static boolean isGooglePlayServicesAvailable() {
        return DeviceInfo.isGooglePlayServicesAvailable();
    }

    private static String getGCMSenderID() {
        return DeviceInfo.getGCMSenderID();
    }

    private static String GCMGetFreshToken(String senderID) {
        Logger.v("GcmManager: Requesting a GCM token for Sender ID - " + senderID);
        String token = null;
        try {
            token = InstanceID.getInstance((Context)context).getToken(senderID, "GCM", null);
            Logger.i("GCM token : " + token);
        }
        catch (Throwable t) {
            Logger.v("GcmManager: Error requesting GCM token", t);
        }
        return token;
    }

    private static SharedPreferences getPreferences() {
        try {
            return context == null ? null : StorageHelper.getPreferences(context);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static String getCachedGCMToken() {
        SharedPreferences prefs = GcmManager.getPreferences();
        return prefs == null ? null : prefs.getString(GCM_PROPERTY_REG_ID, null);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private static void cacheGCMToken(String token) {
        try {
            if (token == null || GcmManager.alreadyHaveGCMToken(token)) {
                return;
            }
            SharedPreferences prefs = GcmManager.getPreferences();
            if (prefs == null) {
                return;
            }
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString(GCM_PROPERTY_REG_ID, token);
            StorageHelper.persist(editor);
        }
        catch (Throwable t) {
            Logger.v("GcmManager: Unable to cache GCM Token", t);
        }
    }

    private static boolean alreadyHaveGCMToken(String newToken) {
        if (newToken == null) {
            return false;
        }
        String cachedToken = GcmManager.getCachedGCMToken();
        return cachedToken != null && cachedToken.equals(newToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void pushDeviceToken(String token, boolean register, boolean forceUpdate) {
        Object object = LOCK;
        synchronized (object) {
            if (havePushedDeviceToken && !forceUpdate) {
                Logger.d("GcmManager: skipping device token push - already sent.");
                return;
            }
            try {
                String string = token = token != null ? token : GcmManager.getCachedGCMToken();
                if (token == null) {
                    return;
                }
                DataHandler.pushDeviceToken(context, token, register, PushType.GCM);
                havePushedDeviceToken = true;
            }
            catch (Throwable t) {
                Logger.v("GcmManager: pushing device token failed", t);
            }
        }
    }
}

