/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.exceptions.CleverTapException;

public final class ActivityLifecycleCallback {
    static boolean registered = false;

    @TargetApi(value=14)
    public static synchronized void register(Application application) {
        CleverTapAPI wr;
        if (application == null || Build.VERSION.SDK_INT < 14) {
            Logger.i("Application instance is null/system API is too old");
            return;
        }
        if (registered) {
            Logger.v("Lifecycle callbacks have already been registered");
            return;
        }
        try {
            wr = CleverTapAPI.getInstance(application.getApplicationContext());
        }
        catch (CleverTapException e) {
            return;
        }
        registered = true;
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle bundle) {
                CleverTapAPI.setAppForeground(true);
                try {
                    wr.event.pushNotificationEvent(activity.getIntent().getExtras());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    Intent intent = activity.getIntent();
                    Uri data = intent.getData();
                    wr.pushDeepLink(data);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
                try {
                    wr.activityResumed(activity);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            public void onActivityPaused(Activity activity) {
                try {
                    wr.activityPaused(activity);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            }

            public void onActivityDestroyed(Activity activity) {
            }
        });
        Logger.i("Activity Lifecycle Callback successfully registered");
    }
}

