package com.clevertap.android.sdk;

import android.util.Log;

/**
 * User: Jude Pereira
 * Date: 06/02/15
 * Time: 17:44
 */
final class Logger {
    /**
     * Logs to info if the debug level is the finest.
     */
    @Deprecated
    static void logFine(String message) {
        if (CleverTapAPI.getDebugLevel() == Constants.DEBUG_FINEST) {
            Log.i(Constants.CLEVERTAP_LOG_TAG, message);
        }
    }

    /**
     * Logs to info if the debug level is the finest + 1.
     */
    @Deprecated
    static void logExtraFine(String message) {
        if (CleverTapAPI.getDebugLevel() == Constants.DEBUG_FINEST + 1) {
            Log.i(Constants.CLEVERTAP_LOG_TAG, message);
        } else {
            logFine(message);
        }
    }

    /**
     * Logs to info if the debug level is the finest.
     */
    @Deprecated
    static void logFine(String message, Throwable t) {
        if (CleverTapAPI.getDebugLevel() == Constants.DEBUG_FINEST) {
            Log.e(Constants.CLEVERTAP_LOG_TAG, message, t);
        }
    }

    /**
     * Logs to info if the debug level is greater than 0.
     */
    @Deprecated
    static void log(String message) {
        if (CleverTapAPI.getDebugLevel() > 0) {
            Log.i(Constants.CLEVERTAP_LOG_TAG, message);
        }
    }

    /**
     * Logs to error if the debug level is greater than 0.
     */
    @Deprecated
    static void error(String message, Throwable t) {
        if (CleverTapAPI.getDebugLevel() > 0) {
            Log.e(Constants.CLEVERTAP_LOG_TAG, message, t);
        }
    }

    /**
     * Logs to error if the debug level is greater than 0.
     */
    @Deprecated
    static void error(String message) {
        if (CleverTapAPI.getDebugLevel() > 0) {
            Log.e(Constants.CLEVERTAP_LOG_TAG, message);
        }
    }


    //New Logging methods
    static void d(String message){
        if(CleverTapAPI.getDebugLevel() > CleverTapAPI.LogLevel.INFO.intValue()){
            Log.d(Constants.CLEVERTAP_LOG_TAG,message);
        }
    }

    static void d(String message, Throwable t){
        if(CleverTapAPI.getDebugLevel() > CleverTapAPI.LogLevel.INFO.intValue()){
            Log.d(Constants.CLEVERTAP_LOG_TAG,message,t);
        }
    }

    static void v(String message){
        if(CleverTapAPI.getDebugLevel() > CleverTapAPI.LogLevel.DEBUG.intValue()){
            Log.v(Constants.CLEVERTAP_LOG_TAG,message);
        }
    }

    static void v(String message, Throwable t){
        if(CleverTapAPI.getDebugLevel() > CleverTapAPI.LogLevel.DEBUG.intValue()){
            Log.v(Constants.CLEVERTAP_LOG_TAG,message,t);
        }
    }

    static void i(String message){
        if (CleverTapAPI.getDebugLevel() >= CleverTapAPI.LogLevel.INFO.intValue()){
            Log.i(Constants.CLEVERTAP_LOG_TAG,message);
        }
    }

    static void i(String message, Throwable t){
        if(CleverTapAPI.getDebugLevel() >= CleverTapAPI.LogLevel.INFO.intValue()){
            Log.i(Constants.CLEVERTAP_LOG_TAG,message,t);
        }
    }

}
