/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class InAppFCManager {
    private static final SimpleDateFormat ddMMyyyy = new SimpleDateFormat("ddMMyyyy", Locale.US);
    private static final String KEY_COUNTS_PER_INAPP = "counts_per_inapp";
    private static final String KEY_COUNTS_SHOWN_TODAY = "istc_inapp";
    private static final String KEY_MAX_PER_DAY = "istmcd_inapp";
    private static final String INAPP_ID_IN_PAYLOAD = "ti";
    private final ArrayList<String> mDismissedThisSession = new ArrayList();
    private final HashMap<String, Integer> mShownThisSession = new HashMap();
    private int mShownThisSessionCount = 0;
    private static InAppFCManager instance = null;
    private Context context;

    private InAppFCManager(Context context) {
        this.context = context;
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private static synchronized InAppFCManager getInstance(Context context) {
        String lastUpdated;
        String today;
        if (instance == null) {
            instance = new InAppFCManager(context);
        }
        if (!(today = ddMMyyyy.format(new Date())).equals(lastUpdated = StorageHelper.getString(context, "ict_date", "20140428"))) {
            StorageHelper.putString(context, "ict_date", today);
            StorageHelper.putInt(context, KEY_COUNTS_SHOWN_TODAY, 0);
            SharedPreferences prefs = StorageHelper.getPreferences(context, KEY_COUNTS_PER_INAPP);
            SharedPreferences.Editor editor = prefs.edit();
            Map all = prefs.getAll();
            for (String inapp : all.keySet()) {
                Object ov = all.get(inapp);
                if (!(ov instanceof String)) {
                    editor.remove(inapp);
                    continue;
                }
                String[] oldValues = ((String)ov).split(",");
                if (oldValues.length != 2) {
                    editor.remove(inapp);
                    continue;
                }
                try {
                    editor.putString(inapp, "0," + oldValues[1]);
                }
                catch (Throwable t) {
                    Logger.v("Failed to reset todayCount for inapp " + inapp, t);
                }
            }
            StorageHelper.persist(editor);
        }
        return instance;
    }

    private int[] getInAppCountsFromPersistentStore(String inappID) {
        SharedPreferences prefs = StorageHelper.getPreferences(this.context, KEY_COUNTS_PER_INAPP);
        String str = prefs.getString(inappID, null);
        if (str == null) {
            return new int[]{0, 0};
        }
        try {
            String[] parts = str.split(",");
            if (parts.length != 2) {
                return new int[]{0, 0};
            }
            return new int[]{Integer.parseInt(parts[0]), Integer.parseInt(parts[1])};
        }
        catch (Throwable t) {
            return new int[]{0, 0};
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private void incrementInAppCountsInPersistentStore(String inappID) {
        int[] current = this.getInAppCountsFromPersistentStore(inappID);
        current[0] = current[0] + 1;
        current[1] = current[1] + 1;
        SharedPreferences prefs = StorageHelper.getPreferences(this.context, KEY_COUNTS_PER_INAPP);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString(inappID, current[0] + "," + current[1]);
        StorageHelper.persist(editor);
    }

    private static String getInAppID(JSONObject inapp) {
        if (inapp.has(INAPP_ID_IN_PAYLOAD)) {
            try {
                return inapp.get(INAPP_ID_IN_PAYLOAD).toString();
            }
            catch (Throwable ignored) {
                return null;
            }
        }
        return null;
    }

    private boolean hasSessionCapacityMaxedOut(JSONObject inapp) {
        String id = InAppFCManager.getInAppID(inapp);
        if (id == null) {
            return false;
        }
        if (this.mDismissedThisSession.contains(id)) {
            return true;
        }
        try {
            int maxPerSession = inapp.getJSONObject("w").getInt("mdc");
            Integer c = this.mShownThisSession.get(id);
            if (c != null && c >= maxPerSession) {
                return true;
            }
        }
        catch (Throwable t) {
            return true;
        }
        int c = StorageHelper.getInt(this.context, "imc", 1);
        return this.mShownThisSessionCount >= c;
    }

    private boolean hasLifetimeCapacityMaxedOut(JSONObject inapp) {
        String id = InAppFCManager.getInAppID(inapp);
        if (id == null) {
            return false;
        }
        if (!inapp.has("tlc")) {
            return false;
        }
        try {
            int c = inapp.getInt("tlc");
            if (c == -1) {
                return false;
            }
            int[] counts = this.getInAppCountsFromPersistentStore(id);
            if (counts[1] >= c) {
                return true;
            }
        }
        catch (JSONException e) {
            return true;
        }
        return false;
    }

    private boolean hasDailyCapacityMaxedOut(JSONObject inapp) {
        int maxPerDayCount;
        String id = InAppFCManager.getInAppID(inapp);
        if (id == null) {
            return false;
        }
        int shownTodayCount = StorageHelper.getInt(this.context, KEY_COUNTS_SHOWN_TODAY, 0);
        if (shownTodayCount >= (maxPerDayCount = StorageHelper.getInt(this.context, KEY_MAX_PER_DAY, 1))) {
            return true;
        }
        if (!inapp.has("tdc")) {
            return false;
        }
        try {
            int maxPerDay = inapp.getInt("tdc");
            if (maxPerDay == -1) {
                return false;
            }
            int[] counts = this.getInAppCountsFromPersistentStore(id);
            if (counts[0] >= maxPerDay) {
                return true;
            }
        }
        catch (Throwable t) {
            return true;
        }
        return false;
    }

    static synchronized boolean canShow(Context context, JSONObject inapp) {
        try {
            if (inapp == null) {
                return false;
            }
            String id = InAppFCManager.getInAppID(inapp);
            if (id == null) {
                return true;
            }
            if (inapp.has("efc") && inapp.getInt("efc") == 1) {
                return true;
            }
            InAppFCManager instance = InAppFCManager.getInstance(context);
            if (instance.hasSessionCapacityMaxedOut(inapp)) break block7;
            if (instance.hasLifetimeCapacityMaxedOut(inapp)) break block8;
            if (!instance.hasDailyCapacityMaxedOut(inapp)) {
                return true;
            }
        }
        finally {
            return false;
        }
        {
            block7: {
                block8: {
                }
            }
        }
    }

    static synchronized void didDismiss(Context context, Bundle b) {
        Object id = b.get(INAPP_ID_IN_PAYLOAD);
        if (id != null) {
            InAppFCManager.getInstance((Context)context).mDismissedThisSession.add(id.toString());
        }
    }

    static synchronized void destroySession() {
        instance = null;
    }

    @SuppressLint(value={"CommitPrefEdits"})
    static void changeUser(Context context) {
        StorageHelper.putInt(context, KEY_COUNTS_SHOWN_TODAY, 0);
        InAppFCManager.instance.mShownThisSession.clear();
        InAppFCManager.instance.mShownThisSessionCount = 0;
        InAppFCManager.instance.mDismissedThisSession.clear();
        SharedPreferences prefs = StorageHelper.getPreferences(context, KEY_COUNTS_PER_INAPP);
        SharedPreferences.Editor editor = prefs.edit();
        editor.clear();
        StorageHelper.persist(editor);
    }

    static synchronized void didShow(Context context, JSONObject inapp) {
        String id = InAppFCManager.getInAppID(inapp);
        if (id == null) {
            return;
        }
        InAppFCManager instance = InAppFCManager.getInstance(context);
        ++instance.mShownThisSessionCount;
        Integer count = instance.mShownThisSession.get(id);
        if (count == null) {
            count = 1;
        }
        count = count + 1;
        instance.mShownThisSession.put(id, count);
        instance.incrementInAppCountsInPersistentStore(id);
        int shownToday = StorageHelper.getInt(context, KEY_COUNTS_SHOWN_TODAY, 0);
        StorageHelper.putInt(context, KEY_COUNTS_SHOWN_TODAY, ++shownToday);
    }

    static synchronized void updateLimits(Context context, int perDay, int perSession) {
        StorageHelper.putInt(context, KEY_MAX_PER_DAY, perDay);
        StorageHelper.putInt(context, "imc", perSession);
    }

    static synchronized void attachToHeader(Context context, JSONObject header) {
        try {
            InAppFCManager.getInstance(context);
            header.put("imp", StorageHelper.getInt(context, KEY_COUNTS_SHOWN_TODAY, 0));
            JSONArray arr = new JSONArray();
            SharedPreferences prefs = StorageHelper.getPreferences(context, KEY_COUNTS_PER_INAPP);
            Map all = prefs.getAll();
            for (String inapp : all.keySet()) {
                String[] parts;
                Object o = all.get(inapp);
                if (!(o instanceof String) || (parts = ((String)o).split(",")).length != 2) continue;
                JSONArray a = new JSONArray();
                a.put(0, (Object)inapp);
                a.put(1, Integer.parseInt(parts[0]));
                a.put(2, Integer.parseInt(parts[1]));
                arr.put((Object)a);
            }
            header.put("tlc", (Object)arr);
        }
        catch (Throwable t) {
            Logger.v("Failed to attach FC to header", t);
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    static synchronized void processResponse(Context context, JSONObject response) {
        try {
            if (!response.has("inapp_stale")) {
                return;
            }
            JSONArray arr = response.getJSONArray("inapp_stale");
            SharedPreferences prefs = StorageHelper.getPreferences(context, KEY_COUNTS_PER_INAPP);
            SharedPreferences.Editor editor = prefs.edit();
            for (int i = 0; i < arr.length(); ++i) {
                Object o = arr.get(i);
                if (o instanceof Integer) {
                    editor.remove("" + o);
                    Logger.d("Purged stale in-app - " + o);
                    continue;
                }
                if (!(o instanceof String)) continue;
                editor.remove((String)o);
                Logger.d("Purged stale in-app - " + o);
            }
            StorageHelper.persist(editor);
        }
        catch (Throwable t) {
            Logger.v("Failed to purge out stale targets", t);
        }
    }
}

