/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.clevertap.android.sdk.BuildInfo;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.InAppFCManager;
import com.clevertap.android.sdk.InAppManager;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.QueueManager;
import com.clevertap.android.sdk.SessionHandler;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.exceptions.CleverTapMetaDataNotFoundException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class CommsManager {
    private static final String NAMESPACE_IJ = "IJ";
    private static final String HEADER_DOMAIN_NAME = "X-WZRK-RD";
    private static final String HEADER_MUTE = "X-WZRK-MUTE";
    private static final String KEY_DOMAIN_NAME = "comms_dmn";
    private static final String KEY_MUTED = "comms_mtd";
    private static final String KEY_LAST_TS = "comms_last_ts";
    private static final String KEY_FIRST_TS = "comms_first_ts";
    private static final String KEY_I = "comms_i";
    private static final String KEY_J = "comms_j";
    private static int mResponseFailureCount = 0;
    private static int currentRequestTimestamp = 0;
    private static final String PRIMARY_DOMAIN = "wzrkt.com";

    CommsManager() {
    }

    static void flushQueueAsync(final Context context) {
        CleverTapAPI.postAsyncSafely("CommsManager#flushQueueAsync", new Runnable(){

            @Override
            public void run() {
                CommsManager.flushQueueSync(context);
            }
        });
    }

    static void flushQueueSync(final Context context) {
        if (!CommsManager.isOnline(context)) {
            Logger.v("Network connectivity unavailable. Will retry later");
            return;
        }
        if (CommsManager.needsHandshakeForDomain(context)) {
            mResponseFailureCount = 0;
            CommsManager.setDomain(context, null);
            CommsManager.performHandshakeForDomain(context, new Runnable(){

                @Override
                public void run() {
                    CommsManager.flushDBQueue(context);
                }
            });
        } else {
            CommsManager.flushDBQueue(context);
        }
    }

    private static void flushDBQueue(Context context) {
        Logger.v("Somebody has invoked me to send the queue to CleverTap servers");
        QueueManager.QueueCursor previousCursor = null;
        boolean loadMore = true;
        while (loadMore) {
            QueueManager.QueueCursor cursor = QueueManager.getQueuedEvents(context, 50, previousCursor);
            if (cursor == null || cursor.isEmpty().booleanValue()) {
                Logger.v("No events in the queue, bailing");
                break;
            }
            previousCursor = cursor;
            JSONArray queue = cursor.getData();
            if (queue == null || queue.length() <= 0) {
                Logger.v("No events in the queue, bailing");
                break;
            }
            loadMore = CommsManager.sendQueue(context, queue);
        }
    }

    private static HttpsURLConnection buildHttpsURLConnection(Context context, String endpoint) throws IOException, CleverTapMetaDataNotFoundException {
        URL url = new URL(endpoint);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        conn.setRequestProperty("X-CleverTap-Account-ID", CleverTapAPI.getAccountID(context));
        conn.setRequestProperty("X-CleverTap-Token", CleverTapAPI.getAccountToken(context));
        conn.setInstanceFollowRedirects(false);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performHandshakeForDomain(Context context, Runnable handshakeSuccessCallback) {
        if (CommsManager.isMuted(context)) {
            return;
        }
        String endpoint = CommsManager.getEndpoint(context, true);
        if (endpoint == null) {
            Logger.v("Unable to perform handshake, endpoint is null");
        }
        Logger.v("Performing handshake with " + endpoint);
        HttpsURLConnection conn = null;
        try {
            conn = CommsManager.buildHttpsURLConnection(context, endpoint);
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                Logger.v("Invalid HTTP status code received for handshake - " + responseCode);
                return;
            }
            Logger.v("Received success from handshake :)");
            if (CommsManager.processIncomingHeaders(context, conn)) {
                Logger.v("We are not muted");
                handshakeSuccessCallback.run();
            }
        }
        catch (Throwable t) {
            Logger.v("Failed to perform handshake!", t);
        }
        finally {
            if (conn != null) {
                try {
                    conn.getInputStream().close();
                    conn.disconnect();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static boolean sendQueue(Context context, JSONArray queue) {
        URLConnection conn;
        block30: {
            String req;
            String endpoint;
            block29: {
                block28: {
                    if (queue == null) return false;
                    if (queue.length() <= 0) {
                        return false;
                    }
                    conn = null;
                    endpoint = CommsManager.getEndpoint(context, false);
                    if (endpoint != null) break block28;
                    Logger.d("Problem configuring queue endpoint, unable to send queue");
                    boolean bl = false;
                    if (conn == null) return bl;
                    try {
                        conn.getInputStream().close();
                        ((HttpURLConnection)conn).disconnect();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return bl;
                }
                conn = CommsManager.buildHttpsURLConnection(context, endpoint);
                Class<CommsManager> clazz = CommsManager.class;
                // MONITORENTER : com.clevertap.android.sdk.CommsManager.class
                req = CommsManager.insertHeader(context, queue);
                if (req != null) break block29;
                Logger.d("Problem configuring queue request, unable to send queue");
                boolean bl = false;
                // MONITOREXIT : clazz
                if (conn == null) return bl;
                try {
                    conn.getInputStream().close();
                    ((HttpURLConnection)conn).disconnect();
                    return bl;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return bl;
            }
            Logger.d("Send queue contains " + queue.length() + " items: " + req);
            Logger.d("Sending queue to: " + endpoint);
            conn.setDoOutput(true);
            conn.getOutputStream().write(req.getBytes("UTF-8"));
            int responseCode = ((HttpURLConnection)conn).getResponseCode();
            if (responseCode != 200) {
                throw new IOException("Response code is not 200. It is " + responseCode);
            }
            String newDomain = conn.getHeaderField(HEADER_DOMAIN_NAME);
            if (newDomain == null || newDomain.trim().length() <= 0 || !CommsManager.hasDomainChanged(context, newDomain)) break block30;
            CommsManager.setDomain(context, newDomain);
            Logger.d("The domain has changed to " + newDomain + ". The request will be retried shortly.");
            boolean bl = false;
            // MONITOREXIT : clazz
            if (conn == null) return bl;
            try {
                conn.getInputStream().close();
                ((HttpURLConnection)conn).disconnect();
                return bl;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return bl;
        }
        if (CommsManager.processIncomingHeaders(context, (HttpsURLConnection)conn)) {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            String body = sb.toString();
            CommsManager.processResponse(context, body);
        }
        CommsManager.setLastRequestTimestamp(context, currentRequestTimestamp);
        CommsManager.setFirstRequestTimestampIfNeeded(context, currentRequestTimestamp);
        Logger.d("Queue sent successfully");
        // MONITOREXIT : clazz
        mResponseFailureCount = 0;
        boolean bl = true;
        if (conn == null) return bl;
        try {
            conn.getInputStream().close();
            ((HttpURLConnection)conn).disconnect();
            return bl;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
        catch (Throwable e) {
            try {
                Logger.d("An exception occurred while sending the queue, will retry", e);
                ++mResponseFailureCount;
                boolean bl2 = false;
                return bl2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.getInputStream().close();
                        ((HttpURLConnection)conn).disconnect();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    private static boolean processIncomingHeaders(Context context, HttpsURLConnection conn) {
        String domainName;
        String muteCommand = conn.getHeaderField(HEADER_MUTE);
        if (muteCommand != null && muteCommand.trim().length() > 0) {
            if (muteCommand.equals("true")) {
                CommsManager.setMuted(context, true);
                return false;
            }
            CommsManager.setMuted(context, false);
        }
        if ((domainName = conn.getHeaderField(HEADER_DOMAIN_NAME)) == null || domainName.trim().length() == 0) {
            return true;
        }
        CommsManager.setMuted(context, false);
        CommsManager.setDomain(context, domainName);
        return true;
    }

    private static String insertHeader(Context context, JSONArray arr) {
        try {
            long j;
            JSONObject header = new JSONObject();
            CleverTapAPI api = CleverTapAPI.getInstance(context);
            String deviceId = api.getCleverTapID();
            if (deviceId != null && !deviceId.equals("")) {
                header.put("g", (Object)deviceId);
            } else {
                Logger.v("CRITICAL: Couldn't finalise on a device ID!");
            }
            header.put("type", (Object)"meta");
            JSONObject appFields = api.getAppLaunchedFields();
            header.put("af", (Object)appFields);
            long i = CommsManager.getI(context);
            if (i > 0L) {
                header.put("_i", i);
            }
            if ((j = CommsManager.getJ(context)) > 0L) {
                header.put("_j", j);
            }
            String accountId = CleverTapAPI.getAccountID(context);
            String token = CleverTapAPI.getAccountToken(context);
            if (accountId == null || token == null) {
                Logger.d("Account ID/token not found, unable to configure queue request");
                return null;
            }
            header.put("id", (Object)accountId);
            header.put("tk", (Object)token);
            header.put("l_ts", CommsManager.getLastRequestTimestamp(context));
            header.put("f_ts", CommsManager.getFirstRequestTimestamp(context));
            try {
                JSONObject arp = CommsManager.getARP(context);
                if (arp != null && arp.length() > 0) {
                    header.put("arp", (Object)arp);
                }
            }
            catch (Throwable t) {
                Logger.v("Failed to attach ARP", t);
            }
            JSONObject ref = new JSONObject();
            try {
                String utmCampaign;
                String utmMedium;
                String utmSource = SessionHandler.getSource();
                if (utmSource != null) {
                    ref.put("us", (Object)utmSource);
                }
                if ((utmMedium = SessionHandler.getMedium()) != null) {
                    ref.put("um", (Object)utmMedium);
                }
                if ((utmCampaign = SessionHandler.getCampaign()) != null) {
                    ref.put("uc", (Object)utmCampaign);
                }
                if (ref.length() > 0) {
                    header.put("ref", (Object)ref);
                }
            }
            catch (Throwable t) {
                Logger.v("Failed to attach ref", t);
            }
            JSONObject wzrkParams = SessionHandler.getWzrkParams();
            if (wzrkParams != null && wzrkParams.length() > 0) {
                header.put("wzrk_ref", (Object)wzrkParams);
            }
            InAppFCManager.attachToHeader(context, header);
            return "[" + header.toString() + ", " + arr.toString().substring(1);
        }
        catch (Throwable t) {
            Logger.v("CommsManager: Failed to attach header", t);
            return arr.toString();
        }
    }

    private static boolean isOnline(Context context) {
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo netInfo = cm.getActiveNetworkInfo();
            return netInfo != null && netInfo.isConnected();
        }
        catch (Throwable ignore) {
            return true;
        }
    }

    private static void processResponse(Context context, String responseStr) {
        if (responseStr == null) {
            Logger.v("Problem processing queue response, response is null");
            return;
        }
        try {
            Logger.v("Trying to process response: " + responseStr);
            JSONObject response = new JSONObject(responseStr);
            try {
                InAppManager.processResponseAsync(response, context);
            }
            catch (Throwable t) {
                Logger.v("Failed to process in-app notifications from the response!", t);
            }
            try {
                if (response.has("g")) {
                    String deviceID = response.getString("g");
                    DeviceInfo.forceUpdateDeviceId(deviceID);
                    Logger.v("Got a new device ID: " + deviceID);
                }
            }
            catch (Throwable t) {
                Logger.v("Failed to update device ID!", t);
            }
            try {
                LocalDataStore.syncWithUpstream(context, response);
            }
            catch (Throwable t) {
                Logger.v("Failed to sync local cache with upstream", t);
            }
            try {
                JSONObject arp;
                if (response.has("arp") && (arp = (JSONObject)response.get("arp")).length() > 0) {
                    CommsManager.handleARPUpdate(context, arp);
                }
            }
            catch (Throwable t) {
                Logger.v("Failed to process ARP", t);
            }
            try {
                if (response.has("_i")) {
                    long i = response.getLong("_i");
                    CommsManager.setI(context, i);
                }
            }
            catch (Throwable i) {
                // empty catch block
            }
            try {
                if (response.has("_j")) {
                    long j = response.getLong("_j");
                    CommsManager.setJ(context, j);
                }
            }
            catch (Throwable j) {
                // empty catch block
            }
            try {
                JSONArray console;
                if (response.has("console") && (console = (JSONArray)response.get("console")).length() > 0) {
                    for (int i = 0; i < console.length(); ++i) {
                        Logger.d(console.get(i).toString());
                    }
                }
            }
            catch (Throwable console) {
                // empty catch block
            }
            try {
                int debugLevel;
                if (response.has("dbg_lvl") && (debugLevel = response.getInt("dbg_lvl")) >= 0) {
                    CleverTapAPI.setDebugLevel(debugLevel);
                    Logger.v("Set debug level to " + debugLevel + " for this session (set by upstream)");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                InAppFCManager.processResponse(context, response);
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable t) {
            ++mResponseFailureCount;
            Logger.v("Problem process send queue response", t);
        }
    }

    private static boolean needsHandshakeForDomain(Context context) {
        String domain = CommsManager.getDomainFromPrefsOrMetadata(context);
        return domain == null || mResponseFailureCount > 5;
    }

    static boolean isMuted(Context context) {
        int muteTS;
        int now = (int)(System.currentTimeMillis() / 1000L);
        return now - (muteTS = StorageHelper.getInt(context, KEY_MUTED, 0)) < 86400;
    }

    private static void setMuted(final Context context, boolean mute) {
        if (mute) {
            int now = (int)(System.currentTimeMillis() / 1000L);
            StorageHelper.putInt(context, KEY_MUTED, now);
            CommsManager.setDomain(context, null);
            CleverTapAPI.postAsyncSafely("CommsManager#setMuted", new Runnable(){

                @Override
                public void run() {
                    QueueManager.clearQueues(context);
                }
            });
        } else {
            StorageHelper.putInt(context, KEY_MUTED, 0);
        }
    }

    private static boolean hasDomainChanged(Context context, String newDomain) {
        String oldDomain = StorageHelper.getString(context, KEY_DOMAIN_NAME, null);
        return !newDomain.equals(oldDomain);
    }

    private static String getDomainFromPrefsOrMetadata(Context context) {
        try {
            String region = CleverTapAPI.getAccountRegion(context);
            if (region != null && region.trim().length() > 0) {
                mResponseFailureCount = 0;
                return region.trim().toLowerCase() + "." + PRIMARY_DOMAIN;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return StorageHelper.getString(context, KEY_DOMAIN_NAME, null);
    }

    private static String getDomain(Context context, boolean defaultToHandshakeURL) {
        boolean emptyDomain;
        String domain = CommsManager.getDomainFromPrefsOrMetadata(context);
        boolean bl = emptyDomain = domain == null || domain.trim().length() == 0;
        if (emptyDomain && !defaultToHandshakeURL) {
            return null;
        }
        domain = emptyDomain ? "wzrkt.com/hello" : domain + "/a1";
        return domain;
    }

    private static void setDomain(Context context, String domainName) {
        Logger.v("Setting domain to " + domainName);
        StorageHelper.putString(context, KEY_DOMAIN_NAME, domainName);
    }

    private static String getEndpoint(Context context, boolean defaultToHandshakeURL) {
        String domain = CommsManager.getDomain(context, defaultToHandshakeURL);
        if (domain == null) {
            Logger.v("Unable to configure endpoint, domain is null");
            return null;
        }
        String accountId = CleverTapAPI.getAccountID(context);
        if (accountId == null) {
            Logger.v("Unable to configure endpoint, accountID is null");
            return null;
        }
        String endpoint = "https://" + domain + "?os=Android&t=" + BuildInfo.SDK_SVN_REVISION;
        endpoint = endpoint + "&z=" + accountId;
        boolean needsHandshake = CommsManager.needsHandshakeForDomain(context);
        if (needsHandshake) {
            return endpoint;
        }
        currentRequestTimestamp = (int)(System.currentTimeMillis() / 1000L);
        endpoint = endpoint + "&ts=" + currentRequestTimestamp;
        return endpoint;
    }

    private static int getFirstRequestTimestamp(Context context) {
        return StorageHelper.getInt(context, KEY_FIRST_TS, 0);
    }

    private static int getLastRequestTimestamp(Context context) {
        return StorageHelper.getInt(context, KEY_LAST_TS, 0);
    }

    private static void setLastRequestTimestamp(Context context, int ts) {
        StorageHelper.putInt(context, KEY_LAST_TS, ts);
    }

    private static void setFirstRequestTimestampIfNeeded(Context context, int ts) {
        if (CommsManager.getFirstRequestTimestamp(context) > 0) {
            return;
        }
        StorageHelper.putInt(context, KEY_FIRST_TS, ts);
    }

    private static void clearLastRequestTimestamp(Context context) {
        StorageHelper.putInt(context, KEY_LAST_TS, 0);
    }

    private static void clearFirstRequestTimestampIfNeeded(Context context) {
        StorageHelper.putInt(context, KEY_FIRST_TS, 0);
    }

    private static JSONObject getARP(Context context) {
        try {
            String nameSpaceKey = CommsManager.getNamespaceARPKey(context);
            if (nameSpaceKey == null) {
                return null;
            }
            SharedPreferences prefs = StorageHelper.getPreferences(context, nameSpaceKey);
            Map all = prefs.getAll();
            Iterator iter = all.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry kv = iter.next();
                Object o = kv.getValue();
                if (!(o instanceof Number) || ((Number)o).intValue() != -1) continue;
                iter.remove();
            }
            JSONObject ret = new JSONObject(all);
            Logger.v("Fetched ARP for namespace key: " + nameSpaceKey + " values: " + all.toString());
            return ret;
        }
        catch (Throwable t) {
            Logger.v("Failed to construct ARP object", t);
            return null;
        }
    }

    private static String getNamespaceARPKey(Context context) {
        String accountId = CleverTapAPI.getAccountID(context);
        if (accountId == null) {
            return null;
        }
        return "ARP:" + accountId;
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private static void _clearARP(Context context) {
        String nameSpaceKey = CommsManager.getNamespaceARPKey(context);
        if (nameSpaceKey == null) {
            return;
        }
        SharedPreferences prefs = StorageHelper.getPreferences(context, nameSpaceKey);
        SharedPreferences.Editor editor = prefs.edit();
        editor.clear();
        StorageHelper.persist(editor);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private static void handleARPUpdate(Context context, JSONObject arp) {
        if (arp == null || arp.length() == 0) {
            return;
        }
        String nameSpaceKey = CommsManager.getNamespaceARPKey(context);
        if (nameSpaceKey == null) {
            return;
        }
        SharedPreferences prefs = StorageHelper.getPreferences(context, nameSpaceKey);
        SharedPreferences.Editor editor = prefs.edit();
        Iterator keys = arp.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                Object o = arp.get(key);
                if (o instanceof Number) {
                    int update = ((Number)o).intValue();
                    editor.putInt(key, update);
                    continue;
                }
                if (o instanceof String) {
                    if (((String)o).length() < 100) {
                        editor.putString(key, (String)o);
                        continue;
                    }
                    Logger.v("ARP update for key " + key + " rejected (string value too long)");
                    continue;
                }
                if (o instanceof Boolean) {
                    editor.putBoolean(key, ((Boolean)o).booleanValue());
                    continue;
                }
                Logger.v("ARP update for key " + key + " rejected (invalid data type)");
            }
            catch (JSONException jSONException) {}
        }
        Logger.v("Completed ARP update for namespace key: " + nameSpaceKey + "");
        StorageHelper.persist(editor);
    }

    static void clearUserContext(Context context) {
        CommsManager.clearIJ(context);
        CommsManager._clearARP(context);
        CommsManager.clearFirstRequestTimestampIfNeeded(context);
        CommsManager.clearLastRequestTimestamp(context);
    }

    private static long getI(Context context) {
        SharedPreferences prefs = StorageHelper.getPreferences(context, NAMESPACE_IJ);
        return prefs.getLong(KEY_I, 0L);
    }

    private static long getJ(Context context) {
        SharedPreferences prefs = StorageHelper.getPreferences(context, NAMESPACE_IJ);
        return prefs.getLong(KEY_J, 0L);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private static void setJ(Context context, long j) {
        SharedPreferences prefs = StorageHelper.getPreferences(context, NAMESPACE_IJ);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putLong(KEY_J, j);
        StorageHelper.persist(editor);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private static void setI(Context context, long i) {
        SharedPreferences prefs = StorageHelper.getPreferences(context, NAMESPACE_IJ);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putLong(KEY_I, i);
        StorageHelper.persist(editor);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private static void clearIJ(Context context) {
        SharedPreferences prefs = StorageHelper.getPreferences(context, NAMESPACE_IJ);
        SharedPreferences.Editor editor = prefs.edit();
        editor.clear();
        StorageHelper.persist(editor);
    }
}

