/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.PushType;
import com.clevertap.android.sdk.QueueManager;
import org.json.JSONException;
import org.json.JSONObject;

public final class DataHandler {
    private final Context context;

    DataHandler(Context context) {
        this.context = context;
    }

    static void pushDeviceToken(Context context, String token, boolean register, PushType type) {
        if (token == null || type == null) {
            return;
        }
        JSONObject event = new JSONObject();
        JSONObject data = new JSONObject();
        try {
            String action = register ? "register" : "unregister";
            data.put("action", (Object)action);
            data.put("id", (Object)token);
            data.put("type", (Object)type.toString());
            event.put("data", (Object)data);
            Logger.logFine("DataHandler: pushing device token with action " + action + " and type " + type.toString());
            QueueManager.queueEvent(context, event, 5);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void pushGcmRegistrationId(String gcmId, boolean register) {
        DataHandler.pushDeviceToken(this.context, gcmId, register, PushType.GCM);
    }

    public void pushFcmRegistrationId(String fcmId, boolean register) {
        DataHandler.pushDeviceToken(this.context, fcmId, register, PushType.FCM);
    }
}

