/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.ImageView;
import com.clevertap.android.sdk.Logger;
import java.io.IOException;
import java.io.InputStream;

final class CloseImageView
extends ImageView {
    private final int canvasSize = this.getScaledPixels(40);

    public CloseImageView(Context context) {
        super(context);
        this.setId(199272);
    }

    public CloseImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setId(199272);
    }

    public CloseImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setId(199272);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.canvasSize, this.canvasSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        InputStream is = null;
        try {
            Bitmap closeBitmap;
            is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/clevertap/android/sdk/images/close.png");
            if (is != null) {
                closeBitmap = BitmapFactory.decodeStream((InputStream)is);
            } else {
                Context context = this.getContext();
                int resourceID = context.getResources().getIdentifier("close", "drawable", context.getPackageName());
                closeBitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)resourceID, null);
            }
            if (closeBitmap != null) {
                Bitmap scaledCloseBitmap = Bitmap.createScaledBitmap((Bitmap)closeBitmap, (int)this.canvasSize, (int)this.canvasSize, (boolean)true);
                canvas.drawBitmap(scaledCloseBitmap, 0.0f, 0.0f, new Paint());
            } else {
                Logger.v("Unable to find inapp notif close button image");
            }
        }
        catch (Throwable t) {
            Logger.v("Error displaying the inapp notif close button image:", t);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException closeBitmap) {}
        }
    }

    private int getScaledPixels(int raw) {
        return (int)TypedValue.applyDimension((int)1, (float)raw, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }
}

