/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.support.v4.content.ContextCompat;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestMetaData;
import com.clevertap.android.sdk.PushType;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.exceptions.CleverTapMetaDataNotFoundException;
import com.clevertap.android.sdk.exceptions.CleverTapPermissionsNotSatisfied;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GoogleApiAvailability;
import java.util.ArrayList;
import java.util.UUID;

final class DeviceInfo {
    private static final String GUID_PREFIX = "__";
    private static String provisionalGUID = null;
    private static final Object deviceIDLock = new Object();
    private static final Object adIDLock = new Object();
    private static Context context = null;
    private static String googleAdID = null;
    private static boolean limitAdTracking = false;
    private static ArrayList<PushType> enabledPushTypes = null;
    private static String GCMSenderID = null;
    private static Boolean isFirebasePresent = null;
    private static Boolean areGoogleServicesAvailable = null;
    private static final String FIREBASE_CLASS_NAME = "com.google.firebase.messaging.FirebaseMessaging";

    DeviceInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getGoogleAdID() {
        Object object = adIDLock;
        synchronized (object) {
            return googleAdID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isLimitAdTrackingEnabled() {
        Object object = adIDLock;
        synchronized (object) {
            return limitAdTracking;
        }
    }

    static void initializeWithContext(Context context) {
        DeviceInfo.context = context;
        DeviceInfo.initDeviceIDAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateProvisionalGUID() {
        Object object = deviceIDLock;
        synchronized (object) {
            if (provisionalGUID == null) {
                provisionalGUID = DeviceInfo.generateGUID();
            }
        }
    }

    private static void initDeviceIDAsync() {
        DeviceInfo.generateProvisionalGUID();
        CleverTapAPI.postAsyncSafely("DeviceInfo#generateDeviceID", new Runnable(){

            @Override
            public void run() {
                DeviceInfo.cacheGoogleAdID();
                String deviceID = DeviceInfo.getDeviceID();
                if (deviceID != null && deviceID.trim().length() > 2) {
                    DeviceInfo.notifyNewDeviceID(deviceID);
                } else {
                    DeviceInfo.generateDeviceID();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheGoogleAdID() {
        String advertisingID;
        try {
            AdvertisingIdClient.Info adInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
            advertisingID = adInfo.getId();
            Object object = adIDLock;
            synchronized (object) {
                limitAdTracking = adInfo.isLimitAdTrackingEnabled();
            }
        }
        catch (Throwable t) {
            advertisingID = null;
        }
        if (advertisingID != null && advertisingID.trim().length() > 2) {
            Object object = adIDLock;
            synchronized (object) {
                googleAdID = advertisingID.replace("-", "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateDeviceID() {
        String generatedDeviceID;
        if (googleAdID != null) {
            Object object = adIDLock;
            synchronized (object) {
                generatedDeviceID = "__g" + googleAdID;
            }
        }
        Logger.logFine("Failed with Advertising ID");
        Object object = deviceIDLock;
        synchronized (object) {
            generatedDeviceID = provisionalGUID;
            Logger.logFine("Made provisional ID permanent");
        }
        if (generatedDeviceID != null && generatedDeviceID.trim().length() > 2) {
            DeviceInfo.forceUpdateDeviceId(generatedDeviceID);
        } else {
            Logger.logFine("Unable to generate device ID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getAttributionID() {
        String deviceID = DeviceInfo.getDeviceID();
        Object object = deviceIDLock;
        synchronized (object) {
            return deviceID != null && deviceID.trim().length() > 2 ? deviceID : provisionalGUID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getDeviceID() {
        Object object = deviceIDLock;
        synchronized (object) {
            return StorageHelper.getString(context, "deviceId", null);
        }
    }

    private static void notifyNewDeviceID(final String deviceID) {
        CleverTapAPI.postAsyncSafely("DeviceInfo#notifyNewDeviceID", new Runnable(){

            @Override
            public void run() {
                try {
                    CleverTapAPI.notifyUserProfileInitialized(deviceID);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    private static String generateGUID() {
        return GUID_PREFIX + UUID.randomUUID().toString().replace("-", "");
    }

    static void forceNewDeviceID() {
        String deviceID = DeviceInfo.generateGUID();
        DeviceInfo.forceUpdateDeviceId(deviceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CommitPrefEdits"})
    static void forceUpdateDeviceId(String id) {
        Logger.logExtraFine("Force updating the device ID to " + id);
        Object object = deviceIDLock;
        synchronized (object) {
            StorageHelper.putString(context, "deviceId", id);
        }
        DeviceInfo.notifyNewDeviceID(id);
    }

    static void testPermission(Context context, String permission) throws CleverTapPermissionsNotSatisfied {
        if (!DeviceInfo.hasPermission(context, permission)) {
            throw new CleverTapPermissionsNotSatisfied("Permission required: " + permission);
        }
    }

    static boolean hasPermission(Context context, String permission) {
        try {
            return 0 == ContextCompat.checkSelfPermission((Context)context, (String)permission);
        }
        catch (Throwable t) {
            return false;
        }
    }

    static int getAppIconAsIntId(Context context) {
        ApplicationInfo ai = context.getApplicationInfo();
        return ai.icon;
    }

    private static boolean isGCMAvailable() {
        return DeviceInfo.isGooglePlayServicesAvailable() && DeviceInfo.getGCMSenderID() != null;
    }

    private static boolean isFCMAvailable() {
        if (isFirebasePresent == null) {
            try {
                Class.forName(FIREBASE_CLASS_NAME);
                isFirebasePresent = true;
                Logger.logFine("FCM installed");
            }
            catch (ClassNotFoundException e) {
                isFirebasePresent = false;
                Logger.logFine("FCM unavailable");
            }
        }
        return DeviceInfo.isGooglePlayServicesAvailable() && isFirebasePresent != false;
    }

    static ArrayList<PushType> getEnabledPushTypes() {
        if (enabledPushTypes == null) {
            enabledPushTypes = new ArrayList();
            boolean fcmAvail = DeviceInfo.isFCMAvailable();
            if (fcmAvail) {
                enabledPushTypes.add(PushType.FCM);
            }
            if (!fcmAvail && DeviceInfo.isGCMAvailable()) {
                enabledPushTypes.add(PushType.GCM);
            }
        }
        return enabledPushTypes;
    }

    static boolean isGooglePlayServicesAvailable() {
        if (areGoogleServicesAvailable == null) {
            try {
                GoogleApiAvailability googleAPI = GoogleApiAvailability.getInstance();
                int result = googleAPI.isGooglePlayServicesAvailable(context);
                areGoogleServicesAvailable = result == 0;
                Logger.logFine("Google Play services availability: " + areGoogleServicesAvailable.toString());
            }
            catch (Throwable t) {
                Logger.logFine("Error checking Google Play services availability", t);
                areGoogleServicesAvailable = false;
            }
        }
        return areGoogleServicesAvailable;
    }

    static String getGCMSenderID() {
        if (GCMSenderID == null) {
            String senderID = null;
            try {
                senderID = ManifestMetaData.getMetaData(context, "GCM_SENDER_ID");
                if (senderID != null) {
                    senderID = senderID.replace("id:", "");
                }
            }
            catch (CleverTapMetaDataNotFoundException e) {
                Logger.logFine("GCM sender ID not found");
            }
            catch (Throwable t) {
                Logger.error("Error retrieving GCM sender ID", t);
            }
            GCMSenderID = senderID;
        }
        return GCMSenderID;
    }
}

