/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.util.Base64;
import com.clevertap.android.sdk.BuildInfo;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.InAppFCManager;
import com.clevertap.android.sdk.InAppManager;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestMetaData;
import com.clevertap.android.sdk.QueueManager;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.exceptions.CleverTapMetaDataNotFoundException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class CommsManager {
    static final String NAMESPACE_ARP = "ARP";
    private static final String HEADER_DOMAIN_NAME = "X-WZRK-RD";
    private static final String HEADER_MUTE = "X-WZRK-MUTE";
    private static final String KEY_DOMAIN_NAME = "comms_dmn";
    private static final String KEY_MUTED = "comms_mtd";
    private static int mResponseFailureCount = 0;

    CommsManager() {
    }

    static void flushQueueAsync(final Context context) {
        CleverTapAPI.postAsyncSafely("CommsManager#flushQueueAsync", new Runnable(){

            @Override
            public void run() {
                CommsManager.flushQueueSync(context);
            }
        });
    }

    static void flushQueueSync(final Context context) {
        if (!CommsManager.isOnline(context)) {
            Logger.logFine("Network connectivity unavailable. Will retry later");
            return;
        }
        if (CommsManager.needsHandshakeForDomain(context)) {
            mResponseFailureCount = 0;
            CommsManager.setDomain(context, null);
            CommsManager.performHandshakeForDomain(context, new Runnable(){

                @Override
                public void run() {
                    CommsManager.flushDBQueue(context);
                }
            });
        } else {
            CommsManager.flushDBQueue(context);
        }
    }

    private static void flushDBQueue(Context context) {
        Logger.logFine("Somebody has invoked me to send the queue to CleverTap servers");
        QueueManager.QueueCursor previousCursor = null;
        boolean loadMore = true;
        while (loadMore) {
            QueueManager.QueueCursor cursor = QueueManager.getQueuedEvents(context, 50, previousCursor);
            if (cursor == null || cursor.isEmpty().booleanValue()) {
                Logger.logFine("No events in the queue, bailing");
                break;
            }
            previousCursor = cursor;
            JSONArray queue = cursor.getData();
            if (queue == null || queue.length() <= 0) {
                Logger.logFine("No events in the queue, bailing");
                break;
            }
            loadMore = CommsManager.sendQueue(context, queue);
        }
    }

    private static HttpsURLConnection buildHttpsURLConnection(Context context, String endpoint) throws IOException, CleverTapMetaDataNotFoundException {
        URL url = new URL(endpoint);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        conn.setRequestProperty("X-CleverTap-Account-ID", ManifestMetaData.getMetaData(context, "CLEVERTAP_ACCOUNT_ID"));
        conn.setRequestProperty("X-CleverTap-Token", ManifestMetaData.getMetaData(context, "CLEVERTAP_TOKEN"));
        conn.setInstanceFollowRedirects(false);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performHandshakeForDomain(Context context, Runnable handshakeSuccessCallback) {
        if (CommsManager.isMuted(context)) {
            return;
        }
        String endpoint = CommsManager.getEndpoint(context, true);
        Logger.logExtraFine("Performing handshake with " + endpoint);
        HttpsURLConnection conn = null;
        try {
            conn = CommsManager.buildHttpsURLConnection(context, endpoint);
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                Logger.error("Invalid HTTP status code received for handshake - " + responseCode);
                return;
            }
            Logger.logExtraFine("Received success from handshake :)");
            if (CommsManager.processIncomingHeaders(context, conn)) {
                Logger.logExtraFine("We are not muted");
                handshakeSuccessCallback.run();
            }
        }
        catch (Throwable t) {
            Logger.error("Failed to perform handshake!", t);
        }
        finally {
            if (conn != null) {
                try {
                    conn.getInputStream().close();
                    conn.disconnect();
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static boolean sendQueue(Context context, JSONArray queue) {
        URLConnection conn;
        block26: {
            String endpoint;
            block25: {
                if (queue == null) return false;
                if (queue.length() <= 0) {
                    return false;
                }
                conn = null;
                endpoint = CommsManager.getEndpoint(context, false);
                if (endpoint != null) break block25;
                boolean bl = false;
                if (conn == null) return bl;
                try {
                    conn.getInputStream().close();
                    ((HttpURLConnection)conn).disconnect();
                    return bl;
                }
                catch (Throwable t) {
                    // empty catch block
                }
                return bl;
            }
            conn = CommsManager.buildHttpsURLConnection(context, endpoint);
            Logger.logFine("Using endpoint " + endpoint);
            Class<CommsManager> t = CommsManager.class;
            // MONITORENTER : com.clevertap.android.sdk.CommsManager.class
            String req = CommsManager.insertHeader(context, queue);
            Logger.logFine("Send queue contains " + queue.length() + " items: " + req);
            conn.setDoOutput(true);
            conn.getOutputStream().write(req.getBytes("UTF-8"));
            int responseCode = ((HttpURLConnection)conn).getResponseCode();
            if (responseCode != 200) {
                throw new IOException("Response code is not 200. It is " + responseCode);
            }
            String newDomain = conn.getHeaderField(HEADER_DOMAIN_NAME);
            if (newDomain == null || newDomain.trim().length() <= 0 || !CommsManager.hasDomainChanged(context, newDomain)) break block26;
            CommsManager.setDomain(context, newDomain);
            Logger.logExtraFine("The domain has changed to " + newDomain + ". The request will be retried shortly.");
            boolean bl = false;
            // MONITOREXIT : t
            if (conn == null) return bl;
            try {
                conn.getInputStream().close();
                ((HttpURLConnection)conn).disconnect();
                return bl;
            }
            catch (Throwable t2) {
                // empty catch block
            }
            return bl;
        }
        if (CommsManager.processIncomingHeaders(context, (HttpsURLConnection)conn)) {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            String body = sb.toString();
            CommsManager.processResponse(context, body);
        }
        Logger.logFine("Completed successfully");
        // MONITOREXIT : t
        mResponseFailureCount = 0;
        boolean t = true;
        if (conn == null) return t;
        try {
            conn.getInputStream().close();
            ((HttpURLConnection)conn).disconnect();
            return t;
        }
        catch (Throwable t3) {
            // empty catch block
        }
        return t;
        catch (Throwable e) {
            try {
                Logger.logFine("An exception occurred while trying to send the queue", e);
                ++mResponseFailureCount;
                boolean bl = false;
                return bl;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.getInputStream().close();
                        ((HttpURLConnection)conn).disconnect();
                    }
                    catch (Throwable t4) {}
                }
            }
        }
    }

    private static boolean processIncomingHeaders(Context context, HttpsURLConnection conn) {
        String domainName;
        String muteCommand = conn.getHeaderField(HEADER_MUTE);
        if (muteCommand != null && muteCommand.trim().length() > 0) {
            if (muteCommand.equals("true")) {
                CommsManager.setMuted(context, true);
                return false;
            }
            CommsManager.setMuted(context, false);
        }
        if ((domainName = conn.getHeaderField(HEADER_DOMAIN_NAME)) == null || domainName.trim().length() == 0) {
            return true;
        }
        CommsManager.setMuted(context, false);
        CommsManager.setDomain(context, domainName);
        return true;
    }

    private static String insertHeader(Context context, JSONArray arr) {
        try {
            JSONObject header = new JSONObject();
            CleverTapAPI api = CleverTapAPI.getInstance(context);
            String deviceId = api.getCleverTapID();
            if (deviceId != null && !deviceId.equals("")) {
                header.put("g", (Object)deviceId);
            } else {
                Logger.error("CRITICAL: Couldn't finalise on a device ID!");
            }
            header.put("type", (Object)"meta");
            JSONObject appFields = api.getAppLaunchedFields();
            header.put("af", (Object)appFields);
            String accountId = null;
            String token = null;
            try {
                accountId = ManifestMetaData.getMetaData(context, "CLEVERTAP_ACCOUNT_ID");
                token = ManifestMetaData.getMetaData(context, "CLEVERTAP_TOKEN");
            }
            catch (CleverTapMetaDataNotFoundException e) {
                Logger.logFine("Account ID/token not found, will not add to queue header");
            }
            if (accountId != null) {
                header.put("id", (Object)accountId);
            }
            if (token != null) {
                header.put("tk", (Object)token);
            }
            InAppFCManager.attachToHeader(context, header);
            return "[" + header.toString() + ", " + arr.toString().substring(1);
        }
        catch (Throwable t) {
            Logger.error("CommsManager: Failed to attach header", t);
            return arr.toString();
        }
    }

    private static boolean isOnline(Context context) {
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo netInfo = cm.getActiveNetworkInfo();
            return netInfo != null && netInfo.isConnected();
        }
        catch (Throwable ignore) {
            return true;
        }
    }

    private static void processResponse(Context context, String responseStr) {
        if (responseStr == null) {
            return;
        }
        try {
            Logger.logFine("Trying to process response: " + responseStr);
            JSONObject response = new JSONObject(responseStr);
            try {
                InAppManager.processResponseAsync(response, context);
            }
            catch (Throwable t) {
                Logger.error("Failed to process in-app notifications from the response!", t);
            }
            try {
                if (response.has("g")) {
                    String deviceID = response.getString("g");
                    DeviceInfo.forceUpdateDeviceId(deviceID);
                    Logger.logFine("Got a new device ID: " + deviceID);
                }
            }
            catch (Throwable t) {
                Logger.error("Failed to update device ID!", t);
            }
            try {
                LocalDataStore.syncWithUpstream(context, response);
            }
            catch (Throwable t) {
                Logger.error("Failed to sync local cache with upstream", t);
            }
            try {
                JSONObject arp;
                if (response.has("arp") && (arp = (JSONObject)response.get("arp")).length() > 0) {
                    CommsManager.handleARPUpdate(context, arp);
                }
            }
            catch (Throwable t) {
                Logger.logFine("Failed to process ARP", t);
            }
            try {
                JSONArray console;
                if (response.has("console") && (console = (JSONArray)response.get("console")).length() > 0) {
                    for (int i = 0; i < console.length(); ++i) {
                        Logger.log(console.get(i).toString());
                    }
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                int debugLevel;
                if (response.has("dbg_lvl") && (debugLevel = response.getInt("dbg_lvl")) >= 0) {
                    CleverTapAPI.setDebugLevel(debugLevel);
                    Logger.logFine("Set debug level to " + debugLevel + " for this session (set by upstream)");
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                InAppFCManager.processResponse(context, response);
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable t) {
            ++mResponseFailureCount;
            Logger.error("Failed to send events to CleverTap", t);
        }
    }

    private static boolean needsHandshakeForDomain(Context context) {
        String domain = StorageHelper.getString(context, KEY_DOMAIN_NAME, null);
        return domain == null || mResponseFailureCount > 5;
    }

    static boolean isMuted(Context context) {
        int muteTS;
        int now = (int)(System.currentTimeMillis() / 1000L);
        return now - (muteTS = StorageHelper.getInt(context, KEY_MUTED, 0)) < 86400;
    }

    private static void setMuted(final Context context, boolean mute) {
        if (mute) {
            int now = (int)(System.currentTimeMillis() / 1000L);
            StorageHelper.putInt(context, KEY_MUTED, now);
            CommsManager.setDomain(context, null);
            CleverTapAPI.postAsyncSafely("CommsManager#setMuted", new Runnable(){

                @Override
                public void run() {
                    QueueManager.clearQueues(context);
                }
            });
        } else {
            StorageHelper.putInt(context, KEY_MUTED, 0);
        }
    }

    private static boolean hasDomainChanged(Context context, String newDomain) {
        String oldDomain = StorageHelper.getString(context, KEY_DOMAIN_NAME, null);
        return !newDomain.equals(oldDomain);
    }

    private static String getDomain(Context context, boolean defaultToHandshakeURL) {
        boolean emptyDomain;
        String domain = StorageHelper.getString(context, KEY_DOMAIN_NAME, null);
        boolean bl = emptyDomain = domain == null || domain.trim().length() == 0;
        if (emptyDomain && !defaultToHandshakeURL) {
            return null;
        }
        domain = emptyDomain ? "wzrkt.com/hello" : domain + "/a1";
        return domain;
    }

    private static void setDomain(Context context, String domainName) {
        Logger.logExtraFine("Setting domain to " + domainName);
        StorageHelper.putString(context, KEY_DOMAIN_NAME, domainName);
    }

    private static String getEndpoint(Context context, boolean defaultToHandshakeURL) {
        String domain = CommsManager.getDomain(context, defaultToHandshakeURL);
        if (domain == null && !defaultToHandshakeURL) {
            return null;
        }
        boolean needsHandshake = CommsManager.needsHandshakeForDomain(context);
        String endpoint = "https://" + domain + "?os=Android&t=" + BuildInfo.SDK_SVN_REVISION;
        try {
            endpoint = endpoint + "&z=" + ManifestMetaData.getMetaData(context, "CLEVERTAP_ACCOUNT_ID");
        }
        catch (CleverTapMetaDataNotFoundException ignore) {
            // empty catch block
        }
        if (needsHandshake) {
            return endpoint;
        }
        try {
            String encoded;
            JSONObject arp = CommsManager.getARP(context);
            if (arp != null && arp.length() > 0 && (encoded = Uri.encode((String)Base64.encodeToString((byte[])arp.toString().getBytes("UTF-8"), (int)0))) != null && encoded.length() > 1) {
                endpoint = endpoint + "&arp=" + encoded;
            }
        }
        catch (Throwable t) {
            Logger.error("Failed to attach ARP", t);
        }
        endpoint = endpoint + "&ts=" + (int)(System.currentTimeMillis() / 1000L);
        return endpoint;
    }

    private static JSONObject getARP(Context context) {
        try {
            SharedPreferences prefs = StorageHelper.getPreferences(context, NAMESPACE_ARP);
            Map all = prefs.getAll();
            Iterator iter = all.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry kv = iter.next();
                Object o = kv.getValue();
                if (!(o instanceof Number) || ((Number)o).intValue() != -1) continue;
                iter.remove();
            }
            return new JSONObject(all);
        }
        catch (Throwable t) {
            Logger.logFine("Failed to construct ARP object", t);
            return null;
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    static void clearARP(Context context) {
        SharedPreferences prefs = StorageHelper.getPreferences(context, NAMESPACE_ARP);
        SharedPreferences.Editor editor = prefs.edit();
        editor.clear();
        StorageHelper.persist(editor);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private static void handleARPUpdate(Context context, JSONObject arp) {
        if (arp == null || arp.length() == 0) {
            return;
        }
        SharedPreferences prefs = StorageHelper.getPreferences(context, NAMESPACE_ARP);
        SharedPreferences.Editor editor = prefs.edit();
        Iterator keys = arp.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                Object o = arp.get(key);
                if (o instanceof Number) {
                    int update = ((Number)o).intValue();
                    editor.putInt(key, update);
                    continue;
                }
                if (o instanceof String) {
                    if (((String)o).length() < 100) {
                        editor.putString(key, (String)o);
                        continue;
                    }
                    Logger.logFine("ARP update for key " + key + " rejected (string value too long)");
                    continue;
                }
                if (o instanceof Boolean) {
                    editor.putBoolean(key, ((Boolean)o).booleanValue());
                    continue;
                }
                Logger.logFine("ARP update for key " + key + " rejected (invalid data type)");
            }
            catch (JSONException e) {}
        }
        StorageHelper.persist(editor);
    }
}

