/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.telephony.TelephonyManager;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Constants;
import com.clevertap.android.sdk.DataType;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.QueueManager;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.ValidationResult;
import com.clevertap.android.sdk.Validator;
import com.google.android.gms.plus.model.people.Person;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ProfileHandler {
    private final Context context;

    ProfileHandler(Context context) {
        this.context = context;
    }

    public void setMultiValuesForKey(String key, ArrayList<String> values) {
        this._handleMultiValues(values, key, "$set");
    }

    public void addMultiValueForKey(String key, String value) {
        if (value == null || value.isEmpty()) {
            this._generateInvalidMultiValueError(key, value);
            return;
        }
        this.addMultiValuesForKey(key, new ArrayList<String>(Collections.singletonList(value)));
    }

    public void addMultiValuesForKey(String key, ArrayList<String> values) {
        String command = LocalDataStore.getProfileValueForKey(key) != null ? "$add" : "$set";
        this._handleMultiValues(values, key, command);
    }

    public void removeMultiValueForKey(String key, String value) {
        if (value == null || value.isEmpty()) {
            this._generateInvalidMultiValueError(key, value);
            return;
        }
        this.removeMultiValuesForKey(key, new ArrayList<String>(Collections.singletonList(value)));
    }

    public void removeMultiValuesForKey(String key, ArrayList<String> values) {
        this._handleMultiValues(values, key, "$remove");
    }

    public void removeValueForKey(String key) {
        key = key == null ? "" : key;
        try {
            ValidationResult vr = Validator.cleanObjectKey(key);
            key = vr.getObject().toString();
            if (key.isEmpty()) {
                ValidationResult error = new ValidationResult();
                error.setErrorCode(512);
                error.setErrorDesc("Key is empty, profile removeValueForKey aborted.");
                this.pushValidationResult(error);
                Logger.log("Key is empty, profile removeValueForKey aborted");
                return;
            }
            if (vr.getErrorCode() != 0) {
                this.pushValidationResult(vr);
            }
            LocalDataStore.removeProfileField(this.context, key);
            JSONObject command = new JSONObject().put("$delete", true);
            JSONObject update = new JSONObject().put(key, (Object)command);
            this.pushBasicProfile(update);
            Logger.logFine("removing value for key " + key + " from user profile");
        }
        catch (Throwable t) {
            Logger.error("Failed to remove profile value for key " + key, t);
        }
    }

    public void push(Map<String, Object> profile) {
        if (profile == null || profile.isEmpty()) {
            return;
        }
        try {
            JSONObject customProfile = new JSONObject();
            JSONObject fieldsToUpdateLocally = new JSONObject();
            for (String key : profile.keySet()) {
                Object value = profile.get(key);
                ValidationResult vr = Validator.cleanObjectKey(key);
                key = vr.getObject().toString();
                if (vr.getErrorCode() != 0) {
                    this.pushValidationResult(vr);
                }
                try {
                    vr = Validator.cleanObjectValue(value, true, true);
                }
                catch (Throwable e) {
                    ValidationResult error = new ValidationResult();
                    error.setErrorCode(512);
                    String err = "Object value wasn't a primitive (" + value + ") for profile field " + key;
                    error.setErrorDesc(err);
                    this.pushValidationResult(error);
                    Logger.error(err);
                    continue;
                }
                value = vr.getObject();
                if (vr.getErrorCode() != 0) {
                    this.pushValidationResult(vr);
                }
                if (key.equalsIgnoreCase("Phone")) {
                    try {
                        value = value.toString();
                        Validator.validatePhone((String)value);
                    }
                    catch (Exception e) {
                        this.pushValidationResult(new ValidationResult(512, "Invalid phone number"));
                        Logger.log("Invalid phone number");
                        continue;
                    }
                }
                if (key.equalsIgnoreCase("Age")) {
                    if (value instanceof Integer) {
                        int age = (Integer)value;
                        if (age <= 0 || age >= 120) {
                            Logger.log("Invalid age supplied");
                            this.pushValidationResult(new ValidationResult(512, "Invalid age"));
                            continue;
                        }
                    } else {
                        Logger.log("Age looks to be of an unsupported data type");
                        this.pushValidationResult(new ValidationResult(512, "Invalid age (unknown data type)"));
                        continue;
                    }
                }
                fieldsToUpdateLocally.put(key, value);
                try {
                    KnownFields kf = KnownFields.valueOf(key);
                    this.keepProperty(kf.storageValue, value);
                }
                catch (Throwable t) {
                    customProfile.put(key, value);
                }
            }
            Logger.logFine("Constructed custom profile: " + customProfile.toString());
            if (fieldsToUpdateLocally.length() > 0) {
                LocalDataStore.setProfileFields(this.context, fieldsToUpdateLocally);
            }
            this.pushBasicProfile(customProfile);
        }
        catch (Throwable t) {
            Logger.error("Failed to push profile", t);
        }
    }

    private String getGraphUserPropertySafely(JSONObject graphUser, String key, String def) {
        try {
            String prop = (String)graphUser.get(key);
            if (prop != null) {
                return prop;
            }
            return def;
        }
        catch (Throwable t) {
            return def;
        }
    }

    public void pushFacebookUser(JSONObject graphUser) {
        try {
            String education;
            String work;
            if (graphUser == null) {
                return;
            }
            String name = this.getGraphUserPropertySafely(graphUser, "name", "");
            try {
                ValidationResult vr = Validator.cleanObjectValue(name, false, false);
                name = vr.getObject().toString();
                if (vr.getErrorCode() != 0) {
                    this.pushValidationResult(vr);
                }
            }
            catch (IllegalArgumentException e) {
                name = "";
            }
            String gender = this.getGraphUserPropertySafely(graphUser, "gender", null);
            gender = gender != null ? (gender.toLowerCase().startsWith("m") ? "M" : (gender.toLowerCase().startsWith("f") ? "F" : "")) : null;
            String email = this.getGraphUserPropertySafely(graphUser, "email", "");
            String birthday = this.getGraphUserPropertySafely(graphUser, "birthday", null);
            if (birthday != null) {
                if (birthday.matches("^../..")) {
                    birthday = "";
                } else {
                    try {
                        Date date = Constants.FB_DOB_DATE_FORMAT.parse(birthday);
                        birthday = "$D_" + Constants.DOB_DATE_FORMAT.format(date);
                    }
                    catch (ParseException e) {
                        birthday = "";
                    }
                }
            }
            try {
                JSONArray workArray = graphUser.getJSONArray("work");
                work = workArray.length() > 0 ? "Y" : "N";
            }
            catch (Throwable t) {
                work = "";
            }
            try {
                JSONArray eduArray = graphUser.getJSONArray("education");
                String fbEdu = eduArray.getJSONObject(eduArray.length() - 1).getString("type");
                education = fbEdu.toLowerCase().contains("high school") ? "School" : (fbEdu.toLowerCase().contains("college") ? "College" : (fbEdu.toLowerCase().contains("graduate school") ? "Graduate" : ""));
            }
            catch (Throwable t) {
                education = "";
            }
            String id = this.getGraphUserPropertySafely(graphUser, "id", "");
            String married = this.getGraphUserPropertySafely(graphUser, "relationship_status", null);
            if (married != null) {
                married = married.equalsIgnoreCase("married") ? "Y" : "N";
            }
            this.keepProperty("fbID", id);
            this.keepProperty("fbName", name);
            this.keepProperty("fbEmail", email);
            this.keepProperty("fbGender", gender);
            this.keepProperty("fbEducation", education);
            this.keepProperty("fbEmployed", work);
            this.keepProperty("fbDOB", birthday);
            this.keepProperty("fbRS", married);
            this.pushBasicProfile(null);
        }
        catch (Throwable t) {
            Logger.error("Failed to parse graph user object successfully", t);
        }
    }

    private void keepProperty(String key, Object value) {
        if (key == null || key.equals("") || value == null) {
            return;
        }
        if (value instanceof String) {
            StorageHelper.putString(this.context, key, (String)value);
        } else if (value instanceof Integer) {
            StorageHelper.putInt(this.context, key, (Integer)value);
        } else if (value instanceof Long) {
            StorageHelper.putLong(this.context, key, (Long)value);
        } else {
            Logger.log("Ignored value due to unsupported type: " + value.getClass().getName());
        }
    }

    void pushBasicProfile(JSONObject baseProfile) {
        try {
            JSONObject profileEvent = new JSONObject();
            if (baseProfile != null && baseProfile.length() > 0) {
                Iterator i = baseProfile.keys();
                while (i.hasNext()) {
                    String next = i.next().toString();
                    Object value = null;
                    try {
                        value = baseProfile.getJSONObject(next);
                    }
                    catch (Throwable t) {
                        try {
                            value = baseProfile.get(next);
                        }
                        catch (JSONException e) {
                            // empty catch block
                        }
                    }
                    if (value == null) continue;
                    profileEvent.put(next, value);
                }
            }
            try {
                String cc;
                String carrier = this.getCarrier();
                if (carrier != null && !carrier.equals("")) {
                    this.keepProperty("systemCarrier", carrier);
                }
                if ((cc = this.getCountryCode()) != null && !cc.equals("")) {
                    this.keepProperty("systemCountryCode", cc);
                }
                this.keepProperty("systemTimezone", TimeZone.getDefault().getID());
                this.addKeptProfileProperties(this.context, profileEvent);
                JSONObject event = new JSONObject();
                event.put("profile", (Object)profileEvent);
                QueueManager.addToQueue(this.context, event, 3);
            }
            catch (JSONException e) {
                Logger.logFine("FATAL: Creating basic profile update event failed!");
            }
        }
        catch (Throwable t) {
            Logger.error("Basic profile sync", t);
        }
    }

    private void addPropertyFromStoreIfExists(Context context, String profileEventKey, JSONObject profile, DataType dataType, String ... preferenceKeys) {
        block13: for (String pk : preferenceKeys) {
            try {
                Object value;
                switch (dataType) {
                    case Integer: {
                        try {
                            value = StorageHelper.getInt(context, pk, Integer.MIN_VALUE);
                            if ((Integer)value != Integer.MIN_VALUE) break;
                        }
                        catch (ClassCastException c) {
                            value = StorageHelper.getLong(context, pk, Long.MIN_VALUE);
                            if ((Long)value != Long.MIN_VALUE) break;
                        }
                        continue block13;
                    }
                    case Long: {
                        try {
                            value = StorageHelper.getLong(context, pk, Long.MIN_VALUE);
                            if ((Long)value != Long.MIN_VALUE) break;
                        }
                        catch (ClassCastException c) {
                            value = StorageHelper.getInt(context, pk, Integer.MIN_VALUE);
                            if ((Integer)value != Integer.MIN_VALUE) break;
                        }
                        continue block13;
                    }
                    case String: {
                        value = StorageHelper.getString(context, pk, null);
                        if (value != null) break;
                        continue block13;
                    }
                    default: {
                        value = null;
                    }
                }
                if (value == null) continue;
                try {
                    profile.put(profileEventKey, value);
                    LocalDataStore.setProfileField(context, profileEventKey, value.toString());
                    return;
                }
                catch (JSONException e) {
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void addKeptProfileProperties(Context context, JSONObject profile) {
        this.addPropertyFromStoreIfExists(context, "Name", profile, DataType.String, "userName", "fbName", "gpName");
        this.addPropertyFromStoreIfExists(context, "Gender", profile, DataType.String, "userGender", "fbGender", "gpGender");
        this.addPropertyFromStoreIfExists(context, "Education", profile, DataType.String, "userEducation", "fbEducation");
        this.addPropertyFromStoreIfExists(context, "Employed", profile, DataType.String, "userEmployed", "fbEmployed", "gpEmployed");
        this.addPropertyFromStoreIfExists(context, "Married", profile, DataType.String, "userRS", "fbRS", "gpRS");
        this.addPropertyFromStoreIfExists(context, "DOB", profile, DataType.String, "userDOB", "fbDOB", "gpDOB");
        this.addPropertyFromStoreIfExists(context, "FBID", profile, DataType.String, "fbID");
        this.addPropertyFromStoreIfExists(context, "GPID", profile, DataType.String, "gpID");
        this.addPropertyFromStoreIfExists(context, "Phone", profile, DataType.String, "userPhone");
        this.addPropertyFromStoreIfExists(context, "Age", profile, DataType.Integer, "userAge");
        this.addPropertyFromStoreIfExists(context, "Email", profile, DataType.String, "userEmail", "fbEmail");
        this.addPropertyFromStoreIfExists(context, "tz", profile, DataType.String, "systemTimezone");
        this.addPropertyFromStoreIfExists(context, "Carrier", profile, DataType.String, "systemCarrier");
        this.addPropertyFromStoreIfExists(context, "cc", profile, DataType.String, "systemCountryCode");
        this.addSecondaryEmail(context, profile);
    }

    private void addSecondaryEmail(Context context, JSONObject profile) {
        try {
            String originalEmail = profile.getString("Email");
            if (originalEmail == null || originalEmail.equals("")) {
                this.addPropertyFromStoreIfExists(context, "Email", profile, DataType.String, "fbEmail");
            } else {
                String email2 = StorageHelper.getString(context, "fbEmail", "");
                if (email2 == null || email2.equals(originalEmail) || email2.equals("")) {
                    return;
                }
                profile.put("Email2", (Object)email2);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Deprecated
    public void pushEnum(String key, String value) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(key, value);
        this.push(m);
    }

    private String getCarrier() {
        try {
            TelephonyManager tm = (TelephonyManager)this.context.getSystemService("phone");
            String carrier = tm.getSimOperatorName();
            ValidationResult vr = Validator.cleanObjectValue(carrier, false, false);
            if (vr.getErrorCode() == 0) {
                return (String)vr.getObject();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    private String getCountryCode() {
        try {
            TelephonyManager tm = (TelephonyManager)this.context.getSystemService("phone");
            return tm.getSimCountryIso();
        }
        catch (Throwable ignore) {
            return "";
        }
    }

    /*
     * Unable to fully structure code
     */
    public void pushGooglePlusPerson(Person person) {
        if (person == null) {
            return;
        }
        try {
            block10: {
                name = "";
                if (!person.hasDisplayName()) break block10;
                try {
                    name = person.getDisplayName();
                    vr = Validator.cleanObjectValue(name, false, false);
                    name = vr.getObject().toString();
                    if (vr.getErrorCode() != 0) {
                        this.pushValidationResult(vr);
                    }
                    ** break block11
                }
                finally {
                    gender = "";
                }
            }
lbl-1000:
            // 1 sources

            {
            }
        }
        catch (Throwable t) {
            Logger.logFine("FATAL: Creating G+ profile update event failed!");
        }
    }

    public Object getProperty(String name) {
        if (!LocalDataStore.isPersonalisationEnabled(this.context)) {
            return null;
        }
        return LocalDataStore.getProfileProperty(this.context, name);
    }

    private Object _getProfilePropertyIgnorePersonalizationFlag(String key) {
        return LocalDataStore.getProfileValueForKey(key);
    }

    private void _handleMultiValues(ArrayList<String> values, String key, String command) {
        Object _key;
        String cleanKey;
        if (key == null) {
            return;
        }
        if (values == null || values.isEmpty()) {
            this._generateInvalidMultiValueError(key, values);
            return;
        }
        ValidationResult vr = Validator.cleanMultiValuePropertyKey(key);
        if (vr.getErrorCode() != 0) {
            this.pushValidationResult(vr);
        }
        String string = cleanKey = (_key = vr.getObject()) != null ? vr.getObject().toString() : null;
        if (cleanKey == null || cleanKey.isEmpty()) {
            this._generateInvalidMultiValueKeyError(key);
            return;
        }
        key = cleanKey;
        try {
            JSONArray currentValues = this._constructExistingMultiValue(key, command);
            JSONArray newValues = this._cleanMultiValues(values, key);
            this._validateAndPushMultiValue(currentValues, newValues, values, key, command);
        }
        catch (Throwable t) {
            Logger.logFine("Error handling multi value operation for key " + key, t);
        }
    }

    private JSONArray _constructExistingMultiValue(String key, String command) {
        Boolean remove = command.equals("$remove");
        Boolean add = command.equals("$add");
        if (!remove.booleanValue() && !add.booleanValue()) {
            return new JSONArray();
        }
        Object existing = this._getProfilePropertyIgnorePersonalizationFlag(key);
        if (existing == null) {
            if (remove.booleanValue()) {
                return null;
            }
            return new JSONArray();
        }
        if (existing instanceof JSONArray) {
            return (JSONArray)existing;
        }
        JSONArray _default = add != false ? new JSONArray() : null;
        String stringified = this._stringifyAndCleanScalarProfilePropValue(existing);
        return stringified != null ? new JSONArray().put((Object)stringified) : _default;
    }

    private String _stringifyScalarProfilePropValue(Object value) {
        String val = null;
        try {
            val = value.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    private String _stringifyAndCleanScalarProfilePropValue(Object value) {
        String val = this._stringifyScalarProfilePropValue(value);
        if (val != null) {
            Object _value;
            ValidationResult vr = Validator.cleanMultiValuePropertyValue(val);
            if (vr.getErrorCode() != 0) {
                this.pushValidationResult(vr);
            }
            val = (_value = vr.getObject()) != null ? vr.getObject().toString() : null;
        }
        return val;
    }

    private JSONArray _cleanMultiValues(ArrayList<String> values, String key) {
        try {
            if (values == null || key == null) {
                return null;
            }
            JSONArray cleanedValues = new JSONArray();
            for (String value : values) {
                Object _value;
                value = value == null ? "" : value;
                ValidationResult vr = Validator.cleanMultiValuePropertyValue(value);
                if (vr.getErrorCode() != 0) {
                    this.pushValidationResult(vr);
                }
                String string = value = (_value = vr.getObject()) != null ? vr.getObject().toString() : null;
                if (value == null || value.isEmpty()) {
                    this._generateInvalidMultiValueError(key, value);
                    return null;
                }
                cleanedValues.put((Object)value);
            }
            return cleanedValues;
        }
        catch (Throwable t) {
            Logger.logFine("Error cleaning multi values for key " + key, t);
            this._generateInvalidMultiValueError(key, values);
            return null;
        }
    }

    private void _validateAndPushMultiValue(JSONArray currentValues, JSONArray newValues, ArrayList<String> originalValues, String key, String command) {
        try {
            JSONArray localValues;
            if (currentValues == null || newValues == null || originalValues == null || key == null || command == null) {
                return;
            }
            String mergeOperation = command.equals("$remove") ? "multiValuePropertyRemoveValues" : "multiValuePropertyAddValues";
            ValidationResult vr = Validator.mergeMultiValuePropertyForKey(currentValues, newValues, mergeOperation, key);
            if (vr.getErrorCode() != 0) {
                this.pushValidationResult(vr);
            }
            if ((localValues = (JSONArray)vr.getObject()) == null || localValues.length() <= 0) {
                LocalDataStore.removeProfileField(this.context, key);
            } else {
                LocalDataStore.setProfileField(this.context, key, localValues);
            }
            JSONObject commandObj = new JSONObject();
            commandObj.put(command, (Object)new JSONArray(originalValues));
            JSONObject fields = new JSONObject();
            fields.put(key, (Object)commandObj);
            this.pushBasicProfile(fields);
            Logger.logFine("Constructed multi-value profile push: " + fields.toString());
        }
        catch (Throwable t) {
            Logger.logFine("Error pushing multiValue for key " + key, t);
        }
    }

    private void _generateInvalidMultiValueError(String key, Object value) {
        ValidationResult error = new ValidationResult();
        String msg = "Invalid multi value: " + value.toString() + " for key " + key + ", profile multi value operation aborted.";
        error.setErrorCode(512);
        error.setErrorDesc(msg);
        this.pushValidationResult(error);
        Logger.log(msg);
    }

    private void _generateInvalidMultiValueKeyError(String key) {
        ValidationResult error = new ValidationResult();
        error.setErrorCode(523);
        error.setErrorDesc("Invalid multi-value property key " + key);
        this.pushValidationResult(error);
        Logger.log("Invalid multi-value property key " + key + " profile multi value operation aborted");
    }

    private void pushValidationResult(ValidationResult vr) {
        CleverTapAPI.pushValidationResult(vr);
    }

    static enum KnownFields {
        Name("userName"),
        Email("userEmail"),
        Education("userEducation"),
        Married("userRS"),
        DOB("userDOB"),
        Gender("userGender"),
        Phone("userPhone"),
        Age("userAge");

        private final String storageValue;

        private KnownFields(String storageValue) {
            this.storageValue = storageValue;
        }
    }
}

