/*
 * Author: Jude Pereira
 * Copyright (c) 2014
 */

package com.clevertap.android.sdk;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.clevertap.android.sdk.exceptions.CleverTapMetaDataNotFoundException;

import java.util.HashMap;

/**
 * Provides methods to access the meta data values present in the Android manifest.
 */
final class ManifestMetaData {
    private static HashMap<String, String> cachedMeta = new HashMap<String, String>();

    /**
     * Returns the value of the meta data key specified by name.
     *
     * @param context The Android context
     * @param name    The name of the meta data key
     * @return The value of the meta data key, if found
     * @throws CleverTapMetaDataNotFoundException
     */
    public static String getMetaData(Context context, String name)
            throws CleverTapMetaDataNotFoundException {

        if (name.equals(Constants.LABEL_ACCOUNT_ID) && CleverTapAPI.localAccountID != null) {
            return CleverTapAPI.localAccountID;
        }

        if (name.equals(Constants.LABEL_TOKEN) && CleverTapAPI.localToken != null) {
            return CleverTapAPI.localToken;
        }

        String meta = cachedMeta.get(name);
        if (meta != null) {
            return meta;
        }
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo ai = pm.getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            Bundle metaData = ai.metaData;
            if (metaData == null) {
                throw new PackageManager.NameNotFoundException();
            } else {
                Object o = metaData.get(name);
                if (o == null) {
                    throw new Exception();
                }

                cachedMeta.put(name, o.toString());
                return o.toString();
            }
        } catch (Throwable t) {
            throw new CleverTapMetaDataNotFoundException("Required meta data entry "
                    + name + " is not specified");
        }
    }
}
