/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.net.Uri;
import android.net.UrlQuerySanitizer;
import android.os.Bundle;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.SessionHandler;
import com.clevertap.android.sdk.Validator;
import java.util.Set;
import org.json.JSONObject;

class UriHelper {
    UriHelper() {
    }

    static JSONObject getUrchinFromUri(Context context, Uri uri) {
        JSONObject referrer = new JSONObject();
        try {
            UrlQuerySanitizer sanitizer = new UrlQuerySanitizer();
            sanitizer.setAllowUnregisteredParamaters(true);
            sanitizer.parseUrl(uri.toString());
            String source = UriHelper.getUtmOrWzrkValue("source", sanitizer);
            String medium = UriHelper.getUtmOrWzrkValue("medium", sanitizer);
            String campaign = UriHelper.getUtmOrWzrkValue("campaign", sanitizer);
            SessionHandler cfr_ignored_0 = CleverTapAPI.getInstance((Context)context).session;
            SessionHandler.setSource(source);
            SessionHandler cfr_ignored_1 = CleverTapAPI.getInstance((Context)context).session;
            SessionHandler.setMedium(medium);
            SessionHandler cfr_ignored_2 = CleverTapAPI.getInstance((Context)context).session;
            SessionHandler.setCampaign(campaign);
            referrer.put("us", (Object)source);
            referrer.put("um", (Object)medium);
            referrer.put("uc", (Object)campaign);
            String wm = UriHelper.getWzrkValueForKey("medium", sanitizer);
            if (wm != null && wm.matches("^email$|^social$|^search$")) {
                referrer.put("wm", (Object)wm);
            }
            Logger.logFine("Referrer data: " + referrer.toString(4));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return referrer;
    }

    private static String getUtmOrWzrkValue(String utmKey, UrlQuerySanitizer sanitizer) {
        String value = UriHelper.getUtmValueForKey(utmKey, sanitizer);
        if (value != null || (value = UriHelper.getWzrkValueForKey(utmKey, sanitizer)) != null) {
            return value;
        }
        return null;
    }

    private static String getWzrkValueForKey(String key, UrlQuerySanitizer sanitizer) {
        key = "wzrk_" + key;
        return UriHelper.getValueForKey(key, sanitizer);
    }

    private static String getUtmValueForKey(String key, UrlQuerySanitizer sanitizer) {
        key = "utm_" + key;
        return UriHelper.getValueForKey(key, sanitizer);
    }

    private static String getValueForKey(String key, UrlQuerySanitizer sanitizer) {
        if (key == null || sanitizer == null) {
            return null;
        }
        try {
            String value = sanitizer.getValue(key);
            if (value == null) {
                return null;
            }
            if (value.getBytes("UTF-8").length > 120) {
                return Validator.fastTrim(value, 120);
            }
            return value;
        }
        catch (Throwable t) {
            Logger.logFine("Couldn't parse the URI", t);
            return null;
        }
    }

    static Bundle getAllKeyValuePairs(String url) {
        if (url == null) {
            return new Bundle();
        }
        Bundle customPairs = new Bundle();
        try {
            UrlQuerySanitizer sanitizer = new UrlQuerySanitizer();
            sanitizer.setAllowUnregisteredParamaters(true);
            sanitizer.parseUrl(url);
            Set queryParams = sanitizer.getParameterSet();
            for (String key : queryParams) {
                String value = UriHelper.getValueForKey(key, sanitizer);
                if (value == null) continue;
                customPairs.putString(key, value);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return customPairs;
    }
}

