/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.content.SharedPreferences;

final class StorageHelper {
    StorageHelper() {
    }

    static void putString(Context context, String key, String value) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().putString(key, value);
        StorageHelper.persist(editor);
    }

    static String getString(Context context, String key, String defaultValue) {
        return StorageHelper.getPreferences(context).getString(key, defaultValue);
    }

    static void putLong(Context context, String key, long value) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().putLong(key, value);
        StorageHelper.persist(editor);
    }

    static long getLong(Context context, String key, long defaultValue) {
        return StorageHelper.getPreferences(context).getLong(key, defaultValue);
    }

    static void putInt(Context context, String key, int value) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().putInt(key, value);
        StorageHelper.persist(editor);
    }

    static int getInt(Context context, String key, int defaultValue) {
        return StorageHelper.getPreferences(context).getInt(key, defaultValue);
    }

    static void putBoolean(Context context, String key, boolean value) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().putBoolean(key, value);
        StorageHelper.persist(editor);
    }

    static boolean getBoolean(Context context, String key, boolean defaultValue) {
        return StorageHelper.getPreferences(context).getBoolean(key, defaultValue);
    }

    static SharedPreferences getPreferences(Context context, String namespace) {
        String path = "WizRocket";
        if (namespace != null) {
            path = path + "_" + namespace;
        }
        return context.getSharedPreferences(path, 0);
    }

    static SharedPreferences getPreferences(Context context) {
        return StorageHelper.getPreferences(context, null);
    }

    static void persist(SharedPreferences.Editor editor) {
        editor.commit();
    }
}

