/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.os.Environment;
import android.support.v4.content.ContextCompat;
import android.telephony.TelephonyManager;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.exceptions.CleverTapPermissionsNotSatisfied;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;

final class DeviceInfo {
    private static final String separator = "\\|";
    private static final File targetDeviceIdFile = new File(Environment.getExternalStorageDirectory() + "/Android/data/com.wizrocket/device_id");

    DeviceInfo() {
    }

    static String getDeviceID(Context context) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        return prefs.getString("deviceId", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CommitPrefEdits"})
    static void updateDeviceIdIfRequired(Context context) {
        String id;
        SharedPreferences prefs;
        block27: {
            prefs = StorageHelper.getPreferences(context);
            String deviceID = prefs.getString("deviceId", null);
            if (deviceID != null) {
                DeviceInfo.writeDeviceIdToFileAsync(context, targetDeviceIdFile, deviceID);
                return;
            }
            try {
                if (!targetDeviceIdFile.exists() || !targetDeviceIdFile.isFile()) break block27;
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(targetDeviceIdFile));
                    id = reader.readLine();
                    if (id != null && !id.equals("") && !DeviceInfo.isDeviceIdCorrupted(id)) {
                        id = id.split(separator)[0];
                        SharedPreferences.Editor editor = prefs.edit().putString("deviceId", id);
                        StorageHelper.persist(editor);
                        Logger.logFine("Restored existing GUID!");
                        return;
                    }
                }
                catch (FileNotFoundException e) {
                }
                catch (Throwable ex) {
                    Logger.logFine("IOException when attempting to read device ID from file: " + ex);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable e) {}
                    }
                }
            }
            catch (Throwable t) {
                Logger.logFine("Failed to read the GUID from persistent storage");
            }
        }
        if (DeviceInfo.hasPermission(context, "android.permission.READ_PHONE_STATE")) {
            try {
                TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
                id = tm.getDeviceId();
                if (id != null && !id.equals("")) {
                    id = "_" + id;
                    SharedPreferences.Editor editor = prefs.edit().putString("deviceId", id);
                    StorageHelper.persist(editor);
                    DeviceInfo.writeDeviceIdToFileAsync(context, targetDeviceIdFile, id);
                    return;
                }
            }
            catch (Throwable ex) {
                Logger.logFine("Couldn't get a device ID. Will fallback to GUID after the first request is made.");
            }
        } else {
            Logger.logFine("Cannot retrieve device ID due to insufficient permissions");
        }
        String id2 = "";
        SharedPreferences.Editor editor = prefs.edit().putString("deviceId", id2);
        StorageHelper.persist(editor);
        DeviceInfo.writeDeviceIdToFileAsync(context, targetDeviceIdFile, id2);
    }

    private static void writeDeviceIdToFileAsync(final Context context, final File f, final String id) {
        CleverTapAPI.postAsyncSafely("DeviceInfo#writeDeviceIdToFileAsync", new Runnable(){

            @Override
            public void run() {
                DeviceInfo.writeDeviceIdToFile(context, f, id);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeDeviceIdToFile(Context context, File f, String id) {
        OutputStreamWriter writer = null;
        try {
            if (!DeviceInfo.hasPermission(context, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                return;
            }
            f.getParentFile().mkdirs();
            writer = new FileWriter(f);
            writer.write(id + "|" + DeviceInfo.generateChecksum(id));
            writer.flush();
        }
        catch (Throwable e) {
            Logger.logFine("Failed when attempting to write device ID to file: " + e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable e) {
                    Logger.logFine("Failed when attempting to close FileWriter: " + e);
                }
            }
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    static void forceUpdateDeviceId(Context context, String id) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().putString("deviceId", id);
        StorageHelper.persist(editor);
        DeviceInfo.writeDeviceIdToFileAsync(context, targetDeviceIdFile, id);
    }

    static void testPermission(Context context, String permission) throws CleverTapPermissionsNotSatisfied {
        if (!DeviceInfo.hasPermission(context, permission)) {
            throw new CleverTapPermissionsNotSatisfied("Permission required: " + permission);
        }
    }

    static boolean hasPermission(Context context, String permission) {
        try {
            return 0 == ContextCompat.checkSelfPermission((Context)context, (String)permission);
        }
        catch (Throwable t) {
            return false;
        }
    }

    static int getAppIconAsIntId(Context context) {
        ApplicationInfo ai = context.getApplicationInfo();
        return ai.icon;
    }

    private static int generateChecksum(String key) {
        int sum = 0;
        int len = key.length();
        for (int i = 0; i < len; ++i) {
            char x = key.charAt(i);
            sum += x * x + i * i + 3 * i * x + 5 * i + 7;
        }
        return sum;
    }

    private static boolean isDeviceIdCorrupted(String s) {
        try {
            String[] parts = s.split(separator);
            String key = parts[0];
            int checksum = Integer.parseInt(parts[1]);
            int calculatedChecksum = DeviceInfo.generateChecksum(key);
            return calculatedChecksum != checksum;
        }
        catch (Exception e) {
            return true;
        }
    }
}

