package com.clevertap.android.sdk;

import android.content.Context;
import android.net.Uri;
import android.net.UrlQuerySanitizer;
import android.os.Bundle;
import org.json.JSONObject;

import java.util.Set;

/**
 * Created by mohit on 01/03/16.
 */
class UriHelper {

    /*package*/
    static JSONObject getUrchinFromUri(Context context, Uri uri) {
        JSONObject referrer = new JSONObject();
        try {

            UrlQuerySanitizer sanitizer = new UrlQuerySanitizer();
            sanitizer.setAllowUnregisteredParamaters(true);
            sanitizer.parseUrl(uri.toString());

            // Don't care for null values - they won't be added anyway
            String source = getUtmOrWzrkValue("source", sanitizer);
            String medium = getUtmOrWzrkValue("medium", sanitizer);
            String campaign = getUtmOrWzrkValue("campaign", sanitizer);

            CleverTapAPI.getInstance(context).session.setSource(source);
            CleverTapAPI.getInstance(context).session.setMedium(medium);
            CleverTapAPI.getInstance(context).session.setCampaign(campaign);

            referrer.put("us", source);
            referrer.put("um", medium);
            referrer.put("uc", campaign);

            String wm = getWzrkValueForKey("medium", sanitizer);
            if (wm != null && wm.matches("^email$|^social$|^search$"))
                referrer.put("wm", wm);

            Logger.logFine("Referrer data: " + referrer.toString(4));
        } catch (Throwable ignore) {
            // Won't happen
        }
        return referrer;
    }

    private static String getUtmOrWzrkValue(String utmKey, UrlQuerySanitizer sanitizer) {
        // Give preference to utm_*, else, try to look for wzrk_*
        String value;
        if ((value = getUtmValueForKey(utmKey, sanitizer)) != null
                || (value = getWzrkValueForKey(utmKey, sanitizer)) != null)
            return value;
        else
            return null;
    }

    private static String getWzrkValueForKey(String key, UrlQuerySanitizer sanitizer) {
        key = "wzrk_" + key;
        return getValueForKey(key, sanitizer);
    }

    private static String getUtmValueForKey(String key, UrlQuerySanitizer sanitizer) {
        key = "utm_" + key;
        return getValueForKey(key, sanitizer);
    }

    private static String getValueForKey(String key, UrlQuerySanitizer sanitizer) {
        if (key == null || sanitizer == null) return null;
        try {
            String value = sanitizer.getValue(key);

            if (value == null) return null;
            if (value.getBytes("UTF-8").length > 120)
                return Validator.fastTrim(value, 120);
            else
                return value;
        } catch (Throwable t) {
            Logger.logFine("Couldn't parse the URI", t);
            return null;
        }
    }

    static Bundle getAllKeyValuePairs(String url) {
        if(url == null) return new Bundle();
        Bundle customPairs = new Bundle();
        try {
            UrlQuerySanitizer sanitizer = new UrlQuerySanitizer();
            sanitizer.setAllowUnregisteredParamaters(true);
            sanitizer.parseUrl(url);
            Set<String> queryParams = sanitizer.getParameterSet();
            for(String key: queryParams) {
                String value = getValueForKey(key, sanitizer);
                if(value != null) {
                    customPairs.putString(key, value);
                }
            }
        } catch (Throwable ignore) {
            // Won't happen
        }
        return customPairs;
    }

}
