/*
 * Author: Jude Pereira
 * Copyright (c) 2014
 */

package com.clevertap.android.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.clevertap.android.sdk.exceptions.CleverTapMetaDataNotFoundException;
import com.clevertap.android.sdk.exceptions.CleverTapPermissionsNotSatisfied;

/**
 * Broadcast receiver for INSTALL_REFERRAL intents.
 */
public final class InstallReferrerBroadcastReceiver extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        try {
            CleverTapAPI wr = CleverTapAPI.getInstance(context);
            wr.pushInstallReferrer(intent);
        } catch (CleverTapMetaDataNotFoundException ignore) {
            // Ignore
        } catch (CleverTapPermissionsNotSatisfied ignore) {
            // Ignore
        }
    }

}
