/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.InAppManager;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.PingEntity;
import com.clevertap.android.sdk.QueueManager;
import com.clevertap.android.sdk.SessionHandler;
import com.clevertap.android.sdk.StorageHelper;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

final class SessionManager {
    private static PingEntity pingEntity = null;
    private static Runnable pingTickerRunnable = null;
    private static int currentElapsedPingSeconds = 0;
    private static int currentSessionId = 0;
    private static boolean firstSession = false;
    private static boolean appLaunchedBeenPushed = true;
    private static int lastSessionLength = 0;
    private static final ArrayList<String> activityList = new ArrayList();
    private static JSONArray lastSessionActivityTrail = null;
    private static final Runnable syncLastTickRunnable = new Runnable(){

        @Override
        public void run() {
            int now = (int)(System.currentTimeMillis() / 1000L);
            try {
                StorageHelper.putInt(CleverTapAPI.getInstance(null).getContext(), "sexe", now);
                Logger.logFine("Synced last ping time");
            }
            catch (Throwable t) {
                Logger.logFine("Failed to sync last ping time: " + t.getMessage());
            }
            try {
                JSONArray arr = new JSONArray();
                for (String s : activityList) {
                    arr.put((Object)s);
                }
                StorageHelper.putString(CleverTapAPI.getInstance(null).getContext(), "slat", arr.toString());
                Logger.logFine("Synced activity trail");
            }
            catch (Throwable t) {
                Logger.logFine("Failed to sync activity trail: " + t.getMessage());
            }
        }
    };

    SessionManager() {
    }

    static void activityChanged(String newActivityName) {
        if (newActivityName == null || newActivityName.trim().equals("")) {
            return;
        }
        activityList.add(newActivityName);
    }

    public static int getLastSessionLength() {
        return lastSessionLength;
    }

    static boolean isAppLaunchedBeenPushed() {
        return appLaunchedBeenPushed;
    }

    static void setAppLaunchedBeenPushed(boolean appLaunchedBeenPushed) {
        SessionManager.appLaunchedBeenPushed = appLaunchedBeenPushed;
    }

    static boolean isFirstSession() {
        return firstSession;
    }

    static void destroySession() {
        Logger.logFine("Session destroyed; Session ID is now 0");
        currentSessionId = 0;
        SessionHandler.setSource(null);
        SessionHandler.setMedium(null);
        SessionHandler.setCampaign(null);
        activityList.clear();
    }

    static int getCurrentSession() {
        return currentSessionId;
    }

    @SuppressLint(value={"CommitPrefEdits"})
    static int createSession(Context context) {
        currentSessionId = (int)(System.currentTimeMillis() / 1000L);
        Logger.logFine("Session created with ID: " + currentSessionId);
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        int lastSessionID = prefs.getInt("lastSessionId", 0);
        int lastSessionPingEpoch = prefs.getInt("sexe", 0);
        if (lastSessionPingEpoch > 0) {
            lastSessionLength = lastSessionPingEpoch - lastSessionID;
        }
        Logger.logFine("Last session length: " + lastSessionLength + " seconds");
        if (lastSessionID == 0) {
            firstSession = true;
        }
        try {
            String activityTrail = prefs.getString("slat", "[]");
            lastSessionActivityTrail = new JSONArray(activityTrail);
            Logger.logFine("Last activity trail: " + lastSessionActivityTrail.toString());
        }
        catch (Throwable t) {
            Logger.logFine("Last activity trail not found");
        }
        SharedPreferences.Editor editor = prefs.edit().putInt("lastSessionId", currentSessionId);
        StorageHelper.persist(editor);
        SessionManager.resetPingTimer(context);
        InAppManager.clearTargetCounts();
        SessionManager.setAppLaunchedBeenPushed(false);
        return currentSessionId;
    }

    private static void resetPingTimer(final Context context) {
        currentElapsedPingSeconds = 0;
        if (pingTickerRunnable != null) {
            CleverTapAPI.getHandlerUsingMainLooper().removeCallbacks(pingTickerRunnable);
        }
        pingEntity = new PingEntity();
        if (pingTickerRunnable == null) {
            pingTickerRunnable = new Runnable(){

                @Override
                public void run() {
                    if (pingEntity == null) {
                        return;
                    }
                    if (CleverTapAPI.isAppForeground()) {
                        pingEntity.doTick();
                        CleverTapAPI.getHandlerUsingMainLooper().removeCallbacks(syncLastTickRunnable);
                        CleverTapAPI.getHandlerUsingMainLooper().postDelayed(syncLastTickRunnable, 2000L);
                    }
                    int now = (int)(System.currentTimeMillis() / 1000L);
                    StorageHelper.putInt(context, "sexe", now);
                    int duration = SessionManager.isFirstSession() ? 5 : 20;
                    if (pingEntity.hasMatured(currentElapsedPingSeconds + duration)) {
                        currentElapsedPingSeconds += duration;
                        Logger.logFine("Ping timer has matured. Firing ping event. Elapsed=" + currentElapsedPingSeconds);
                        QueueManager.addToQueue(context, new JSONObject(), 2);
                    }
                    if (pingEntity != null) {
                        CleverTapAPI.getHandlerUsingMainLooper().postDelayed(pingTickerRunnable, 1000L);
                    }
                }
            };
        }
        CleverTapAPI.getHandlerUsingMainLooper().postDelayed(pingTickerRunnable, 1000L);
        Logger.logFine("New ping entity associated with this session");
    }

    public static JSONArray getLastSessionActivityTrail() {
        if (lastSessionActivityTrail == null) {
            return new JSONArray();
        }
        return lastSessionActivityTrail;
    }
}

