/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CommsManager;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestMetaData;
import com.clevertap.android.sdk.SessionManager;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.ValidationResult;
import com.clevertap.android.sdk.exceptions.CleverTapMetaDataNotFoundException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class QueueManager {
    private static final Boolean lock = true;
    private static Runnable commsRunnable = null;
    private static String mDeviceID = null;

    QueueManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CommitPrefEdits"})
    static JSONArray getAndRemoveAll(Context context) {
        Boolean bl = lock;
        synchronized (bl) {
            SharedPreferences prefs = StorageHelper.getPreferences(context);
            try {
                JSONArray all = new JSONArray(prefs.getString("events", "[]"));
                SharedPreferences.Editor editor = prefs.edit().remove("events");
                StorageHelper.persist(editor);
                return all;
            }
            catch (JSONException e) {
                return new JSONArray();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CommitPrefEdits"})
    static void restoreQueue(Context context, JSONArray all) {
        Boolean bl = lock;
        synchronized (bl) {
            SharedPreferences prefs = StorageHelper.getPreferences(context);
            try {
                JSONArray existingQueue = new JSONArray(prefs.getString("events", "[]"));
                int len = existingQueue.length();
                for (int i = 0; i < len; ++i) {
                    all.put(existingQueue.get(i));
                }
                SharedPreferences.Editor editor = prefs.edit().putString("events", all.toString());
                StorageHelper.persist(editor);
            }
            catch (JSONException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CommitPrefEdits"})
    static void addToQueue(Context context, JSONObject event, int eventType) {
        Boolean bl = lock;
        synchronized (bl) {
            SharedPreferences prefs = StorageHelper.getPreferences(context);
            try {
                String type;
                String token;
                String accountId;
                String evtName;
                int session = SessionManager.getCurrentSession();
                if (session == 0) {
                    session = SessionManager.createSession(context);
                }
                if (CleverTapAPI.isAppForeground() && eventType == 4 && !SessionManager.isAppLaunchedBeenPushed() && !(evtName = event.getString("evtName")).equals("Notification Clicked")) {
                    CleverTapAPI wr = CleverTapAPI.getInstance(context);
                    wr.pushAppLaunchedEvent("Queue Manager - addToQueue");
                }
                if (mDeviceID == null) {
                    mDeviceID = prefs.getString("deviceId", null);
                }
                try {
                    accountId = ManifestMetaData.getMetaData(context, "CLEVERTAP_ACCOUNT_ID");
                    token = ManifestMetaData.getMetaData(context, "CLEVERTAP_TOKEN");
                }
                catch (CleverTapMetaDataNotFoundException e) {
                    Logger.logFine("Account ID/token not found, will not add to queue");
                    return;
                }
                int activityCount = CleverTapAPI.activityCount;
                int n = activityCount = activityCount == 0 ? 1 : activityCount;
                if (eventType == 1) {
                    type = "page";
                } else if (eventType == 2) {
                    type = "ping";
                    QueueManager.attachMeta(event, context);
                } else {
                    type = eventType == 3 ? "profile" : (eventType == 5 ? "data" : "event");
                }
                event.put("id", (Object)accountId);
                String currentActivityName = CleverTapAPI.getInstance(context).getCurrentActivityName();
                if (currentActivityName != null) {
                    event.put("n", (Object)currentActivityName);
                }
                event.put("s", session);
                if (mDeviceID != null && !mDeviceID.equals("")) {
                    event.put("g", (Object)mDeviceID);
                }
                event.put("pg", activityCount);
                event.put("tk", (Object)token);
                event.put("type", (Object)type);
                event.put("ep", System.currentTimeMillis() / 1000L);
                event.put("f", SessionManager.isFirstSession());
                event.put("lsl", SessionManager.getLastSessionLength());
                QueueManager.attachLastSessionActivityTrailAndPackageNameIfRequired(context, event);
                if (CleverTapAPI.pendingValidationResult != null) {
                    event.put("wzrk_error", (Object)QueueManager.getErrorObject(CleverTapAPI.pendingValidationResult));
                    CleverTapAPI.pendingValidationResult = null;
                }
                LocalDataStore.setDataSyncFlag(context, event);
                JSONArray queuedEvents = new JSONArray(prefs.getString("events", "[]"));
                int len = queuedEvents.length();
                if (len > 50) {
                    JSONArray trimmedQueuedEvents = new JSONArray();
                    for (int i = 10; i < len; ++i) {
                        trimmedQueuedEvents.put(queuedEvents.get(i));
                    }
                    trimmedQueuedEvents.put((Object)event);
                    queuedEvents = trimmedQueuedEvents;
                } else {
                    queuedEvents.put((Object)event);
                }
                SharedPreferences.Editor editor = prefs.edit();
                editor.putString("events", queuedEvents.toString());
                StorageHelper.persist(editor);
                if (CleverTapAPI.getDebugLevel() == 1277182231) {
                    Logger.logFine("New event queued: " + event.toString());
                }
                QueueManager.updateLocalStoreAsync(context, event, eventType);
                QueueManager.setupSend(context);
            }
            catch (Throwable e) {
                Logger.error("FATAL: Queuing events failed!", e);
            }
        }
    }

    private static void updateLocalStoreAsync(final Context context, final JSONObject event, final int type) {
        if (type == 3 || type == 4) {
            CleverTapAPI.postAsyncSafely("QueueManager#updateLocalStoreAsync", context, new Runnable(){

                @Override
                public void run() {
                    LocalDataStore.persistEvent(context, event, type);
                }
            });
        }
    }

    private static void setupSend(final Context context) {
        if (commsRunnable == null) {
            commsRunnable = new Runnable(){

                @Override
                public void run() {
                    new CommsManager().drainQueueAsync(context);
                }
            };
        }
        CleverTapAPI.getHandlerUsingMainLooper().removeCallbacks(commsRunnable);
        CleverTapAPI.getHandlerUsingMainLooper().postDelayed(commsRunnable, 1000L);
        Logger.logFine("Posted delayed runnable to send queue");
    }

    private static JSONObject getErrorObject(ValidationResult vr) {
        JSONObject error = new JSONObject();
        try {
            error.put("c", vr.getErrorCode());
            error.put("d", (Object)vr.getErrorDesc());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return error;
    }

    private static void attachMeta(JSONObject o, Context context) {
        try {
            o.put("mc", Utils.getMemoryConsumption());
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            o.put("sc", Utils.getServiceCount(context));
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            o.put("nt", (Object)Utils.getCurrentNetworkType(context));
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            o.put("oa", Utils.getInstalledAppsCount(context));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void attachLastSessionActivityTrailAndPackageNameIfRequired(Context context, JSONObject event) {
        try {
            String type = event.getString("type");
            if ("event".equals(type) && "App Launched".equals(event.getString("evtName"))) {
                JSONArray lastSessionActivityTrail = SessionManager.getLastSessionActivityTrail();
                event.put("lsat", (Object)lastSessionActivityTrail);
                event.put("pai", (Object)context.getPackageName());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

